/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.ttc7;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.ttc7.TTCColumn;
import oracle.jdbc.ttc7.TTCItem;
import oracle.jdbc.ttc7.TTIoac;

public class PlsqlTTCColumn
extends TTCColumn {
    private TTCItem in;
    private TTCItem out;

    protected PlsqlTTCColumn(TTIoac type) {
        super(type, 1);
    }

    protected void marshal() throws SQLException, IOException {
        if (this.in == null && this.out == null) {
            DBError.check_error((int)426);
        }
        if (this.in != null) {
            this.in.marshal();
        } else {
            this.out.marshalPLSQL();
        }
    }

    protected boolean unmarshal() throws SQLException, IOException {
        if (this.in == null && this.out == null) {
            DBError.check_error((int)426);
        }
        if (this.out != null) {
            this.out.unmarshal();
            this.out.unmarshalIndicator();
        } else {
            this.in.unmarshal();
            this.in.unmarshalIndicator();
        }
        return false;
    }

    protected void setIN(TTCItem item) {
        this.in = item;
    }

    protected void setOUT(TTCItem item) {
        this.out = item;
    }

    protected void print(int mod, int submod, int cat) {
        OracleLog.print((Object)this, (int)mod, (int)submod, (int)cat, (String)"           ---- Enter: PlsqlTTCColumn.print  --- ");
        super.print(mod, submod, cat);
        OracleLog.print((Object)this, (int)mod, (int)submod, (int)cat, (String)"          +++++ IN Item information: ");
        if (this.in != null) {
            this.in.print(mod, submod, cat);
        } else {
            OracleLog.print((Object)this, (int)mod, (int)submod, (int)cat, (String)"              IN bind is NULL ");
        }
        OracleLog.print((Object)this, (int)mod, (int)submod, (int)cat, (String)"          +++++ OUT Item information: ");
        if (this.out != null) {
            this.out.print(mod, submod, cat);
        } else {
            OracleLog.print((Object)this, (int)mod, (int)submod, (int)cat, (String)"              OUT bind is NULL ");
        }
        OracleLog.print((Object)this, (int)mod, (int)submod, (int)cat, (String)"           ---- Exit: PlsqlTTCColumn.print --- ");
    }
}

