/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.ttc7;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.ttc7.MAREngine;
import oracle.jdbc.ttc7.TTIfun;
import oracle.jdbc.ttc7.TTIoer;
import oracle.net.ns.BreakNetException;

public class Oversion
extends TTIfun {
    private byte[] rdbmsVersion = new byte[]{78, 111, 116, 32, 100, 101, 116, 101, 114, 109, 105, 110, 101, 100, 32, 121, 101, 116};
    private boolean rdbmsVersionO2U = false;
    private int bufLen = 256;
    private boolean retVerLenO2U = false;
    private int retVerLen = 0;
    private boolean retVerNumO2U = false;
    private long retVerNum = 0L;

    public Oversion(MAREngine _mrengine) throws IOException, SQLException {
        super((byte)3, 0, (byte)59);
        this.setMarshalingEngine(_mrengine);
        this.oer = new TTIoer(this.meg);
        this.rdbmsVersionO2U = true;
        this.retVerLenO2U = true;
        this.retVerNumO2U = true;
    }

    public void receive() throws SQLException, IOException {
        boolean rpaProcessed = false;
        block7: while (true) {
            try {
                byte code = this.meg.unmarshalSB1();
                switch (code) {
                    case 8: {
                        if (rpaProcessed) {
                            DBError.check_error((int)401);
                        }
                        this.retVerLen = this.meg.unmarshalUB2();
                        this.rdbmsVersion = this.meg.unmarshalCHR(this.retVerLen);
                        if (this.rdbmsVersion == null) {
                            DBError.check_error((int)438);
                        }
                        this.retVerNum = this.meg.unmarshalUB4();
                        rpaProcessed = true;
                        break;
                    }
                    case 4: {
                        this.oer.init();
                        this.oer.unmarshal();
                        this.oer.processError();
                        break block7;
                    }
                    case 9: {
                        break block7;
                    }
                    default: {
                        DBError.check_error((int)401);
                        break;
                    }
                }
            }
            catch (BreakNetException breakNetException) {}
        }
    }

    public byte[] getVersion() {
        return this.rdbmsVersion;
    }

    public short getVersionNumber() {
        int ver = 0;
        ver = (int)((long)ver + (this.retVerNum >>> 24 & 0xFFL) * 1000L);
        ver = (int)((long)ver + (this.retVerNum >>> 20 & 0xFL) * 100L);
        ver = (int)((long)ver + (this.retVerNum >>> 12 & 0xFL) * 10L);
        ver = (int)((long)ver + (this.retVerNum & 0xFL));
        return (short)ver;
    }

    public long getVersionNumberasIs() {
        return this.retVerNum;
    }

    protected void marshal() throws IOException {
        this.marshalFunHeader();
        this.meg.marshalO2U(this.rdbmsVersionO2U);
        this.meg.marshalSWORD(this.bufLen);
        this.meg.marshalO2U(this.retVerLenO2U);
        this.meg.marshalO2U(this.retVerNumO2U);
    }
}

