/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.ttc7;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBColumn;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.ttc7.MAREngine;
import oracle.jdbc.ttc7.TTCStatement;
import oracle.jdbc.ttc7.TTIfun;
import oracle.jdbc.ttc7.TTIoer;
import oracle.jdbc.ttc7.TTIuds;
import oracle.net.ns.BreakNetException;

public class Odscrarr
extends TTIfun {
    protected int cursor_id = 0;
    private int startpos = 1;
    public static final int HSTITEMS = 32;
    public static final int M_IDEN = 30;
    public static final int NBL = 960;
    public int totalColumns = 0;
    public int numuds = 0;
    private TTIuds[] uds;
    protected String[] colnames;
    private int totalretlen;
    public int colOffset;
    private boolean numitemsO2U = true;
    protected boolean udsarrayO2U = true;
    protected boolean numudsO2U = true;
    private boolean colnameO2U = true;
    private boolean lencolsO2U = true;

    public Odscrarr(MAREngine _mrengine) throws IOException, SQLException {
        super((byte)3, 0, (byte)43);
        this.setMarshalingEngine(_mrengine);
        this.oer = new TTIoer(_mrengine);
    }

    public void init(TTCStatement _stmt, int _offset) throws IOException, SQLException {
        this.startpos = 1;
        this.totalColumns = 0;
        this.numuds = 0;
        this.uds = null;
        this.colnames = null;
        this.totalretlen = 0;
        this.numitemsO2U = true;
        this.udsarrayO2U = true;
        this.numudsO2U = true;
        this.colnameO2U = true;
        this.lencolsO2U = true;
        this.oer.init();
        this.cursor_id = _stmt.getCursor();
        this.colOffset = _offset;
    }

    public DBColumn[] receive(DBColumn[] _dbcols) throws SQLException, IOException {
        boolean descinfo_read = false;
        while (!descinfo_read) {
            try {
                byte code = this.meg.unmarshalSB1();
                switch (code) {
                    case 8: {
                        byte[] encodedColnames;
                        this.totalColumns = this.meg.unmarshalUB2();
                        this.numuds = this.meg.unmarshalUB2();
                        this.uds = new TTIuds[this.totalColumns];
                        if (_dbcols == null) {
                            _dbcols = new DBColumn[this.totalColumns];
                        }
                        int i2 = 0;
                        while (i2 < this.numuds) {
                            this.uds[i2] = new TTIuds(this.meg);
                            this.uds[i2].unmarshal();
                            ++i2;
                        }
                        this.totalretlen = this.meg.unmarshalUB2();
                        if (this.totalretlen > 960) {
                            DBError.check_error((int)414);
                        }
                        if (this.totalretlen == 0 && (this.numuds > 0 || this.totalColumns > 0)) {
                            DBError.check_error((int)419);
                        }
                        if ((encodedColnames = this.meg.unmarshalCHR(this.totalretlen)) == null || encodedColnames.length == 0 || this.totalretlen == 0) {
                            DBError.check_error((int)438);
                        }
                        this.decodeAllColumnNames(encodedColnames);
                        this.fillupDBcols(_dbcols);
                        break;
                    }
                    case 4: {
                        this.oer.init();
                        this.oer.unmarshal();
                        this.oer.processError();
                        descinfo_read = true;
                    }
                    case 9: {
                        descinfo_read = true;
                    }
                }
            }
            catch (BreakNetException breakNetException) {
                // empty catch block
            }
        }
        return _dbcols;
    }

    private void decodeAllColumnNames(byte[] _encodedstr) throws SQLException {
        int index = 0;
        short numBytes = 0;
        this.colnames = new String[this.numuds];
        int i2 = 0;
        while (i2 < this.numuds) {
            numBytes = this.uds[i2].udscnl;
            index = this.decodeColName(_encodedstr, index, this.colnames, i2, numBytes);
            ++i2;
        }
    }

    private int decodeColName(byte[] _encodedString, int _index, String[] _colNames, int _colIndex, short _numBytes) throws SQLException {
        byte[] _encodedStringCopy = new byte[_numBytes];
        System.arraycopy(_encodedString, _index, _encodedStringCopy, 0, _numBytes);
        String decodedString = this.meg.conv.CharBytesToString(_encodedStringCopy, (int)_numBytes);
        int doubleQuoteIndex = decodedString.indexOf(34);
        char[] colNameInChars = decodedString.toCharArray();
        StringBuffer colNameSB = new StringBuffer();
        int i2 = 0;
        while (i2 < doubleQuoteIndex) {
            if (colNameInChars[i2] != '\'') {
                colNameSB.append(colNameInChars[i2]);
            }
            ++i2;
        }
        _colNames[_colIndex] = colNameSB.toString();
        _index = _index + doubleQuoteIndex + 1;
        return _index;
    }

    public void fillupDBcols(DBColumn[] _dbcols) throws SQLException {
        int i2 = 0;
        while (i2 < this.numuds) {
            _dbcols[this.colOffset + i2] = new DBColumn(this.colnames[i2], this.uds[i2].udsnull, (int)this.uds[i2].udsoac.oacdty, (int)this.uds[i2].udsoac.oacflg, (int)this.uds[i2].udsoac.oacpre, (int)this.uds[i2].udsoac.oacscl, this.uds[i2].udsoac.oacmxl, this.uds[i2].udsoac.oacmal, this.uds[i2].udsoac.oacfl2);
            ++i2;
        }
    }

    public void marshal() throws IOException {
        this.marshalFunHeader();
        this.meg.marshalSWORD(this.cursor_id);
        this.meg.marshalSWORD(this.colOffset + this.startpos);
        this.meg.marshalO2U(this.numitemsO2U);
        this.meg.marshalO2U(this.udsarrayO2U);
        this.meg.marshalSWORD(32);
        this.meg.marshalO2U(this.numudsO2U);
        this.meg.marshalO2U(this.colnameO2U);
        this.meg.marshalSWORD(960);
        this.meg.marshalO2U(this.lencolsO2U);
    }

    static {
        HSTITEMS = 32;
        M_IDEN = 30;
        NBL = 960;
    }
}

