/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.ttc7;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBData;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.dbaccess.DBType;
import oracle.jdbc.ttc7.MAREngine;
import oracle.jdbc.ttc7.PlsqlTTCDataSet;
import oracle.jdbc.ttc7.TTCDataSet;
import oracle.jdbc.ttc7.TTIfun;
import oracle.jdbc.ttc7.TTIiov;
import oracle.jdbc.ttc7.TTIoer;
import oracle.jdbc.ttc7.TTIrxd;
import oracle.jdbc.ttc7.TTIrxh;
import oracle.net.ns.BreakNetException;

public class Oall7
extends TTIfun {
    public static final int PARSE = 1;
    public static final int BIND = 8;
    public static final int DEFINE = 16;
    public static final int EXECUTE = 32;
    public static final int FETCH = 64;
    public static final int CANCEL = 128;
    public static final int COMMIT = 256;
    public static final int EXACTFE = 512;
    public static final int SNDIOV = 1024;
    public static final int NOPLSQL = 32768;
    public int rowsProcessed;
    boolean streamingOn = false;
    private final int OACSIZE = 23;
    private long options;
    private int cursor;
    private byte[] sqlStmt = new byte[0];
    private byte[] dbLink = new byte[0];
    private long[] inVector = new long[0];
    private long[] outVector = new long[0];
    private boolean outVecO2U = false;
    private int outVecRet = 0;
    private boolean outVecRetO2U = false;
    private boolean plsql = false;
    private DBType[] bindTypes;
    private byte[] bindArgs;
    public TTCDataSet binds;
    public TTCDataSet defines;
    public TTIrxd rxd;
    public TTIrxh rxh;
    private byte type;
    private boolean sendDefines = true;
    boolean autoCommitSet;

    public Oall7(MAREngine _mrengine) throws IOException, SQLException {
        super((byte)3, 0, (byte)71);
        this.setMarshalingEngine(_mrengine);
        this.rxh = (TTIrxh)this.meg.types.newTTCMsgObject((byte)3, this.meg);
        this.rxd = new TTIrxd(this.meg);
        this.oer = new TTIoer(this.meg);
    }

    public void init(byte _call, byte _type, int _cursor, byte[] _sqlStmt, TTCDataSet _binds, TTCDataSet _defines, int _batchSize) throws IOException, SQLException {
        this.rowsProcessed = 0;
        this.streamingOn = false;
        this.options = 0L;
        this.dbLink = new byte[0];
        this.plsql = false;
        this.bindTypes = null;
        this.bindArgs = null;
        this.rxh.init();
        this.rxd.init(_binds, _defines);
        this.oer.init();
        if (_sqlStmt == null) {
            DBError.check_error((int)431);
        }
        this.binds = _binds;
        this.defines = _defines;
        this.type = _type;
        this.sendDefines = _call != 3;
        this.options = this.setOptions(_call, _type, _binds, _defines);
        if (this.type == 1 || this.type == 3) {
            this.plsql = true;
        }
        this.cursor = _cursor;
        this.sqlStmt = _sqlStmt;
        this.inVector = new long[7];
        this.inVector[0] = 1L;
        if (this.plsql) {
            this.inVector[1] = 1L;
        } else if ((this.options & 0x20L) > 0L && (this.options & 0x40L) == 0L) {
            this.inVector[1] = this.binds.depth == 0 ? (long)_batchSize : (long)this.binds.depth;
        } else if ((this.options & 0x40L) > 0L) {
            this.inVector[1] = this.defines.depth;
        }
        this.outVecO2U = true;
        this.outVecRetO2U = false;
        this.outVector = new long[2];
        boolean itemsBytes = false;
    }

    public void receive() throws SQLException, IOException {
        boolean rpaProcessed = false;
        boolean rxhProcessed = false;
        boolean iovProcessed = false;
        this.rowsProcessed = 0;
        block9: while (true) {
            try {
                byte code = this.meg.unmarshalSB1();
                switch (code) {
                    case 11: {
                        TTIiov iov = new TTIiov(this.meg);
                        iov.init();
                        iov.unmarshal();
                        if (!iov.isIOVectorEmpty()) {
                            PlsqlTTCDataSet plsqlBinds = (PlsqlTTCDataSet)this.binds;
                            plsqlBinds.setIOVector(iov.getIOVector());
                            TTIrxd tmpRXD = iov.processRXD(plsqlBinds);
                            if (tmpRXD != null) {
                                this.rxd = tmpRXD;
                            }
                        }
                        iovProcessed = true;
                        break;
                    }
                    case 6: {
                        this.rxh.init();
                        this.rxh.unmarshal();
                        if (this.rxh.uacBufLength > 0) {
                            DBError.check_error((int)405);
                        }
                        rxhProcessed = true;
                        break;
                    }
                    case 7: {
                        if (!rxhProcessed && !iovProcessed) {
                            DBError.check_error((int)401);
                        }
                        if (!this.rxd.unmarshal()) continue block9;
                        this.streamingOn = true;
                        return;
                    }
                    case 8: {
                        if (rpaProcessed) {
                            DBError.check_error((int)401);
                        }
                        this.outVecRet = this.meg.unmarshalUB2();
                        int i2 = 0;
                        while (i2 < this.outVecRet) {
                            this.outVector[i2] = this.meg.unmarshalUB4();
                            ++i2;
                        }
                        rpaProcessed = true;
                        break;
                    }
                    case 4: {
                        this.oer.init();
                        this.oer.unmarshal();
                        this.rowsProcessed = this.oer.getCurRowNumber();
                        if (this.type == 0 && (this.type != 0 || this.oer.retCode == 1403)) break block9;
                        this.oer.processError();
                        break block9;
                    }
                    default: {
                        DBError.check_error((int)401);
                        break;
                    }
                }
            }
            catch (BreakNetException ea) {}
        }
    }

    public boolean getColumnsUptoNextSream() throws SQLException, IOException {
        this.streamingOn = false;
        this.receive();
        return this.streamingOn;
    }

    public int getNumRows() {
        int rows = 0;
        if (this.streamingOn) {
            rows = -2;
        } else {
            switch (this.type) {
                case 2: 
                case 4: {
                    rows = this.rowsProcessed;
                    break;
                }
                case 0: {
                    rows = this.defines.unmarshaledRows;
                    break;
                }
                case 1: 
                case 3: {
                    rows = this.binds.unmarshaledRows;
                }
            }
        }
        return rows;
    }

    private int getItemsValueLength(DBData[] _data, int _depth) throws SQLException {
        int bytes = 0;
        if (_data == null || _depth < 1) {
            return bytes;
        }
        int i2 = 0;
        while (i2 < _data.length) {
            int j2 = 0;
            while (j2 < _depth) {
                bytes += _data[i2].getItem((int)j2).data_size;
                ++bytes;
                ++j2;
            }
            ++bytes;
            ++i2;
        }
        return bytes;
    }

    protected void marshal() throws IOException, SQLException {
        super.marshalFunHeader();
        this.meg.marshalUB4(this.options);
        this.meg.marshalSWORD(this.cursor);
        if (this.sqlStmt.length == 0) {
            this.meg.marshalNULLPTR();
        } else {
            this.meg.marshalPTR();
        }
        this.meg.marshalSB4(this.sqlStmt.length);
        if (this.dbLink.length == 0) {
            this.meg.marshalNULLPTR();
        } else {
            this.meg.marshalPTR();
        }
        this.meg.marshalSB4(this.dbLink.length);
        if (this.inVector.length == 0) {
            this.meg.marshalNULLPTR();
        } else {
            this.meg.marshalPTR();
        }
        this.meg.marshalSB4(this.inVector.length);
        this.meg.marshalO2U(this.outVecO2U);
        this.meg.marshalSB4(this.outVecO2U ? this.outVector.length : 0);
        this.meg.marshalO2U(this.outVecRetO2U);
        int defCols = this.defines.numberOfColumns();
        if (defCols > 0 && this.sendDefines) {
            this.meg.marshalPTR();
            this.meg.marshalSWORD(defCols);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalSWORD(0);
        }
        int binCols = this.binds.numberOfColumns();
        if (binCols > 0) {
            this.meg.marshalPTR();
        } else {
            this.meg.marshalNULLPTR();
        }
        this.meg.marshalSWORD(binCols);
        this.meg.marshalCHR(this.sqlStmt);
        this.meg.marshalCHR(this.dbLink);
        this.meg.marshalUB4Array(this.inVector);
    }

    private long setOptions(byte _call, byte _type, TTCDataSet _binds, TTCDataSet _defines) throws SQLException {
        long options = 0L;
        block0 : switch (_call) {
            case 2: {
                options = 32800L;
                if (_type != 0 && this.autoCommitSet) {
                    options |= 0x100L;
                }
            }
            case 1: {
                options |= 1L;
                break;
            }
            case 4: {
                options = 1L;
            }
            case 3: {
                switch (_type) {
                    case 0: {
                        options |= 0x8060L;
                        break;
                    }
                    case 1: 
                    case 3: {
                        options = _binds.depth > 0 ? (options |= 0x428L) : (options |= 0x20L);
                        if (!this.autoCommitSet) break block0;
                        options |= 0x100L;
                        break;
                    }
                    case 2: 
                    case 4: {
                        options |= 0x8020L;
                        if (!this.autoCommitSet) break block0;
                        options |= 0x100L;
                        break;
                    }
                    default: {
                        DBError.check_error((int)432);
                        break;
                    }
                }
                break;
            }
            case 5: {
                options = 32832L;
                break;
            }
            default: {
                DBError.check_error((int)432);
            }
        }
        if (this.type != 1 && this.type != 3) {
            if (_binds.depth != 0) {
                options |= 8L;
            }
            if (this.sendDefines && _defines.depth != 0) {
                options |= 0x10L;
            }
        }
        return options &= 0xFFFFFFFFFFFFFFFFL;
    }

    void release(boolean haveOpenStreams) {
        this.binds = null;
        this.defines = null;
        this.rxd.binds = null;
        this.rxd.defines = null;
        if (!haveOpenStreams) {
            this.rxd.rxdDataSet = null;
        }
    }

    static {
        PARSE = 1;
        BIND = 8;
        DEFINE = 16;
        EXECUTE = 32;
        FETCH = 64;
        CANCEL = 128;
        COMMIT = 256;
        EXACTFE = 512;
        SNDIOV = 1024;
        NOPLSQL = 32768;
    }
}

