/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.ttc7;

import java.io.IOException;
import java.net.InetAddress;
import java.sql.SQLException;
import java.util.Properties;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.ttc7.MAREngine;
import oracle.jdbc.ttc7.TTIfun;
import oracle.jdbc.ttc7.TTIoer;
import oracle.jdbc.util.RepConversion;
import oracle.net.ns.BreakNetException;
import oracle.security.o3logon.O3LoginClientHelper;

public class O3log
extends TTIfun {
    private byte[] user;
    private byte[] password;
    private int auditFlag = 0;
    private long connectFlag = 0L;
    private int revisionLev = 0;
    private int padO2UPtr = 0;
    private boolean padO2U = false;
    private byte[] terminal = new byte[0];
    private byte[] machine = new byte[0];
    private byte[] sysUserName = new byte[0];
    private int sizeofUCAUAC = 4096;
    private byte[] processID = new byte[0];
    private byte[] programName = new byte[0];
    private short svrAttrPtr = 0;
    private int lenSvrAttrs = 0;
    private boolean svrDataO2U = false;
    private long svrDataO2UPtr = 0L;
    private int lenSvrData = 0;
    private int svrInfoLen = 16;
    private boolean svrInfoO2U = false;
    private byte[] svrInfoO2UPtr = new byte[this.svrInfoLen];
    private boolean retLenO2U = false;
    private int retLenO2UPtr = 0;
    public byte[] encryptedSK;
    public byte[] sessionKey;

    public O3log(MAREngine _mrengine, String _user, Properties info, long mode) throws IOException, SQLException {
        super((byte)3, 0, (byte)82);
        this.setMarshalingEngine(_mrengine);
        this.user = this.meg.conv.StringToCharBytes(_user);
        this.password = new byte[0];
        this.connectFlag = mode;
        this.setSessionFields(info);
        this.svrInfoO2U = true;
        this.retLenO2U = true;
        this.oer = new TTIoer(this.meg);
    }

    public O3log(MAREngine _mrengine, String _user, String _password, byte[] _encryptedSK, Properties info, long mode) throws IOException, SQLException {
        super((byte)3, 0, (byte)81);
        this.setMarshalingEngine(_mrengine);
        this.connectFlag = mode;
        this.oer = new TTIoer(this.meg);
        if (_encryptedSK.length > 16) {
            DBError.check_error((int)413);
        }
        String trimUser = _user.trim();
        String trimPwd = _password.trim();
        String noQuotesUser = trimUser;
        String noQuotesPwd = trimPwd;
        if (trimUser.startsWith("\"") || trimUser.endsWith("\"")) {
            noQuotesUser = this.removeQuotes(trimUser);
        }
        if (trimPwd.startsWith("\"") || trimPwd.endsWith("\"")) {
            noQuotesPwd = this.removeQuotes(trimPwd);
        }
        O3LoginClientHelper O3LHelper = new O3LoginClientHelper(this.meg.conv.isServerMultiByte());
        this.sessionKey = O3LHelper.getSessionKey(noQuotesUser, noQuotesPwd, _encryptedSK);
        byte[] passwordNet = this.meg.conv.StringToNetworkRep(noQuotesPwd);
        byte pwdPadLen = passwordNet.length % 8 > 0 ? (byte)((byte)(8 - passwordNet.length % 8)) : (byte)0;
        byte[] paddedPwd = new byte[passwordNet.length + pwdPadLen];
        System.arraycopy(passwordNet, 0, paddedPwd, 0, passwordNet.length);
        byte[] ePwdOnSessKey = O3LHelper.getEPasswd(this.sessionKey, paddedPwd);
        this.user = this.meg.conv.StringToCharBytes(_user);
        this.password = new byte[2 * paddedPwd.length + 1];
        if (this.password.length < 2 * ePwdOnSessKey.length) {
            DBError.check_error((int)413);
        }
        RepConversion.bArray2nibbles((byte[])ePwdOnSessKey, (byte[])this.password);
        this.password[this.password.length - 1] = RepConversion.nibbleToHex(pwdPadLen);
        this.setSessionFields(info);
    }

    public void receive1st() throws SQLException, IOException {
        boolean rpaProcessed = false;
        block6: while (true) {
            try {
                byte code = this.meg.unmarshalSB1();
                switch (code) {
                    case 8: {
                        if (rpaProcessed) {
                            DBError.check_error((int)401);
                        }
                        int eskLength = this.meg.unmarshalUB2();
                        this.encryptedSK = this.meg.unmarshalCHR(16);
                        if (this.encryptedSK == null) {
                            DBError.check_error((int)438);
                        }
                        rpaProcessed = true;
                        break;
                    }
                    case 4: {
                        this.oer.init();
                        this.oer.unmarshal();
                        this.oer.processError();
                        break block6;
                    }
                    default: {
                        DBError.check_error((int)401);
                        break;
                    }
                }
            }
            catch (BreakNetException breakNetException) {}
        }
    }

    public void receive2nd() throws SQLException, IOException {
        block7: while (true) {
            try {
                byte code = this.meg.unmarshalSB1();
                switch (code) {
                    case 8: {
                        DBError.check_error((int)401);
                    }
                    case 4: {
                        this.oer.init();
                        this.oer.unmarshal();
                        this.oer.processError();
                        break block7;
                    }
                    case 15: {
                        this.oer.init();
                        this.oer.unmarshalWarning();
                        this.oer.processWarning();
                        break block7;
                    }
                    default: {
                        DBError.check_error((int)401);
                        break;
                    }
                }
            }
            catch (BreakNetException breakNetException) {}
        }
    }

    public void marshal() throws IOException {
        this.marshalFunHeader();
        if (this.user.length == 0) {
            this.meg.marshalNULLPTR();
        } else {
            this.meg.marshalPTR();
        }
        this.meg.marshalSB4(this.user.length);
        if (this.password.length == 0) {
            this.meg.marshalNULLPTR();
        } else {
            this.meg.marshalPTR();
        }
        this.meg.marshalSB4(this.password.length);
        this.meg.marshalSB4(this.auditFlag);
        this.meg.marshalUB4(this.connectFlag);
        this.meg.marshalSB4(this.revisionLev);
        this.meg.marshalO2U(this.padO2U);
        if (this.terminal.length == 0) {
            this.meg.marshalNULLPTR();
        } else {
            this.meg.marshalPTR();
        }
        this.meg.marshalSB4(this.terminal.length);
        if (this.machine.length == 0) {
            this.meg.marshalNULLPTR();
        } else {
            this.meg.marshalPTR();
        }
        this.meg.marshalSB4(this.machine.length);
        if (this.sysUserName.length == 0) {
            this.meg.marshalNULLPTR();
        } else {
            this.meg.marshalPTR();
        }
        this.meg.marshalSB4(this.sysUserName.length);
        this.meg.marshalSB4(this.sizeofUCAUAC);
        if (this.processID.length == 0) {
            this.meg.marshalNULLPTR();
        } else {
            this.meg.marshalPTR();
        }
        this.meg.marshalSB4(this.processID.length);
        if (this.programName.length == 0) {
            this.meg.marshalNULLPTR();
        } else {
            this.meg.marshalPTR();
        }
        this.meg.marshalSB4(this.programName.length);
        this.meg.marshalSB2(this.svrAttrPtr);
        this.meg.marshalSB4(this.lenSvrAttrs);
        this.meg.marshalO2U(this.svrDataO2U);
        this.meg.marshalSB4(this.lenSvrData);
        this.meg.marshalO2U(this.svrInfoO2U);
        this.meg.marshalSB4(this.svrInfoLen);
        this.meg.marshalO2U(this.retLenO2U);
        this.meg.marshalCHR(this.user);
        this.meg.marshalCHR(this.password);
        this.meg.marshalCHR(this.terminal);
        this.meg.marshalCHR(this.machine);
        this.meg.marshalCHR(this.sysUserName);
        this.meg.marshalCHR(this.processID);
        this.meg.marshalCHR(this.programName);
    }

    private String removeQuotes(String str) {
        int first = 0;
        int last = str.length() - 1;
        int i2 = 0;
        while (i2 < str.length()) {
            if (str.charAt(i2) != '\"') {
                first = i2;
                break;
            }
            ++i2;
        }
        int i3 = str.length() - 1;
        while (i3 >= 0) {
            if (str.charAt(i3) != '\"') {
                last = i3;
                break;
            }
            --i3;
        }
        String result = str.substring(first, last + 1);
        return result;
    }

    public byte[] getSessionKey() {
        return this.sessionKey;
    }

    public void setSessionFields(Properties info) throws SQLException {
        String terminalStr = info.getProperty("v$session.terminal");
        String machineStr = info.getProperty("v$session.machine");
        String osuserStr = info.getProperty("v$session.osuser");
        String programStr = info.getProperty("v$session.program");
        String processStr = info.getProperty("v$session.process");
        if (terminalStr == null) {
            terminalStr = "unknown";
        }
        if (machineStr == null) {
            try {
                machineStr = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception e2) {
                machineStr = "jdbcclient";
            }
        }
        if (osuserStr == null) {
            try {
                osuserStr = OracleDriver.getSystemProperty((String)"user.name");
                if (osuserStr == null) {
                    osuserStr = "jdbcuser";
                }
            }
            catch (Exception e3) {
                osuserStr = "jdbcuser";
            }
        }
        if (programStr == null) {
            programStr = "JDBC Thin Client";
        }
        if (processStr == null) {
            processStr = "";
        }
        this.terminal = this.meg.conv.StringToCharBytes(terminalStr);
        this.machine = this.meg.conv.StringToCharBytes(machineStr);
        this.sysUserName = this.meg.conv.StringToCharBytes(osuserStr);
        this.programName = this.meg.conv.StringToCharBytes(programStr);
        this.processID = this.meg.conv.StringToCharBytes(processStr);
    }
}

