/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.ttc7;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.ttc7.NonPlsqlTTCColumn;
import oracle.jdbc.ttc7.TTCColumn;
import oracle.jdbc.ttc7.TTCDataSet;

public class NonPlsqlTTCDataSet
extends TTCDataSet {
    private NonPlsqlTTCColumn[] columns;
    private boolean streaming;

    protected NonPlsqlTTCDataSet(NonPlsqlTTCColumn[] cols, int depth) {
        super((TTCColumn[])cols, depth);
        this.columns = cols != null ? cols : new NonPlsqlTTCColumn[]{};
        this.streaming = false;
    }

    protected void marshalRow() throws SQLException, IOException {
        int ColOffset = -1;
        int col = 0;
        while (col < this.columns.length) {
            if (!this.columns[col].sizeExceeded()) {
                if (this.columns[col].type.isStream()) {
                    this.columns[col].pushStream();
                } else {
                    this.columns[col].marshal();
                }
            } else if (ColOffset != -1) {
                if (this.columns[col].type.isStream()) {
                    this.columns[col].pushStream();
                } else {
                    this.columns[col].marshal();
                }
            } else {
                ColOffset = col;
            }
            ++col;
        }
        if (ColOffset != -1) {
            if (this.columns[ColOffset].type.isStream()) {
                this.columns[ColOffset].pushStream();
            } else {
                this.columns[ColOffset].marshal();
            }
        }
        ++this.marshaledRows;
    }

    protected boolean unmarshalRow() throws SQLException, IOException {
        this.unmarshaledCols = -1;
        int col = 0;
        while (col < this.columns.length) {
            this.columns[col].clearNull();
            ++col;
        }
        int col2 = 0;
        while (col2 < this.columns.length) {
            this.streaming = this.columns[col2].unmarshal();
            if (this.streaming) {
                return true;
            }
            this.incrementUnmarshaledcols();
            ++col2;
        }
        if (this.isLastCol()) {
            this.incrementeUnmarshaledRows();
        }
        return false;
    }

    protected boolean unmarshalRow(int from_col, int to_col) throws SQLException, IOException {
        this.streaming = false;
        int col = from_col;
        while (col <= to_col) {
            if (this.columns[col].unmarshal()) {
                DBError.check_error((int)401);
            }
            this.incrementUnmarshaledcols();
            ++col;
        }
        if (this.isLastCol()) {
            this.incrementeUnmarshaledRows();
        }
        return false;
    }

    public void processIndicator() throws IOException, SQLException {
        this.columns[this.unmarshaledCols].setItemOriginalSize(this.unmarshaledRows);
    }

    protected boolean next() {
        boolean result = this.columns.length > 0 ? this.columns[0].moreRows() : false;
        return result;
    }

    protected void print(int mod, int submod, int cat) {
        OracleLog.print((Object)this, (int)mod, (int)submod, (int)cat, (String)"    ---- Enter: NonPlsqlTTCDataSet.print --- ");
        super.print(mod, submod, cat);
        OracleLog.print((Object)this, (int)mod, (int)submod, (int)cat, (String)("   unmarshaledCols = " + this.unmarshaledCols));
        OracleLog.print((Object)this, (int)mod, (int)submod, (int)cat, (String)("   streaming       = " + this.streaming));
        OracleLog.print((Object)this, (int)mod, (int)submod, (int)cat, (String)"    ---- Exit: NonPlsqlTTCDataSet.print --- \n");
    }
}

