/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.ttc7;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.ttc7.LongTTCItem;
import oracle.jdbc.ttc7.TTCColumn;
import oracle.jdbc.ttc7.TTCItem;
import oracle.jdbc.ttc7.TTIoac;

public class NonPlsqlTTCColumn
extends TTCColumn {
    private int row;
    private TTCItem[] items;
    private boolean marshaling;

    protected NonPlsqlTTCColumn(TTIoac type, int rowsDepth, boolean marshaling, TTCItem[] items) {
        super(type, rowsDepth);
        this.items = items;
        this.marshaling = marshaling;
    }

    protected boolean sizeExceeded() throws SQLException, IOException {
        int SIZE_LIMIT = 4000;
        short oVersion = this.items[this.row].meg.types.getVersion();
        SIZE_LIMIT = oVersion < 8030 ? 2000 : 4000;
        boolean sizeExceeded = false;
        if (this.type.type != 999 && this.type.type != 96 && this.type.type != 1 && this.type.type != 8 && this.type.type != 24) {
            return false;
        }
        if (this.type.max_length > SIZE_LIMIT) {
            sizeExceeded = true;
        }
        return sizeExceeded;
    }

    protected void marshal() throws IOException, SQLException {
        this.items[this.row].marshal();
        ++this.row;
    }

    public void clearNull() throws SQLException {
        if (this.type.isStream()) {
            this.items[this.row].is_null = false;
        }
    }

    protected boolean unmarshal() throws SQLException, IOException {
        if (this.marshaling) {
            DBError.check_error((int)424);
        }
        if (this.type.isStream()) {
            return true;
        }
        this.items[this.row].unmarshal();
        this.items[this.row++].unmarshalIndicator();
        return false;
    }

    protected void pushStream() throws IOException {
        ((LongTTCItem)this.items[this.row]).putStream();
        ++this.row;
    }

    protected void setItemOriginalSize(int row) throws SQLException, IOException {
        int os = this.items[row].meg.processIndicator(this.items[row].isNull(), this.items[row].getDataSize());
        this.items[row].setOriginalSize(os);
    }

    protected boolean moreRows() {
        return this.row < this.rowsDepth;
    }

    protected void print(int mod, int submod, int cat) {
    }
}

