/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.ttc7;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.Vector;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.ttc7.TTCConversion;
import oracle.jdbc.ttc7.TTCItem;
import oracle.jdbc.ttc7.TTCTypeRep;
import oracle.net.ns.BreakNetException;
import oracle.net.ns.Communication;
import oracle.net.ns.NetException;

/*
 * Exception performing whole class analysis ignored.
 */
public class MAREngine {
    public static final int TTCC_MXL = 252;
    public static final int TTCC_ESC = 253;
    public static final int TTCC_LNG = 254;
    public static final int TTCC_ERR = 255;
    public static final int TTCC_MXIN = 64;
    public static final byte TTCLXMULTI = 1;
    public static final byte TTCLXMCONV = 2;
    public TTCTypeRep types;
    public Communication net;
    public TTCConversion conv;
    public byte proSvrVer;
    protected InputStream inStream;
    boolean sentCancel = false;
    protected OutputStream outStream;
    final byte[] ignored = new byte[255];
    final byte[] tmpBuffer1 = new byte[1];
    final byte[] tmpBuffer2 = new byte[2];
    final byte[] tmpBuffer3 = new byte[3];
    final byte[] tmpBuffer4 = new byte[4];
    final int[] retLen = new int[1];

    protected static String toHex(long value, int bytes) {
        String result;
        switch (bytes) {
            case 1: {
                result = "00" + Long.toString(value & 0xFFL, 16);
                break;
            }
            case 2: {
                result = "0000" + Long.toString(value & 0xFFFFL, 16);
                break;
            }
            case 3: {
                result = "000000" + Long.toString(value & 0xFFFFFFL, 16);
                break;
            }
            case 4: {
                result = "00000000" + Long.toString(value & 0xFFFFFFFFL, 16);
                break;
            }
            case 5: {
                result = "0000000000" + Long.toString(value & 0xFFFFFFFFFFL, 16);
                break;
            }
            case 6: {
                result = "000000000000" + Long.toString(value & 0xFFFFFFFFFFFFL, 16);
                break;
            }
            case 7: {
                result = "00000000000000" + Long.toString(value & 0xFFFFFFFFFFFFFFL, 16);
                break;
            }
            case 8: {
                return MAREngine.toHex((long)(value >> 32), (int)4) + MAREngine.toHex((long)value, (int)4).substring(2);
            }
            default: {
                return "more than 8 bytes";
            }
        }
        return "0x" + result.substring(result.length() - 2 * bytes);
    }

    protected static String toHex(byte value) {
        String result = "00" + Integer.toHexString(value & 0xFF);
        return "0x" + result.substring(result.length() - 2);
    }

    protected static String toHex(short value) {
        return MAREngine.toHex((long)value, (int)2);
    }

    protected static String toHex(int value) {
        return MAREngine.toHex((long)value, (int)4);
    }

    protected static String toHex(byte[] value, int length) {
        if (value == null) {
            return "null";
        }
        if (length > value.length) {
            return "byte array not long enough";
        }
        String result = "[";
        int len = Math.min(64, length);
        int i2 = 0;
        while (i2 < len) {
            result = result + MAREngine.toHex((byte)value[i2]) + " ";
            ++i2;
        }
        if (len < length) {
            result = result + "...";
        }
        return result + "]";
    }

    protected static String toHex(byte[] value) {
        if (value == null) {
            return "null";
        }
        return MAREngine.toHex((byte[])value, (int)value.length);
    }

    public MAREngine(Communication net) throws SQLException, IOException {
        if (net == null) {
            DBError.check_error((int)433);
        }
        this.net = net;
        try {
            this.inStream = net.getInputStream();
            this.outStream = net.getOutputStream();
        }
        catch (NetException ne) {
            throw new IOException(ne.getMessage());
        }
        this.types = new TTCTypeRep();
        this.types.setRep((byte)1, (byte)2);
    }

    public void initBuffers() {
    }

    protected void marshalSB1(byte value) throws IOException {
        this.outStream.write(value);
    }

    protected void marshalUB1(short value) throws IOException {
        this.outStream.write((byte)(value & 0xFF));
    }

    protected void marshalSB2(short value) throws IOException {
        byte bytes = this.value2Buffer((int)value, this.tmpBuffer2, (byte)1);
        if (bytes != 0) {
            this.outStream.write(this.tmpBuffer2, 0, bytes);
        }
    }

    protected void marshalUB2(int value) throws IOException {
        this.marshalSB2((short)(value & 0xFFFF));
    }

    protected void marshalSB4(int value) throws IOException {
        byte bytes = this.value2Buffer(value, this.tmpBuffer4, (byte)2);
        if (bytes != 0) {
            this.outStream.write(this.tmpBuffer4, 0, bytes);
        }
    }

    protected void marshalUB4(long value) throws IOException {
        this.marshalSB4((int)(value & 0xFFFFFFFFFFFFFFFFL));
    }

    protected void marshalSWORD(int value) throws IOException {
        this.marshalSB4(value);
    }

    protected void marshalUWORD(long value) throws IOException {
        this.marshalSB4((int)(value & 0xFFFFFFFFFFFFFFFFL));
    }

    protected void marshalB1Array(byte[] value) throws IOException {
        if (value.length > 0) {
            this.outStream.write(value);
        }
    }

    protected void marshalB1Array(byte[] value, int off, int len) throws IOException {
        if (value.length > 0) {
            this.outStream.write(value, off, len);
        }
    }

    protected void marshalUB4Array(long[] value) throws IOException {
        int i2 = 0;
        while (i2 < value.length) {
            this.marshalSB4((int)(value[i2] & 0xFFFFFFFFFFFFFFFFL));
            ++i2;
        }
    }

    public void marshalO2U(boolean notnull) throws IOException {
        if (notnull) {
            this.addPtr((byte)1);
        } else {
            this.addPtr((byte)0);
        }
    }

    public void marshalNULLPTR() throws IOException {
        this.addPtr((byte)0);
    }

    public void marshalPTR() throws IOException {
        this.addPtr((byte)1);
    }

    protected void marshalCHR(byte[] value) throws IOException {
        if (value.length > 0) {
            if (this.types.isConvNeeded()) {
                this.marshalCLR(value, value.length);
            } else {
                this.outStream.write(value);
            }
        }
    }

    protected void marshalCLR(byte[] value, int valueLen) throws IOException {
        if (valueLen > 64) {
            int len;
            int offset = 0;
            this.outStream.write(-2);
            do {
                int bytesLeft;
                len = (bytesLeft = valueLen - offset) > 64 ? 64 : bytesLeft;
                this.outStream.write((byte)(len & 0xFF));
                this.outStream.write(value, offset, len);
            } while ((offset += len) < valueLen);
            this.outStream.write(0);
        } else {
            this.outStream.write((byte)(valueLen & 0xFF));
            if (value.length != 0) {
                this.outStream.write(value);
            }
        }
    }

    public void marshalDALC(byte[] buffer) throws SQLException, IOException {
        if (buffer == null || buffer.length < 1) {
            this.outStream.write(0);
        } else {
            this.marshalSB4(0xFFFFFFFF & buffer.length);
            this.marshalCLR(buffer, buffer.length);
        }
    }

    protected void addPtr(byte value) throws IOException {
        if ((this.types.rep[3] & 1) > 0) {
            this.outStream.write(value);
        } else {
            byte bytes = this.value2Buffer((int)value, this.tmpBuffer4, (byte)3);
            if (bytes != 0) {
                this.outStream.write(this.tmpBuffer4, 0, bytes);
            }
        }
    }

    protected byte value2Buffer(int value, byte[] outBuffer, byte repOffset) throws IOException {
        boolean zeros = true;
        byte bytes = 0;
        int i2 = outBuffer.length - 1;
        while (i2 >= 0) {
            outBuffer[bytes] = (byte)(value >>> 8 * i2 & 0xFF);
            if ((this.types.rep[repOffset] & 1) > 0) {
                if (!zeros || outBuffer[bytes] != 0) {
                    zeros = false;
                    bytes = (byte)(bytes + 1);
                }
            } else {
                bytes = (byte)(bytes + 1);
            }
            --i2;
        }
        if ((this.types.rep[repOffset] & 1) > 0) {
            this.outStream.write(bytes);
        }
        if ((this.types.rep[repOffset] & 2) > 0) {
            this.reverseArray(outBuffer, bytes);
        }
        return bytes;
    }

    protected void reverseArray(byte[] buffer, byte bytes) {
        int i2 = 0;
        while (i2 < bytes / 2) {
            byte tmp = buffer[i2];
            buffer[i2] = buffer[bytes - 1 - i2];
            buffer[bytes - 1 - i2] = tmp;
            ++i2;
        }
    }

    public byte unmarshalSB1() throws SQLException, IOException {
        byte result = (byte)this.unmarshalUB1();
        return result;
    }

    public short unmarshalUB1() throws SQLException, IOException {
        short value = 0;
        try {
            value = (short)this.inStream.read();
        }
        catch (BreakNetException e2) {
            this.net.sendReset();
            throw e2;
        }
        catch (NetException ne) {
            throw new IOException(ne.getMessage());
        }
        if (value < 0) {
            DBError.check_error((int)410);
        }
        return value;
    }

    public short unmarshalSB2() throws SQLException, IOException {
        short result = (short)this.unmarshalUB2();
        return result;
    }

    public int unmarshalUB2() throws SQLException, IOException {
        int value = (int)this.buffer2Value((byte)1);
        return value & 0xFFFF;
    }

    int unmarshalUCS2(byte[] ucs2Char, long offset) throws SQLException, IOException {
        int value = this.unmarshalUB2();
        this.tmpBuffer2[0] = (byte)((value & 0xFF00) >> 8);
        this.tmpBuffer2[1] = (byte)(value & 0xFF);
        if (offset + 1L < (long)ucs2Char.length) {
            ucs2Char[(int)offset] = this.tmpBuffer2[0];
            ucs2Char[(int)offset + 1] = this.tmpBuffer2[1];
        }
        return this.tmpBuffer2[0] == 0 ? (this.tmpBuffer2[1] == 0 ? 1 : 2) : 3;
    }

    public int unmarshalSB4() throws SQLException, IOException {
        int result = (int)this.unmarshalUB4();
        return result;
    }

    public long unmarshalUB4() throws SQLException, IOException {
        long value = this.buffer2Value((byte)2);
        return value;
    }

    public int unmarshalSB4(byte[] buffer) throws SQLException, IOException {
        long value = this.buffer2Value((byte)2, new ByteArrayInputStream(buffer));
        return (int)value;
    }

    public int unmarshalRefCursor(byte[] buffer) throws SQLException, IOException {
        int result = this.unmarshalSB4(buffer);
        return result;
    }

    public int unmarshalSWORD() throws SQLException, IOException {
        int result = (int)this.unmarshalUB4();
        return result;
    }

    public long unmarshalUWORD() throws SQLException, IOException {
        long result = this.unmarshalUB4();
        return result;
    }

    public byte[] unmarshalNBytes(int n2) throws SQLException, IOException {
        byte[] tmpBuffer = new byte[n2];
        try {
            if (this.inStream.read(tmpBuffer) < 0) {
                DBError.check_error((int)410);
            }
        }
        catch (BreakNetException e2) {
            this.net.sendReset();
            throw e2;
        }
        catch (NetException ne) {
            throw new IOException(ne.getMessage());
        }
        return tmpBuffer;
    }

    public int unmarshalNBytes(byte[] buf, int off, int n2) throws SQLException, IOException {
        int bytes = 0;
        while (bytes < n2) {
            bytes += this.getNBytes(buf, off + bytes, n2 - bytes);
        }
        return bytes;
    }

    public int getNBytes(byte[] buf, int off, int len) throws SQLException, IOException {
        int cnt = 0;
        try {
            cnt = this.inStream.read(buf, off, len);
            if (cnt < 0) {
                DBError.check_error((int)410);
            }
        }
        catch (BreakNetException e2) {
            this.net.sendReset();
            throw e2;
        }
        catch (NetException ne) {
            throw new IOException(ne.getMessage());
        }
        return cnt;
    }

    public byte[] getNBytes(int n2) throws SQLException, IOException {
        byte[] tmpBuffer = new byte[n2];
        try {
            if (this.inStream.read(tmpBuffer) < 0) {
                DBError.check_error((int)410);
            }
        }
        catch (BreakNetException e2) {
            this.net.sendReset();
            throw e2;
        }
        catch (NetException ne) {
            throw new IOException(ne.getMessage());
        }
        return tmpBuffer;
    }

    public byte[] unmarshalTEXT(int bytes) throws SQLException, IOException {
        byte[] buffer;
        int offset = 0;
        byte[] tmpBuffer = new byte[bytes];
        while (offset < bytes) {
            try {
                if (this.inStream.read(tmpBuffer, offset, 1) < 0) {
                    DBError.check_error((int)410);
                }
            }
            catch (BreakNetException e2) {
                this.net.sendReset();
                throw e2;
            }
            catch (NetException ne) {
                throw new IOException(ne.getMessage());
            }
            if (tmpBuffer[offset++] == 0) break;
        }
        if (tmpBuffer.length == --offset) {
            buffer = tmpBuffer;
        } else {
            buffer = new byte[offset];
            System.arraycopy(tmpBuffer, 0, buffer, 0, offset);
        }
        return buffer;
    }

    public byte[] unmarshalCHR(int retLength) throws SQLException, IOException {
        byte[] resBuffer = null;
        if (this.types.isConvNeeded()) {
            resBuffer = this.unmarshalCLR(retLength, this.retLen);
            if (resBuffer.length != this.retLen[0]) {
                byte[] tmpBuf = new byte[this.retLen[0]];
                System.arraycopy(resBuffer, 0, tmpBuf, 0, this.retLen[0]);
                resBuffer = tmpBuf;
            }
        } else {
            resBuffer = this.getNBytes(retLength);
        }
        return resBuffer;
    }

    public void unmarshalCLR(TTCItem item, int[] intArray) throws SQLException, IOException {
        short len = 0;
        int offset = 0;
        boolean optimized = false;
        int lastread = -1;
        len = this.unmarshalUB1();
        if (len < 0) {
            DBError.check_error((int)401);
        }
        if (len == 0) {
            return;
        }
        if (this.escapeSequenceNull((int)len)) {
            intArray[0] = 0;
            return;
        }
        if (len != 254) {
            offset = this.unmarshalBuffer(item.byte_value, offset, (int)len);
        } else {
            lastread = -1;
            block5: while (lastread == -1 || (len = this.unmarshalUB1()) > 0) {
                if (len == 254) {
                    switch (lastread) {
                        case -1: {
                            lastread = 1;
                            continue block5;
                        }
                        case 1: {
                            lastread = 0;
                            break;
                        }
                        case 0: {
                            if (optimized) {
                                lastread = 0;
                                break;
                            }
                            lastread = 0;
                            continue block5;
                        }
                    }
                }
                if (offset == -1) {
                    this.unmarshalBuffer(this.ignored, 0, (int)len);
                } else {
                    offset = this.unmarshalBuffer(item.byte_value, offset, (int)len);
                }
                lastread = 0;
                if (len <= 252) continue;
                optimized = true;
            }
        }
        if (intArray != null) {
            intArray[0] = offset != -1 ? offset : item.byte_value.length;
        }
    }

    /*
     * Unable to fully structure code
     */
    public byte[] unmarshalCLR(int buflen, int[] intArray) throws SQLException, IOException {
        block6: {
            block7: {
                block5: {
                    len = 0;
                    offset = 0;
                    bytes = this.unmarshalUB1();
                    if (bytes < 0) {
                        DBError.check_error((int)401);
                    }
                    if (bytes == 0) {
                        intArray[0] = 0;
                        return new byte[0];
                    }
                    tmpBuf = new byte[buflen * this.conv.getNLSRATIO()];
                    if (!this.escapeSequenceNull((int)bytes)) break block5;
                    intArray[0] = 0;
                    break block6;
                }
                if (bytes == 254) ** GOTO lbl23
                offset = this.unmarshalBuffer(tmpBuf, offset, (int)bytes);
                break block7;
lbl-1000:
                // 1 sources

                {
                    if (len == 254 && this.types.isServerConversion()) continue;
                    if (offset == -1) {
                        this.unmarshalBuffer(this.ignored, 0, (int)len);
                        continue;
                    }
                    offset = this.unmarshalBuffer(tmpBuf, offset, (int)len);
lbl23:
                    // 4 sources

                    ** while ((len = this.unmarshalUB1()) > 0)
                }
            }
            if (intArray != null) {
                intArray[0] = offset != -1 ? offset : tmpBuf.length;
            }
        }
        return tmpBuf;
    }

    private int unmarshalBuffer(byte[] _byteValue, int offset, int len) throws SQLException, IOException {
        if (_byteValue.length < offset + len) {
            this.unmarshalNBytes(_byteValue, offset, _byteValue.length - offset);
            this.unmarshalNBytes(this.ignored, 0, offset + len - _byteValue.length);
            offset = -1;
        } else {
            this.unmarshalNBytes(_byteValue, offset, len);
            offset += len;
        }
        return offset;
    }

    public byte[] unmarshalCLRforREFS() throws SQLException, IOException {
        short len = 0;
        short totalLen = 0;
        byte[] finalBuffer = null;
        Vector<byte[]> refVector = new Vector<byte[]>(10, 10);
        short bytes = this.unmarshalUB1();
        if (bytes < 0) {
            DBError.check_error((int)401);
        }
        if (bytes == 0) {
            return null;
        }
        if (!this.escapeSequenceNull((int)bytes)) {
            byte[] tmpBuf;
            if (bytes == 254) {
                while ((len = this.unmarshalUB1()) > 0) {
                    if (len == 254 && this.types.isServerConversion()) continue;
                    totalLen = (short)(totalLen + len);
                    tmpBuf = new byte[len];
                    this.unmarshalBuffer(tmpBuf, 0, (int)len);
                    refVector.addElement(tmpBuf);
                }
            } else {
                totalLen = bytes;
                tmpBuf = new byte[bytes];
                this.unmarshalBuffer(tmpBuf, 0, (int)bytes);
                refVector.addElement(tmpBuf);
            }
            finalBuffer = new byte[totalLen];
            int start = 0;
            while (refVector.size() > 0) {
                int arrayLen = ((byte[])refVector.elementAt(0)).length;
                System.arraycopy(refVector.elementAt(0), 0, finalBuffer, start, arrayLen);
                start += arrayLen;
                refVector.removeElementAt(0);
            }
        } else {
            finalBuffer = null;
        }
        return finalBuffer;
    }

    public boolean escapeSequenceNull(int bytes) throws SQLException {
        boolean is_null = false;
        switch (bytes) {
            case 0: {
                is_null = true;
                break;
            }
            case 253: {
                DBError.check_error((int)401);
            }
            case 255: {
                is_null = true;
                break;
            }
            case 254: {
                break;
            }
        }
        return is_null;
    }

    public int processIndicator(boolean isNull, int dataSize) throws SQLException, IOException {
        short ind = this.unmarshalSB2();
        int res = 0;
        if (!isNull) {
            res = ind == 0 ? dataSize : (ind == -2 || ind > 0 ? (int)ind : 65536 + ind);
        }
        return res;
    }

    public byte[] unmarshalDALC() throws SQLException, IOException {
        long len = this.unmarshalUB4();
        byte[] buffer = new byte[(int)(0xFFFFFFFFFFFFFFFFL & len)];
        if (buffer.length > 0) {
            if ((buffer = this.unmarshalCLR(buffer.length, this.retLen)) == null) {
                DBError.check_error((int)401);
            }
        } else {
            buffer = new byte[]{};
        }
        return buffer;
    }

    public byte[] unmarshalDALC(int[] CLRRetLen) throws SQLException, IOException {
        long len = this.unmarshalUB4();
        byte[] buffer = new byte[(int)(0xFFFFFFFFFFFFFFFFL & len)];
        if (buffer.length > 0) {
            if ((buffer = this.unmarshalCLR(buffer.length, CLRRetLen)) == null) {
                DBError.check_error((int)401);
            }
        } else {
            buffer = new byte[]{};
        }
        return buffer;
    }

    private long buffer2Value(byte repOffset) throws SQLException, IOException {
        byte[] tmpBuffer;
        int bufLength = 0;
        long value = 0L;
        boolean negative = false;
        if ((this.types.rep[repOffset] & 1) > 0) {
            try {
                bufLength = this.inStream.read();
            }
            catch (BreakNetException e2) {
                this.net.sendReset();
                throw e2;
            }
            catch (NetException ne) {
                throw new IOException(ne.getMessage());
            }
            if ((bufLength & 0x80) > 0) {
                bufLength &= 0x7F;
                negative = true;
            }
            if (bufLength < 0) {
                DBError.check_error((int)410);
            }
            if (bufLength == 0) {
                return 0L;
            }
            if (repOffset == 1 && bufLength > 2 || repOffset == 2 && bufLength > 4) {
                DBError.check_error((int)412);
            }
        } else if (repOffset == 1) {
            bufLength = 2;
        } else if (repOffset == 2) {
            bufLength = 4;
        }
        switch (bufLength) {
            case 1: {
                tmpBuffer = this.tmpBuffer1;
                break;
            }
            case 2: {
                tmpBuffer = this.tmpBuffer2;
                break;
            }
            case 3: {
                tmpBuffer = this.tmpBuffer3;
                break;
            }
            case 4: {
                tmpBuffer = this.tmpBuffer4;
                break;
            }
            default: {
                tmpBuffer = new byte[bufLength];
                break;
            }
        }
        try {
            if (this.inStream.read(tmpBuffer) < 0) {
                DBError.check_error((int)410);
            }
        }
        catch (BreakNetException e3) {
            this.net.sendReset();
            throw e3;
        }
        catch (NetException ne) {
            throw new IOException(ne.getMessage());
        }
        int i2 = 0;
        while (i2 < tmpBuffer.length) {
            long tmpByte = (this.types.rep[repOffset] & 2) > 0 ? (long)(tmpBuffer[tmpBuffer.length - 1 - i2] & 0xFF) & 0xFFL : (long)(tmpBuffer[i2] & 0xFF) & 0xFFL;
            value |= tmpByte << 8 * (tmpBuffer.length - 1 - i2);
            ++i2;
        }
        value &= 0xFFFFFFFFFFFFFFFFL;
        if (negative) {
            value *= -1L;
        }
        return value;
    }

    private long buffer2Value(byte repOffset, ByteArrayInputStream in) throws SQLException, IOException {
        byte[] tmpBuffer;
        int bufLength = 0;
        long value = 0L;
        boolean negative = false;
        if ((this.types.rep[repOffset] & 1) > 0) {
            bufLength = in.read();
            if ((bufLength & 0x80) > 0) {
                bufLength &= 0x7F;
                negative = true;
            }
            if (bufLength < 0) {
                DBError.check_error((int)410);
            }
            if (bufLength == 0) {
                return 0L;
            }
            if (repOffset == 1 && bufLength > 2 || repOffset == 2 && bufLength > 4) {
                DBError.check_error((int)412);
            }
        } else if (repOffset == 1) {
            bufLength = 2;
        } else if (repOffset == 2) {
            bufLength = 4;
        }
        if (in.read(tmpBuffer = new byte[bufLength]) < 0) {
            DBError.check_error((int)410);
        }
        int i2 = 0;
        while (i2 < tmpBuffer.length) {
            short tmpByte = (this.types.rep[repOffset] & 2) > 0 ? (short)(tmpBuffer[tmpBuffer.length - 1 - i2] & 0xFF) : (short)(tmpBuffer[i2] & 0xFF);
            value |= (long)(tmpByte << 8 * (tmpBuffer.length - 1 - i2));
            ++i2;
        }
        value &= 0xFFFFFFFFFFFFFFFFL;
        if (negative) {
            value *= -1L;
        }
        return value;
    }

    static {
        TTCC_MXL = 252;
        TTCC_ESC = 253;
        TTCC_LNG = 254;
        TTCC_ERR = 255;
        TTCC_MXIN = 64;
        TTCLXMULTI = 1;
        TTCLXMCONV = (byte)2;
    }
}

