/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.ttc7;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.dbaccess.DBType;
import oracle.jdbc.driver.OracleInputStream;
import oracle.jdbc.ttc7.MAREngine;
import oracle.jdbc.ttc7.TTCItem;

public class LongTTCItem
extends TTCItem {
    private byte[] buffer = new byte[64];

    protected LongTTCItem(MAREngine _mrengine, DBType _dbtype) {
        super(_mrengine, _dbtype);
    }

    protected void marshal() throws IOException {
        if (this.isNull() || this.stream_value == null) {
            this.meg.marshalUB1((short)253);
            this.meg.marshalUB1((short)1);
        }
    }

    protected void putStream() throws IOException {
        int bytes = 0;
        int bytesRead = 0;
        int bytesToRead = 0;
        int totalBytesRead = 0;
        int data_size = this.getDataSize();
        if (this.isNull() || this.stream_value == null) {
            return;
        }
        this.meg.marshalUB1((short)254);
        do {
            bytesRead = 0;
            bytes = 0;
            while (bytesRead < 64 && totalBytesRead < data_size) {
                bytesToRead = 64 - bytesRead > data_size - totalBytesRead ? data_size - totalBytesRead : 64 - bytesRead;
                bytes = this.stream_value.read(this.buffer, bytesRead, bytesToRead);
                if (bytes < 0) break;
                bytesRead += bytes;
                totalBytesRead += bytes;
            }
            if (bytesRead <= 0) continue;
            this.meg.marshalUB1((short)(bytesRead & 0xFF));
            this.meg.marshalB1Array(this.buffer, 0, bytesRead);
        } while (!this.meg.sentCancel && bytes > -1 && totalBytesRead < data_size);
        this.meg.marshalSB1((byte)0);
    }

    public char[] getChars(short fo_use) throws SQLException {
        OracleInputStream stream = (OracleInputStream)this.stream_value;
        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
        byte[] buffer = new byte[1024];
        int length = 0;
        int totalLength = 0;
        if (stream == null) {
            return null;
        }
        try {
            if (stream.isClosed()) {
                DBError.throwSqlException((int)27);
            }
            while ((length = stream.read(buffer)) != -1) {
                out.write(buffer, 0, length);
                totalLength += length;
            }
            if (totalLength == 0) {
                this.is_null = true;
            }
        }
        catch (IOException e2) {
            DBError.throwSqlException((IOException)e2);
        }
        byte[] _bytes = out.toByteArray();
        this.data_size = _bytes.length;
        this.char_value = new char[this.data_size];
        this.char_size = this.meg.conv.CHARBytesToJavaChars(_bytes, this.data_size, this.char_value);
        return this.char_value;
    }
}

