/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.io.Serializable;
import java.sql.SQLException;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.pool.OracleConnectionCacheImpl;
import oracle.jdbc.pool.OracleDataSource;
import oracle.jdbc.xa.OracleXAConnection;
import oracle.jdbc.xa.OracleXADataSource;

public class OracleXAConnectionCacheImpl
extends OracleConnectionCacheImpl
implements XADataSource,
Serializable {
    private boolean m_nativeXA = false;
    private static final String clientXADS = "oracle.jdbc.xa.client.OracleXADataSource";
    private static final String serverXADS = "oracle.jdbc.xa.server.OracleXADataSource";

    public OracleXAConnectionCacheImpl() throws SQLException {
        this(null);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)"OracleXAConnectionCacheImpl.OracleXAConnectionCacheImpl()");
        }
    }

    public OracleXAConnectionCacheImpl(ConnectionPoolDataSource cpds) throws SQLException {
        super(cpds);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleXAConnectionCacheImpl.OracleXAConnectionCacheImpl(" + cpds + ")"));
        }
        this.m_dataSourceName = "OracleXAConnectionCacheImpl";
    }

    PooledConnection getNewPoolOrXAConnection() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)"OracleXAConnectionCacheImpl.getNewPoolOrXAConnection()");
            OracleLog.print((Object)this, (int)1, (int)512, (int)32, (String)("OracleXAConnectionCacheImpl.getNewPoolOrXAConnection(): m_cpds=" + this.m_cpds));
        }
        if (this.m_cpds == null) {
            if (this.m_user == null || this.m_password == null) {
                DBError.throwSqlException((int)79);
            }
            String xadsClassName = null;
            xadsClassName = OracleDriver.getSystemProperty((String)"oracle.jserver.version") == null ? clientXADS : serverXADS;
            try {
                this.m_cpds = (OracleXADataSource)Class.forName(xadsClassName).newInstance();
            }
            catch (Exception exc) {
                exc.printStackTrace();
                DBError.throwSqlException((int)1);
            }
            this.copy((OracleDataSource)((Object)this.m_cpds));
            ((OracleXADataSource)this.m_cpds).setNativeXA(this.m_nativeXA);
        }
        XAConnection xac = ((OracleXADataSource)this.m_cpds).getXAConnection();
        ((OracleXAConnection)xac).setStmtCacheSize(this.m_stmtCacheSize, this.m_stmtClearMetaData);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleXAConnectionCacheImpl.getNewPoolOrXAConnection(): returned " + xac));
        }
        return xac;
    }

    public synchronized XAConnection getXAConnection() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)"OracleXAConnectionCacheImpl.getXAConnection()");
        }
        XAConnection xc = (XAConnection)super.getPooledConnection(this.m_user, this.m_password);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleXAConnectionCacheImpl.getXAConnection(): returned " + xc));
        }
        return xc;
    }

    public synchronized XAConnection getXAConnection(String user, String passwd) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleXAConnectionCacheImpl.getXAConnection(user=" + user + ", passwd=" + passwd + ")"));
        }
        XAConnection xc = (XAConnection)super.getPooledConnection(user, passwd);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleXAConnectionCacheImpl.getXAConnection(user, passwd): returned " + xc));
        }
        return xc;
    }

    public synchronized boolean getNativeXA() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)"OracleXAConnectionCacheImpl.getNativeXA()");
        }
        return this.m_nativeXA;
    }

    public synchronized void setNativeXA(boolean nativeXA) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleXAConnectionCacheImpl.setNativeXA(" + nativeXA + ")"));
        }
        this.m_nativeXA = nativeXA;
    }

    public synchronized void closeActualConnection(PooledConnection xac) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleXAConnectionCacheImpl.closeActualConnection(" + xac + ")"));
        }
        ((OracleXAConnection)xac).close();
    }

    static {
        clientXADS = clientXADS;
        serverXADS = serverXADS;
    }
}

