/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleCloseCallback;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.driver.OracleLog;

public class OraclePooledConnection
implements PooledConnection,
Serializable {
    public static final String url_string = "connection_url";
    public static final String pool_auto_commit_string = "pool_auto_commit";
    public static final String object_type_map = "obj_type_map";
    public static final String transaction_isolation = "trans_isolation";
    public static final String statement_cache_size = "stmt_cache_size";
    public static final String connect_auto_commit_string = "connect_auto_commit";
    public static final String implicit_caching_enabled = "implicit_cache_enabled";
    public static final String explicit_caching_enabled = "explict_cache_enabled";
    public static final String connection_properties_string = "connection_properties";
    public static final String event_listener_string = "event_listener";
    public static final String sql_exception_string = "sql_exception";
    public static final String close_callback_string = "close_callback";
    public static final String private_data = "private_data";
    private Hashtable m_eventListeners = null;
    private SQLException m_sqlException = null;
    protected boolean m_autoCommit = true;
    protected transient Connection m_logicalHandle = null;
    protected transient Connection m_physicalConn = null;
    private Hashtable m_connectionProperty = null;
    private OracleCloseCallback m_occ = null;
    private Object m_privData = null;
    private long m_lastAccessedTime = 0L;
    protected transient OracleDriver m_oracleDriver = new OracleDriver();

    public OraclePooledConnection() {
        this((Connection)null);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)"OraclePooledConnection.OraclePooledConnection()");
        }
    }

    public OraclePooledConnection(String url) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OraclePooledConnection.OraclePooledConnection(" + url + ")"));
        }
        Connection conn = this.m_oracleDriver.connect(url, new Properties());
        this.initialize(conn);
    }

    public OraclePooledConnection(String url, String user, String passwd) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OraclePooledConnection.OraclePooledConnection(url=" + url + ", user=" + user + ", passwd=" + passwd + ")"));
        }
        Properties props = new Properties();
        props.put("user", user);
        props.put("password", passwd);
        Connection conn = this.m_oracleDriver.connect(url, props);
        this.initialize(conn);
    }

    public OraclePooledConnection(Connection pc) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OraclePooledConnection.OraclePooledConnection(" + pc + ")"));
        }
        this.initialize(pc);
    }

    public OraclePooledConnection(Connection pc, boolean ac) {
        this(pc);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OraclePooledConnection.OraclePooledConnection(pc=" + pc + ", ac=" + ac + ")"));
        }
        this.m_autoCommit = ac;
    }

    private void initialize(Connection pc) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OraclePooledConnection.initialize(" + pc + ")"));
        }
        this.m_physicalConn = pc;
        this.m_eventListeners = new Hashtable(10);
        this.m_occ = null;
        this.m_privData = null;
        this.m_lastAccessedTime = 0L;
    }

    public synchronized void addConnectionEventListener(ConnectionEventListener cel) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OraclePooledConnection.addConnectionEventListener(" + cel + ")"));
        }
        if (this.m_eventListeners == null) {
            this.m_sqlException = new SQLException("Listener Hashtable Null");
        } else {
            this.m_eventListeners.put(cel, cel);
        }
    }

    public synchronized void close() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)"OraclePooledConnection.close()");
        }
        if (this.m_occ != null) {
            this.m_occ.beforeClose((OracleConnection)this.m_physicalConn, this.m_privData);
        }
        if (this.m_physicalConn != null) {
            this.m_physicalConn.close();
            this.m_physicalConn = null;
        }
        if (this.m_occ != null) {
            this.m_occ.afterClose(this.m_privData);
        }
        this.m_lastAccessedTime = 0L;
        this.callListener(2);
    }

    public synchronized Connection getConnection() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)"OraclePooledConnection.getConnection()");
            OracleLog.print((Object)this, (int)1, (int)512, (int)32, (String)("OraclePooledConnection.getConnection(): m_physicalConn=" + this.m_physicalConn));
        }
        if (this.m_physicalConn == null) {
            this.m_sqlException = new SQLException("Physical Connection doesn't exis");
            this.callListener(2);
            DBError.throwSqlException((int)8);
            return null;
        }
        try {
            if (this.m_logicalHandle != null) {
                ((OracleConnection)this.m_logicalHandle).setPhysicalStatus(false);
                this.m_logicalHandle.close();
            }
            this.m_logicalHandle = new OracleConnection(this, (OracleConnection)this.m_physicalConn, this.m_autoCommit);
        }
        catch (SQLException se) {
            this.m_sqlException = se;
            this.callListener(2);
            DBError.throwSqlException((int)8);
            return null;
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OraclePooledConnection.getConnection(): returned " + this.m_logicalHandle));
        }
        return this.m_logicalHandle;
    }

    public synchronized Connection getLogicalHandle() throws SQLException {
        return this.m_logicalHandle;
    }

    public synchronized void setLastAccessedTime(long lastAccessedTime) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OraclePooledConnection.setLastAccessedTime(" + lastAccessedTime + ")"));
        }
        this.m_lastAccessedTime = lastAccessedTime;
    }

    public long getLastAccessedTime() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OraclePooledConnection.getLastAccessedTime(): returned " + this.m_lastAccessedTime));
        }
        return this.m_lastAccessedTime;
    }

    public synchronized void registerCloseCallback(OracleCloseCallback occ, Object privData) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OraclePooledConnection.registerCloseCallback(occ=" + occ + ", privData=" + privData + ")"));
        }
        this.m_occ = occ;
        this.m_privData = privData;
    }

    public synchronized void removeConnectionEventListener(ConnectionEventListener cel) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OraclePooledConnection.removeConnectionEventListener(" + cel + ")"));
        }
        if (this.m_eventListeners == null) {
            this.m_sqlException = new SQLException("Listener Hashtable Null");
        } else {
            this.m_eventListeners.remove(cel);
        }
    }

    public synchronized void logicalClose() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)"OraclePooledConnection.logicalClose()");
        }
        this.callListener(1);
    }

    private void callListener(int callcode) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OraclePooledConnection.callListener(" + callcode + "): m_eventListeners=" + this.m_eventListeners));
        }
        if (this.m_eventListeners == null) {
            return;
        }
        Enumeration listeners = this.m_eventListeners.keys();
        ConnectionEvent ce = new ConnectionEvent(this, this.m_sqlException);
        while (listeners.hasMoreElements()) {
            ConnectionEventListener listKey = (ConnectionEventListener)listeners.nextElement();
            ConnectionEventListener cev = (ConnectionEventListener)this.m_eventListeners.get(listKey);
            if (callcode == 1) {
                cev.connectionClosed(ce);
                continue;
            }
            if (callcode != 2) continue;
            cev.connectionErrorOccurred(ce);
        }
    }

    public synchronized void setStmtCacheSize(int size) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OraclePooledConnection.setStmtCacheSize(" + size + ")"));
        }
        this.setStmtCacheSize(size, false);
    }

    public synchronized void setStmtCacheSize(int size, boolean clearMetaData) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OraclePooledConnection.setStmtCacheSize(size=" + size + ", clearMetaData=" + clearMetaData + ")"));
        }
        if (size < 0) {
            DBError.throwSqlException((int)68);
        }
        if (this.m_physicalConn != null) {
            ((OracleConnection)this.m_physicalConn).setStmtCacheSize(size, clearMetaData);
        }
    }

    public synchronized int getStmtCacheSize() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OraclePooledConnection.getStmtCacheSize(): m_physicalConn=" + this.m_physicalConn));
        }
        if (this.m_physicalConn != null) {
            return ((OracleConnection)this.m_physicalConn).getStmtCacheSize();
        }
        return 0;
    }

    public void setStatementCacheSize(int size) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OraclePooledConnection.setStatementCacheSize(" + size + "), m_physicalConn = " + this.m_physicalConn));
        }
        if (this.m_physicalConn != null) {
            ((OracleConnection)this.m_physicalConn).setStatementCacheSize(size);
        }
    }

    public int getStatementCacheSize() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OraclePooledConnection.getStatementCacheSize(), m_physicalConn = " + this.m_physicalConn));
        }
        if (this.m_physicalConn != null) {
            return ((OracleConnection)this.m_physicalConn).getStatementCacheSize();
        }
        return 0;
    }

    public void setImplicitCachingEnabled(boolean cache) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OraclePooledConnection.setImplicitCachingEnabled(" + cache + "), m_physicalConn = " + this.m_physicalConn));
        }
        if (this.m_physicalConn != null) {
            ((OracleConnection)this.m_physicalConn).setImplicitCachingEnabled(cache);
        }
    }

    public boolean getImplicitCachingEnabled() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OraclePooledConnection.getImplicitCachingEnabled(), m_physicalConn = " + this.m_physicalConn));
        }
        if (this.m_physicalConn != null) {
            return ((OracleConnection)this.m_physicalConn).getImplicitCachingEnabled();
        }
        return false;
    }

    public void setExplicitCachingEnabled(boolean cache) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OraclePooledConnection.setExplicitCachingEnabled(" + cache + "), m_physicalConn = " + this.m_physicalConn));
        }
        if (this.m_physicalConn != null) {
            ((OracleConnection)this.m_physicalConn).setExplicitCachingEnabled(cache);
        }
    }

    public boolean getExplicitCachingEnabled() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OraclePooledConnection.getExplicitCachingEnabled(), m_physicalConn = " + this.m_physicalConn));
        }
        if (this.m_physicalConn != null) {
            return ((OracleConnection)this.m_physicalConn).getExplicitCachingEnabled();
        }
        return false;
    }

    public void purgeImplicitCache() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OraclePooledConnection.purgeImplicitCache(), m_physicalConn = " + this.m_physicalConn));
        }
        if (this.m_physicalConn != null) {
            ((OracleConnection)this.m_physicalConn).purgeImplicitCache();
        }
    }

    public void purgeExplicitCache() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OraclePooledConnection.purgeExplicitCache(), m_physicalConn = " + this.m_physicalConn));
        }
        if (this.m_physicalConn != null) {
            ((OracleConnection)this.m_physicalConn).purgeExplicitCache();
        }
    }

    public PreparedStatement getStatementWithKey(String key) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OraclePooledConnection.getStatementWithKey(key), m_physicalConn = " + this.m_physicalConn));
        }
        if (this.m_physicalConn != null) {
            return ((OracleConnection)this.m_physicalConn).getStatementWithKey(key);
        }
        return null;
    }

    public CallableStatement getCallWithKey(String key) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OraclePooledConnection.getCallWithKey(key), m_physicalConn = " + this.m_physicalConn));
        }
        if (this.m_physicalConn != null) {
            return ((OracleConnection)this.m_physicalConn).getCallWithKey(key);
        }
        return null;
    }

    public boolean isStatementCacheInitialized() {
        if (this.m_physicalConn != null) {
            return ((OracleConnection)this.m_physicalConn).isStatementCacheInitialized();
        }
        return false;
    }

    public final void setProperties(Hashtable prop) {
        this.m_connectionProperty = prop;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        try {
            ((OracleConnection)this.m_physicalConn).getPropertyForPooledConnection(this);
            if (this.m_eventListeners != null) {
                this.m_connectionProperty.put(event_listener_string, this.m_eventListeners);
            }
            if (this.m_sqlException != null) {
                this.m_connectionProperty.put(sql_exception_string, this.m_sqlException);
            }
            this.m_connectionProperty.put(pool_auto_commit_string, "" + this.m_autoCommit);
            if (this.m_occ != null) {
                this.m_connectionProperty.put(close_callback_string, this.m_occ);
            }
            if (this.m_privData != null) {
                this.m_connectionProperty.put(private_data, this.m_privData);
            }
            out.writeObject(this.m_connectionProperty);
            this.m_physicalConn.close();
        }
        catch (SQLException ea) {
            ea.printStackTrace();
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.m_connectionProperty = (Hashtable)in.readObject();
        try {
            Properties prop = (Properties)this.m_connectionProperty.get(connection_properties_string);
            String l_url = prop.getProperty(url_string);
            this.m_oracleDriver = new OracleDriver();
            Connection conn = this.m_oracleDriver.connect(l_url, prop);
            this.initialize(conn);
            this.m_eventListeners = (Hashtable)this.m_connectionProperty.get(event_listener_string);
            this.m_sqlException = (SQLException)this.m_connectionProperty.get(sql_exception_string);
            this.m_autoCommit = ((String)this.m_connectionProperty.get(pool_auto_commit_string)).equals("true");
            this.m_occ = (OracleCloseCallback)this.m_connectionProperty.get(close_callback_string);
            this.m_privData = this.m_connectionProperty.get(private_data);
            Map l_map = (Map)this.m_connectionProperty.get(object_type_map);
            if (l_map != null) {
                ((OracleConnection)conn).setTypeMap(l_map);
            }
            String l_tmp = prop.getProperty(transaction_isolation);
            conn.setTransactionIsolation(Integer.parseInt(l_tmp));
            l_tmp = prop.getProperty(statement_cache_size);
            int l_statementCacheSize = Integer.parseInt(l_tmp);
            if (l_statementCacheSize != -1) {
                this.setStatementCacheSize(l_statementCacheSize);
                l_tmp = prop.getProperty(implicit_caching_enabled);
                this.setImplicitCachingEnabled(Boolean.getBoolean(l_tmp));
                l_tmp = prop.getProperty(explicit_caching_enabled);
                this.setExplicitCachingEnabled(Boolean.getBoolean(l_tmp));
            }
            this.m_physicalConn.setAutoCommit(((String)prop.get(connect_auto_commit_string)).equals("true"));
        }
        catch (Exception ea) {
            ea.printStackTrace();
        }
    }

    static {
        url_string = url_string;
        pool_auto_commit_string = pool_auto_commit_string;
        object_type_map = object_type_map;
        transaction_isolation = transaction_isolation;
        statement_cache_size = statement_cache_size;
        connect_auto_commit_string = connect_auto_commit_string;
        implicit_caching_enabled = implicit_caching_enabled;
        explicit_caching_enabled = explicit_caching_enabled;
        connection_properties_string = connection_properties_string;
        event_listener_string = event_listener_string;
        sql_exception_string = sql_exception_string;
        close_callback_string = close_callback_string;
        private_data = private_data;
    }
}

