/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.oci.OracleOCIConnection;
import oracle.jdbc.oci8.OCIDBAccess;
import oracle.jdbc.pool.OracleDataSource;

public class OracleOCIConnectionPool
extends OracleDataSource {
    public OracleOCIConnection m_connection_pool;
    public static final String IS_CONNECTION_POOLING = "is_connection_pooling";
    private int m_conn_min_limit = 0;
    private int m_conn_max_limit = 0;
    private int m_conn_increment = 0;
    private int m_conn_active_size = 0;
    private int m_conn_pool_size = 0;
    private int m_conn_timeout = 0;
    private String m_conn_nowait = "false";
    private int m_is_transactions_distributed = 0;
    public static final String CONNPOOL_OBJECT = "connpool_object";
    public static final String CONNPOOL_LOGON_MODE = "connection_pool";
    public static final String CONNECTION_POOL = "connection_pool";
    public static final String CONNPOOL_CONNECTION = "connpool_connection";
    public static final String CONNPOOL_PROXY_CONNECTION = "connpool_proxy_connection";
    public static final String CONNPOOL_ALIASED_CONNECTION = "connpool_alias_connection";
    public static final String PROXY_USER_NAME = "proxy_user_name";
    public static final String PROXY_DISTINGUISHED_NAME = "proxy_distinguished_name";
    public static final String PROXY_CERTIFICATE = "proxy_certificate";
    public static final String PROXY_ROLES = "proxy_roles";
    public static final String PROXY_NUM_ROLES = "proxy_num_roles";
    public static final String PROXY_PASSWORD = "proxy_password";
    public static final String PROXYTYPE = "proxytype";
    public static final String PROXYTYPE_USER_NAME = "proxytype_user_name";
    public static final String PROXYTYPE_DISTINGUISHED_NAME = "proxytype_distinguished_name";
    public static final String PROXYTYPE_CERTIFICATE = "proxytype_certificate";
    public static final String CONNECTION_ID = "connection_id";
    public static String CONNPOOL_MIN_LIMIT;
    public static String CONNPOOL_MAX_LIMIT;
    public static String CONNPOOL_INCREMENT;
    public static String CONNPOOL_ACTIVE_SIZE;
    public static String CONNPOOL_POOL_SIZE;
    public static String CONNPOOL_TIMEOUT;
    public static String CONNPOOL_NOWAIT;
    public static String CONNPOOL_IS_POOLCREATED;
    public static final String TRANSACTIONS_DISTRIBUTED = "transactions_distributed";
    private Hashtable m_lconnections = null;
    private boolean m_poolCreated = false;
    private OracleDriver m_oracleDriver = new OracleDriver();
    protected int m_stmtCacheSize = 0;
    protected boolean m_stmtClearMetaData = false;

    public OracleOCIConnectionPool(String us, String p2, String url, Properties info) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleOCIConnectionPool.OracleOCIConnectionPool(us=" + us + ", p=" + p2 + ", url=" + url + ", info=" + info + ")"));
        }
        this.m_lconnections = new Hashtable(10);
        this.setDriverType("oci8");
        this.setURL(url);
        this.setUser(us);
        this.setPassword(p2);
        this.createConnectionPool(info);
    }

    public OracleOCIConnectionPool(String us, String p2, String url) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleOCIConnectionPool.OracleOCIConnectionPool(us=" + us + ", p=" + p2 + ", url=" + url + ")"));
        }
        this.m_lconnections = new Hashtable(10);
        this.setDriverType("oci8");
        this.setURL(url);
        this.setUser(us);
        this.setPassword(p2);
        this.createConnectionPool(null);
    }

    public OracleOCIConnectionPool() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)"OracleOCIConnectionPool.OracleOCIConnectionPool()");
        }
        this.m_lconnections = new Hashtable(10);
        this.setDriverType("oci8");
    }

    public synchronized Connection getConnection() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)"OracleOCIConnectionPool.getConnection()");
            OracleLog.print((Object)this, (int)1, (int)512, (int)64, (String)("OracleOCIConnectionPool.getConnection(): \nUser us " + this.m_user + "URL is " + this.getURL()));
        }
        if (!this.isPoolCreated()) {
            this.createConnectionPool(null);
        }
        Connection conn = this.getConnection(this.m_user, this.m_password);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleOCIConnectionPool.getConnection(): returned " + conn));
        }
        return conn;
    }

    public synchronized Connection getConnection(String us, String p2) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleOCIConnectionPool.getConnection(us=" + us + ", p=" + p2 + ")"));
            OracleLog.print((Object)this, (int)1, (int)512, (int)64, (String)("OracleOCIConnectionPool.getConnection(us,p):\nURL is " + this.getURL()));
        }
        if (!this.isPoolCreated()) {
            this.createConnectionPool(null);
        }
        Properties info = new Properties();
        info.put(IS_CONNECTION_POOLING, "true");
        info.put("user", us);
        info.put("password", p2);
        info.put("connection_pool", CONNPOOL_CONNECTION);
        info.put(CONNPOOL_OBJECT, (OCIDBAccess)this.m_connection_pool.db_access);
        OracleOCIConnection conn = (OracleOCIConnection)this.m_oracleDriver.connect(this.m_url, info);
        conn.setStmtCacheSize(this.m_stmtCacheSize, this.m_stmtClearMetaData);
        this.m_lconnections.put(conn, conn);
        conn.setConnectionPool(this);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleOCIConnectionPool.getConnection(us, p): returned " + conn));
        }
        return conn;
    }

    public synchronized Reference getReference() throws NamingException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)"OracleOCIConnectionPool.getReference()");
        }
        Reference ref = new Reference(this.getClass().getName(), "oracle.jdbc.pool.OracleDataSourceFactory", null);
        super.addRefProperties(ref);
        ref.add(new StringRefAddr(CONNPOOL_MIN_LIMIT, String.valueOf(this.m_conn_min_limit)));
        ref.add(new StringRefAddr(CONNPOOL_MAX_LIMIT, String.valueOf(this.m_conn_max_limit)));
        ref.add(new StringRefAddr(CONNPOOL_INCREMENT, String.valueOf(this.m_conn_increment)));
        ref.add(new StringRefAddr(CONNPOOL_ACTIVE_SIZE, String.valueOf(this.m_conn_active_size)));
        ref.add(new StringRefAddr(CONNPOOL_POOL_SIZE, String.valueOf(this.m_conn_pool_size)));
        ref.add(new StringRefAddr(CONNPOOL_TIMEOUT, String.valueOf(this.m_conn_timeout)));
        ref.add(new StringRefAddr(CONNPOOL_NOWAIT, this.m_conn_nowait));
        ref.add(new StringRefAddr(CONNPOOL_IS_POOLCREATED, String.valueOf(this.isPoolCreated())));
        ref.add(new StringRefAddr(TRANSACTIONS_DISTRIBUTED, String.valueOf(this.isDistributedTransEnabled())));
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleOCIConnectionPool.getReference(): returned " + ref));
        }
        return ref;
    }

    public synchronized OracleConnection getProxyConnection(String proxytype, Properties prop) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleOCIConnectionPool.getProxyConnection(proxytype=" + proxytype + ", prop=" + prop + ")"));
            OracleLog.print((Object)this, (int)1, (int)512, (int)64, (String)("OracleOCIConnectionPool.getProxyConnection(proxytype,prop):\nUser us " + this.m_user + "URL is " + this.getURL()));
        }
        if (!this.isPoolCreated()) {
            this.createConnectionPool(null);
        }
        if (proxytype == PROXYTYPE_USER_NAME) {
            prop.put("user", prop.getProperty(PROXY_USER_NAME));
        } else if (proxytype == PROXYTYPE_DISTINGUISHED_NAME) {
            prop.put("user", prop.getProperty(PROXY_DISTINGUISHED_NAME));
        } else if (proxytype == PROXYTYPE_CERTIFICATE) {
            prop.put("user", String.valueOf(prop.getProperty(PROXY_USER_NAME)));
        } else {
            DBError.throwSqlException((int)107, (Object)"null properties");
        }
        prop.put(IS_CONNECTION_POOLING, "true");
        prop.put(PROXYTYPE, proxytype);
        String[] proxyRoles = (String[])prop.get(PROXY_ROLES);
        if (proxyRoles != null) {
            prop.put(PROXY_NUM_ROLES, new Integer(proxyRoles.length));
        } else {
            prop.put(PROXY_NUM_ROLES, new Integer(0));
        }
        prop.put("connection_pool", CONNPOOL_PROXY_CONNECTION);
        prop.put(CONNPOOL_OBJECT, (OCIDBAccess)this.m_connection_pool.db_access);
        OracleOCIConnection conn = (OracleOCIConnection)this.m_oracleDriver.connect(this.m_url, prop);
        conn.setStmtCacheSize(this.m_stmtCacheSize, this.m_stmtClearMetaData);
        this.m_lconnections.put(conn, conn);
        conn.setConnectionPool(this);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleOCIConnectionPool.getProxyConnection(proxytype, prop): returned " + conn));
        }
        return conn;
    }

    public synchronized OracleConnection getAliasedConnection(byte[] conId) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleOCIConnectionPool.getAliasedConnection(" + OracleLog.bytesToPrintableForm("conId[]=", conId) + ")"));
            OracleLog.print((Object)this, (int)1, (int)512, (int)64, (String)("OracleOCIConnectionPool.getAliasedConnection(conId[]): User us " + this.m_user + "URL is " + this.getURL()));
        }
        if (!this.isPoolCreated()) {
            this.createConnectionPool(null);
        }
        Properties info = new Properties();
        info.put(IS_CONNECTION_POOLING, "true");
        info.put(CONNECTION_ID, conId);
        info.put("connection_pool", CONNPOOL_ALIASED_CONNECTION);
        info.put(CONNPOOL_OBJECT, (OCIDBAccess)this.m_connection_pool.db_access);
        OracleOCIConnection conn = (OracleOCIConnection)this.m_oracleDriver.connect(this.m_url, info);
        conn.setStmtCacheSize(this.m_stmtCacheSize, this.m_stmtClearMetaData);
        this.m_lconnections.put(conn, conn);
        conn.setConnectionPool(this);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleOCIConnectionPool.getAliasedConnection(conId[]): returned " + conn));
        }
        return conn;
    }

    public synchronized void close() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)"OracleOCIConnectionPool.close()");
            OracleLog.print((Object)this, (int)1, (int)512, (int)64, (String)("OracleOCIConnectionPool.close(): User us " + this.m_user + "URL is " + this.getURL()));
        }
        if (!this.isPoolCreated()) {
            return;
        }
        Enumeration e2 = this.m_lconnections.elements();
        while (e2.hasMoreElements()) {
            OracleOCIConnection conn = (OracleOCIConnection)e2.nextElement();
            if (conn == null || conn == this.m_connection_pool) continue;
            conn.close();
        }
        this.m_connection_pool.close();
    }

    public synchronized void setPoolConfig(Properties prop) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleOCIConnectionPool.setPoolConfig(" + prop + ")"));
            OracleLog.print((Object)this, (int)1, (int)512, (int)64, (String)("OracleOCIConnectionPool.setPoolConfig(prop):\nUser us " + this.m_user + "URL is " + this.getURL()));
        }
        Properties info = new Properties();
        if (prop == null) {
            DBError.throwSqlException((int)106, (Object)"null properties");
        }
        if (!this.isPoolCreated()) {
            this.createConnectionPool(prop);
        } else {
            this.checkPoolConfig(prop, info);
            ((OCIDBAccess)this.m_connection_pool.db_access).setConnectionPoolInfo(info, this.m_connection_pool);
        }
        this.storePoolProperties();
    }

    private void checkPoolConfig(Properties pc_in, Properties pc_out) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleOCIConnectionPool.checkPoolConfig(pc_in=" + pc_in + ", pc_out=" + pc_out + ")"));
        }
        String dist_txn = (String)pc_in.get(TRANSACTIONS_DISTRIBUTED);
        String conn_nowait = (String)pc_in.get(CONNPOOL_NOWAIT);
        if (dist_txn != null && !dist_txn.equalsIgnoreCase("true") || conn_nowait != null && !conn_nowait.equalsIgnoreCase("true") || pc_in.get(CONNPOOL_MIN_LIMIT) == null || pc_in.get(CONNPOOL_MAX_LIMIT) == null || pc_in.get(CONNPOOL_INCREMENT) == null || Integer.decode((String)pc_in.get(CONNPOOL_MIN_LIMIT)) < 0 || Integer.decode((String)pc_in.get(CONNPOOL_MAX_LIMIT)) < 0 || Integer.decode((String)pc_in.get(CONNPOOL_INCREMENT)) < 0) {
            DBError.throwSqlException((int)106, (Object)"");
        }
        Enumeration<?> e2 = pc_in.propertyNames();
        while (e2.hasMoreElements()) {
            String key = (String)e2.nextElement();
            String value = pc_in.getProperty(key);
            if (key == TRANSACTIONS_DISTRIBUTED || key == CONNPOOL_NOWAIT) {
                pc_out.put(key, "true");
                continue;
            }
            pc_out.put(key, value);
        }
    }

    private synchronized void storePoolProperties() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)"OracleOCIConnectionPool.storePoolProperties()");
        }
        Properties info = this.getPoolConfig();
        this.m_conn_min_limit = Integer.decode(info.getProperty(CONNPOOL_MIN_LIMIT));
        this.m_conn_max_limit = Integer.decode(info.getProperty(CONNPOOL_MAX_LIMIT));
        this.m_conn_increment = Integer.decode(info.getProperty(CONNPOOL_INCREMENT));
        this.m_conn_active_size = Integer.decode(info.getProperty(CONNPOOL_ACTIVE_SIZE));
        this.m_conn_pool_size = Integer.decode(info.getProperty(CONNPOOL_POOL_SIZE));
        this.m_conn_timeout = Integer.decode(info.getProperty(CONNPOOL_TIMEOUT));
        this.m_conn_nowait = info.getProperty(CONNPOOL_NOWAIT);
    }

    public synchronized Properties getPoolConfig() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)"OracleOCIConnectionPool.getPoolConfig()");
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleOCIConnectionPool.getPoolConfig():\nUser us " + this.m_user + "URL is " + this.getURL()));
        }
        if (!this.isPoolCreated()) {
            this.createConnectionPool(null);
        }
        Properties info = ((OCIDBAccess)this.m_connection_pool.db_access).getConnectionPoolInfo();
        info.put(CONNPOOL_IS_POOLCREATED, String.valueOf(this.isPoolCreated()));
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleOCIConnectionPool.getPoolConfig(): returned " + info));
        }
        return info;
    }

    public synchronized int getActiveSize() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)"OracleOCIConnectionPool.getActiveSize()");
        }
        if (!this.isPoolCreated()) {
            this.createConnectionPool(null);
        }
        Properties info = ((OCIDBAccess)this.m_connection_pool.db_access).getConnectionPoolInfo();
        String value = info.getProperty(CONNPOOL_ACTIVE_SIZE);
        int res = Integer.decode(value);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleOCIConnectionPool.getActiveSize(): returned " + res));
        }
        return res;
    }

    public synchronized int getPoolSize() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)"OracleOCIConnectionPool.getPoolSize()");
        }
        if (!this.isPoolCreated()) {
            this.createConnectionPool(null);
        }
        Properties info = ((OCIDBAccess)this.m_connection_pool.db_access).getConnectionPoolInfo();
        String value = info.getProperty(CONNPOOL_POOL_SIZE);
        int res = Integer.decode(value);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleOCIConnectionPool.getPoolSize(): returned " + res));
        }
        return res;
    }

    public synchronized int getTimeout() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)"OracleOCIConnectionPool.getTimeout()");
        }
        if (!this.isPoolCreated()) {
            this.createConnectionPool(null);
        }
        Properties info = ((OCIDBAccess)this.m_connection_pool.db_access).getConnectionPoolInfo();
        String value = info.getProperty(CONNPOOL_TIMEOUT);
        int res = Integer.decode(value);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleOCIConnectionPool.getTimeout(): returned " + res));
        }
        return res;
    }

    public synchronized String getNoWait() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)"OracleOCIConnectionPool.getNoWait()");
        }
        if (!this.isPoolCreated()) {
            this.createConnectionPool(null);
        }
        Properties info = ((OCIDBAccess)this.m_connection_pool.db_access).getConnectionPoolInfo();
        return info.getProperty(CONNPOOL_NOWAIT);
    }

    public synchronized int getMinLimit() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)"OracleOCIConnectionPool.getMinLimit()");
        }
        if (!this.isPoolCreated()) {
            this.createConnectionPool(null);
        }
        Properties info = ((OCIDBAccess)this.m_connection_pool.db_access).getConnectionPoolInfo();
        String value = info.getProperty(CONNPOOL_MIN_LIMIT);
        int res = Integer.decode(value);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleOCIConnectionPool.getMinLimit(): returned " + res));
        }
        return res;
    }

    public synchronized int getMaxLimit() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)"OracleOCIConnectionPool.getMaxLimit()");
        }
        if (!this.isPoolCreated()) {
            this.createConnectionPool(null);
        }
        Properties info = ((OCIDBAccess)this.m_connection_pool.db_access).getConnectionPoolInfo();
        String value = info.getProperty(CONNPOOL_MAX_LIMIT);
        int res = Integer.decode(value);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleOCIConnectionPool.getMaxLimit(): returned " + res));
        }
        return res;
    }

    public synchronized int getConnectionIncrement() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)"OracleOCIConnectionPool.getConnectionIncrement()");
        }
        if (!this.isPoolCreated()) {
            this.createConnectionPool(null);
        }
        Properties info = ((OCIDBAccess)this.m_connection_pool.db_access).getConnectionPoolInfo();
        String value = info.getProperty(CONNPOOL_INCREMENT);
        int res = Integer.decode(value);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleOCIConnectionPool.getConnectionIncrement(): returned " + res));
        }
        return res;
    }

    public synchronized boolean isDistributedTransEnabled() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)"OracleOCIConnectionPool.isDistributedTransEnabled()");
            OracleLog.print((Object)this, (int)1, (int)512, (int)32, (String)("OracleOCIConnectionPool.isDistributedTransEnabled(): m_is_transactions_distributed=" + this.m_is_transactions_distributed));
        }
        return this.m_is_transactions_distributed == 1;
    }

    private void createConnectionPool(Properties poolConfig) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleOCIConnectionPool.createConnectionPool(" + poolConfig + ")"));
        }
        if (this.isPoolCreated()) {
            return;
        }
        if (this.m_user == null || this.m_password == null) {
            DBError.throwSqlException((int)106, (Object)" ");
        } else {
            Properties info = new Properties();
            if (poolConfig != null) {
                this.checkPoolConfig(poolConfig, info);
            }
            info.put(IS_CONNECTION_POOLING, "true");
            info.put("user", this.m_user);
            info.put("password", this.m_password);
            info.put("connection_pool", "connection_pool");
            if (this.getURL() == null) {
                this.makeURL();
            }
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleOCIConnectionPool.createConnectionPool(User us " + this.m_user + "URL is " + this.getURL()));
            }
            this.m_connection_pool = (OracleOCIConnection)this.m_oracleDriver.connect(this.m_url, info);
            this.m_poolCreated = true;
            this.m_connection_pool.setConnectionPool(this);
            this.m_lconnections.put(this.m_connection_pool, this.m_connection_pool);
            this.storePoolProperties();
            if (poolConfig != null && poolConfig.getProperty(TRANSACTIONS_DISTRIBUTED) != null) {
                this.m_is_transactions_distributed = 1;
            }
        }
    }

    public synchronized boolean isPoolCreated() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleOCIConnectionPool.isPoolCreated(): returned " + this.m_poolCreated));
        }
        return this.m_poolCreated;
    }

    public synchronized void connectionClosed(OracleOCIConnection conn) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleOCIConnectionPool.connectionClosed(" + conn + ")"));
        }
        if (this.m_lconnections.remove(conn) == null) {
            DBError.throwSqlException((int)1, (Object)"internal OracleOCIConnectionPool error");
        }
    }

    public synchronized void setStmtCacheSize(int size) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleOCIConnectionPool.setStmtCacheSize(" + size + ")"));
        }
        this.setStmtCacheSize(size, false);
    }

    public synchronized void setStmtCacheSize(int size, boolean clearMetaData) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleOCIConnectionPool.setStmtCacheSize(size=" + size + ", clearMetaData=" + clearMetaData + ")"));
            OracleLog.print((Object)this, (int)1, (int)512, (int)64, (String)("OracleOCIConnectionPool.setStmtCacheSize(size, clearMetaDate):\nUser us " + this.m_user + "URL is " + this.getURL()));
        }
        if (size < 0) {
            DBError.throwSqlException((int)68);
        }
        this.m_stmtCacheSize = size;
        this.m_stmtClearMetaData = clearMetaData;
    }

    public synchronized int getStmtCacheSize() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleOCIConnectionPool.getStmtCacheSize(): returned " + this.m_stmtCacheSize));
        }
        return this.m_stmtCacheSize;
    }

    public synchronized boolean isStmtCacheEnabled() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleOCIConnectionPool.isStmtCacheEnabled(): m_stmtCacheSize=" + this.m_stmtCacheSize));
        }
        return this.m_stmtCacheSize > 0;
    }

    static {
        IS_CONNECTION_POOLING = IS_CONNECTION_POOLING;
        CONNPOOL_OBJECT = CONNPOOL_OBJECT;
        CONNPOOL_LOGON_MODE = "connection_pool";
        CONNECTION_POOL = "connection_pool";
        CONNPOOL_CONNECTION = CONNPOOL_CONNECTION;
        CONNPOOL_PROXY_CONNECTION = CONNPOOL_PROXY_CONNECTION;
        CONNPOOL_ALIASED_CONNECTION = CONNPOOL_ALIASED_CONNECTION;
        PROXY_USER_NAME = PROXY_USER_NAME;
        PROXY_DISTINGUISHED_NAME = PROXY_DISTINGUISHED_NAME;
        PROXY_CERTIFICATE = PROXY_CERTIFICATE;
        PROXY_ROLES = PROXY_ROLES;
        PROXY_NUM_ROLES = PROXY_NUM_ROLES;
        PROXY_PASSWORD = PROXY_PASSWORD;
        PROXYTYPE = PROXYTYPE;
        PROXYTYPE_USER_NAME = PROXYTYPE_USER_NAME;
        PROXYTYPE_DISTINGUISHED_NAME = PROXYTYPE_DISTINGUISHED_NAME;
        PROXYTYPE_CERTIFICATE = PROXYTYPE_CERTIFICATE;
        CONNECTION_ID = CONNECTION_ID;
        CONNPOOL_MIN_LIMIT = "connpool_min_limit";
        CONNPOOL_MAX_LIMIT = "connpool_max_limit";
        CONNPOOL_INCREMENT = "connpool_increment";
        CONNPOOL_ACTIVE_SIZE = "connpool_active_size";
        CONNPOOL_POOL_SIZE = "connpool_pool_size";
        CONNPOOL_TIMEOUT = "connpool_timeout";
        CONNPOOL_NOWAIT = "connpool_nowait";
        CONNPOOL_IS_POOLCREATED = "connpool_is_poolcreated";
        TRANSACTIONS_DISTRIBUTED = TRANSACTIONS_DISTRIBUTED;
    }
}

