/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.pool.OracleConnectionCacheImpl;
import oracle.jdbc.pool.OracleConnectionPoolDataSource;
import oracle.jdbc.pool.OracleDataSource;
import oracle.jdbc.pool.OracleOCIConnectionPool;
import oracle.jdbc.xa.client.OracleXADataSource;

public class OracleDataSourceFactory
implements ObjectFactory {
    public Object getObjectInstance(Object refObj, Name name, Context nameCtx, Hashtable env) throws Exception {
        String pn;
        StringRefAddr st;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleDataSourceFactory.getObjectInstance(refObj=" + refObj + ", name=" + name + ", nameCtx=" + nameCtx + ", env=" + env + ")"));
        }
        Reference ref = (Reference)refObj;
        OracleDataSource ods = null;
        String cn = ref.getClassName();
        Properties info = new Properties();
        if (cn.equals("oracle.jdbc.pool.OracleDataSource")) {
            ods = new OracleDataSource();
        } else if (cn.equals("oracle.jdbc.pool.OracleConnectionPoolDataSource")) {
            ods = new OracleConnectionPoolDataSource();
        } else if (cn.equals("oracle.jdbc.xa.client.OracleXADataSource")) {
            ods = new OracleXADataSource();
        } else if (cn.equals("oracle.jdbc.pool.OracleConnectionCacheImpl")) {
            ods = new OracleConnectionCacheImpl();
            st = null;
            pn = null;
            st = (StringRefAddr)ref.get("minLimit");
            if (st != null) {
                pn = (String)st.getContent();
                ((OracleConnectionCacheImpl)ods).setMinLimit(Integer.parseInt(pn));
            }
            if ((st = (StringRefAddr)ref.get("maxLimit")) != null) {
                pn = (String)st.getContent();
                ((OracleConnectionCacheImpl)ods).setMaxLimit(Integer.parseInt(pn));
            }
            if ((st = (StringRefAddr)ref.get("cacheScheme")) != null) {
                pn = (String)st.getContent();
                ((OracleConnectionCacheImpl)ods).setCacheScheme(Integer.parseInt(pn));
            }
        } else if (cn.equals("oracle.jdbc.pool.OracleOCIConnectionPool")) {
            ods = new OracleOCIConnectionPool();
            String pn_conn_min_limit = null;
            String pn_conn_max_limit = null;
            String pn_conn_increment = null;
            String pn_conn_active_size = null;
            String pn_conn_pool_size = null;
            String pn_conn_timeout = null;
            String pn_conn_nowait = null;
            StringRefAddr st2 = null;
            Object pn2 = null;
            String pn_txn_dist = null;
            st2 = (StringRefAddr)ref.get(OracleOCIConnectionPool.CONNPOOL_MIN_LIMIT);
            if (st2 != null) {
                pn_conn_min_limit = (String)st2.getContent();
            }
            if ((st2 = (StringRefAddr)ref.get(OracleOCIConnectionPool.CONNPOOL_MAX_LIMIT)) != null) {
                pn_conn_max_limit = (String)st2.getContent();
            }
            if ((st2 = (StringRefAddr)ref.get(OracleOCIConnectionPool.CONNPOOL_INCREMENT)) != null) {
                pn_conn_increment = (String)st2.getContent();
            }
            if ((st2 = (StringRefAddr)ref.get(OracleOCIConnectionPool.CONNPOOL_ACTIVE_SIZE)) != null) {
                pn_conn_active_size = (String)st2.getContent();
            }
            if ((st2 = (StringRefAddr)ref.get(OracleOCIConnectionPool.CONNPOOL_POOL_SIZE)) != null) {
                pn_conn_pool_size = (String)st2.getContent();
            }
            if ((st2 = (StringRefAddr)ref.get(OracleOCIConnectionPool.CONNPOOL_TIMEOUT)) != null) {
                pn_conn_timeout = (String)st2.getContent();
            }
            if ((st2 = (StringRefAddr)ref.get(OracleOCIConnectionPool.CONNPOOL_NOWAIT)) != null) {
                pn_conn_nowait = (String)st2.getContent();
            }
            if ((st2 = (StringRefAddr)ref.get("transactions_distributed")) != null) {
                pn_txn_dist = (String)st2.getContent();
            }
            info.put(OracleOCIConnectionPool.CONNPOOL_MIN_LIMIT, pn_conn_min_limit);
            info.put(OracleOCIConnectionPool.CONNPOOL_MAX_LIMIT, pn_conn_max_limit);
            info.put(OracleOCIConnectionPool.CONNPOOL_INCREMENT, pn_conn_increment);
            info.put(OracleOCIConnectionPool.CONNPOOL_ACTIVE_SIZE, pn_conn_active_size);
            info.put(OracleOCIConnectionPool.CONNPOOL_POOL_SIZE, pn_conn_pool_size);
            info.put(OracleOCIConnectionPool.CONNPOOL_TIMEOUT, pn_conn_timeout);
            if (pn_conn_nowait == "true") {
                info.put(OracleOCIConnectionPool.CONNPOOL_NOWAIT, pn_conn_nowait);
            }
            if (pn_txn_dist == "true") {
                info.put("transactions_distributed", pn_txn_dist);
            }
        } else {
            return null;
        }
        if (ods != null) {
            st = null;
            st = (StringRefAddr)ref.get("url");
            if (st != null) {
                ods.setURL((String)st.getContent());
            }
            if ((st = (StringRefAddr)ref.get("userName")) != null || (st = (StringRefAddr)ref.get("u")) != null || (st = (StringRefAddr)ref.get("user")) != null) {
                ods.setUser((String)st.getContent());
            }
            if ((st = (StringRefAddr)ref.get("passWord")) != null || (st = (StringRefAddr)ref.get("password")) != null) {
                ods.setPassword((String)st.getContent());
            }
            if ((st = (StringRefAddr)ref.get("description")) != null || (st = (StringRefAddr)ref.get("describe")) != null) {
                ods.setDescription((String)st.getContent());
            }
            if ((st = (StringRefAddr)ref.get("driverType")) != null || (st = (StringRefAddr)ref.get("driver")) != null) {
                ods.setDriverType((String)st.getContent());
            }
            if ((st = (StringRefAddr)ref.get("serverName")) != null || (st = (StringRefAddr)ref.get("host")) != null) {
                ods.setServerName((String)st.getContent());
            }
            if ((st = (StringRefAddr)ref.get("databaseName")) != null || (st = (StringRefAddr)ref.get("sid")) != null) {
                ods.setDatabaseName((String)st.getContent());
            }
            if ((st = (StringRefAddr)ref.get("networkProtocol")) != null || (st = (StringRefAddr)ref.get("protocol")) != null) {
                ods.setNetworkProtocol((String)st.getContent());
            }
            if ((st = (StringRefAddr)ref.get("portNumber")) != null || (st = (StringRefAddr)ref.get("port")) != null) {
                pn = (String)st.getContent();
                ods.setPortNumber(Integer.parseInt(pn));
            }
            if ((st = (StringRefAddr)ref.get("tnsentryname")) != null || (st = (StringRefAddr)ref.get("tns")) != null) {
                ods.setTNSEntryName((String)st.getContent());
            }
            if (cn.equals("oracle.jdbc.pool.OracleOCIConnectionPool")) {
                String pn_is_poolCreated = null;
                st = (StringRefAddr)ref.get(OracleOCIConnectionPool.CONNPOOL_IS_POOLCREATED);
                if (st != null) {
                    pn_is_poolCreated = (String)st.getContent();
                }
                if (pn_is_poolCreated.equals(String.valueOf("true"))) {
                    ((OracleOCIConnectionPool)ods).setPoolConfig(info);
                }
            }
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleDataSourceFactory.getObjectInstance(refObj): returned " + ods));
        }
        return ods;
    }
}

