/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.DataSource;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.driver.OracleLog;

public class OracleDataSource
implements DataSource,
Serializable,
Referenceable {
    protected PrintWriter m_pw = null;
    protected int m_loginTimeout = 0;
    protected String m_databaseName = null;
    protected String m_serviceName = null;
    protected String m_dataSourceName = "OracleDataSource";
    protected String m_description = null;
    protected String m_networkProtocol = "tcp";
    protected int m_portNumber = 0;
    protected String m_user = null;
    protected String m_password = null;
    protected String m_serverName = null;
    protected String m_url = null;
    protected String m_driverType = null;
    protected String m_tnsentry = null;
    protected int m_maxStatements = 0;
    protected boolean m_implicitCachingEnabled = false;
    protected boolean m_explicitCachingEnabled = false;
    protected Properties m_connectionProperties;
    private boolean m_url_explicit = false;
    private boolean m_use_defConn = false;
    protected transient OracleDriver m_od = new OracleDriver();

    public OracleDataSource() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)"OracleDataSource.OracleDataSource()");
        }
    }

    public synchronized Connection getConnection() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)"OracleDataSource.getConnection()");
        }
        return this.getConnection(this.m_user, this.m_password);
    }

    public synchronized Connection getConnection(String user, String passwd) throws SQLException {
        Properties props;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleDataSource.getConnection(user=" + user + ", passwd=" + passwd + ")"));
        }
        this.makeURL();
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)32, (String)("OracleDataSource.getConnection(user, passwd): URL is" + this.m_url));
        }
        Connection conn = null;
        Properties properties = props = this.m_connectionProperties == null ? new Properties() : this.m_connectionProperties;
        if (user != null) {
            props.put("user", user);
        }
        if (passwd != null) {
            props.put("password", passwd);
        }
        if (this.m_loginTimeout != 0) {
            props.put("oracle.net.CONNECT_TIMEOUT", "" + this.m_loginTimeout * 1000);
        }
        if (this.m_od == null) {
            this.m_od = new OracleDriver();
        }
        conn = this.m_use_defConn ? this.m_od.defaultConnection() : this.m_od.connect(this.m_url, props);
        ((OracleConnection)conn).setStatementCacheSize(this.m_maxStatements);
        ((OracleConnection)conn).setImplicitCachingEnabled(this.m_implicitCachingEnabled);
        ((OracleConnection)conn).setExplicitCachingEnabled(this.m_explicitCachingEnabled);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleDataSource.getConnection(user, passwd): returned " + conn));
        }
        return conn;
    }

    public synchronized int getLoginTimeout() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleDataSource.getLoginTimeout(): returned " + this.m_loginTimeout));
        }
        return this.m_loginTimeout;
    }

    public synchronized void setLoginTimeout(int timeout) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleDataSource.setLoginTimeout(" + timeout + ")"));
        }
        this.m_loginTimeout = timeout;
    }

    public synchronized void setLogWriter(PrintWriter pw) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleDataSource.setLogWriter(" + pw + ")"));
        }
        this.m_pw = pw;
        OracleLog.setLogWriter((PrintWriter)pw);
    }

    public synchronized PrintWriter getLogWriter() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleDataSource.getLogWriter(): returned " + this.m_pw));
        }
        return this.m_pw;
    }

    public synchronized void setTNSEntryName(String dbname) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleDataSource.setTNSEntryName(" + dbname + ")"));
        }
        this.m_tnsentry = dbname;
    }

    public synchronized String getTNSEntryName() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleDataSource.getTNSEntryName(): returned " + this.m_tnsentry));
        }
        return this.m_tnsentry;
    }

    public synchronized void setDataSourceName(String dsname) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleDataSource.setDataSourceName(" + dsname + ")"));
        }
        this.m_dataSourceName = dsname;
    }

    public synchronized String getDataSourceName() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleDataSource.getDataSourceName(): returned " + this.m_dataSourceName));
        }
        return this.m_dataSourceName;
    }

    public synchronized String getDatabaseName() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleDataSource.getDatabaseName(): returned " + this.m_databaseName));
        }
        return this.m_databaseName;
    }

    public synchronized void setDatabaseName(String dsname) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleDataSource.setDatabaseName(" + dsname + "): returned " + dsname));
        }
        this.m_databaseName = dsname;
    }

    public synchronized void setServiceName(String svcname) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleDataSource.setServiceName(" + svcname + ")"));
        }
        this.m_serviceName = svcname;
    }

    public synchronized String getServiceName() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleDataSource.getServiceName: returned " + this.m_serviceName));
        }
        return this.m_serviceName;
    }

    public synchronized void setServerName(String sn) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleDataSource.setServerName(" + sn + "): returned " + sn));
        }
        this.m_serverName = sn;
    }

    public synchronized String getServerName() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleDataSource.getServerName(): returned " + this.m_serverName));
        }
        return this.m_serverName;
    }

    public synchronized void setURL(String url) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleDataSource.setURL(" + url + ")"));
        }
        this.m_url = url;
        if (this.m_url != null) {
            this.m_url_explicit = true;
        }
    }

    public synchronized String getURL() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleDataSource.getURL(): m_url_explicit=" + this.m_url_explicit));
        }
        if (!this.m_url_explicit) {
            this.makeURL();
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleDataSource.getURL(): returned " + this.m_url));
        }
        return this.m_url;
    }

    public synchronized void setUser(String user) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleDataSource.setUser(" + user + "): returned " + user));
        }
        this.m_user = user;
    }

    public synchronized String getUser() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleDataSource.getUser(): returned " + this.m_user));
        }
        return this.m_user;
    }

    public synchronized void setPassword(String pd) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleDataSource.setPassword(" + pd + "): returned " + pd));
        }
        this.m_password = pd;
    }

    protected synchronized String getPassword() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleDataSource.getPassword(): returned " + this.m_password));
        }
        return this.m_password;
    }

    public synchronized String getDescription() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleDataSource.getDescription(): returned " + this.m_description));
        }
        return this.m_description;
    }

    public synchronized void setDescription(String des) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleDataSource.setDescription(" + des + "): returned " + des));
        }
        this.m_description = des;
    }

    public synchronized String getDriverType() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleDataSource.getDriverType(): returned " + this.m_driverType));
        }
        return this.m_driverType;
    }

    public synchronized void setDriverType(String dt) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleDataSource.setDriverType(" + dt + ")"));
        }
        this.m_driverType = dt;
    }

    public synchronized String getNetworkProtocol() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleDataSource.getNetworkProtocol(): returned " + this.m_networkProtocol));
        }
        return this.m_networkProtocol;
    }

    public synchronized void setNetworkProtocol(String np) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleDataSource.setNetworkProtocol(" + np + ")"));
        }
        this.m_networkProtocol = np;
    }

    public synchronized void setPortNumber(int pn) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleDataSource.setPortNumber(" + pn + ")"));
        }
        this.m_portNumber = pn;
    }

    public synchronized int getPortNumber() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleDataSource.getPortNumber(): returned " + this.m_portNumber));
        }
        return this.m_portNumber;
    }

    public synchronized Reference getReference() throws NamingException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)"OracleDataSource.getReference()");
        }
        Reference ref = new Reference(this.getClass().getName(), "oracle.jdbc.pool.OracleDataSourceFactory", null);
        this.addRefProperties(ref);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleDataSource.getReference(): returned " + ref));
        }
        return ref;
    }

    protected void addRefProperties(Reference ref) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleDataSource.addRefProperties(" + ref + ")"));
            OracleLog.print((Object)this, (int)1, (int)512, (int)32, (String)("OracleDataSource.addRefProperties(ref):\nm_url=" + this.m_url + ", m_user=" + this.m_user + ", m_password" + this.m_password + ", m_description" + this.m_description + ", m_driverType" + this.m_driverType + ", m_serverName" + this.m_serverName + ", m_databaseName" + this.m_databaseName + ", m_serviceName" + this.m_serviceName + ", m_networkProtocol" + this.m_networkProtocol + ", m_portNumber" + this.m_portNumber + ", m_tnsentry" + this.m_tnsentry + ", m_maxStatements=" + this.m_maxStatements + ", m_implicitCachingEnabled=" + this.m_implicitCachingEnabled + ", m_explicitCachingEnabled=" + this.m_explicitCachingEnabled));
        }
        if (this.m_url != null) {
            ref.add(new StringRefAddr("url", this.m_url));
        }
        if (this.m_user != null) {
            ref.add(new StringRefAddr("userName", this.m_user));
        }
        if (this.m_password != null) {
            ref.add(new StringRefAddr("passWord", this.m_password));
        }
        if (this.m_description != null) {
            ref.add(new StringRefAddr("description", this.m_description));
        }
        if (this.m_driverType != null) {
            ref.add(new StringRefAddr("driverType", this.m_driverType));
        }
        if (this.m_serverName != null) {
            ref.add(new StringRefAddr("serverName", this.m_serverName));
        }
        if (this.m_databaseName != null) {
            ref.add(new StringRefAddr("databaseName", this.m_databaseName));
        }
        if (this.m_serviceName != null) {
            ref.add(new StringRefAddr("serviceName", this.m_serviceName));
        }
        if (this.m_networkProtocol != null) {
            ref.add(new StringRefAddr("networkProtocol", this.m_networkProtocol));
        }
        if (this.m_portNumber != 0) {
            ref.add(new StringRefAddr("portNumber", Integer.toString(this.m_portNumber)));
        }
        if (this.m_tnsentry != null) {
            ref.add(new StringRefAddr("tnsentryname", this.m_tnsentry));
        }
        if (this.m_maxStatements != 0) {
            ref.add(new StringRefAddr("maxStatements", Integer.toString(this.m_maxStatements)));
        }
        if (this.m_implicitCachingEnabled) {
            ref.add(new StringRefAddr("implicitCachingEnabled", "true"));
        }
        if (this.m_explicitCachingEnabled) {
            ref.add(new StringRefAddr("explicitCachingEnabled", "true"));
        }
    }

    void makeURL() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)"OracleDataSource.makeURL()");
            OracleLog.print((Object)this, (int)1, (int)512, (int)32, (String)("OracleDataSource.makeURL(): m_url_explicit=" + this.m_url_explicit + ", m_driverType=" + this.m_driverType));
        }
        if (this.m_url_explicit) {
            return;
        }
        if (this.m_driverType == null || !this.m_driverType.equals("oci8") && !this.m_driverType.equals("oci") && !this.m_driverType.equals("thin") && !this.m_driverType.equals("kprb")) {
            DBError.check_error((int)67, (Object)"OracleDataSource.makeURL");
        }
        if (this.m_driverType.equals("kprb")) {
            this.m_use_defConn = true;
            this.m_url = "jdbc:oracle:kprb:@";
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleDataSource.makeURL(): m_use_defConn=" + this.m_use_defConn + ", m_url=" + this.m_url));
            }
            return;
        }
        if ((this.m_driverType.equals("oci8") || this.m_driverType.equals("oci")) && this.m_networkProtocol != null && this.m_networkProtocol.equals("ipc")) {
            this.m_url = "jdbc:oracle:oci:@";
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleDataSource.makeURL(): m_url=" + this.m_url));
            }
            return;
        }
        if (this.m_tnsentry != null) {
            this.m_url = "jdbc:oracle:" + this.m_driverType + ":@" + this.m_tnsentry;
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleDataSource.makeURL(): m_url=" + this.m_url));
            }
            return;
        }
        if (this.m_serviceName != null) {
            this.m_url = "jdbc:oracle:" + this.m_driverType + ":@(DESCRIPTION=(ADDRESS=(PROTOCOL=" + this.m_networkProtocol + ")(PORT=" + this.m_portNumber + ")(HOST=" + this.m_serverName + "))(CONNECT_DATA=(SERVICE_NAME=" + this.m_serviceName + ")))";
        } else {
            this.m_url = "jdbc:oracle:" + this.m_driverType + ":@(DESCRIPTION=(ADDRESS=(PROTOCOL=" + this.m_networkProtocol + ")(PORT=" + this.m_portNumber + ")(HOST=" + this.m_serverName + "))(CONNECT_DATA=(SID=" + this.m_databaseName + ")))";
            DBError.addSqlWarning(null, (SQLWarning)new SQLWarning("URL with SID jdbc:subprotocol:@host:port:sid will be deprecated in 10i\nPlease use URL with SERVICE_NAME as jdbc:subprotocol:@//host:port/service_name"));
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleDataSource.makeURL(): m_url=" + this.m_url));
        }
    }

    protected void trace(String s2) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleDataSource.trace(" + s2 + "): m_pw=" + this.m_pw));
        }
        if (this.m_pw != null) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)32, (String)"OracleDataSource.trace(s): m_pw is not null");
        }
    }

    void copy(OracleDataSource ds) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleDataSource.copy(" + ds + ")"));
        }
        ds.setUser(this.m_user);
        ds.setPassword(this.m_password);
        ds.setTNSEntryName(this.m_tnsentry);
        this.makeURL();
        ds.setURL(this.m_url);
    }

    public void setMaxStatements(int max) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleDataSource.setMaxStatements(" + max + ")"));
        }
        this.m_maxStatements = max;
    }

    public int getMaxStatements() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleDataSource.getMaxStatements(), returning " + this.m_maxStatements));
        }
        return this.m_maxStatements;
    }

    public void setImplicitCachingEnabled(boolean cache) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleDataSource.setImplicitCachingEnabled(" + cache + ")"));
        }
        this.m_implicitCachingEnabled = cache;
    }

    public boolean getImplicitCachingEnabled() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleDataSource.getImplicitCachingEnabled(), returning " + this.m_implicitCachingEnabled));
        }
        return this.m_implicitCachingEnabled;
    }

    public void setExplicitCachingEnabled(boolean cache) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleDataSource.setExplicitCachingEnabled(" + cache + ")"));
        }
        this.m_explicitCachingEnabled = cache;
    }

    public boolean getExplicitCachingEnabled() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleDataSource.getExplicitCachingEnabled(), returning " + this.m_explicitCachingEnabled));
        }
        return this.m_explicitCachingEnabled;
    }

    public void setConnectionProperties(Properties value) throws SQLException {
        this.m_connectionProperties = value;
    }

    public Properties getConnectionProperties() throws SQLException {
        return this.m_connectionProperties;
    }
}

