/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.pool.OracleDataSource;
import oracle.jdbc.pool.OraclePooledConnection;

public class OracleConnectionPoolDataSource
extends OracleDataSource
implements ConnectionPoolDataSource {
    public OracleConnectionPoolDataSource() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)"OracleConnectionPoolDataSource.OracleConnectionPoolDataSource()");
        }
        this.m_dataSourceName = "OracleConnectionPoolDataSource";
    }

    public synchronized PooledConnection getPooledConnection() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)"OracleConnectionPoolDataSource.getPooledConnection()");
        }
        return this.getPooledConnection(this.m_user, this.m_password);
    }

    public synchronized PooledConnection getPooledConnection(String user, String passwd) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleConnectionPoolDataSource.getPooledConnection(user=" + user + ", passwd=" + passwd + ")"));
            OracleLog.print((Object)this, (int)1, (int)512, (int)32, (String)("OracleConnectionPoolDataSource.getPooledConnection(user,passwd): URL is " + this.m_url));
        }
        Connection conn = this.getPhysicalConnection(this.m_url, user, passwd);
        OraclePooledConnection opc = new OraclePooledConnection(conn);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleConnectionPoolDataSource.getPooledConnection(user, passwd): returned " + opc));
        }
        return opc;
    }

    protected Connection getPhysicalConnection() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)"OracleConnectionPoolDataSource.getPhysicalConnection()");
        }
        return super.getConnection(this.m_user, this.m_password);
    }

    protected Connection getPhysicalConnection(String url, String user, String passwd) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleConnectionPoolDataSource.getPhysicalConnection(url=" + url + ", user=" + user + ")"));
        }
        this.m_url = url;
        return super.getConnection(user, passwd);
    }

    protected Connection getPhysicalConnection(String user, String passwd) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleConnectionPoolDataSource.getPhysicalConnection(user=" + user + ", passwd=" + passwd + ")"));
        }
        return super.getConnection(user, passwd);
    }
}

