/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.io.Serializable;
import java.sql.SQLException;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.pool.OracleConnectionCache;
import oracle.jdbc.pool.OracleConnectionCacheImpl;

public class OracleConnectionEventListener
implements ConnectionEventListener,
Serializable {
    static final int _CLOSED_EVENT = 1;
    static final int _ERROROCCURED_EVENT = 2;
    private DataSource m_ds = null;
    protected long m_lastCleanupTime = -1L;

    public OracleConnectionEventListener() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)"OracleConnectionEventListener.OracleConnectionEventListener()");
        }
        this.m_ds = null;
    }

    public OracleConnectionEventListener(DataSource ds) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleConnectionEventListener.OracleConnectionEventListener(" + ds + ")"));
        }
        this.m_ds = ds;
    }

    public void setDataSource(DataSource ds) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleConnectionEventListener.setDataSource(" + ds + ")"));
        }
        this.m_ds = ds;
    }

    public void connectionClosed(ConnectionEvent ce) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleConnectionEventListener.connectionClosed(" + ce + ")"));
        }
        try {
            if (this.m_ds != null && this.m_ds instanceof OracleConnectionCache) {
                ((OracleConnectionCache)this.m_ds).reusePooledConnection((PooledConnection)ce.getSource());
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void connectionErrorOccurred(ConnectionEvent ce) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleConnectionEventListener.connectionErrorOccurred(" + ce + ")"));
        }
        try {
            if (this.m_ds != null && this.m_ds instanceof OracleConnectionCache) {
                ((OracleConnectionCache)this.m_ds).closePooledConnection((PooledConnection)ce.getSource());
            }
        }
        catch (SQLException se) {
            this.cleanupInvalidConnections(se);
        }
    }

    protected synchronized void cleanupInvalidConnections(SQLException se) {
        try {
            long interval;
            long currTime;
            if (this.m_ds != null && this.m_ds instanceof OracleConnectionCacheImpl && (currTime = System.currentTimeMillis()) - this.m_lastCleanupTime > (interval = ((OracleConnectionCacheImpl)this.m_ds).getConnectionCleanupInterval()) * 1000L) {
                if (((OracleConnectionCacheImpl)this.m_ds).isFatalConnectionError(se)) {
                    ((OracleConnectionCacheImpl)this.m_ds).closeConnections();
                }
                this.m_lastCleanupTime = System.currentTimeMillis();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        _CLOSED_EVENT = 1;
        _ERROROCCURED_EVENT = 2;
    }
}

