/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.sql.PooledConnection;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.pool.OracleConnectionCacheImpl;
import oracle.jdbc.pool.OraclePooledConnection;

public class OracleConnectionCacheTimeOutThread
extends Thread
implements Serializable {
    private OracleConnectionCacheImpl m_occi = null;

    OracleConnectionCacheTimeOutThread(OracleConnectionCacheImpl occimpl) throws SQLException {
        this.m_occi = occimpl;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)"OracleConnectionCacheTimeOutThread(occimpl)");
        }
    }

    public void run() {
        block8: {
            long threadTTLTimeOut = 0L;
            long threadInactivityTimeOut = 0L;
            boolean timeToLive = true;
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)"OracleConnectionCacheTimeOutThread:run()");
            }
            try {
                while (timeToLive) {
                    threadTTLTimeOut = this.m_occi.getCacheTimeToLiveTimeout();
                    if (threadTTLTimeOut > 0L) {
                        this.runTimeToLiveTimeOut(threadTTLTimeOut);
                    }
                    if ((threadInactivityTimeOut = this.m_occi.getCacheInactivityTimeout()) > 0L) {
                        this.runInactivityTimeOut(threadInactivityTimeOut);
                    }
                    Thread.sleep(this.m_occi.getThreadWakeUpInterval() * 1000L);
                    if (this.m_occi.m_cache != null && (threadTTLTimeOut > 0L || threadInactivityTimeOut > 0L)) continue;
                    timeToLive = false;
                }
            }
            catch (SQLException e2) {
                if (OracleLog.TRACE) {
                    OracleLog.print((Object)this, (int)1, (int)512, (int)32, (String)"OracleConnectionCacheTimeOutThread.run()", (Exception)e2);
                }
            }
            catch (InterruptedException ie) {
                if (!OracleLog.TRACE) break block8;
                OracleLog.print((Object)this, (int)1, (int)512, (int)32, (String)"OracleConnectionCacheTimeOutThread.run()", (Exception)ie);
            }
        }
    }

    public void runTimeToLiveTimeOut(long threadTTLTimeOut) throws SQLException {
        long connCurrTime = 0L;
        long connStartTime = 0L;
        int activeCacheSize = 0;
        PooledConnection pooledConn = null;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)32, (String)("runTimeToLiveTimeOut():timeOut=<" + threadTTLTimeOut + ">" + ", activeSize=<" + this.m_occi.getActiveSize() + ">"));
        }
        if ((activeCacheSize = this.m_occi.getActiveSize()) > 0) {
            Enumeration connSet = this.m_occi.m_activeCache.keys();
            while (connSet.hasMoreElements()) {
                Connection conn;
                block10: {
                    pooledConn = (PooledConnection)connSet.nextElement();
                    conn = ((OraclePooledConnection)pooledConn).getLogicalHandle();
                    if (conn != null) {
                        connStartTime = ((OracleConnection)conn).getStartTime();
                    }
                    if ((connCurrTime = System.currentTimeMillis()) - connStartTime <= threadTTLTimeOut * 1000L) continue;
                    if (OracleLog.TRACE) {
                        OracleLog.print((Object)this, (int)1, (int)512, (int)32, (String)"OracleConnectionCacheTimeOutThread.runTimeToLiveTimeOut():TTL Timeout expired... Executing cancel()/close()");
                    }
                    try {
                        ((OracleConnection)conn).cancel();
                    }
                    catch (SQLException e2) {
                        if (!OracleLog.TRACE) break block10;
                        OracleLog.print((Object)this, (int)1, (int)512, (int)32, (String)"OracleConnectionCacheTimeOutThread.runTimeToLiveTimeout()", (Exception)e2);
                    }
                }
                try {
                    conn.close();
                }
                catch (SQLException e3) {
                    if (!OracleLog.TRACE) continue;
                    OracleLog.print((Object)this, (int)1, (int)512, (int)32, (String)("OracleConnectionCacheTimeOutThread.runTimeToLiveTimeOut():Exception:" + e3));
                }
            }
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)32, (String)("OracleConnectionCacheTimeOutThread.runTimeToLiveTimeOut():activeCacheSize=" + activeCacheSize + "TTLTimeOut=" + threadTTLTimeOut));
        }
    }

    public void runInactivityTimeOut(long threadInactivityTimeOut) throws SQLException {
        block7: {
            long lastAccessedTime = 0L;
            long currentTime = 0L;
            long timeOut = threadInactivityTimeOut * 1000L;
            OraclePooledConnection pooledConn = null;
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)1, (int)512, (int)32, (String)("OracleConnectionCacheTimeOutThread.runInactivityTimeOut():threadInactivityTimeOut=" + threadInactivityTimeOut));
            }
            try {
                if (this.m_occi.m_cache != null && this.m_occi.m_cache.size() > 0 && this.m_occi.m_cacheSize > this.m_occi._MIN_LIMIT) {
                    Enumeration pooledConnSet = this.m_occi.m_cache.elements();
                    while (this.m_occi.m_cacheSize > this.m_occi._MIN_LIMIT && pooledConnSet.hasMoreElements()) {
                        pooledConn = (OraclePooledConnection)pooledConnSet.nextElement();
                        lastAccessedTime = pooledConn.getLastAccessedTime();
                        currentTime = System.currentTimeMillis();
                        if (currentTime - lastAccessedTime <= timeOut) continue;
                        try {
                            this.m_occi.closeSingleConnection((PooledConnection)pooledConn, false);
                        }
                        catch (SQLException ea) {
                            if (!OracleLog.TRACE) continue;
                            OracleLog.print((Object)this, (int)1, (int)512, (int)32, (String)("OracleConnectionCacheTimeOutThread.runInactivityTimeOut():Exception:" + ea));
                        }
                    }
                }
            }
            catch (NoSuchElementException ne) {
                if (!OracleLog.TRACE) break block7;
                OracleLog.print((Object)this, (int)1, (int)512, (int)32, (String)"OracleConnectionCacheTimeOutThread.runInactivityTimeOut()", (Exception)ne);
            }
        }
    }
}

