/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.pool.OracleConnectionCache;
import oracle.jdbc.pool.OracleConnectionCacheTimeOutThread;
import oracle.jdbc.pool.OracleConnectionEventListener;
import oracle.jdbc.pool.OracleConnectionPoolDataSource;
import oracle.jdbc.pool.OracleDataSource;
import oracle.jdbc.pool.OraclePooledConnection;

public class OracleConnectionCacheImpl
extends OracleDataSource
implements OracleConnectionCache,
Serializable,
Referenceable {
    protected ConnectionPoolDataSource m_cpds = null;
    protected static int _DEFAULT_MIN_LIMIT = 0;
    protected static int _DEFAULT_MAX_LIMIT = Integer.MAX_VALUE;
    protected int _MIN_LIMIT = _DEFAULT_MIN_LIMIT;
    protected int _MAX_LIMIT = _DEFAULT_MAX_LIMIT;
    protected static final int DEFAULT_CACHE_TIMEOUT = -1;
    protected static final int DEFAULT_THREAD_INTERVAL = 900;
    public static final int ORAERROR_END_OF_FILE_ON_COM_CHANNEL = 3113;
    public static final int ORAERROR_NOT_CONNECTED_TO_ORACLE = 3114;
    public static final int ORAERROR_INIT_SHUTDOWN_IN_PROGRESS = 1033;
    public static final int ORAERROR_ORACLE_NOT_AVAILABLE = 1034;
    public static final int ORAERROR_IMMEDIATE_SHUTDOWN_IN_PROGRESS = 1089;
    public static final int ORAERROR_SHUTDOWN_IN_PROGRESS_NO_CONN = 1090;
    public static final int ORAERROR_NET_IO_EXCEPTION = 17002;
    protected long m_cacheTTLTimeOut = -1L;
    protected long m_cacheInactivityTimeOut = -1L;
    protected long m_cacheFixedWaitTimeOut = -1L;
    protected long m_threadInterval = 900L;
    Stack m_cache = new Stack();
    Hashtable m_activeCache = new Hashtable(50);
    private Object CACHE_SIZE_LOCK = new String("");
    protected int m_cacheSize = 0;
    protected int m_activeSize = 0;
    protected int m_cacheScheme;
    protected long m_cleanupInterval = 30L;
    protected int[] m_fatalErrorCodes = null;
    public static final long DEFAULT_FIXED_WAIT_IDLE_TIME = 30L;
    protected long m_fixedWaitIdleTime = -1L;
    public static final int DYNAMIC_SCHEME = 1;
    public static final int FIXED_WAIT_SCHEME = 2;
    public static final int FIXED_RETURN_NULL_SCHEME = 3;
    protected OracleConnectionEventListener m_ocel = null;
    protected int m_stmtCacheSize = 0;
    protected boolean m_stmtClearMetaData = false;
    protected OracleConnectionCacheTimeOutThread m_timeOutThread = null;
    SQLWarning m_warning = null;

    public OracleConnectionCacheImpl() throws SQLException {
        this(null);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)"OracleConnectionCacheImpl.OracleConnectionCacheImpl()");
        }
    }

    public OracleConnectionCacheImpl(ConnectionPoolDataSource ds) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleConnectionCacheImpl.OracleConnectionCacheImpl(" + ds + ")"));
        }
        this.m_cacheScheme = 1;
        this.m_cpds = ds;
        this.m_ocel = new OracleConnectionEventListener((DataSource)this);
        this.m_dataSourceName = "OracleConnectionCacheImpl";
    }

    public synchronized void setConnectionPoolDataSource(ConnectionPoolDataSource ds) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleConnectionCacheImpl.setConnectionPoolDataSource(" + ds + ")"));
        }
        if (this.m_cacheSize > 0) {
            DBError.throwSqlException((int)78);
        }
        this.m_cpds = ds;
    }

    public synchronized Connection getConnection() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)"OracleConnectionCacheImpl.getConnection()");
        }
        return this.getConnection(this.m_user, this.m_password);
    }

    public synchronized Connection getConnection(String user, String passwd) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleConnectionCacheImpl.getConnection(user=" + user + ", passwd=" + passwd + ")"));
        }
        Connection conn = null;
        PooledConnection pc = this.getPooledConnection(user, passwd);
        if (pc != null) {
            conn = pc.getConnection();
        }
        if (conn != null) {
            ((OracleConnection)conn).setStartTime(System.currentTimeMillis());
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PooledConnection getPooledConnection(String user, String passwd) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleConnectionCacheImpl.getPooledConnection(user=" + user + ", passwd=" + passwd + ")"));
        }
        PooledConnection pc = null;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)32, (String)("OracleConnectionCacheImpl.getPooledConnection(user,passwd): -start m_cacheSize=" + this.m_cacheSize));
        }
        if (!this.m_cache.empty()) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)1, (int)512, (int)32, (String)("OracleConnectionCacheImpl.getPooledConnection(user,passwd):  Active Count" + this.m_activeSize));
            }
            this.checkCredentials(user, passwd);
            pc = this.removeConnectionFromCache();
        } else {
            if (this.m_cacheSize < this._MAX_LIMIT || this.m_cacheScheme == 1) {
                if (OracleLog.TRACE) {
                    OracleLog.print((Object)this, (int)1, (int)512, (int)32, (String)("OracleConnectionCacheImpl.getPooledConnection(user,passwd):  Getting a new one m_cacheSize " + this.m_cacheSize + " m_activeSize " + this.m_activeSize));
                }
                String mc_user = null;
                String mc_passwd = null;
                if (this.m_cpds != null) {
                    mc_user = ((OracleConnectionPoolDataSource)this.m_cpds).getUser();
                    mc_passwd = ((OracleConnectionPoolDataSource)this.m_cpds).getPassword();
                }
                if (this.m_cacheSize > 0 && user != null && !user.equalsIgnoreCase(mc_user)) {
                    DBError.throwSqlException((int)79);
                } else if (user != null) {
                    this.m_user = user;
                    if (this.m_cpds != null) {
                        ((OracleConnectionPoolDataSource)this.m_cpds).setUser(user);
                    }
                }
                if (this.m_cacheSize > 0 && passwd != null && !passwd.equalsIgnoreCase(mc_passwd)) {
                    DBError.throwSqlException((int)79);
                } else if (passwd != null) {
                    this.m_password = passwd;
                    if (this.m_cpds != null) {
                        ((OracleConnectionPoolDataSource)this.m_cpds).setPassword(passwd);
                    }
                }
                pc = this.getNewPoolOrXAConnection();
                Object object = this.CACHE_SIZE_LOCK;
                synchronized (object) {
                    ++this.m_cacheSize;
                }
            }
            if (this.m_cacheScheme != 3) {
                this.checkCredentials(user, passwd);
                long startTime = System.currentTimeMillis();
                while (this.m_cache.empty()) {
                    if (OracleLog.TRACE) {
                        OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)"OracleConnectionCacheImpl.getPooledConnection(user, passwd): Waiting...");
                    }
                    if (this.m_cacheFixedWaitTimeOut > 0L && System.currentTimeMillis() - startTime > this.m_cacheFixedWaitTimeOut * 1000L) {
                        DBError.throwSqlException((int)126);
                    }
                    Stack stack = this.m_cache;
                    synchronized (stack) {
                        block30: {
                            try {
                                this.m_cache.wait((this.m_fixedWaitIdleTime == -1L ? 30L : this.m_fixedWaitIdleTime) * 1000L);
                            }
                            catch (InterruptedException ea) {
                                if (!OracleLog.TRACE) break block30;
                                OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)"OracleConnectionCacheImpl.getPooledConnection  (use, passwd): got an InterruptedException", (Exception)ea);
                            }
                        }
                    }
                }
                pc = this.removeConnectionFromCache();
            }
        }
        if (pc != null) {
            pc.addConnectionEventListener((ConnectionEventListener)this.m_ocel);
            this.m_activeCache.put(pc, pc);
            ++this.m_activeSize;
            ((OraclePooledConnection)pc).setStmtCacheSize(this.m_stmtCacheSize, this.m_stmtClearMetaData);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleConnectionCacheImpl.getPooledConnection(use, passwd): returned " + pc));
        }
        return pc;
    }

    PooledConnection getNewPoolOrXAConnection() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)"OracleConnectionCacheImpl.getNewPoolOrXAConnection()");
        }
        if (this.m_cpds == null) {
            if (this.m_user == null || this.m_password == null) {
                DBError.throwSqlException((int)79);
            }
            this.m_cpds = new OracleConnectionPoolDataSource();
            this.copy((OracleDataSource)((Object)this.m_cpds));
        }
        PooledConnection pc = this.m_cpds.getPooledConnection();
        ((OraclePooledConnection)pc).setStmtCacheSize(this.m_stmtCacheSize, this.m_stmtClearMetaData);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleConnectionCacheImpl.getNewPoolOrXAConnection(): returned " + pc));
        }
        return pc;
    }

    public void reusePooledConnection(PooledConnection pc) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleConnectionCacheImpl.reusePooledConnection(" + pc + ")"));
        }
        this.detachSingleConnection(pc);
        if (this.m_cache.size() >= this._MAX_LIMIT && this.m_cacheScheme == 1) {
            this.closeSingleConnection(pc, false);
        } else {
            this.putConnectionToCache(pc);
        }
    }

    public void closePooledConnection(PooledConnection pc) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleConnectionCacheImpl.closePooledConnection(" + pc + ")"));
        }
        this.detachSingleConnection(pc);
        this.closeSingleConnection(pc, false);
    }

    private void detachSingleConnection(PooledConnection pc) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleConnectionCacheImpl.detachSingleConnection(" + pc + ")"));
        }
        pc.removeConnectionEventListener((ConnectionEventListener)this.m_ocel);
        this.m_activeCache.remove(pc);
        this.m_activeSize = this.m_activeCache.size();
    }

    public void closeSingleConnection(PooledConnection pc) throws SQLException {
        this.closeSingleConnection(pc, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void closeSingleConnection(PooledConnection pc, boolean isCached) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleConnectionCacheImpl.closeSingleConnection(" + pc + ", isCached=" + isCached + ")"));
        }
        if (!this.removeConnectionFromCache(pc) && isCached) {
            return;
        }
        try {
            pc.close();
        }
        catch (SQLException ea) {
            this.m_warning = DBError.addSqlWarning((SQLWarning)this.m_warning, (SQLWarning)new SQLWarning(ea.getMessage()));
        }
        Object object = this.CACHE_SIZE_LOCK;
        synchronized (object) {
            --this.m_cacheSize;
        }
    }

    public synchronized void close() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)"OracleConnectionCacheImpl.close()");
        }
        this.closeConnections();
        this.m_cache = null;
        this.m_activeCache = null;
        this.m_ocel = null;
        this.m_cpds = null;
        this.m_timeOutThread = null;
        this.clearWarnings();
    }

    public void closeConnections() {
        Enumeration connSet = this.m_activeCache.keys();
        while (connSet.hasMoreElements()) {
            try {
                OraclePooledConnection opcKey = (OraclePooledConnection)connSet.nextElement();
                OraclePooledConnection opc = (OraclePooledConnection)this.m_activeCache.get(opcKey);
                OracleConnection conn = (OracleConnection)opc.getLogicalHandle();
                conn.close();
            }
            catch (Exception e2) {
                if (!OracleLog.TRACE) continue;
                OracleLog.print((Object)this, (int)1, (int)512, (int)32, (String)"OracleConnectionCacheImpl.closeConnections()", (Exception)e2);
            }
        }
        while (!this.m_cache.empty()) {
            try {
                this.closeSingleConnection((PooledConnection)this.m_cache.peek(), false);
            }
            catch (Exception e3) {
                if (!OracleLog.TRACE) continue;
                OracleLog.print((Object)this, (int)1, (int)512, (int)32, (String)"OracleConnectionCacheImpl.closeConnections()", (Exception)e3);
            }
        }
    }

    public synchronized void setConnectionCleanupInterval(long secs) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleConnectionCacheImpl.setConnectionCleanupInterval(" + secs + ")"));
        }
        if (secs > 0L) {
            this.m_cleanupInterval = secs;
        }
    }

    public long getConnectionCleanupInterval() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)"OracleConnectionCacheImpl.getConnectionCleanupInterval()");
        }
        return this.m_cleanupInterval;
    }

    public synchronized void setConnectionErrorCodes(int[] fatalErrorCodes) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleConnectionCacheImpl.setConnectionErrorCodes(" + fatalErrorCodes + ")"));
        }
        if (fatalErrorCodes != null) {
            this.m_fatalErrorCodes = fatalErrorCodes;
        }
    }

    public int[] getConnectionErrorCodes() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)"OracleConnectionCacheImpl.getConnectionErrorCodes()");
        }
        return this.m_fatalErrorCodes;
    }

    public boolean isFatalConnectionError(SQLException se) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)"OracleConnectionCacheImpl.isFatalConnectionError()");
        }
        if (this.m_cleanupInterval < 0L) {
            return false;
        }
        boolean retCode = false;
        int errCode = se.getErrorCode();
        if (errCode == 3113 || errCode == 3114 || errCode == 1033 || errCode == 1034 || errCode == 1089 || errCode == 1090 || errCode == 17002) {
            retCode = true;
        } else if (this.m_fatalErrorCodes != null) {
            int i2 = 0;
            while (i2 < this.m_fatalErrorCodes.length) {
                if (errCode == this.m_fatalErrorCodes[i2]) {
                    retCode = true;
                }
                ++i2;
            }
        }
        return retCode;
    }

    public synchronized void setMinLimit(int l2) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleConnectionCacheImpl.setMinLimit(" + l2 + ")"));
        }
        if (l2 < 0 || l2 > this._MAX_LIMIT) {
            DBError.throwSqlException((int)68);
        }
        this._MIN_LIMIT = l2;
        if (this.m_cacheSize < this._MIN_LIMIT) {
            int i2 = this.m_cacheSize;
            while (i2 < this._MIN_LIMIT) {
                PooledConnection pc = this.getNewPoolOrXAConnection();
                this.putConnectionToCache(pc);
                ++i2;
            }
            this.m_cacheSize = this._MIN_LIMIT;
        }
    }

    public synchronized int getMinLimit() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleConnectionCacheImpl.getMinLimit(): returned " + this._MIN_LIMIT));
        }
        return this._MIN_LIMIT;
    }

    public synchronized void setMaxLimit(int l2) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleConnectionCacheImpl.setMaxLimit(" + l2 + ")"));
            OracleLog.print((Object)this, (int)1, (int)512, (int)32, (String)("OracleConnectionCacheImpl.setMaxLimit(l): m_cacheSize=" + this.m_cacheSize));
        }
        if (l2 < 0 || l2 < this._MIN_LIMIT) {
            DBError.throwSqlException((int)68);
        }
        this._MAX_LIMIT = l2;
        if (this.m_cacheSize > this._MAX_LIMIT && this.m_cacheScheme != 1) {
            int i2 = this._MAX_LIMIT;
            while (i2 < this.m_cacheSize) {
                if (this.m_cache.empty()) {
                    DBError.throwSqlException((int)78);
                } else {
                    this.removeConnectionFromCache().close();
                }
                ++i2;
            }
            this.m_cacheSize = this._MAX_LIMIT;
        }
    }

    public synchronized int getMaxLimit() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleConnectionCacheImpl.getMaxLimit(): returned " + this._MAX_LIMIT));
        }
        return this._MAX_LIMIT;
    }

    public synchronized int getCacheScheme() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleConnectionCacheImpl.getCacheScheme(): returned " + this.m_cacheScheme));
        }
        return this.m_cacheScheme;
    }

    public synchronized void setCacheScheme(int s2) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleConnectionCacheImpl.setCacheScheme(" + s2 + ")"));
        }
        if (s2 == 1 || s2 == 3 || s2 == 2) {
            this.m_cacheScheme = s2;
            return;
        }
        DBError.throwSqlException((int)68);
    }

    public synchronized void setCacheScheme(String s2) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleConnectionCacheImpl.setCacheScheme(" + s2 + ")"));
        }
        if (s2.equalsIgnoreCase("DYNAMIC_SCHEME")) {
            this.m_cacheScheme = 1;
        } else if (s2.equalsIgnoreCase("FIXED_RETURN_NULL_SCHEME")) {
            this.m_cacheScheme = 3;
        } else if (s2.equalsIgnoreCase("FIXED_WAIT_SCHEME")) {
            this.m_cacheScheme = 2;
        } else {
            DBError.throwSqlException((int)68);
        }
    }

    public synchronized int getActiveSize() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleConnectionCacheImpl.getActiveSize(): returned " + this.m_activeSize));
        }
        return this.m_activeSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCacheSize() {
        Object object = this.CACHE_SIZE_LOCK;
        synchronized (object) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleConnectionCacheImpl.getCacheSize(): returned " + this.m_cacheSize));
            }
            int n2 = this.m_cacheSize;
            return n2;
        }
    }

    public synchronized void setCacheTimeToLiveTimeout(long timeOut) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)1, (String)("OracleConnectionCacheImpl.setCacheTimeToLiveTimeout(" + timeOut + ")"));
        }
        if (this.m_timeOutThread == null) {
            this.m_timeOutThread = new OracleConnectionCacheTimeOutThread(this);
        }
        if (timeOut <= 0L) {
            this.m_cacheTTLTimeOut = -1L;
            this.m_warning = DBError.addSqlWarning((SQLWarning)this.m_warning, (int)111);
        } else {
            this.m_cacheTTLTimeOut = timeOut;
            this.checkAndStartTimeOutThread();
        }
    }

    public synchronized void setCacheInactivityTimeout(long timeout) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)1, (String)("OracleConnectionCacheImpl.setCacheInactivityTimeout(" + timeout + ")"));
        }
        if (this.m_timeOutThread == null) {
            this.m_timeOutThread = new OracleConnectionCacheTimeOutThread(this);
        }
        if (timeout <= 0L) {
            this.m_cacheInactivityTimeOut = -1L;
            this.m_warning = DBError.addSqlWarning((SQLWarning)this.m_warning, (int)124);
        } else {
            this.m_cacheInactivityTimeOut = timeout;
            this.checkAndStartTimeOutThread();
        }
    }

    public synchronized void setCacheFixedWaitTimeout(long timeout) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)1, (String)("OracleConnectionCacheImpl.setCacheFixedWaitTimeout(" + timeout + ")"));
        }
        if (timeout <= 0L) {
            this.m_cacheFixedWaitTimeOut = -1L;
            this.m_warning = DBError.addSqlWarning((SQLWarning)this.m_warning, (int)127);
        } else {
            this.m_cacheFixedWaitTimeOut = timeout;
        }
    }

    public long getCacheTimeToLiveTimeout() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)1, (String)("OracleConnectionCacheImpl.getCacheTimeToLiveTimeout(): returned " + this.m_cacheTTLTimeOut));
        }
        return this.m_cacheTTLTimeOut;
    }

    public long getCacheInactivityTimeout() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)1, (String)("OracleConnectionCacheImpl.getCacheInactivityTimeout(): returned " + this.m_cacheInactivityTimeOut));
        }
        return this.m_cacheInactivityTimeOut;
    }

    public long getCacheFixedWaitTimeout() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)1, (String)("OracleConnectionCacheImpl.getCacheFixedWaitTimeout(): returned " + this.m_cacheFixedWaitTimeOut));
        }
        return this.m_cacheFixedWaitTimeOut;
    }

    public synchronized void setThreadWakeUpInterval(long interval) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)1, (String)("OracleConnectionCacheImpl.setThreadWakeUpInterval(" + interval + ")"));
        }
        if (interval <= 0L) {
            this.m_threadInterval = 900L;
            this.m_warning = DBError.addSqlWarning((SQLWarning)this.m_warning, (int)112);
        } else {
            this.m_threadInterval = interval;
        }
        if (this.m_cacheTTLTimeOut > 0L && this.m_threadInterval > this.m_cacheTTLTimeOut || this.m_cacheInactivityTimeOut > 0L && this.m_threadInterval > this.m_cacheInactivityTimeOut) {
            this.m_warning = DBError.addSqlWarning((SQLWarning)this.m_warning, (int)113);
        }
    }

    public long getThreadWakeUpInterval() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)1, (String)("OracleConnectionCacheImpl.getThreadWakeUpInterval(): returned " + this.m_threadInterval));
        }
        return this.m_threadInterval;
    }

    private void checkAndStartTimeOutThread() throws SQLException {
        block3: {
            try {
                if (!this.m_timeOutThread.isAlive()) {
                    this.m_timeOutThread.setDaemon(true);
                    this.m_timeOutThread.start();
                }
            }
            catch (IllegalThreadStateException ie) {
                if (!OracleLog.TRACE) break block3;
                OracleLog.print((Object)this, (int)1, (int)512, (int)32, (String)"OracleConnectionCacheImpl.checkAndStartTimeOutThread()", (Exception)ie);
            }
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.m_warning;
    }

    public void clearWarnings() throws SQLException {
        this.m_warning = null;
    }

    private final void checkCredentials(String user, String passwd) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleConnectionCacheImpl.checkCredentials(user=" + user + ", passwd=" + passwd + ")"));
        }
        String mc_user = null;
        String mc_passwd = null;
        if (this.m_cpds != null) {
            mc_user = ((OracleConnectionPoolDataSource)this.m_cpds).getUser();
            mc_passwd = ((OracleConnectionPoolDataSource)this.m_cpds).getPassword();
        }
        if (user != null && !user.equals(mc_user) || passwd != null && !passwd.equals(mc_passwd)) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleConnectionCacheImpl.checkCredentials(user, passwd): \nCannot create a connection with user as " + user + " as it is doesnt match the existing user " + this.m_user + " Or the Password"));
            }
            DBError.throwSqlException((int)79);
        }
    }

    public synchronized Reference getReference() throws NamingException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)"OracleConnectionCacheImpl.getReference()");
        }
        Reference ref = new Reference(this.getClass().getName(), "oracle.jdbc.pool.OracleDataSourceFactory", null);
        super.addRefProperties(ref);
        if (this._MIN_LIMIT != _DEFAULT_MIN_LIMIT) {
            ref.add(new StringRefAddr("minLimit", Integer.toString(this._MIN_LIMIT)));
        }
        if (this._MAX_LIMIT != _DEFAULT_MAX_LIMIT) {
            ref.add(new StringRefAddr("maxLimit", Integer.toString(this._MAX_LIMIT)));
        }
        if (this.m_cacheScheme != 1) {
            ref.add(new StringRefAddr("cacheScheme", Integer.toString(this.m_cacheScheme)));
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleConnectionCacheImpl.getReference(): returned " + ref));
        }
        return ref;
    }

    public synchronized void setStmtCacheSize(int size) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleConnectionCacheImpl.setStmtCacheSize" + size + ")"));
        }
        this.setStmtCacheSize(size, false);
    }

    public synchronized void setStmtCacheSize(int size, boolean clearMetaData) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleConnectionCacheImpl.setStmtCacheSize" + size + ", clearMetaData=" + clearMetaData + ")"));
        }
        if (size < 0) {
            DBError.throwSqlException((int)68);
        }
        this.m_stmtCacheSize = size;
        this.m_stmtClearMetaData = clearMetaData;
    }

    public synchronized int getStmtCacheSize() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)"OracleConnectionCacheImpl.getStmtCacheSize()");
        }
        return this.m_stmtCacheSize;
    }

    synchronized boolean isStmtCacheEnabled() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleConnectionCacheImpl.isStmtCacheEnabled(): m_stmtCacheSize=" + this.m_stmtCacheSize));
        }
        return this.m_stmtCacheSize > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putConnectionToCache(PooledConnection pc) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleConnectionCacheImpl.putConnectionToCache(" + pc + ")"));
        }
        ((OraclePooledConnection)pc).setLastAccessedTime(System.currentTimeMillis());
        this.m_cache.push(pc);
        Stack stack = this.m_cache;
        synchronized (stack) {
            this.m_cache.notify();
        }
    }

    private PooledConnection removeConnectionFromCache() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)"OracleConnectionCacheImpl.removeConnectionFromCache()");
        }
        return (PooledConnection)this.m_cache.pop();
    }

    private boolean removeConnectionFromCache(PooledConnection pc) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleConnectionCacheImpl.removeConnectionFromCache(" + pc + ")"));
        }
        return this.m_cache.removeElement(pc);
    }

    public synchronized void setCacheFixedWaitIdleTime(long idleTime) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleConnectionCacheImpl.setCacheFixedWaitIdleTime(" + idleTime + ")"));
        }
        if (this.m_cacheScheme == 2) {
            if (idleTime <= 0L) {
                DBError.addSqlWarning((SQLWarning)this.m_warning, (int)68);
                this.m_fixedWaitIdleTime = 30L;
            } else {
                this.m_fixedWaitIdleTime = idleTime;
            }
        } else {
            DBError.addSqlWarning((SQLWarning)this.m_warning, (SQLWarning)new SQLWarning("Caching scheme is not FIXED_WAIT_SCHEME"));
        }
    }

    public long getCacheFixedWaitIdleTime() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleConnectionCacheImpl.getCacheFixedWaitIdleTime()returned " + (this.m_fixedWaitIdleTime == -1L ? 30L : this.m_fixedWaitIdleTime)));
        }
        return this.m_fixedWaitIdleTime == -1L ? 30L : this.m_fixedWaitIdleTime;
    }

    static {
        DEFAULT_CACHE_TIMEOUT = -1;
        DEFAULT_THREAD_INTERVAL = 900;
        ORAERROR_END_OF_FILE_ON_COM_CHANNEL = 3113;
        ORAERROR_NOT_CONNECTED_TO_ORACLE = 3114;
        ORAERROR_INIT_SHUTDOWN_IN_PROGRESS = 1033;
        ORAERROR_ORACLE_NOT_AVAILABLE = 1034;
        ORAERROR_IMMEDIATE_SHUTDOWN_IN_PROGRESS = 1089;
        ORAERROR_SHUTDOWN_IN_PROGRESS_NO_CONN = 1090;
        ORAERROR_NET_IO_EXCEPTION = 17002;
        DEFAULT_FIXED_WAIT_IDLE_TIME = 30L;
        DYNAMIC_SCHEME = 1;
        FIXED_WAIT_SCHEME = 2;
        FIXED_RETURN_NULL_SCHEME = 3;
    }
}

