/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleLog;

public class Util {
    private static int[] LDSRoundtab = new int[]{0, 1, 0, 2, 0, 0, 0, 3, 0};

    static void check_next_byte(InputStream in, byte value) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)16, (int)32, (int)64, (String)("Util.check_next_byte( inputStream = " + in + ", value = " + value + ")"));
        }
        try {
            if (in.read() != value) {
                DBError.check_error((int)47, (Object)"parseTDS");
            }
        }
        catch (IOException ex) {
            DBError.check_error((IOException)ex);
        }
    }

    public static int[] toJavaUnsignedBytes(byte[] array) {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)16, (int)32, (int)64, (String)("Util.toJavaUnsignedBytes( bytes = " + array + ")"));
        }
        int[] result = new int[array.length];
        int i2 = 0;
        while (i2 < array.length) {
            result[i2] = array[i2] & 0xFF;
            ++i2;
        }
        return result;
    }

    static byte[] read_bytes(InputStream in, int length) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)16, (int)32, (int)64, (String)("Util.read_bytes( input stream = " + in + ", length = " + length + ")"));
        }
        byte[] array = new byte[length];
        try {
            int length_read = in.read(array);
            if (length_read != length) {
                byte[] final_bytes = new byte[length_read];
                System.arraycopy(array, 0, final_bytes, 0, length_read);
                return final_bytes;
            }
        }
        catch (IOException ex) {
            DBError.check_error((IOException)ex);
        }
        return array;
    }

    static void write_bytes(OutputStream out, byte[] array) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)16, (int)32, (int)64, (String)("Util.write_bytes( output stream = " + out + ", bytes = " + array + ")"));
        }
        try {
            out.write(array);
        }
        catch (IOException ex) {
            DBError.check_error((IOException)ex);
        }
    }

    static void skip_bytes(InputStream in, int byte_num) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)16, (int)32, (int)64, (String)("Util.skip_bytes( input stream = " + in + ", bytes to skip = " + byte_num + ")"));
        }
        try {
            in.skip(byte_num);
        }
        catch (IOException ex) {
            DBError.check_error((IOException)ex);
        }
    }

    static long read_long(InputStream in) throws SQLException {
        byte[] bytes = new byte[4];
        try {
            in.read(bytes);
            return (((bytes[0] & 0xFF) * 256 + (bytes[1] & 0xFF)) * 256 + (bytes[2] & 0xFF)) * 256 + (bytes[3] & 0xFF);
        }
        catch (IOException ex) {
            DBError.check_error((IOException)ex);
            return 0L;
        }
    }

    static short read_short(InputStream in) throws SQLException {
        byte[] bytes = new byte[2];
        try {
            in.read(bytes);
            return (short)((bytes[0] & 0xFF) * 256 + (bytes[1] & 0xFF));
        }
        catch (IOException ex) {
            DBError.check_error((IOException)ex);
            return 0;
        }
    }

    static byte read_byte(InputStream in) throws SQLException {
        try {
            return (byte)in.read();
        }
        catch (IOException ex) {
            DBError.check_error((IOException)ex);
            return 0;
        }
    }

    static byte FDO_get_size(byte[] FDO, int mapping_offset) {
        byte value = Util.FDO_get_entry((byte[])FDO, (int)mapping_offset);
        return (byte)(value >> 3 & 0x1F);
    }

    static byte FDO_get_align(byte[] FDO, int mapping_offset) {
        byte value = Util.FDO_get_entry((byte[])FDO, (int)mapping_offset);
        return (byte)(value & 7);
    }

    static int LDSRound(int size, int alignvalue) {
        int sval = LDSRoundtab[alignvalue];
        return (size >> sval) + 1 << sval;
    }

    private static byte FDO_get_entry(byte[] FDO, int mapping_offset) {
        short fdo_5 = Util.getUnsignedByte(FDO[5]);
        byte value = FDO[6 + fdo_5 + mapping_offset];
        return value;
    }

    public static short getUnsignedByte(byte b2) {
        return (short)(b2 & 0xFF);
    }

    public static byte[] serializeObject(Object obj) throws IOException {
        if (obj == null) {
            return null;
        }
        ByteArrayOutputStream ostream = new ByteArrayOutputStream();
        ObjectOutputStream p2 = new ObjectOutputStream(ostream);
        p2.writeObject(obj);
        p2.flush();
        return ostream.toByteArray();
    }

    public static Object deserializeObject(byte[] bytes) throws IOException, ClassNotFoundException {
        if (bytes == null) {
            return null;
        }
        ByteArrayInputStream istream = new ByteArrayInputStream(bytes);
        return new ObjectInputStream(istream).readObject();
    }

    public static void printByteArray(byte[] x) {
        System.out.println("DONT CALL THIS -- oracle.jdbc.oracore.Util.printByteArray");
    }
}

