/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.sql.SQLException;
import java.util.Vector;
import oracle.jdbc.driver.OracleLog;

public final class UnpickleContext {
    byte[] m_image;
    int m_offset;
    int m_beginOffset;
    int m_markedOffset;
    Vector m_patches;
    long[] m_ldsOffsets;
    boolean[] m_nullIndicators;
    boolean m_bigEndian;

    public UnpickleContext() {
    }

    public UnpickleContext(byte[] image, int begin_offset, boolean[] null_bytes, long[] lds_offset_array, boolean big_endian) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)2, (int)32, (String)("UnpickleContext (image " + image + ", begin_offset" + begin_offset + ", null_bytes" + null_bytes + ",lds_offset_array " + lds_offset_array + ", big_endian" + big_endian + ")"));
        }
        this.m_image = image;
        this.m_beginOffset = begin_offset;
        this.m_offset = begin_offset;
        this.m_bigEndian = big_endian;
        this.m_nullIndicators = null_bytes;
        this.m_patches = null;
        this.m_ldsOffsets = lds_offset_array;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte read_byte() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)32, (int)64, (String)"UnpickleContext.read_bytes()");
        }
        try {
            byte by = this.m_image[this.m_offset];
            Object var3_2 = null;
            ++this.m_offset;
            return by;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            ++this.m_offset;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] read_varNumBytes() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)32, (int)64, (String)"UnpickleContext.read_varNumBytes()");
        }
        byte[] varNumBytes = new byte[this.m_image[this.m_offset] & 0xFF];
        try {
            System.arraycopy(this.m_image, this.m_offset + 1, varNumBytes, 0, varNumBytes.length);
            Object var3_2 = null;
            this.m_offset += 22;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.m_offset += 22;
            throw throwable;
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)32, (int)64, (String)("UnpickleContext.read_varNumBytes:return " + varNumBytes));
        }
        return varNumBytes;
    }

    public byte[] read_ptrBytes() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)32, (int)64, (String)"UnpickleContext.read_ptrBytes()");
        }
        byte[] bytes = new byte[(this.m_image[this.m_offset] & 0xFF) * 256 + (this.m_image[this.m_offset + 1] & 0xFF) + 2];
        System.arraycopy(this.m_image, this.m_offset, bytes, 0, bytes.length);
        this.m_offset += bytes.length;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)32, (int)64, (String)("UnpickleContext.read_ptrBytes:return " + bytes));
        }
        return bytes;
    }

    public void skip_ptrBytes() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)32, (int)64, (String)"UnpickleContext.skip_ptrBytes()");
        }
        this.m_offset += (this.m_image[this.m_offset] & 0xFF) * 256 + (this.m_image[this.m_offset + 1] & 0xFF) + 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] read_bytes(int n2) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)32, (int)64, (String)("UnpickleContext.read_bytes( n = " + n2 + " )"));
        }
        try {
            byte[] bytes = new byte[n2];
            System.arraycopy(this.m_image, this.m_offset, bytes, 0, n2);
            byte[] byArray = bytes;
            Object var5_4 = null;
            this.m_offset += n2;
            return byArray;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.m_offset += n2;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long read_long() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)32, (int)64, (String)"UnpickleContext.read_long()");
        }
        try {
            long l2 = (((this.m_image[this.m_offset] & 0xFF) * 256 + (this.m_image[this.m_offset + 1] & 0xFF)) * 256 + (this.m_image[this.m_offset + 2] & 0xFF)) * 256 + (this.m_image[this.m_offset + 3] & 0xFF);
            Object var4_2 = null;
            this.m_offset += 4;
            return l2;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.m_offset += 4;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short read_short() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)32, (int)64, (String)"UnpickleContext.read_short()");
        }
        try {
            short s2 = (short)((this.m_image[this.m_offset] & 0xFF) * 256 + (this.m_image[this.m_offset + 1] & 0xFF));
            Object var3_2 = null;
            this.m_offset += 2;
            return s2;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.m_offset += 2;
            throw throwable;
        }
    }

    public byte[] read_lengthBytes() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)32, (int)64, (String)"UnpickleContext.read_lengthBytes()");
        }
        long variable_length = this.read_long();
        return this.read_bytes((int)variable_length);
    }

    public void skip_lengthBytes() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)32, (int)64, (String)"UnpickleContext.skip_lengthBytes()");
        }
        long variable_length = this.read_long();
        this.m_offset = (int)((long)this.m_offset + variable_length);
    }

    public void skip_to(long offset) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)32, (int)64, (String)("UnpickleContext.skip_to( offset = " + offset + ")"));
        }
        if (offset > (long)(this.m_offset - this.m_beginOffset)) {
            this.m_offset = this.m_beginOffset + (int)offset;
        }
    }

    public void skip_to(int offset) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)32, (int)64, (String)("UnpickleContext.skip_to( offset = " + offset + ")"));
        }
        if (offset > this.m_offset - this.m_beginOffset) {
            this.m_offset = this.m_beginOffset + offset;
        }
    }

    public void mark() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)32, (int)64, (String)"UnpickleContext.mark()");
        }
        this.m_markedOffset = this.m_offset;
    }

    public void reset() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)32, (int)64, (String)"UnpickleContext.reset()");
        }
        this.m_offset = this.m_markedOffset;
    }

    public void markAndSkip() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)32, (int)64, (String)"UnpickleContext.markAndSkip()");
        }
        this.m_markedOffset = this.m_offset + 4;
        this.m_offset = this.m_beginOffset + (int)this.read_long();
    }

    public void markAndSkip(long offset) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)32, (int)64, (String)("UnpickleContext.markAndSkip( offset = " + offset + ")"));
        }
        this.m_markedOffset = this.m_offset;
        this.m_offset = this.m_beginOffset + (int)offset;
    }

    public void skip_bytes(int n2) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)32, (int)64, (String)("UnpickleContext.skip_bytes( n = " + n2 + ")"));
        }
        if (n2 >= 0) {
            this.m_offset += n2;
        }
    }

    public boolean is_null(int idx) {
        return this.m_nullIndicators[idx];
    }

    public int absolute_offset() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)32, (int)64, (String)("UnpickleContext.absolute_offset:return " + this.m_offset));
        }
        return this.m_offset;
    }

    public int offset() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)32, (int)64, (String)("UnpickleContext.offset:return " + (this.m_offset - this.m_beginOffset)));
        }
        return this.m_offset - this.m_beginOffset;
    }

    public byte[] image() throws SQLException {
        return this.m_image;
    }
}

