/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.oracore.OracleNamedType;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCOLLECTION;
import oracle.jdbc.oracore.OracleTypeUPT;

public class TDSPatch {
    static final int S_NORMAL_PATCH = 0;
    static final int S_SIMPLE_PATCH = 1;
    int m_type;
    OracleType m_owner;
    long m_pos;
    int m_uptCode;

    public TDSPatch(int type, OracleType owner, long pos, int uptCode) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)2, (int)32, (String)("TDSPatch (type = " + type + ", owner = " + owner + ", pos = " + pos + ", uptCode = " + uptCode + ")"));
        }
        this.m_type = type;
        this.m_owner = owner;
        this.m_pos = pos;
        this.m_uptCode = uptCode;
    }

    int getType() throws SQLException {
        return this.m_type;
    }

    OracleNamedType getOwner() throws SQLException {
        return (OracleNamedType)this.m_owner;
    }

    long getPosition() throws SQLException {
        return this.m_pos;
    }

    byte getUptTypeCode() throws SQLException {
        return (byte)this.m_uptCode;
    }

    void apply(OracleType typeValue) throws SQLException {
        this.apply(typeValue, -1);
    }

    void apply(OracleType typeValue, int opcode) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)2, (int)64, (String)("TDSPatch.apply(typeValue = " + typeValue + ", opcode = " + opcode + ")"));
        }
        if (this.m_type == 0) {
            OracleTypeUPT patchElem = (OracleTypeUPT)this.m_owner;
            patchElem.m_realType = (OracleTypeADT)typeValue;
            if (typeValue instanceof OracleNamedType) {
                OracleNamedType namedType = (OracleNamedType)typeValue;
                namedType.setParent(patchElem.getParent());
                namedType.setOrder(patchElem.getOrder());
            }
        } else if (this.m_type == 1) {
            OracleTypeCOLLECTION patchElem = (OracleTypeCOLLECTION)this.m_owner;
            patchElem.m_opcode = opcode;
            patchElem.m_elemType = typeValue;
            if (typeValue instanceof OracleNamedType) {
                OracleNamedType namedType = (OracleNamedType)typeValue;
                namedType.setParent(patchElem);
                namedType.setOrder(1);
            }
        } else {
            DBError.throwSqlException((int)1);
        }
    }

    static {
        S_NORMAL_PATCH = 0;
        S_SIMPLE_PATCH = 1;
    }
}

