/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.sql.SQLException;
import java.util.Vector;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.TDSPatch;

public class StreamInfo {
    static final int KOPT_NONE_FINAL_TYPE = 1;
    static final int KOPT_JAVA_OBJECT = 2;
    int null_offset;
    int lds_offset;
    long fixed_data_size;
    Vector m_patches;
    byte[] m_tds;
    int m_beginIndex;
    int m_index;

    StreamInfo(byte[] tds, long beginIndex) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)2, (int)32, (String)("StreamInfo( tds = " + tds + ", beginIndex = " + beginIndex + ")"));
        }
        this.null_offset = 0;
        this.lds_offset = 0;
        this.fixed_data_size = 0L;
        this.m_patches = null;
        this.m_tds = tds;
        this.m_beginIndex = (int)beginIndex;
        this.m_index = (int)beginIndex;
    }

    void skipBytes(int number) throws SQLException {
        this.m_index += number;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkNextByte(byte value) throws SQLException {
        try {
            if (value != this.m_tds[this.m_index]) {
                DBError.throwSqlException((int)47, (Object)"parseTDS");
            }
            Object var3_2 = null;
            ++this.m_index;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            ++this.m_index;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte readByte() throws SQLException {
        try {
            byte by = this.m_tds[this.m_index];
            Object var3_2 = null;
            ++this.m_index;
            return by;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            ++this.m_index;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int readUnsignedByte() throws SQLException {
        try {
            int n2 = this.m_tds[this.m_index] & 0xFF;
            Object var3_2 = null;
            ++this.m_index;
            return n2;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            ++this.m_index;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    short readShort() throws SQLException {
        try {
            short s2 = (short)((this.m_tds[this.m_index] & 0xFF) * 256 + (this.m_tds[this.m_index + 1] & 0xFF));
            Object var3_2 = null;
            this.m_index += 2;
            return s2;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.m_index += 2;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long readLong() throws SQLException {
        try {
            long l2 = (((this.m_tds[this.m_index] & 0xFF) * 256 + (this.m_tds[this.m_index + 1] & 0xFF)) * 256 + (this.m_tds[this.m_index + 2] & 0xFF)) * 256 + (this.m_tds[this.m_index + 3] & 0xFF);
            Object var4_2 = null;
            this.m_index += 4;
            return l2;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.m_index += 4;
            throw throwable;
        }
    }

    void addNormalPatch(long pos, byte uptStyle, OracleType type) throws SQLException {
        this.addPatch(new TDSPatch(0, type, pos, uptStyle));
    }

    void addSimplePatch(long pos, OracleType type) throws SQLException {
        this.addPatch(new TDSPatch(1, type, pos, 0));
    }

    void addPatch(TDSPatch patch) throws SQLException {
        if (this.m_patches == null) {
            this.m_patches = new Vector(5);
        }
        this.m_patches.addElement(patch);
    }

    long moveToPatchPos(TDSPatch patch) throws SQLException {
        long patchPos = patch.getPosition();
        if ((long)this.m_beginIndex + patchPos > (long)this.m_tds.length) {
            DBError.throwSqlException((int)47, (Object)"parseTDS");
        }
        this.skip_to(patchPos);
        return patchPos;
    }

    TDSPatch getNextPatch() throws SQLException {
        TDSPatch patch = null;
        if (this.m_patches != null && this.m_patches.size() > 0) {
            patch = (TDSPatch)this.m_patches.firstElement();
            this.m_patches.removeElementAt(0);
        }
        return patch;
    }

    void skip_to(long offset) {
        this.m_index = this.m_beginIndex + (int)offset;
    }

    long offset() throws SQLException {
        return this.m_index - this.m_beginIndex;
    }

    long absolute_offset() throws SQLException {
        return this.m_index;
    }

    byte[] tds() throws SQLException {
        return this.m_tds;
    }

    boolean isJavaObject(int version, byte flag) {
        return version >= 3 && (flag & 2) != 0;
    }

    boolean isFinalType(int version, byte flag) {
        return version >= 3 && (flag & 1) == 0;
    }

    static {
        KOPT_NONE_FINAL_TYPE = 1;
        KOPT_JAVA_OBJECT = 2;
    }
}

