/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.oracore.PickleOutputStream;

public final class PickleContext {
    private PickleOutputStream stream_pctx;
    byte[] m_image;
    int m_offset;
    private byte[] lenbuf_pctx = new byte[5];
    static short KOPI20_LN_ELNL = (short)255;
    static short KOPI20_LN_5BLN = (short)254;
    static short KOPI20_LN_ATMN = (short)253;
    static short KOPI20_LN_IEMN = (short)252;
    static short KOPI20_LN_MAXV = (short)245;
    static short KOPI20_IF_IS81 = (short)128;
    static short KOPI20_IF_CMSB = (short)64;
    static short KOPI20_IF_CLSB = (short)32;
    static short KOPI20_IF_DEGN = (short)16;
    static short KOPI20_IF_COLL = (short)8;
    static short KOPI20_IF_NOPS = (short)4;
    static short KOPI20_IF_ANY = (short)2;
    static short KOPI20_IF_NONL = 1;
    static short KOPI20_CF_CMSB = (short)64;
    static short KOPI20_CF_CLSB = (short)32;
    static short KOPI20_CF_INDX = (short)16;
    static short KOPI20_CF_NOLN = (short)8;
    static short KOPI20_VERSION = 1;
    static final byte KOPUP_INLINE_COLL = 1;
    static final byte KOPUP_TYPEINFO_NONE = 0;
    static final byte KOPUP_TYPEINFO_TOID = 4;
    static final byte KOPUP_TYPEINFO_TOBJN = 8;
    static final byte KOPUP_TYPEINFO_TDS = 12;
    static final byte KOPUP_VSN_PRESENT = 16;

    public PickleContext() {
    }

    public PickleContext(byte[] pickled_bytes) {
        this.m_image = pickled_bytes;
        this.m_offset = 0;
    }

    public PickleContext(byte[] pickled_bytes, long offset) {
        this.m_image = pickled_bytes;
        this.m_offset = (int)offset;
    }

    public void initStream_pctx(int imglen) {
        this.stream_pctx = new PickleOutputStream(imglen);
    }

    public void initStream_pctx() {
        this.stream_pctx = new PickleOutputStream();
    }

    public int lenbytes_pctx(int v) {
        return v <= KOPI20_LN_MAXV ? 1 : 5;
    }

    public int writeEltNull_pctx() throws SQLException {
        this.stream_pctx.write(KOPI20_LN_ELNL);
        return 1;
    }

    public int writeAtomicNull_pctx() throws SQLException {
        this.stream_pctx.write(KOPI20_LN_ATMN);
        return 1;
    }

    public int writeIEmbNull_pctx(byte null_adtno) throws SQLException {
        this.lenbuf_pctx[0] = (byte)KOPI20_LN_IEMN;
        this.lenbuf_pctx[1] = null_adtno;
        this.stream_pctx.write(this.lenbuf_pctx, 0, 2);
        return 2;
    }

    public int writeLength_pctx(int len) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)32, (int)32, (String)("OracleTypeADT.writeLength_pctx (" + len + ")"));
        }
        if (len <= KOPI20_LN_MAXV) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)16, (int)32, (int)64, (String)"OracleTypeADT.writeLength_pctx 1 byte length format");
            }
            this.stream_pctx.write((byte)len);
            return 1;
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)32, (int)64, (String)"OracleTypeADT.writeLength_pctx 5 byte length format");
        }
        this.lenbuf_pctx[0] = (byte)KOPI20_LN_5BLN;
        this.lenbuf_pctx[1] = (byte)(len >> 24);
        this.lenbuf_pctx[2] = (byte)((len &= 0xFFFFFF) >> 16);
        this.lenbuf_pctx[3] = (byte)((len &= 0xFFFF) >> 8);
        this.lenbuf_pctx[4] = (byte)(len &= 0xFF);
        try {
            this.stream_pctx.write(this.lenbuf_pctx);
        }
        catch (IOException ex) {
            if (OracleLog.TRACE) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                ex.printStackTrace(pw);
                OracleLog.print((Object)this, (int)16, (int)32, (int)64, (String)("OracleTypeADT.writeLength_pctx " + ex.toString() + sw.toString()));
            }
            DBError.throwSqlException((IOException)ex);
        }
        return 5;
    }

    public int writeLength_pctx(int datalen, boolean include) throws SQLException {
        if (!include) {
            return this.writeLength_pctx(datalen);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)32, (int)64, (String)("OracleTypeADT.writeLength_pctx(" + datalen + ")"));
        }
        if (datalen <= KOPI20_LN_MAXV - 1) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)16, (int)32, (int)64, (String)"OracleTypeADT.writeLength_pctx 1 byte length format");
            }
            this.stream_pctx.write((byte)datalen + 1);
            return 1;
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)32, (int)64, (String)"OracleTypeADT.writeLength_pctx 5 byte length format");
        }
        this.lenbuf_pctx[0] = (byte)KOPI20_LN_5BLN;
        this.lenbuf_pctx[1] = (byte)((datalen += 5) >> 24);
        this.lenbuf_pctx[2] = (byte)((datalen &= 0xFFFFFF) >> 16);
        this.lenbuf_pctx[3] = (byte)((datalen &= 0xFFFF) >> 8);
        this.lenbuf_pctx[4] = (byte)(datalen &= 0xFF);
        try {
            this.stream_pctx.write(this.lenbuf_pctx);
        }
        catch (IOException ex) {
            if (OracleLog.TRACE) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                ex.printStackTrace(pw);
                OracleLog.print((Object)this, (int)16, (int)32, (int)64, (String)("OracleTypeADT.writeLength_pctx " + ex.toString() + sw.toString()));
            }
            DBError.throwSqlException((IOException)ex);
        }
        return 5;
    }

    public byte[] to5bLengthBytes_pctx(int len) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)32, (int)64, (String)("OracleTypeADT.to5bLengthBytes_pct(" + len + ")5 byte length format"));
        }
        this.lenbuf_pctx[0] = (byte)KOPI20_LN_5BLN;
        this.lenbuf_pctx[1] = (byte)(len >> 24);
        this.lenbuf_pctx[2] = (byte)((len &= 0xFFFFFF) >> 16);
        this.lenbuf_pctx[3] = (byte)((len &= 0xFFFF) >> 8);
        this.lenbuf_pctx[4] = (byte)(len &= 0xFF);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)32, (int)64, (String)("OracleTypeADT.to5bLengthBytes_pct:return " + this.lenbuf_pctx));
        }
        return this.lenbuf_pctx;
    }

    public int write_data_pctx(byte b2) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)32, (int)16, (String)("PickleContext.write_data_pctx(b = " + b2 + ")"));
        }
        this.stream_pctx.write(b2);
        return 1;
    }

    public int write_data_pctx(byte[] b2) throws SQLException {
        try {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)16, (int)32, (int)16, (String)("PickleContext.write_data_pctx(b = " + b2 + ")"));
            }
            this.stream_pctx.write(b2);
        }
        catch (IOException ex) {
            if (OracleLog.TRACE) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                ex.printStackTrace(pw);
                OracleLog.print((Object)this, (int)16, (int)32, (int)64, (String)("OracleTypeADT.write_data_pctx" + ex.toString() + sw.toString()));
            }
            DBError.throwSqlException((IOException)ex);
        }
        return b2.length;
    }

    public int write_data_pctx(byte[] b2, int off, int len) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)32, (int)16, (String)("PickleContext.write_data_pctx(b = " + b2 + ", off=" + off + ", len=" + len + ")"));
        }
        this.stream_pctx.write(b2, off, len);
        return len;
    }

    public void patchImageLen_pctx(int offset, int image_length) throws SQLException {
        byte[] lenbuf = this.to5bLengthBytes_pctx(image_length);
        this.stream_pctx.overwrite(offset, lenbuf, 0, lenbuf.length);
    }

    public int writeImageHeader_pctx(boolean withPrefix) throws SQLException {
        return this.writeImageHeader_pctx(KOPI20_LN_MAXV + 1, withPrefix);
    }

    public int writeOpaqueImageHeader_pctx(int data_length) throws SQLException {
        int count = 2;
        this.lenbuf_pctx[0] = (byte)(KOPI20_IF_IS81 | KOPI20_IF_NOPS | KOPI20_IF_NONL);
        this.lenbuf_pctx[1] = (byte)KOPI20_VERSION;
        this.stream_pctx.write(this.lenbuf_pctx, 0, 2);
        return count += this.writeLength_pctx(data_length + 2, true);
    }

    public int writeImageHeader_pctx(int image_length, boolean withPrefix) throws SQLException {
        int count = 2;
        this.lenbuf_pctx[0] = withPrefix ? (byte)KOPI20_IF_IS81 : (byte)(KOPI20_IF_IS81 | KOPI20_IF_NOPS);
        this.lenbuf_pctx[1] = (byte)KOPI20_VERSION;
        this.stream_pctx.write(this.lenbuf_pctx, 0, 2);
        return count += this.writeLength_pctx(image_length);
    }

    public int writeCollImageHeader_pctx(int num_collection_items) throws SQLException {
        return this.writeCollImageHeader_pctx(KOPI20_LN_MAXV + 1, num_collection_items);
    }

    public int writeCollImageHeader_pctx(int image_length, int num_collection_items) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)32, (int)64, (String)("OracleTypeADT.WriteCollImageHeader_pctx( length = " + image_length + ", number of items =" + num_collection_items + ")"));
        }
        int count = 5;
        this.lenbuf_pctx[0] = (byte)(KOPI20_IF_IS81 | KOPI20_IF_COLL);
        this.lenbuf_pctx[1] = (byte)KOPI20_VERSION;
        this.stream_pctx.write(this.lenbuf_pctx, 0, 2);
        count += this.writeLength_pctx(image_length);
        this.lenbuf_pctx[0] = 1;
        this.lenbuf_pctx[1] = 1;
        this.stream_pctx.write(this.lenbuf_pctx, 0, 2);
        this.lenbuf_pctx[0] = 0;
        this.stream_pctx.write(this.lenbuf_pctx, 0, 1);
        return count += this.writeLength_pctx(num_collection_items);
    }

    public int writeCollImageHeader_pctx(byte[] prefix_segment) throws SQLException {
        return this.writeCollImageHeader_pctx(KOPI20_LN_MAXV + 1, prefix_segment);
    }

    public int writeCollImageHeader_pctx(int image_length, byte[] prefix_segment) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)32, (int)64, (String)("OracleTypeADT.writeCollImageHeader_pctx( length = " + image_length + ", bytes =" + prefix_segment + ")"));
        }
        int psegLen = prefix_segment.length;
        int count = 3 + psegLen;
        this.lenbuf_pctx[0] = (byte)(KOPI20_IF_IS81 | KOPI20_IF_DEGN);
        this.lenbuf_pctx[1] = (byte)KOPI20_VERSION;
        this.stream_pctx.write(this.lenbuf_pctx, 0, 2);
        count += this.writeLength_pctx(image_length);
        this.lenbuf_pctx[0] = 0;
        this.stream_pctx.write(this.lenbuf_pctx, 0, 1);
        this.stream_pctx.write(prefix_segment, 0, psegLen);
        return count += this.writeLength_pctx(psegLen + 1);
    }

    public byte[] stream2bytes_pctx() throws SQLException {
        return this.stream_pctx.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte readByte_pctx() throws SQLException {
        try {
            byte by = this.m_image[this.m_offset];
            Object var3_2 = null;
            ++this.m_offset;
            return by;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            ++this.m_offset;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readAndCheckVersion_pctx() throws SQLException {
        try {
            boolean bl = (this.m_image[this.m_offset] & 0xFF) <= KOPI20_VERSION;
            Object var3_2 = null;
            ++this.m_offset;
            return bl;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            ++this.m_offset;
            throw throwable;
        }
    }

    public int readLength_pctx() throws SQLException {
        int len;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)32, (int)64, (String)"OracleTypeADT.readLength_pctx()");
        }
        if ((len = this.m_image[this.m_offset] & 0xFF) > KOPI20_LN_MAXV) {
            if (len == KOPI20_LN_ELNL) {
                DBError.throwSqlException((int)1, (Object)"Invalid null flag read");
            }
            len = (((this.m_image[this.m_offset + 1] & 0xFF) * 256 + (this.m_image[this.m_offset + 2] & 0xFF)) * 256 + (this.m_image[this.m_offset + 3] & 0xFF)) * 256 + (this.m_image[this.m_offset + 4] & 0xFF);
            this.m_offset += 5;
        } else {
            ++this.m_offset;
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)32, (int)64, (String)("OracleTypeADT.readLength_pctx:return " + len));
        }
        return len;
    }

    public void skipLength_pctx() throws SQLException {
        int len = this.m_image[this.m_offset] & 0xFF;
        this.m_offset = len > KOPI20_LN_MAXV ? (this.m_offset += 5) : ++this.m_offset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readRestOfLength_pctx(byte len) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)32, (int)64, (String)("OracleTypeADT.readRestOfLength_pctx( length = " + len + ")"));
        }
        if ((len & 0xFF) != KOPI20_LN_5BLN) {
            return len & 0xFF;
        }
        try {
            int n2 = (((this.m_image[this.m_offset] & 0xFF) * 256 + (this.m_image[this.m_offset + 1] & 0xFF)) * 256 + (this.m_image[this.m_offset + 2] & 0xFF)) * 256 + (this.m_image[this.m_offset + 3] & 0xFF);
            Object var4_3 = null;
            this.m_offset += 4;
            return n2;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.m_offset += 4;
            throw throwable;
        }
    }

    public void skipRestOfLength_pctx(byte len) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)32, (int)64, (String)("OracleTypeADT.skipRestOfLength_pctx( length = " + len + ")"));
        }
        if ((len & 0xFF) > KOPI20_LN_MAXV) {
            if ((len & 0xFF) == KOPI20_LN_5BLN) {
                this.m_offset += 4;
            } else {
                DBError.throwSqlException((int)1, (Object)"Invalid first length byte");
            }
        }
    }

    public int readLength_pctx(boolean exclude) throws SQLException {
        int len;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)32, (int)64, (String)("OracleTypeADT.reaLength_pctx( exclude = " + exclude + ")"));
        }
        if ((len = this.m_image[this.m_offset] & 0xFF) > KOPI20_LN_MAXV) {
            len = (((this.m_image[this.m_offset + 1] & 0xFF) * 256 + (this.m_image[this.m_offset + 2] & 0xFF)) * 256 + (this.m_image[this.m_offset + 3] & 0xFF)) * 256 + (this.m_image[this.m_offset + 4] & 0xFF);
            if (exclude) {
                len -= 5;
            }
            this.m_offset += 5;
        } else {
            if (exclude) {
                --len;
            }
            ++this.m_offset;
        }
        return len;
    }

    public byte[] readPrefixSegment_pctx() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)32, (int)64, (String)"OracleTypeADT.readPrefixSegment_pctx()");
        }
        byte[] b2 = new byte[this.readLength_pctx()];
        System.arraycopy(this.m_image, this.m_offset, b2, 0, b2.length);
        this.m_offset += b2.length;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)32, (int)64, (String)("OracleTypeADT.readPrefixSegment_pctx:return " + b2));
        }
        return b2;
    }

    public byte[] readDataValue_pctx() throws SQLException {
        int len;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)32, (int)64, (String)"OracleTypeADT.readDataValue_pctx()");
        }
        if ((len = this.m_image[this.m_offset] & 0xFF) == KOPI20_LN_ELNL) {
            ++this.m_offset;
            return null;
        }
        if (len > KOPI20_LN_MAXV) {
            len = (((this.m_image[this.m_offset + 1] & 0xFF) * 256 + (this.m_image[this.m_offset + 2] & 0xFF)) * 256 + (this.m_image[this.m_offset + 3] & 0xFF)) * 256 + (this.m_image[this.m_offset + 4] & 0xFF);
            this.m_offset += 5;
        } else {
            ++this.m_offset;
        }
        byte[] b2 = new byte[len];
        System.arraycopy(this.m_image, this.m_offset, b2, 0, b2.length);
        this.m_offset += b2.length;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)32, (int)64, (String)("OracleTypeADT.readDataValue_pctx:return " + b2));
        }
        return b2;
    }

    public byte[] readBytes_pctx(int length) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)32, (int)64, (String)("OracleTypeADT.readBytes_pctx( length = " + length + ")"));
        }
        byte[] b2 = new byte[length];
        System.arraycopy(this.m_image, this.m_offset, b2, 0, length);
        this.m_offset += length;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)32, (int)64, (String)("OracleTypeADT.readBytes_pctx:return " + b2));
        }
        return b2;
    }

    public byte[] read1byteDataValue_pctx() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)32, (int)64, (String)"OracleTypeADT.read1byteDataValue_pctx()");
        }
        if ((this.m_image[this.m_offset] & 0xFF) == KOPI20_LN_ELNL) {
            return null;
        }
        byte[] b2 = new byte[this.m_image[this.m_offset] & 0xFF];
        System.arraycopy(this.m_image, this.m_offset + 1, b2, 0, b2.length);
        this.m_offset += b2.length + 1;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)32, (int)64, (String)("OracleTypeADT.read1byteDataValue_pctx:return " + b2));
        }
        return b2;
    }

    public byte[] readDataValue_pctx(byte byte1) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)32, (int)64, (String)("OracleTypeADT.readDataValue_pctx( length byte = " + byte1 + ")"));
        }
        byte[] b2 = new byte[this.readRestOfLength_pctx(byte1)];
        System.arraycopy(this.m_image, this.m_offset, b2, 0, b2.length);
        this.m_offset += b2.length;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)32, (int)64, (String)("OracleTypeADT.readDataValue_pctx:return " + b2));
        }
        return b2;
    }

    public byte[] readDataValue_pctx(int len) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)32, (int)64, (String)("OracleTypeADT.readDataValue_pctx( length  = " + len + ")"));
        }
        byte[] b2 = new byte[len];
        System.arraycopy(this.m_image, this.m_offset, b2, 0, len);
        this.m_offset += len;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)32, (int)64, (String)("OracleTypeADT.readDataValue_pctx:return " + b2));
        }
        return b2;
    }

    public void skipDataValue_pctx() throws SQLException {
        if ((this.m_image[this.m_offset] & 0xFF) == KOPI20_LN_ELNL) {
            ++this.m_offset;
        } else {
            this.skip_bytes(this.readLength_pctx());
        }
    }

    public void skipDataValue_pctx(byte b2) throws SQLException {
        this.skip_bytes(this.readRestOfLength_pctx(b2));
    }

    public void skip_bytes(int b2) throws SQLException {
        if (b2 > 0) {
            this.m_offset += b2;
        }
    }

    public int offset() throws SQLException {
        if (this.stream_pctx != null) {
            return this.stream_pctx.offset();
        }
        return this.m_offset;
    }

    public int absolute_offset() throws SQLException {
        return this.m_offset;
    }

    public void skip_to(long offset) throws SQLException {
        if (offset > (long)this.m_offset) {
            this.m_offset = (int)offset;
        }
    }

    public byte[] image() throws SQLException {
        return this.m_image;
    }

    public static boolean is81format_pctx(byte flag) throws SQLException {
        return (flag & 0xFF & KOPI20_IF_IS81) != 0;
    }

    public static boolean isCollectionImage_pctx(byte flag) throws SQLException {
        return (flag & 0xFF & KOPI20_IF_COLL) != 0;
    }

    public static boolean isDegenerateImage_pctx(byte flag) throws SQLException {
        return (flag & 0xFF & KOPI20_IF_DEGN) != 0;
    }

    public static boolean hasPrefix_pctx(byte flag) throws SQLException {
        return (flag & 0xFF & KOPI20_IF_NOPS) == 0;
    }

    public static boolean isAtomicNull_pctx(byte flag) throws SQLException {
        return (flag & 0xFF) == KOPI20_LN_ATMN;
    }

    public static boolean isImmEmbNull_pctx(byte flag) throws SQLException {
        return (flag & 0xFF) == KOPI20_LN_IEMN;
    }

    public static boolean isElementNull_pctx(byte flag) throws SQLException {
        return (flag & 0xFF) == KOPI20_LN_ELNL;
    }

    static {
        KOPUP_INLINE_COLL = 1;
        KOPUP_TYPEINFO_NONE = 0;
        KOPUP_TYPEINFO_TOID = (byte)4;
        KOPUP_TYPEINFO_TOBJN = (byte)8;
        KOPUP_TYPEINFO_TDS = (byte)12;
        KOPUP_VSN_PRESENT = (byte)16;
    }
}

