/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleNamedType;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCOLLECTION;
import oracle.jdbc.oracore.OracleTypeOPAQUE;
import oracle.jdbc.oracore.PickleContext;
import oracle.jdbc.oracore.StreamInfo;
import oracle.jdbc.oracore.UnpickleContext;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.Datum;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;

public class OracleTypeUPT
extends OracleTypeADT
implements Serializable {
    static final long serialVersionUID = -1994358478872378695L;
    static final byte KOPU_UPT_ADT = -6;
    static final byte KOPU_UPT_COLL = -5;
    static final byte KOPU_UPT_REFCUR = 102;
    static final byte KOTTCOPQ = 58;
    byte m_uptCode = 0;
    OracleNamedType m_realType = null;

    protected OracleTypeUPT() {
    }

    public OracleTypeUPT(String sql_name, OracleConnection conn) throws SQLException {
        super(sql_name, (Connection)conn);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)2, (int)32, (String)("OracleTypeUPT (sql_name = " + sql_name + ", connection = " + conn + ")"));
        }
    }

    public OracleTypeUPT(OracleTypeADT parent, int id, OracleConnection conn) throws SQLException {
        super(parent, id, (Connection)conn);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)2, (int)32, (String)("OracleTypeUPT (parent = " + parent + ", id = " + id + ", connection = " + conn + ")"));
        }
    }

    public Datum toDatum(Object value, OracleConnection conn) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)32, (int)32, (String)("OracleTypeUPT.toDatum(value = " + value + ", connection =" + conn + ")"));
        }
        if (value != null) {
            return this.m_realType.toDatum(value, conn);
        }
        return null;
    }

    public Datum[] toDatumArray(Object value, OracleConnection conn, long beginIdx, int count) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)32, (int)32, (String)("OracleTypeUPT.toDatum(value = " + value + ", connection = " + conn + ")"));
        }
        if (value != null) {
            return this.m_realType.toDatumArray(value, conn, beginIdx, count);
        }
        return null;
    }

    public int getTypeCode() throws SQLException {
        switch (this.m_uptCode) {
            case -6: {
                return this.m_realType.getTypeCode();
            }
            case -5: {
                return 2003;
            }
            case 58: {
                return 2007;
            }
        }
        DBError.throwSqlException((int)1, (Object)"Invalid type code");
        return 0;
    }

    public boolean isInHierarchyOf(OracleType anOracleType) throws SQLException {
        return false;
    }

    public boolean isInHierarchyOf(StructDescriptor aStructDescriptor) throws SQLException {
        return false;
    }

    public boolean isObjectType() {
        return false;
    }

    public void parseTDSrec(StreamInfo offset) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)4, (int)32, (String)("OracleTypeUPT.parseTDSrec(" + offset + ") " + this.m_fullName));
        }
        this.null_offset = offset.null_offset++;
        this.lds_offset = offset.lds_offset++;
        long offsetPosition = offset.readLong();
        this.m_uptCode = offset.readByte();
        offset.addNormalPatch(offsetPosition, this.m_uptCode, (OracleType)this);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)4, (int)64, (String)("OracleTypeUPT.parseTDSrec() " + this.m_fullName + " m_uptCode=" + this.m_uptCode));
        }
    }

    protected Object unpickle80rec(UnpickleContext context, int format, int style, Map map) throws SQLException {
        block0 : switch (format) {
            case 2: {
                switch (this.m_uptCode) {
                    case -5: {
                        if ((context.read_byte() & 1) == 1) {
                            context.skip_bytes(2);
                            return null;
                        }
                        return ((OracleTypeCOLLECTION)this.m_realType).unpickle80(context, null, style == 9 ? style : 3, style, map);
                    }
                    case -6: {
                        if ((context.read_byte() & 1) == 1) {
                            context.skip_bytes(4);
                            return null;
                        }
                        switch (style) {
                            case 1: {
                                return ((OracleTypeADT)this.m_realType).unpickle80(context, null, 3, style, map);
                            }
                            case 2: {
                                STRUCT result = ((OracleTypeADT)this.m_realType).unpickle80(context, null, 1, style, map);
                                return result == null ? result : result.toJdbc(map);
                            }
                            case 9: {
                                return ((OracleTypeADT)this.m_realType).unpickle80(context, null, 9, 1, map);
                            }
                        }
                        DBError.throwSqlException((int)1);
                        break block0;
                    }
                }
                DBError.throwSqlException((int)48, (Object)"upt_type");
                break;
            }
            case 3: {
                switch (this.m_uptCode) {
                    case -5: {
                        return ((OracleTypeCOLLECTION)this.m_realType).unpickle80(context, null, style == 9 ? style : 3, style, map);
                    }
                    case -6: {
                        switch (style) {
                            case 1: {
                                return ((OracleTypeADT)this.m_realType).unpickle80(context, null, 3, style, map);
                            }
                            case 2: {
                                STRUCT result = ((OracleTypeADT)this.m_realType).unpickle80(context, null, 1, style, map);
                                return result == null ? result : result.toJdbc(map);
                            }
                            case 9: {
                                return ((OracleTypeADT)this.m_realType).unpickle80(context, null, 9, 1, map);
                            }
                        }
                        DBError.throwSqlException((int)1);
                        break block0;
                    }
                }
                DBError.throwSqlException((int)48, (Object)"upt_type");
                break;
            }
            case 1: {
                switch (this.m_uptCode) {
                    case -5: {
                        if (context.is_null(this.null_offset)) {
                            context.skip_bytes(4);
                            return null;
                        }
                        context.skip_to(context.m_ldsOffsets[this.lds_offset]);
                        if (style == 9) {
                            context.skip_bytes(4);
                            return null;
                        }
                        context.markAndSkip();
                        ARRAY result = ((OracleTypeCOLLECTION)this.m_realType).unpickle80(context, null, 3, style, map);
                        context.reset();
                        return result;
                    }
                }
                DBError.throwSqlException((int)1, (Object)"upt_type");
                break;
            }
            default: {
                DBError.throwSqlException((int)1, (Object)"upt_type");
            }
        }
        return null;
    }

    protected int pickle81(PickleContext ctx, Datum data) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)8, (int)32, (String)("OracleTypeUPT.pickle81(context = " + ctx + ", datum = " + data + ") " + this.m_fullName));
        }
        int imglen = 0;
        if (data == null) {
            imglen += ctx.writeEltNull_pctx();
        } else {
            int lenOffset = ctx.offset();
            imglen += ctx.writeLength_pctx(PickleContext.KOPI20_LN_MAXV + 1);
            int realLen = 0;
            if (this.m_uptCode == -6 && !((OracleTypeADT)this.m_realType).isFinalType()) {
                if (data instanceof STRUCT) {
                    realLen = ((STRUCT)data).getDescriptor().getOracleTypeADT().pickle81(ctx, data);
                } else {
                    DBError.throwSqlException((int)1, (Object)"invalid upt state");
                }
            } else {
                realLen = this.m_realType.pickle81(ctx, data);
            }
            imglen += realLen;
            ctx.patchImageLen_pctx(lenOffset, realLen);
        }
        return imglen;
    }

    protected Object unpickle81rec(PickleContext context, int type, Map map) throws SQLException {
        OracleLog.print((Object)this, (int)16, (int)8, (int)32, (String)("OracleTypeUPT.unpickle81rec(" + context + ") " + this.m_fullName));
        byte lengthbyte = context.readByte_pctx();
        if (PickleContext.isElementNull_pctx((byte)lengthbyte)) {
            return null;
        }
        if (type == 9) {
            context.skip_bytes(context.readRestOfLength_pctx(lengthbyte));
            return null;
        }
        context.skipRestOfLength_pctx(lengthbyte);
        return this.unpickle81UPT(context, type, map);
    }

    protected Object unpickle81rec(PickleContext context, byte length, int type, Map map) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)8, (int)32, (String)("OracleTypeUPT.unpickle81rec(context = " + context + ", length =" + length + ", m_fullName = " + this.m_fullName));
        }
        long len = context.readRestOfLength_pctx(length);
        if (type == 9) {
            context.skip_bytes((int)len);
            return null;
        }
        return this.unpickle81UPT(context, type, map);
    }

    private Object unpickle81UPT(PickleContext context, int style, Map map) throws SQLException {
        switch (this.m_uptCode) {
            case -6: {
                switch (style) {
                    case 1: {
                        return ((OracleTypeADT)this.m_realType).unpickle81(context, null, 3, style, map);
                    }
                    case 2: {
                        STRUCT result = ((OracleTypeADT)this.m_realType).unpickle81(context, null, 1, style, map);
                        return result == null ? result : result.toJdbc(map);
                    }
                    case 9: {
                        return ((OracleTypeADT)this.m_realType).unpickle81(context, null, 9, 1, map);
                    }
                }
                DBError.throwSqlException((int)1);
                break;
            }
            case -5: {
                return ((OracleTypeCOLLECTION)this.m_realType).unpickle81(context, (ARRAY)null, style == 9 ? style : 3, style, map);
            }
            case 58: {
                return ((OracleTypeOPAQUE)this.m_realType).unpickle81(context, null, style == 9 ? style : 3, map);
            }
            default: {
                DBError.throwSqlException((int)1, (Object)"Unrecognized UPT code");
            }
        }
        return null;
    }

    StructDescriptor createStructDescriptor() throws SQLException {
        StructDescriptor desc = null;
        desc = !this.m_hasName ? new StructDescriptor((OracleTypeADT)this.m_realType, (Connection)this.m_conn) : StructDescriptor.createDescriptor(this.m_fullName, (Connection)this.m_conn);
        return desc;
    }

    ArrayDescriptor createArrayDescriptor() throws SQLException {
        ArrayDescriptor desc = null;
        desc = !this.m_hasName ? new ArrayDescriptor((OracleTypeCOLLECTION)this.m_realType, (Connection)this.m_conn) : ArrayDescriptor.createDescriptor(this.m_fullName, (Connection)this.m_conn);
        return desc;
    }

    public OracleType getRealType() throws SQLException {
        return this.m_realType;
    }

    public int getNumAttrs() throws SQLException {
        return ((OracleTypeADT)this.m_realType).getNumAttrs();
    }

    public OracleType getAttrTypeAt(int idx) throws SQLException {
        return ((OracleTypeADT)this.m_realType).getAttrTypeAt(idx);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)256, (int)32, (String)"OracleTypeUPT.writeObject()");
        }
        out.writeByte(this.m_uptCode);
        out.writeObject(this.m_realType);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)256, (int)32, (String)"OracleTypeUPT.readObject()");
        }
        this.m_uptCode = in.readByte();
        this.m_realType = (OracleNamedType)in.readObject();
    }

    public void setConnection(OracleConnection conn) throws SQLException {
        this.m_conn = conn;
        this.m_realType.setConnection(conn);
    }

    static {
        serialVersionUID = -1994358478872378695L;
        KOPU_UPT_ADT = (byte)-6;
        KOPU_UPT_COLL = (byte)-5;
        KOPU_UPT_REFCUR = (byte)102;
        KOTTCOPQ = (byte)58;
    }
}

