/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleNamedType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.UnpickleContext;
import oracle.sql.Datum;
import oracle.sql.REF;
import oracle.sql.StructDescriptor;

public class OracleTypeREF
extends OracleNamedType
implements Serializable {
    static final long serialVersionUID = 3186448715463064573L;

    protected OracleTypeREF() {
    }

    public OracleTypeREF(String sql_name, OracleConnection conn) {
        super(sql_name, conn);
    }

    public OracleTypeREF(OracleTypeADT parent, int idx, OracleConnection conn) {
        super(parent, idx, conn);
    }

    public Datum toDatum(Object value, OracleConnection conn) throws SQLException {
        REF datum = null;
        if (value != null) {
            if (value instanceof REF) {
                datum = (REF)value;
            } else {
                DBError.check_error((int)59, (Object)value);
            }
        }
        return datum;
    }

    public int getTypeCode() {
        return 2006;
    }

    protected Object unpickle80rec(UnpickleContext context, int format, int style, Map map) throws SQLException {
        switch (format) {
            case 1: {
                if (context.is_null(this.null_offset)) {
                    return null;
                }
                context.skip_to(context.m_ldsOffsets[this.lds_offset]);
                if (style == 9) {
                    context.skip_bytes(4);
                    return null;
                }
                context.markAndSkip();
                byte[] final_locator = context.read_ptrBytes();
                context.reset();
                return this.toObject(final_locator, style, null);
            }
            case 2: {
                if ((context.read_byte() & 1) == 1) {
                    context.skip_ptrBytes();
                    return null;
                }
            }
            case 3: {
                if (style == 9) {
                    context.skip_ptrBytes();
                    return null;
                }
                return this.toObject(context.read_ptrBytes(), style, null);
            }
        }
        DBError.throwSqlException((int)1, (Object)("format=" + format));
        return null;
    }

    protected Object toObject(byte[] val, int style, Map map) throws SQLException {
        if (val == null || val.length == 0) {
            return null;
        }
        if (style == 1 || style == 2) {
            StructDescriptor desc = this.createStructDescriptor();
            return new REF(desc, (Connection)this.m_conn, val);
        }
        if (style == 3) {
            return val;
        }
        DBError.check_error((int)59, (Object)val);
        return null;
    }

    StructDescriptor createStructDescriptor() throws SQLException {
        if (this.m_descriptor == null) {
            if (!this.m_hasName && this.getFullName(false) == null) {
                OracleTypeADT otype = new OracleTypeADT(this.getParent(), this.getOrder(), (Connection)this.m_conn);
                this.m_descriptor = new StructDescriptor(otype, (Connection)this.m_conn);
            } else {
                this.m_descriptor = StructDescriptor.createDescriptor(this.m_fullName, (Connection)this.m_conn);
            }
        }
        return (StructDescriptor)this.m_descriptor;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)256, (int)32, (String)"OracleTypeREF.writeObject()");
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)256, (int)32, (String)"OracleTypeREF.readObject()");
        }
    }

    static {
        serialVersionUID = 3186448715463064573L;
    }
}

