/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.PickleContext;
import oracle.jdbc.oracore.StreamInfo;
import oracle.jdbc.oracore.UnpickleContext;
import oracle.sql.Datum;
import oracle.sql.RAW;

public class OracleTypeRAW
extends OracleType
implements Serializable {
    static final long serialVersionUID = -6083664758336974576L;
    int length;

    public OracleTypeRAW() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)2, (int)32, (String)"OracleTypeRAW ()");
        }
    }

    public OracleTypeRAW(int typecode) {
        super(typecode);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)2, (int)32, (String)("OracleTypeRAW (typcode = " + typecode + ")"));
        }
    }

    public Datum toDatum(Object value, OracleConnection conn) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)32, (int)64, (String)("OracleTypeRAW.toDatum (value = " + value + ", conn = " + conn + ")"));
        }
        RAW datum = null;
        if (value != null) {
            try {
                datum = value instanceof RAW ? (RAW)value : new RAW(value);
            }
            catch (SQLException e2) {
                DBError.throwSqlException((int)59, (Object)value);
            }
        }
        return datum;
    }

    public Datum[] toDatumArray(Object obj, OracleConnection conn, long beginIdx, int count) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)32, (int)64, (String)("OracleTypeRAW.toDatumArray( obj = " + obj + ", conn = " + conn + ", beginIdx = " + beginIdx + ", count = " + count + ")"));
        }
        Datum[] datumArray = null;
        if (obj != null) {
            if (obj instanceof char[][]) {
                char[][] strArray = (char[][])obj;
                int length = (int)(count == -1 ? (long)strArray.length : Math.min((long)strArray.length - beginIdx + 1L, (long)count));
                datumArray = new Datum[length];
                int i2 = 0;
                while (i2 < length) {
                    datumArray[i2] = this.toDatum(new String(strArray[(int)beginIdx + i2 - 1]), conn);
                    ++i2;
                }
            } else {
                if (obj instanceof Object[]) {
                    return super.toDatumArray(obj, conn, beginIdx, count);
                }
                DBError.check_error((int)59, (Object)obj);
            }
        }
        return datumArray;
    }

    public int getTypeCode() {
        return -2;
    }

    public void parseTDSrec(StreamInfo offset) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)128, (int)64, (String)("OracleTypeRAW.parseTDSrec (streamInfo = " + offset + ")"));
        }
        super.parseTDSrec(offset);
        this.length = offset.readShort();
    }

    protected Object unpickle80rec(UnpickleContext context, int format, int style, Map map) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)16, (int)64, (String)("OracleTypeRAW.unpickle80rec (context =" + context + ", format = " + format + ", style = " + style + ", map = " + map + ")"));
        }
        switch (format) {
            case 1: {
                if (context.is_null(this.null_offset)) {
                    return null;
                }
                context.skip_to(context.m_ldsOffsets[this.lds_offset]);
                if (style == 9) {
                    context.skip_bytes(4);
                    return null;
                }
                context.markAndSkip();
                byte[] val = context.read_lengthBytes();
                context.reset();
                return this.toObject(val, style, map);
            }
            case 2: {
                if ((context.read_byte() & 1) == 1 || style == 9) {
                    context.skip_lengthBytes();
                    return null;
                }
                return this.toObject(context.read_lengthBytes(), style, map);
            }
            case 3: {
                if (style == 9) {
                    context.skip_lengthBytes();
                    return null;
                }
                return this.toObject(context.read_lengthBytes(), style, map);
            }
        }
        DBError.throwSqlException((int)1, (Object)("format=" + format));
        return null;
    }

    protected int pickle81(PickleContext ctx, Datum data) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)8, (int)64, (String)("OracleTypeRAW.pickle81 (ctx = " + ctx + ", data = " + data + ")"));
        }
        if (data.getLength() > (long)this.length) {
            DBError.check_error((int)72, (Object)this);
        }
        int len = ctx.writeLength_pctx((int)data.getLength());
        return len += ctx.write_data_pctx(data.shareBytes());
    }

    public int getLength() {
        return this.length;
    }

    protected Object toObject(byte[] val, int style, Map map) throws SQLException {
        if (val == null || val.length == 0) {
            return null;
        }
        switch (style) {
            case 1: {
                return new RAW(val);
            }
            case 2: 
            case 3: {
                return val;
            }
        }
        DBError.throwSqlException((int)59, (Object)val);
        return null;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)256, (int)32, (String)"OracleTypeRAW.writeObject()");
        }
        out.writeInt(this.length);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)256, (int)32, (String)"OracleTypeRAW.readObject()");
        }
        this.length = in.readInt();
    }

    static {
        serialVersionUID = -6083664758336974576L;
    }
}

