/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.PickleContext;
import oracle.jdbc.oracore.StreamInfo;
import oracle.sql.Datum;
import oracle.sql.OPAQUE;
import oracle.sql.OpaqueDescriptor;
import oracle.sql.StructDescriptor;

public class OracleTypeOPAQUE
extends OracleTypeADT
implements Serializable {
    static final long KOLOFLLB = 1L;
    static final long KOLOFLCL = 2L;
    static final long KOLOFLUB = 4L;
    static final long KOLOFLFX = 8L;
    static final long serialVersionUID = -7279638692691669378L;
    long m_flag;
    long m_maxLen;

    public OracleTypeOPAQUE(String sql_name, OracleConnection conn) throws SQLException {
        super(sql_name, (Connection)conn);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)2, (int)32, (String)("OracleTypeOPAQUE (+sql_name = " + sql_name + ", conn = " + conn + ")"));
        }
    }

    public OracleTypeOPAQUE(OracleTypeADT parent, int idx, OracleConnection conn) throws SQLException {
        super(parent, idx, (Connection)conn);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)2, (int)32, (String)("OracleTypeOPAQUE (parent = " + parent + ", idx = " + idx + ", conn = " + conn + ")"));
        }
    }

    public Datum toDatum(Object value, OracleConnection conn) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)32, (int)32, (String)("OracleTypeOPAQUE.toDatum(value = " + value + ", conn = " + conn + ")"));
        }
        if (value != null) {
            if (value instanceof OPAQUE) {
                return (OPAQUE)value;
            }
            OpaqueDescriptor desc = this.createOpaqueDescriptor();
            return new OPAQUE(desc, this.m_conn, value);
        }
        return null;
    }

    public int getTypeCode() {
        return 2007;
    }

    public boolean isInHierarchyOf(OracleType anOracleType) throws SQLException {
        return false;
    }

    public boolean isInHierarchyOf(StructDescriptor aStructDescriptor) throws SQLException {
        return false;
    }

    public boolean isObjectType() {
        return false;
    }

    public void parseTDSrec(StreamInfo offset) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)4, (int)32, (String)("OracleTypeOPAQUE.parseTDSrec(offset = " + offset + ") m_fullName = " + this.m_fullName));
        }
        offset.skipBytes(5);
        this.m_flag = offset.readLong();
        this.m_maxLen = offset.readLong();
    }

    public Datum unlinearize(byte[] pickled_bytes, long offset, Datum container, int style, Map objmap) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)16, (int)64, (String)("OracleTypeADT.unlinearize(pickled_bytes = " + pickled_bytes + ", m_fullName = " + this.m_fullName + ")"));
        }
        if (pickled_bytes == null) {
            return null;
        }
        if ((pickled_bytes[0] & 0x80) > 0) {
            PickleContext context = new PickleContext(pickled_bytes, offset);
            return this.unpickle81(context, (OPAQUE)container, style, objmap);
        }
        return null;
    }

    public byte[] linearize(Datum data) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)8, (int)32, (String)("OracleTypeADT.lindarize(" + data + ") " + this.m_fullName));
        }
        return this.pickle81(data);
    }

    protected int pickle81(PickleContext ctx, Datum datum) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)8, (int)64, (String)("OracleTypeOPAQUE.pickle81(ctx = " + ctx + ", datum = " + datum + ") m_fullName = " + this.m_fullName + ")"));
        }
        OPAQUE obj = (OPAQUE)datum;
        byte[] data = obj.getBytesValue();
        int imglen = 0;
        imglen += ctx.writeOpaqueImageHeader_pctx(data.length);
        return imglen += ctx.write_data_pctx(data);
    }

    OPAQUE unpickle81(PickleContext context, OPAQUE container, int style, Map elemMap) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)2, (int)64, (String)("unpickle81( context = " + context + ", container = " + container + ", style = " + style + ", ememMap = " + elemMap + ")"));
        }
        return this.unpickle81datum(context, container);
    }

    protected Object unpickle81rec(PickleContext context, int style, Map map) throws SQLException {
        byte b2 = context.readByte_pctx();
        if (PickleContext.isElementNull_pctx((byte)b2)) {
            return null;
        }
        context.skipRestOfLength_pctx(b2);
        switch (style) {
            case 1: 
            case 2: {
                return this.unpickle81datum(context, null);
            }
            case 3: {
                return new OPAQUE(this.createOpaqueDescriptor(), context.readDataValue_pctx(), this.m_conn);
            }
            case 9: {
                context.skipDataValue_pctx();
                return null;
            }
        }
        DBError.throwSqlException((int)1);
        return null;
    }

    private OPAQUE unpickle81datum(PickleContext context, OPAQUE container) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)2, (int)64, (String)("unpickle81datum( context = " + context + ", container = " + container + ")"));
        }
        context.skip_bytes(2);
        long length = context.readLength_pctx(true) - 2;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)2, (int)64, (String)("unpickle81datum: byte[] length = " + length));
        }
        if (container == null) {
            return new OPAQUE(this.createOpaqueDescriptor(), this.m_conn, context.readBytes_pctx((int)length));
        }
        container.setValue(context.readBytes_pctx((int)length));
        return container;
    }

    OpaqueDescriptor createOpaqueDescriptor() throws SQLException {
        if (!this.m_hasName) {
            return new OpaqueDescriptor(this, (Connection)this.m_conn);
        }
        return OpaqueDescriptor.createDescriptor(this.m_fullName, (Connection)this.m_conn);
    }

    public long getMaxLength() throws SQLException {
        return this.m_maxLen;
    }

    public boolean isTrustedLibrary() throws SQLException {
        return (this.m_flag & 1L) != 0L;
    }

    public boolean isModeledInC() throws SQLException {
        return (this.m_flag & 2L) != 0L;
    }

    public boolean isUnboundedSized() throws SQLException {
        return (this.m_flag & 4L) != 0L;
    }

    public boolean isFixedSized() throws SQLException {
        return (this.m_flag & 8L) != 0L;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)256, (int)32, (String)"OracleTypeOPAQUE.writeObject()");
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)256, (int)32, (String)"OracleTypeOPAQUE.readObject()");
        }
    }

    public void setConnection(OracleConnection conn) throws SQLException {
        this.m_conn = conn;
    }

    static {
        KOLOFLLB = 1L;
        KOLOFLCL = 2L;
        KOLOFLUB = 4L;
        KOLOFLFX = 8L;
        serialVersionUID = -7279638692691669378L;
    }
}

