/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.PickleContext;
import oracle.jdbc.oracore.StreamInfo;
import oracle.jdbc.oracore.UnpickleContext;
import oracle.jdbc.oracore.Util;
import oracle.sql.Datum;
import oracle.sql.NUMBER;

public class OracleTypeNUMBER
extends OracleType
implements Serializable {
    static final long serialVersionUID = -7182242886677299812L;
    int m_precision;
    int m_scale;

    protected OracleTypeNUMBER() {
    }

    protected OracleTypeNUMBER(int typecode) {
        super(typecode);
    }

    public Datum toDatum(Object value, OracleConnection conn) throws SQLException {
        return OracleTypeNUMBER.toNUMBER(value, conn);
    }

    public Datum[] toDatumArray(Object obj, OracleConnection conn, long beginIdx, int count) throws SQLException {
        return OracleTypeNUMBER.toNUMBERArray(obj, conn, beginIdx, count);
    }

    public void parseTDSrec(StreamInfo offset) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)128, (int)64, (String)("OracleTypeNUMBER.parseTDSrec( streamInfo = " + offset + ")"));
        }
        this.null_offset = offset.null_offset++;
        this.lds_offset = offset.lds_offset++;
        this.m_precision = offset.readUnsignedByte();
        this.m_scale = offset.readByte();
    }

    public int getSizeLDS(byte[] FDO) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)128, (int)64, (String)("OracleTypeNUMBER.getSizeLDS( FDO = " + FDO + ")"));
        }
        if (this.size_for_lds == 0) {
            this.size_for_lds = Util.FDO_get_size((byte[])FDO, (int)12);
            this.align_for_lds = Util.FDO_get_align((byte[])FDO, (int)12);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)128, (int)64, (String)("OracleTypeNUMBER.getSizeLDS:return " + this.size_for_lds));
        }
        return this.size_for_lds;
    }

    public int getAlignLDS(byte[] FDO) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)128, (int)64, (String)("OracleTypeNUMBER.getAlignLDS( FDO = " + FDO + ")"));
        }
        if (this.size_for_lds == 0) {
            this.size_for_lds = Util.FDO_get_size((byte[])FDO, (int)12);
            this.align_for_lds = Util.FDO_get_align((byte[])FDO, (int)12);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)128, (int)64, (String)("OracleTypeNUMBER.getAlignLDS:return " + this.align_for_lds));
        }
        return this.align_for_lds;
    }

    protected Object unpickle80rec(UnpickleContext context, int format, int type, Map map) throws SQLException {
        return OracleTypeNUMBER.numericUnpickle80rec((int)this.lds_offset, (int)this.null_offset, (UnpickleContext)context, (int)format, (int)type, (Map)map);
    }

    protected static Object numericUnpickle80rec(int lds_offset, int null_offset, UnpickleContext context, int format, int style, Map map) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)16, (int)16, (int)64, (String)("OracleTypeNUMBER.numericUnpickle80rec( lds_offset = " + lds_offset + ", null_offset =" + null_offset + ", context =" + context + ", format = " + format + ", style = " + style + ", map = " + map + ")"));
        }
        switch (format) {
            case 1: {
                if (context.is_null(null_offset)) {
                    return null;
                }
                context.skip_to(context.m_ldsOffsets[lds_offset]);
                break;
            }
            case 2: {
                if ((context.read_byte() & 1) != 1) break;
                context.skip_bytes(22);
                return null;
            }
            case 3: {
                break;
            }
            default: {
                DBError.throwSqlException((int)1, (Object)("format=" + format));
            }
        }
        if (style == 9) {
            context.skip_bytes(22);
            return null;
        }
        return OracleTypeNUMBER.toNumericObject(context.read_varNumBytes(), style, map);
    }

    protected static Object unpickle80_nativeArray(UnpickleContext context, long beginIdx, int size, int style, int format) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)16, (int)16, (int)64, (String)("OracleTypeNUMBER.unpickle80_nativeArray( context =" + context + ", begin index =" + beginIdx + ", size = " + size + ", style = " + style + ", format = " + format + ")"));
        }
        int numSz = 0;
        switch (format) {
            case 2: {
                numSz = 23;
                break;
            }
            case 3: {
                numSz = 22;
                break;
            }
            default: {
                DBError.throwSqlException((int)1, (Object)("format=" + format));
            }
        }
        if (size > 0) {
            context.skip_bytes(numSz * ((int)beginIdx - 1));
        }
        int offset = context.absolute_offset();
        byte[] data = context.image();
        int current = 0;
        switch (style) {
            case 4: {
                int[] holder = new int[size];
                int i2 = 0;
                while (i2 < size) {
                    current = offset + i2 * numSz;
                    if (format == 3 || (data[current++] & 1) == 0) {
                        byte[] array = new byte[data[current++]];
                        System.arraycopy(data, current, array, 0, array.length);
                        holder[i2] = NUMBER.toInt(array);
                    }
                    ++i2;
                }
                context.skip_bytes(numSz * size);
                return holder;
            }
            case 5: {
                double[] holder = new double[size];
                int i3 = 0;
                while (i3 < size) {
                    current = offset + i3 * numSz;
                    if (format == 3 || (data[current++] & 1) == 0) {
                        byte[] array = new byte[data[current++]];
                        System.arraycopy(data, current, array, 0, array.length);
                        holder[i3] = NUMBER.toDouble(array);
                    }
                    ++i3;
                }
                context.skip_bytes(numSz * size);
                return holder;
            }
            case 7: {
                long[] holder = new long[size];
                int i4 = 0;
                while (i4 < size) {
                    current = offset + i4 * numSz;
                    if (format == 3 || (data[current++] & 1) == 0) {
                        byte[] array = new byte[data[current++]];
                        System.arraycopy(data, current, array, 0, array.length);
                        holder[i4] = NUMBER.toLong(array);
                    }
                    ++i4;
                }
                context.skip_bytes(numSz * size);
                return holder;
            }
            case 6: {
                float[] holder = new float[size];
                int i5 = 0;
                while (i5 < size) {
                    current = offset + i5 * numSz;
                    if (format == 3 || (data[current++] & 1) == 0) {
                        byte[] array = new byte[data[current++]];
                        System.arraycopy(data, current, array, 0, array.length);
                        holder[i5] = NUMBER.toFloat(array);
                    }
                    ++i5;
                }
                context.skip_bytes(numSz * size);
                return holder;
            }
            case 8: {
                short[] holder = new short[size];
                int i6 = 0;
                while (i6 < size) {
                    current = offset + i6 * numSz;
                    if (format == 3 || (data[current++] & 1) == 0) {
                        byte[] array = new byte[data[current++]];
                        System.arraycopy(data, current, array, 0, array.length);
                        holder[i6] = NUMBER.toShort(array);
                    }
                    ++i6;
                }
                context.skip_bytes(numSz * size);
                return holder;
            }
        }
        DBError.throwSqlException((int)23);
        return null;
    }

    protected static Object unpickle81_nativeArray(PickleContext context, long beginIdx, int size, int style) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)16, (int)16, (int)64, (String)("OracleTypeNUMBER.unpickle81_nativeArray( context =" + context + ", begin index =" + beginIdx + ", size = " + size + ", style = " + style + ")"));
        }
        int i2 = 1;
        while ((long)i2 < beginIdx && size > 0) {
            context.skipDataValue_pctx();
            ++i2;
        }
        byte[] val = null;
        switch (style) {
            case 4: {
                int[] holder = new int[size];
                int i3 = 0;
                while (i3 < size) {
                    val = context.readDataValue_pctx();
                    if (val != null) {
                        holder[i3] = NUMBER.toInt(val);
                    }
                    ++i3;
                }
                return holder;
            }
            case 5: {
                double[] holder = new double[size];
                int i4 = 0;
                while (i4 < size) {
                    val = context.readDataValue_pctx();
                    if (val != null) {
                        holder[i4] = NUMBER.toDouble(val);
                    }
                    ++i4;
                }
                return holder;
            }
            case 7: {
                long[] holder = new long[size];
                int i5 = 0;
                while (i5 < size) {
                    val = context.readDataValue_pctx();
                    if (val != null) {
                        holder[i5] = NUMBER.toLong(val);
                    }
                    ++i5;
                }
                return holder;
            }
            case 6: {
                float[] holder = new float[size];
                int i6 = 0;
                while (i6 < size) {
                    val = context.readDataValue_pctx();
                    if (val != null) {
                        holder[i6] = NUMBER.toFloat(val);
                    }
                    ++i6;
                }
                return holder;
            }
            case 8: {
                short[] holder = new short[size];
                int i7 = 0;
                while (i7 < size) {
                    val = context.readDataValue_pctx();
                    if (val != null) {
                        holder[i7] = NUMBER.toShort(val);
                    }
                    ++i7;
                }
                return holder;
            }
        }
        DBError.throwSqlException((int)23);
        return null;
    }

    protected Object toObject(byte[] bytes, int style, Map map) throws SQLException {
        return OracleTypeNUMBER.toNumericObject(bytes, style, map);
    }

    static Object toNumericObject(byte[] bytes, int style, Map map) throws SQLException {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        switch (style) {
            case 1: {
                return new NUMBER(bytes);
            }
            case 2: {
                return NUMBER.toBigDecimal(bytes);
            }
            case 3: {
                return bytes;
            }
        }
        DBError.throwSqlException((int)23);
        return null;
    }

    public static NUMBER toNUMBER(Object value, OracleConnection conn) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)16, (int)32, (int)64, (String)("OracleTypeNUMBER.toNUMBER( object = " + value + ", connection = " + conn + ")"));
        }
        NUMBER datum = null;
        if (value != null) {
            try {
                datum = value instanceof NUMBER ? (NUMBER)value : new NUMBER(value);
            }
            catch (SQLException e2) {
                DBError.check_error((int)59, (Object)value);
            }
        }
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)16, (int)32, (int)64, (String)("OracleTypeNUMBER.toNUMBER:return " + datum));
        }
        return datum;
    }

    public static Datum[] toNUMBERArray(Object obj, OracleConnection conn, long beginIdx, int count) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)16, (int)32, (int)64, (String)("OracleTypeNUMBER.toNUMBERArray( object = " + obj + ", connection = " + conn + ", begin index = " + beginIdx + ", count = " + count + ")"));
        }
        Datum[] datumArray = null;
        if (obj != null) {
            if (obj instanceof Object[] && !(obj instanceof char[][])) {
                Object[] objArray = (Object[])obj;
                int length = (int)(count == -1 ? (long)objArray.length : Math.min((long)objArray.length - beginIdx + 1L, (long)count));
                datumArray = new Datum[length];
                int i2 = 0;
                while (i2 < length) {
                    datumArray[i2] = OracleTypeNUMBER.toNUMBER(objArray[(int)beginIdx + i2 - 1], conn);
                    ++i2;
                }
            } else {
                datumArray = OracleTypeNUMBER.cArrayToNUMBERArray(obj, conn, beginIdx, count);
            }
        }
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)16, (int)32, (int)64, (String)("OracleTypeNUMBER.toNUMBERArray:return " + datumArray));
        }
        return datumArray;
    }

    static Datum[] cArrayToNUMBERArray(Object obj, OracleConnection conn, long beginIdx, int count) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)16, (int)32, (int)64, (String)("OracleTypeNUMBER.cArrayToNUMBERArray( object = " + obj + ", connection = " + conn + ", begin index = " + beginIdx + ", count = " + count + ")"));
        }
        Datum[] datumArray = null;
        if (obj != null) {
            if (obj instanceof short[]) {
                short[] parray = (short[])obj;
                int len = (int)(count == -1 ? (long)parray.length : Math.min((long)parray.length - beginIdx + 1L, (long)count));
                datumArray = new Datum[len];
                int i2 = 0;
                while (i2 < len) {
                    datumArray[i2] = new NUMBER(parray[(int)beginIdx + i2 - 1]);
                    ++i2;
                }
            } else if (obj instanceof int[]) {
                int[] parray = (int[])obj;
                int len = (int)(count == -1 ? (long)parray.length : Math.min((long)parray.length - beginIdx + 1L, (long)count));
                datumArray = new Datum[len];
                int i3 = 0;
                while (i3 < len) {
                    datumArray[i3] = new NUMBER(parray[(int)beginIdx + i3 - 1]);
                    ++i3;
                }
            } else if (obj instanceof long[]) {
                long[] parray = (long[])obj;
                int len = (int)(count == -1 ? (long)parray.length : Math.min((long)parray.length - beginIdx + 1L, (long)count));
                datumArray = new Datum[len];
                int i4 = 0;
                while (i4 < len) {
                    datumArray[i4] = new NUMBER(parray[(int)beginIdx + i4 - 1]);
                    ++i4;
                }
            } else if (obj instanceof float[]) {
                float[] parray = (float[])obj;
                int len = (int)(count == -1 ? (long)parray.length : Math.min((long)parray.length - beginIdx + 1L, (long)count));
                datumArray = new Datum[len];
                int i5 = 0;
                while (i5 < len) {
                    datumArray[i5] = new NUMBER(parray[(int)beginIdx + i5 - 1]);
                    ++i5;
                }
            } else if (obj instanceof double[]) {
                double[] parray = (double[])obj;
                int len = (int)(count == -1 ? (long)parray.length : Math.min((long)parray.length - beginIdx + 1L, (long)count));
                datumArray = new Datum[len];
                int i6 = 0;
                while (i6 < len) {
                    datumArray[i6] = new NUMBER(parray[(int)beginIdx + i6 - 1]);
                    ++i6;
                }
            } else if (obj instanceof boolean[]) {
                boolean[] parray = (boolean[])obj;
                int len = (int)(count == -1 ? (long)parray.length : Math.min((long)parray.length - beginIdx + 1L, (long)count));
                datumArray = new Datum[len];
                int i7 = 0;
                while (i7 < len) {
                    datumArray[i7] = new NUMBER(new Boolean(parray[(int)beginIdx + i7 - 1]));
                    ++i7;
                }
            } else if (obj instanceof char[][]) {
                char[][] parray = (char[][])obj;
                int len = (int)(count == -1 ? (long)parray.length : Math.min((long)parray.length - beginIdx + 1L, (long)count));
                datumArray = new Datum[len];
                int i8 = 0;
                while (i8 < len) {
                    datumArray[i8] = new NUMBER(new String(parray[(int)beginIdx + i8 - 1]));
                    ++i8;
                }
            } else {
                DBError.check_error((int)59, (Object)obj);
            }
        }
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)16, (int)32, (int)64, (String)("OracleTypeNUMBER.cArrayToNUMBERArray:return " + datumArray));
        }
        return datumArray;
    }

    public int getPrecision() {
        return this.m_precision;
    }

    public int getScale() {
        return this.m_scale;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)256, (int)32, (String)"OracleTypeNUMBER.writeObject()");
        }
        out.writeInt(this.m_scale);
        out.writeInt(this.m_precision);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)256, (int)32, (String)"OracleTypeNUMBER.readObject()");
        }
        this.m_scale = in.readInt();
        this.m_precision = in.readInt();
    }

    static {
        serialVersionUID = -7182242886677299812L;
    }
}

