/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.StreamInfo;
import oracle.jdbc.oracore.UnpickleContext;
import oracle.sql.Datum;
import oracle.sql.INTERVALYM;

public class OracleTypeINTERVAL
extends OracleType
implements Serializable {
    static final long serialVersionUID = 1394800182554224957L;
    final int LDIINTYEARMONTH = 7;
    final int LDIINTDAYSECOND = 10;
    final int SIZE_INTERVAL_YM = 5;
    final int SIZE_INTERVAL_DS = 11;
    byte type = 0;
    int fsprec = 0;
    int lfprec = 0;

    protected OracleTypeINTERVAL() {
    }

    public OracleTypeINTERVAL(OracleConnection connection) {
    }

    public int getTypeCode() {
        if (this.type == 7) {
            return -103;
        }
        if (this.type == 10) {
            return -104;
        }
        return 1111;
    }

    public void parseTDSrec(StreamInfo offset) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)128, (int)64, (String)("OracleTypeINTERVAL.parseTDSrec( streamInfo  = " + offset + ")"));
        }
        this.type = offset.readByte();
        this.lfprec = offset.readByte();
        this.fsprec = offset.readByte();
    }

    public int getScale() throws SQLException {
        return this.fsprec;
    }

    public int getPrecision() throws SQLException {
        return this.lfprec;
    }

    public void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)256, (int)32, (String)"OracleTypeINTERVAL.readObject()");
        }
        this.type = in.readByte();
        this.lfprec = in.readByte();
        this.fsprec = in.readByte();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)256, (int)32, (String)"OracleTypeINTERVAL.writeObject()");
        }
        out.writeByte(this.type);
        out.writeByte(this.lfprec);
        out.writeByte(this.fsprec);
    }

    protected Object toObject(byte[] bytes, int otype, Map map) throws SQLException {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        switch (otype) {
            case 1: {
                if (bytes.length != 5) break;
                return new INTERVALYM(bytes);
            }
            case 2: {
                if (bytes.length != 5) break;
                return INTERVALYM.toString(bytes);
            }
            case 3: {
                return bytes;
            }
            default: {
                DBError.check_error((int)59);
            }
        }
        return null;
    }

    public Datum toDatum(Object value, OracleConnection conn) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)16, (int)64, (String)("OracleTypeINTERVAL.toDatum( value = " + value + ", conn = " + conn + ")"));
        }
        if (value != null) {
            if (value instanceof INTERVALYM) {
                return (INTERVALYM)value;
            }
            DBError.check_error((int)59, (Object)value);
        }
        return null;
    }

    protected Object unpickle80rec(UnpickleContext context, int format, int otype, Map map) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)16, (int)64, (String)("OracleTypeINTERVAL.unpickle80rec( context = " + context + ", format = " + format + ", otype = " + otype + ", map = " + map + ")"));
        }
        DBError.throwSqlException((int)90);
        return null;
    }

    protected Object unpickle81rec(UnpickleContext context, int format, int otype, Map map) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)16, (int)64, (String)("OracleTypeINTERVAL.unpickle81rec( context = " + context + ", format = " + format + ", otype = " + otype + ", map = " + map + ")"));
        }
        DBError.throwSqlException((int)90);
        return null;
    }

    static {
        serialVersionUID = 1394800182554224957L;
    }
}

