/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeNUMBER;
import oracle.jdbc.oracore.PickleContext;
import oracle.jdbc.oracore.StreamInfo;
import oracle.jdbc.oracore.UnpickleContext;
import oracle.jdbc.oracore.Util;
import oracle.sql.Datum;

public class OracleTypeFLOAT
extends OracleType
implements Serializable {
    static final long serialVersionUID = 4088841548269771109L;
    int m_precision;

    protected OracleTypeFLOAT() {
    }

    public Datum toDatum(Object value, OracleConnection conn) throws SQLException {
        return OracleTypeNUMBER.toNUMBER(value, conn);
    }

    public Datum[] toDatumArray(Object obj, OracleConnection conn, long beginIdx, int count) throws SQLException {
        return OracleTypeNUMBER.toNUMBERArray(obj, conn, beginIdx, count);
    }

    public int getTypeCode() {
        return 6;
    }

    public void parseTDSrec(StreamInfo offset) throws SQLException {
        this.null_offset = offset.null_offset++;
        this.lds_offset = offset.lds_offset++;
        this.m_precision = offset.readUnsignedByte();
    }

    public int getScale() {
        return -127;
    }

    public int getPrecision() {
        return this.m_precision;
    }

    public int getSizeLDS(byte[] FDO) {
        if (this.size_for_lds == 0) {
            this.size_for_lds = Util.FDO_get_size((byte[])FDO, (int)12);
            this.align_for_lds = Util.FDO_get_align((byte[])FDO, (int)12);
        }
        return this.size_for_lds;
    }

    public int getAlignLDS(byte[] FDO) {
        if (this.size_for_lds == 0) {
            this.size_for_lds = Util.FDO_get_size((byte[])FDO, (int)12);
            this.align_for_lds = Util.FDO_get_align((byte[])FDO, (int)12);
        }
        return this.align_for_lds;
    }

    protected Object unpickle80rec(UnpickleContext context, int format, int type, Map map) throws SQLException {
        return OracleTypeNUMBER.numericUnpickle80rec((int)this.lds_offset, (int)this.null_offset, (UnpickleContext)context, (int)format, (int)type, (Map)map);
    }

    protected static Object unpickle80_nativeArray(UnpickleContext context, long beginIdx, int size, int type, int format) throws SQLException {
        return OracleTypeNUMBER.unpickle80_nativeArray((UnpickleContext)context, (long)beginIdx, (int)size, (int)type, (int)format);
    }

    protected static Object unpickle81_nativeArray(PickleContext context, long beginIdx, int size, int type) throws SQLException {
        return OracleTypeNUMBER.unpickle81_nativeArray((PickleContext)context, (long)beginIdx, (int)size, (int)type);
    }

    protected Object toObject(byte[] bytes, int type, Map map) throws SQLException {
        return OracleTypeNUMBER.toNumericObject(bytes, type, map);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)256, (int)32, (String)"OracleTypeFLOAT.writeObject()");
        }
        out.writeInt(this.m_precision);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)256, (int)32, (String)"OracleTypeFLOAT.readObject()");
        }
        this.m_precision = in.readInt();
    }

    static {
        serialVersionUID = 4088841548269771109L;
    }
}

