/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.UnpickleContext;
import oracle.jdbc.oracore.Util;
import oracle.sql.DATE;
import oracle.sql.Datum;

public class OracleTypeDATE
extends OracleType
implements Serializable {
    static final long serialVersionUID = -5858803341118747965L;

    public OracleTypeDATE() {
    }

    public OracleTypeDATE(int typecode) {
        super(typecode);
    }

    public Datum toDatum(Object value, OracleConnection conn) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)32, (int)32, (String)("OracleTypeDATE.toDatum( object = " + value + ", connection = " + conn + ")"));
        }
        DATE datum = null;
        if (value != null) {
            try {
                datum = value instanceof DATE ? (DATE)value : new DATE(value);
            }
            catch (SQLException e2) {
                DBError.check_error((int)59, (Object)value);
            }
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)32, (int)32, (String)("OracleTypeDATE.toDatum:return " + datum));
        }
        return datum;
    }

    public Datum[] toDatumArray(Object obj, OracleConnection conn, long beginIdx, int count) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)32, (int)32, (String)("OracleTypeDATE.toDatumArray( object = " + obj + ", connection = " + conn + ", begin index = " + beginIdx + ", count =" + count + ")"));
        }
        Datum[] datumArray = null;
        if (obj != null) {
            if (obj instanceof char[][]) {
                char[][] strArray = (char[][])obj;
                int length = (int)(count == -1 ? (long)strArray.length : Math.min((long)strArray.length - beginIdx + 1L, (long)count));
                datumArray = new Datum[length];
                int i2 = 0;
                while (i2 < length) {
                    datumArray[i2] = this.toDatum(new String(strArray[(int)beginIdx + i2 - 1]), conn);
                    ++i2;
                }
            } else {
                if (obj instanceof Object[]) {
                    return super.toDatumArray(obj, conn, beginIdx, count);
                }
                DBError.check_error((int)59, (Object)obj);
            }
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)32, (int)32, (String)("OracleTypeDATE.toDatumArray:returm " + datumArray));
        }
        return datumArray;
    }

    public int getTypeCode() {
        return 91;
    }

    public int getSizeLDS(byte[] FDO) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)128, (int)64, (String)("OracleTypeDATE.getSizeLDS( FDO = " + FDO + ")"));
        }
        if (this.size_for_lds == 0) {
            this.size_for_lds = Util.FDO_get_size((byte[])FDO, (int)11);
            this.align_for_lds = Util.FDO_get_align((byte[])FDO, (int)11);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)128, (int)64, (String)("OracleTypeDATE.getSizeLDS:return " + this.size_for_lds));
        }
        return this.size_for_lds;
    }

    public int getAlignLDS(byte[] FDO) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)128, (int)64, (String)("OracleTypeDATE.getAlignLDS( FDO = " + FDO + ")"));
        }
        if (this.size_for_lds == 0) {
            this.size_for_lds = Util.FDO_get_size((byte[])FDO, (int)11);
            this.align_for_lds = Util.FDO_get_align((byte[])FDO, (int)11);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)128, (int)64, (String)("OracleTypeDATE.getAlignLDS:return " + this.align_for_lds));
        }
        return this.align_for_lds;
    }

    protected Object unpickle80rec(UnpickleContext context, int format, int type, Map map) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)16, (int)64, (String)("OracleTypeDATE.unpickle80rec( context = " + context + ", format =" + format + ", type = " + type + ", map =" + map + ")"));
        }
        switch (format) {
            case 1: {
                if (context.is_null(this.null_offset)) {
                    return null;
                }
                context.skip_to(context.m_ldsOffsets[this.lds_offset]);
                break;
            }
            case 2: {
                if ((context.read_byte() & 1) == 1) {
                    context.skip_bytes(8);
                    return null;
                }
            }
            case 3: {
                break;
            }
            default: {
                DBError.throwSqlException((int)1, (Object)("format=" + format));
            }
        }
        if (type == 9) {
            context.skip_bytes(8);
            return null;
        }
        byte[] bytes = context.image();
        int offset = context.absolute_offset();
        byte[] internal_bytes = new byte[7];
        int kopi0dy = context.m_bigEndian ? (bytes[offset] & 0xFF) * 256 + (bytes[offset + 1] & 0xFF) : (bytes[offset + 1] & 0xFF) * 256 + (bytes[offset] & 0xFF);
        if (kopi0dy < 0) {
            internal_bytes[0] = (byte)(100 - -kopi0dy / 100);
            internal_bytes[1] = (byte)(100 - -kopi0dy % 100);
        } else {
            internal_bytes[0] = (byte)(kopi0dy / 100 + 100);
            internal_bytes[1] = (byte)(kopi0dy % 100 + 100);
        }
        internal_bytes[2] = bytes[offset + 2];
        internal_bytes[3] = bytes[offset + 3];
        internal_bytes[4] = (byte)(bytes[offset + 4] + 1);
        internal_bytes[5] = (byte)(bytes[offset + 5] + 1);
        internal_bytes[6] = (byte)(bytes[offset + 6] + 1);
        context.skip_bytes(8);
        return this.toObject(internal_bytes, type, map);
    }

    protected Object toObject(byte[] bytes, int type, Map map) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)128, (int)64, (String)("OracleTypeDATE.toObject( bytes = " + bytes + ", type = " + type + ", map = " + map + ")"));
        }
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        if (type == 1) {
            return new DATE(bytes);
        }
        if (type == 2) {
            return DATE.toTimestamp(bytes);
        }
        if (type == 3) {
            return bytes;
        }
        DBError.throwSqlException((int)59, (Object)bytes);
        return null;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)256, (int)32, (String)"OracleTypeDATE.writeObject()");
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)256, (int)32, (String)"OracleTypeDATE.readObject()");
        }
    }

    static {
        serialVersionUID = -5858803341118747965L;
    }
}

