/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeFLOAT;
import oracle.jdbc.oracore.OracleTypeNUMBER;
import oracle.jdbc.oracore.OracleTypeSINT32;
import oracle.jdbc.oracore.PickleContext;
import oracle.jdbc.oracore.StreamInfo;
import oracle.jdbc.oracore.UnpickleContext;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.Datum;
import oracle.sql.StructDescriptor;

public class OracleTypeCOLLECTION
extends OracleTypeADT
implements Serializable {
    static final long serialVersionUID = -7279638692691669378L;
    public static final int TYPE_PLSQL_INDEX_TABLE = 1;
    public static final int TYPE_NESTED_TABLE = 2;
    public static final int TYPE_VARRAY = 3;
    int m_userCode = 0;
    long m_maxSize = 0L;
    OracleType m_elemType = null;

    public OracleTypeCOLLECTION(String sql_name, OracleConnection conn) throws SQLException {
        super(sql_name, (Connection)conn);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)2, (int)32, (String)("OracleTypeCOLLECTION (sql_name = " + sql_name + ", connection = " + conn + ")"));
        }
    }

    public OracleTypeCOLLECTION(OracleTypeADT parent, int idx, OracleConnection conn) throws SQLException {
        super(parent, idx, (Connection)conn);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)2, (int)32, (String)("OracleTypeCOLLECTION (parent = " + parent + ", idx = " + idx + ", connection = " + conn + ")"));
        }
    }

    public Datum toDatum(Object value, OracleConnection conn) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)32, (int)32, (String)("OracleTypeCOLLECTION.toDatum(value = " + value + ", connection = " + conn + ")"));
        }
        if (value != null) {
            if (value instanceof ARRAY) {
                return (ARRAY)value;
            }
            ArrayDescriptor desc = this.createArrayDescriptor();
            return new ARRAY(desc, this.m_conn, value);
        }
        return null;
    }

    public int getTypeCode() {
        return 2003;
    }

    public boolean isInHierarchyOf(OracleType anOracleType) throws SQLException {
        if (anOracleType == null) {
            return false;
        }
        if (anOracleType == this) {
            return true;
        }
        if (anOracleType.getClass() != this.getClass()) {
            return false;
        }
        return !anOracleType.getTypeDescriptor().getName().equals(this.m_descriptor.getName());
    }

    public boolean isInHierarchyOf(StructDescriptor aStructDescriptor) throws SQLException {
        return false;
    }

    public boolean isObjectType() {
        return false;
    }

    public void parseTDSrec(StreamInfo offset) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)4, (int)32, (String)("OracleTypeCOLLECTION.parseTDSrec(" + offset + ") " + this.m_fullName));
        }
        long elementPos = offset.readLong();
        this.m_maxSize = offset.readLong();
        this.m_userCode = offset.readByte();
        offset.addSimplePatch(elementPos, (OracleType)this);
    }

    public Datum unlinearize(byte[] pickled_bytes, long offset, Datum container, int type, Map objmap) throws SQLException {
        return this.unlinearize(pickled_bytes, offset, container, 1L, -1, type, objmap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Datum unlinearize(byte[] pickled_bytes, long offset, Datum container, long idx, int cnt, int style, Map objmap) throws SQLException {
        OracleConnection mc = this.getConnection();
        Datum ret = null;
        if (mc == null) {
            ret = this._unlinearize(pickled_bytes, offset, container, idx, cnt, style, objmap);
        } else {
            OracleConnection oracleConnection = mc;
            synchronized (oracleConnection) {
                ret = this._unlinearize(pickled_bytes, offset, container, idx, cnt, style, objmap);
            }
        }
        return ret;
    }

    public synchronized Datum _unlinearize(byte[] pickled_bytes, long offset, Datum container, long idx, int cnt, int style, Map objmap) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)16, (int)32, (String)("OracleTypeADT.unlinearize(" + pickled_bytes + ") " + this.m_fullName));
        }
        if (pickled_bytes == null) {
            return null;
        }
        if ((pickled_bytes[0] & 0x80) > 0) {
            PickleContext context = new PickleContext(pickled_bytes, offset);
            return this.unpickle81(context, (ARRAY)container, idx, cnt, 1, style, objmap);
        }
        UnpickleContext newContext = new UnpickleContext(pickled_bytes, (int)offset, null, null, this.big_endian);
        return this.unpickle80(newContext, (ARRAY)container, idx, cnt, 1, style, objmap);
    }

    public synchronized boolean isInlineImage(byte[] pickled_bytes, int offset) throws SQLException {
        if (pickled_bytes == null) {
            return false;
        }
        if ((pickled_bytes[offset] & 0x80) > 0) {
            if (PickleContext.isCollectionImage_pctx(pickled_bytes[offset])) {
                return true;
            }
            if (PickleContext.isDegenerateImage_pctx(pickled_bytes[offset])) {
                return false;
            }
            DBError.throwSqlException((int)1, (Object)"Image is not a collection image");
            return false;
        }
        if (pickled_bytes[offset + 0] == 0 && pickled_bytes[offset + 1] == 0 && pickled_bytes[offset + 2] == 0 && pickled_bytes[offset + 3] == 0) {
            return false;
        }
        return (pickled_bytes[offset + 10] & 1) == 1;
    }

    protected ARRAY unpickle80(UnpickleContext context, ARRAY collDatum, int style, int elemStyle, Map elemMap) throws SQLException {
        return this.unpickle80(context, collDatum, 1L, -1, style, elemStyle, elemMap);
    }

    protected ARRAY unpickle80(UnpickleContext context, ARRAY container, long beginIdx, int count, int style, int elemStyle, Map elemMap) throws SQLException {
        boolean inline;
        long _length;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)16, (int)32, (String)("OracleTypeCOLLECTION.unpickle(context = " + context + ", container = " + container + ", m_fullName = " + this.m_fullName));
        }
        ARRAY coll_obj = container;
        if (style == 3) {
            if (coll_obj == null) {
                ArrayDescriptor desc = this.createArrayDescriptor();
                coll_obj = new ARRAY(desc, (byte[])null, this.m_conn);
            }
            coll_obj.setImage(context.image(), context.absolute_offset(), 0L);
        }
        if ((_length = context.read_long()) == 0L) {
            return null;
        }
        if (style == 9) {
            context.skip_bytes((int)_length);
            return coll_obj;
        }
        if (style == 3) {
            coll_obj.setImageLength(_length + 4L);
            context.skip_bytes((int)_length);
            return coll_obj;
        }
        if (coll_obj == null) {
            ArrayDescriptor desc = this.createArrayDescriptor();
            coll_obj = new ARRAY(desc, (byte[])null, this.m_conn);
        }
        context.skip_bytes(2);
        long prefixLength = context.read_long();
        byte psegFlag = context.read_byte();
        coll_obj.setLocator(context.read_bytes((int)prefixLength - 1));
        boolean bl = inline = (psegFlag & 1) == 1;
        if (inline) {
            long endOffset = context.read_long() + (long)context.offset();
            UnpickleContext newContext = new UnpickleContext(context.image(), context.absolute_offset(), null, null, this.big_endian);
            coll_obj = beginIdx == 1L && count == -1 ? (ARRAY)this.unpickle80rec(newContext, coll_obj, elemStyle, elemMap) : (ARRAY)this.unpickle80rec(newContext, coll_obj, beginIdx, count, elemStyle, elemMap);
            context.skip_to(endOffset);
        }
        return coll_obj;
    }

    protected Object unpickle80rec(UnpickleContext context, int format, int type, Map map) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)16, (int)32, (String)("OracleTypeCOLLECTION.unpicklerec(" + context + ") " + this.m_fullName));
        }
        return this.unpickle80rec(context, null, type, map);
    }

    private Object unpickle80rec(UnpickleContext context, ARRAY container, int elemStyle, Map elemMap) throws SQLException {
        ARRAY coll_obj = container;
        if (coll_obj == null) {
            ArrayDescriptor desc = this.createArrayDescriptor();
            coll_obj = new ARRAY(desc, (byte[])null, this.m_conn);
        }
        int length = (int)context.read_long();
        coll_obj.setLength(length);
        if (elemStyle == 0) {
            return coll_obj;
        }
        byte flag = context.read_byte();
        if (flag != 0 && flag != 2) {
            DBError.throwSqlException((int)23, (Object)("collection flag = " + flag));
        }
        int format = flag == 0 ? 2 : 3;
        this.unpickle80rec_elems(context, coll_obj, 1, length, elemStyle, elemMap, format);
        return coll_obj;
    }

    private Object unpickle80rec(UnpickleContext context, ARRAY container, long beginIdx, int count, int elemStyle, Map elemMap) throws SQLException {
        boolean cacheAll;
        ARRAY coll_obj = container;
        if (coll_obj == null) {
            ArrayDescriptor desc = this.createArrayDescriptor();
            coll_obj = new ARRAY(desc, (byte[])null, this.m_conn);
        }
        long nbelem = context.read_long();
        coll_obj.setLength((int)nbelem);
        byte flag = context.read_byte();
        if (flag != 0 && flag != 2) {
            DBError.throwSqlException((int)23, (Object)("collection flag = " + flag));
        }
        int format = flag == 0 ? 2 : 3;
        int length = (int)this.getAccessLength(nbelem, beginIdx, count);
        boolean bl = cacheAll = ArrayDescriptor.getCacheStyle(coll_obj) == 1;
        if (beginIdx > 1L && length > 0) {
            if (this.m_elemType instanceof OracleTypeNUMBER || this.m_elemType instanceof OracleTypeFLOAT || this.m_elemType instanceof OracleTypeSINT32) {
                switch (format) {
                    case 2: {
                        context.skip_bytes(23 * ((int)beginIdx - 1));
                        break;
                    }
                    case 3: {
                        context.skip_bytes(22 * ((int)beginIdx - 1));
                        break;
                    }
                    default: {
                        DBError.throwSqlException((int)1);
                        break;
                    }
                }
            } else {
                long lastIdx = coll_obj.getLastIndex();
                if (lastIdx < beginIdx) {
                    if (lastIdx > 0L) {
                        context.skip_to(coll_obj.getLastOffset());
                    } else {
                        lastIdx = 1L;
                    }
                    if (cacheAll) {
                        long i2 = lastIdx;
                        while (i2 < beginIdx) {
                            coll_obj.setIndexOffset(i2, context.offset());
                            this.m_elemType.unpickle80rec(context, format, 9, null);
                            ++i2;
                        }
                    } else {
                        long i3 = lastIdx;
                        while (i3 < beginIdx) {
                            this.m_elemType.unpickle80rec(context, format, 9, null);
                            ++i3;
                        }
                    }
                } else if (lastIdx > beginIdx) {
                    long offset = coll_obj.getOffset(beginIdx);
                    if (offset != -1L) {
                        context.skip_to(offset);
                    } else if (cacheAll) {
                        long i4 = 1L;
                        while (i4 < beginIdx) {
                            coll_obj.setIndexOffset(i4, context.offset());
                            this.m_elemType.unpickle80rec(context, format, 9, null);
                            ++i4;
                        }
                    } else {
                        int i5 = 1;
                        while ((long)i5 < beginIdx) {
                            this.m_elemType.unpickle80rec(context, format, 9, null);
                            ++i5;
                        }
                    }
                } else {
                    context.skip_to(coll_obj.getLastOffset());
                }
                coll_obj.setLastIndexOffset(beginIdx, context.offset());
            }
        }
        this.unpickle80rec_elems(context, coll_obj, (int)beginIdx, length, elemStyle, elemMap, format);
        return coll_obj;
    }

    private Object unpickle80rec_elems(UnpickleContext context, ARRAY container, int beginIdx, int length, int elemStyle, Map elemMap, int format) throws SQLException {
        boolean cacheAll = ArrayDescriptor.getCacheStyle(container) == 1;
        switch (elemStyle) {
            case 1: {
                Datum[] darray = new Datum[length];
                if (cacheAll) {
                    int i2 = 0;
                    while (i2 < length) {
                        container.setIndexOffset(beginIdx + i2, context.offset());
                        darray[i2] = (Datum)this.m_elemType.unpickle80rec(context, format, elemStyle, elemMap);
                        ++i2;
                    }
                } else {
                    int i3 = 0;
                    while (i3 < length) {
                        darray[i3] = (Datum)this.m_elemType.unpickle80rec(context, format, elemStyle, elemMap);
                        ++i3;
                    }
                }
                container.setDatumArray(darray);
                break;
            }
            case 2: {
                Object[] oarray = ArrayDescriptor.makeJavaArray(length, this.m_elemType.getTypeCode());
                if (cacheAll) {
                    int i4 = 0;
                    while (i4 < length) {
                        container.setIndexOffset(beginIdx + i4, context.offset());
                        oarray[i4] = this.m_elemType.unpickle80rec(context, format, elemStyle, elemMap);
                        ++i4;
                    }
                } else {
                    int i5 = 0;
                    while (i5 < length) {
                        oarray[i5] = this.m_elemType.unpickle80rec(context, format, elemStyle, elemMap);
                        ++i5;
                    }
                }
                container.setObjArray(oarray);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                if (this.m_elemType instanceof OracleTypeNUMBER || this.m_elemType instanceof OracleTypeFLOAT) {
                    container.setObjArray(OracleTypeNUMBER.unpickle80_nativeArray((UnpickleContext)context, (long)1L, (int)length, (int)elemStyle, (int)format));
                    break;
                }
                DBError.throwSqlException((int)23);
                break;
            }
            default: {
                DBError.throwSqlException((int)1);
            }
        }
        container.setLastIndexOffset(beginIdx + length, context.offset());
        return container;
    }

    protected int pickle81(PickleContext ctx, Datum datum) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)8, (int)32, (String)("OracleTypeCOLLECTION.pickle81(context = " + ctx + ", datum = " + datum + ") " + this.m_fullName));
        }
        ARRAY data = (ARRAY)datum;
        boolean inline = data.hasDataSeg();
        int imglen = 0;
        int lenOffset = ctx.offset() + 2;
        if (inline) {
            Datum[] dataValues = data.getOracleArray();
            if (this.m_userCode == 3 && (long)dataValues.length > this.m_maxSize) {
                DBError.check_error((int)71, null);
            }
            imglen += ctx.writeCollImageHeader_pctx(dataValues.length);
            int ctr = 0;
            while (ctr < dataValues.length) {
                imglen = dataValues[ctr] == null ? (imglen += ctx.writeEltNull_pctx()) : (imglen += this.m_elemType.pickle81(ctx, dataValues[ctr]));
                if (OracleLog.TRACE) {
                    OracleLog.print((Object)this, (int)16, (int)8, (int)64, (String)("OracleTypeCOLLECTION.pickle81(): idx=" + ctr + " is " + dataValues[ctr]));
                }
                ++ctr;
            }
        } else {
            imglen += ctx.writeCollImageHeader_pctx(data.getLocator());
        }
        ctx.patchImageLen_pctx(lenOffset, imglen);
        return imglen;
    }

    ARRAY unpickle81(PickleContext context, ARRAY container, int style, int elemStyle, Map elemMap) throws SQLException {
        return this.unpickle81(context, container, 1L, -1, style, elemStyle, elemMap);
    }

    ARRAY unpickle81(PickleContext context, ARRAY container, long beginIdx, int count, int style, int elemStyle, Map elemMap) throws SQLException {
        ARRAY coll_obj = container;
        if (coll_obj == null) {
            ArrayDescriptor desc = this.createArrayDescriptor();
            coll_obj = new ARRAY(desc, (byte[])null, this.m_conn);
        }
        if (this.unpickle81_imgHeader(context, coll_obj, style, elemStyle)) {
            if (beginIdx == 1L && count == -1) {
                this.unpickle81_imgBody(context, coll_obj, elemStyle, elemMap);
            } else {
                this.unpickle81_imgBody(context, coll_obj, beginIdx, count, elemStyle, elemMap);
            }
        }
        return coll_obj;
    }

    boolean unpickle81_imgHeader(PickleContext context, ARRAY container, int style, int elemStyle) throws SQLException {
        byte flags;
        boolean inline = true;
        if (style == 3) {
            container.setImage(context.image(), context.absolute_offset(), 0L);
        }
        if (!PickleContext.is81format_pctx((byte)(flags = context.readByte_pctx()))) {
            DBError.throwSqlException((int)1, (Object)"Image is not in 8.1 format");
        }
        if (!PickleContext.hasPrefix_pctx((byte)flags)) {
            DBError.throwSqlException((int)1, (Object)"Image has no prefix segment");
        }
        if (PickleContext.isCollectionImage_pctx(flags)) {
            inline = true;
        } else if (PickleContext.isDegenerateImage_pctx(flags)) {
            inline = false;
        } else {
            DBError.throwSqlException((int)1, (Object)"Image is not a collection image");
        }
        context.readByte_pctx();
        if (style == 9) {
            context.skip_bytes(context.readLength_pctx(true) - 2);
            return false;
        }
        if (style == 3) {
            long length = context.readLength_pctx();
            container.setImageLength(length);
            context.skip_to(container.getImageOffset() + length);
            return false;
        }
        context.skipLength_pctx();
        int psegLen = context.readLength_pctx();
        container.setPrefixFlag(context.readByte_pctx());
        if (container.isInline()) {
            context.readDataValue_pctx(psegLen - 1);
        } else {
            container.setLocator(context.readDataValue_pctx(psegLen - 1));
        }
        return container.isInline();
    }

    void unpickle81_imgBody(PickleContext context, ARRAY container, long beginIdx, int count, int elemStyle, Map elemMap) throws SQLException {
        boolean cacheAll;
        context.readByte_pctx();
        int coll_len = context.readLength_pctx();
        container.setLength(coll_len);
        if (elemStyle == 0) {
            return;
        }
        int length = (int)this.getAccessLength(coll_len, beginIdx, count);
        boolean bl = cacheAll = ArrayDescriptor.getCacheStyle(container) == 1;
        if (beginIdx > 1L && length > 0) {
            long lastIdx = container.getLastIndex();
            if (lastIdx < beginIdx) {
                if (lastIdx > 0L) {
                    context.skip_to(container.getLastOffset());
                } else {
                    lastIdx = 1L;
                }
                if (cacheAll) {
                    long i2 = lastIdx;
                    while (i2 < beginIdx) {
                        container.setIndexOffset(i2, context.offset());
                        this.m_elemType.unpickle81rec(context, 9, null);
                        ++i2;
                    }
                } else {
                    long i3 = lastIdx;
                    while (i3 < beginIdx) {
                        this.m_elemType.unpickle81rec(context, 9, null);
                        ++i3;
                    }
                }
            } else if (lastIdx > beginIdx) {
                long offset = container.getOffset(beginIdx);
                if (offset != -1L) {
                    context.skip_to(offset);
                } else if (cacheAll) {
                    int i4 = 1;
                    while ((long)i4 < beginIdx) {
                        container.setIndexOffset(i4, context.offset());
                        this.m_elemType.unpickle81rec(context, 9, null);
                        ++i4;
                    }
                } else {
                    int i5 = 1;
                    while ((long)i5 < beginIdx) {
                        this.m_elemType.unpickle81rec(context, 9, null);
                        ++i5;
                    }
                }
            } else {
                context.skip_to(container.getLastOffset());
            }
            container.setLastIndexOffset(beginIdx, context.offset());
        }
        this.unpickle81_imgBody_elems(context, container, (int)beginIdx, length, elemStyle, elemMap);
    }

    void unpickle81_imgBody(PickleContext context, ARRAY container, int elemStyle, Map elemMap) throws SQLException {
        context.readByte_pctx();
        int length = context.readLength_pctx();
        container.setLength(length);
        if (elemStyle == 0) {
            return;
        }
        this.unpickle81_imgBody_elems(context, container, 1, length, elemStyle, elemMap);
    }

    private void unpickle81_imgBody_elems(PickleContext context, ARRAY container, int beginIdx, int length, int elemStyle, Map elemMap) throws SQLException {
        boolean cacheAll = ArrayDescriptor.getCacheStyle(container) == 1;
        switch (elemStyle) {
            case 1: {
                Datum[] datumArray = new Datum[length];
                if (cacheAll) {
                    int i2 = 0;
                    while (i2 < length) {
                        container.setIndexOffset(beginIdx + i2, context.offset());
                        datumArray[i2] = (Datum)this.m_elemType.unpickle81rec(context, elemStyle, elemMap);
                        ++i2;
                    }
                } else {
                    int i3 = 0;
                    while (i3 < length) {
                        datumArray[i3] = (Datum)this.m_elemType.unpickle81rec(context, elemStyle, elemMap);
                        ++i3;
                    }
                }
                container.setDatumArray(datumArray);
                break;
            }
            case 2: {
                Object[] darray = ArrayDescriptor.makeJavaArray(length, this.m_elemType.getTypeCode());
                if (cacheAll) {
                    int i4 = 0;
                    while (i4 < length) {
                        container.setIndexOffset(beginIdx + i4, context.offset());
                        darray[i4] = this.m_elemType.unpickle81rec(context, elemStyle, elemMap);
                        ++i4;
                    }
                } else {
                    int i5 = 0;
                    while (i5 < length) {
                        darray[i5] = this.m_elemType.unpickle81rec(context, elemStyle, elemMap);
                        ++i5;
                    }
                }
                container.setObjArray(darray);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                if (this.m_elemType instanceof OracleTypeNUMBER || this.m_elemType instanceof OracleTypeFLOAT) {
                    container.setObjArray(OracleTypeNUMBER.unpickle81_nativeArray((PickleContext)context, (long)1L, (int)length, (int)elemStyle));
                    break;
                }
                DBError.throwSqlException((int)23, (Object)"This feature is limited to numeric collection");
                break;
            }
            default: {
                DBError.throwSqlException((int)68, (Object)("Invalid conversion type " + this.m_elemType));
            }
        }
        container.setLastIndexOffset(beginIdx + length, context.offset());
    }

    private synchronized void initCollElemTypeName() throws SQLException {
        Statement stmt = this.m_conn.createStatement();
        ResultSet rset = stmt.executeQuery("SELECT ELEM_TYPE_NAME, ELEM_TYPE_OWNER FROM ALL_COLL_TYPES WHERE TYPE_NAME='" + this.m_typeName + "' AND OWNER='" + this.m_schemaName + "'");
        if (rset.next()) {
            if (this.m_attrTypeNames == null) {
                this.m_attrTypeNames = new String[1];
            }
            this.m_attrTypeNames[0] = rset.getString(2) + "." + rset.getString(1);
        } else {
            DBError.throwSqlException((int)1);
        }
        rset.close();
        stmt.close();
    }

    public String getAttributeName(int idx) throws SQLException {
        DBError.throwSqlException((int)1);
        return null;
    }

    public String getAttributeName(int idx, boolean force) throws SQLException {
        return this.getAttributeName(idx);
    }

    public String getAttributeType(int idx) throws SQLException {
        if (idx != 1) {
            DBError.throwSqlException((int)68);
        }
        if (!this.m_hasName) {
            this.getFullName();
        }
        if (this.m_attrTypeNames == null) {
            this.initCollElemTypeName();
        }
        return this.m_attrTypeNames[0];
    }

    public String getAttributeType(int idx, boolean force) throws SQLException {
        if (force) {
            return this.getAttributeType(idx);
        }
        if (idx != 1) {
            DBError.throwSqlException((int)68);
        }
        if (this.m_hasName && this.m_attrTypeNames != null) {
            return this.m_attrTypeNames[0];
        }
        return null;
    }

    public int getNumAttrs() throws SQLException {
        return 0;
    }

    public OracleType getAttrTypeAt(int idx) throws SQLException {
        return null;
    }

    ArrayDescriptor createArrayDescriptor() throws SQLException {
        if (this.m_descriptor == null) {
            this.m_descriptor = !this.m_hasName && this.getFullName(false) == null ? new ArrayDescriptor(this, (Connection)this.m_conn) : ArrayDescriptor.createDescriptor(this.m_fullName, (Connection)this.m_conn);
        }
        return (ArrayDescriptor)this.m_descriptor;
    }

    public OracleType getElementType() throws SQLException {
        return this.m_elemType;
    }

    public int getUserCode() throws SQLException {
        return this.m_userCode;
    }

    public long getMaxLength() throws SQLException {
        return this.m_maxSize;
    }

    private long getAccessLength(long coll_len, long beginIdx, int count) throws SQLException {
        if (beginIdx > coll_len) {
            return 0L;
        }
        if (count < 0) {
            return coll_len - beginIdx + 1L;
        }
        return Math.min(coll_len - beginIdx + 1L, (long)count);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)256, (int)32, (String)"OracleTypeCOLLECTION.writeObject()");
        }
        out.writeInt(this.m_userCode);
        out.writeLong(this.m_maxSize);
        out.writeObject(this.m_elemType);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)256, (int)32, (String)"OracleTypeCOLLECTION.readObject()");
        }
        this.m_userCode = in.readInt();
        this.m_maxSize = in.readLong();
        this.m_elemType = (OracleType)in.readObject();
    }

    public void setConnection(OracleConnection conn) throws SQLException {
        this.m_conn = conn;
        this.m_elemType.setConnection(conn);
    }

    static {
        serialVersionUID = -7279638692691669378L;
        TYPE_PLSQL_INDEX_TABLE = 1;
        TYPE_NESTED_TABLE = 2;
        TYPE_VARRAY = 3;
    }
}

