/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeBLOB;
import oracle.jdbc.oracore.PickleContext;
import oracle.jdbc.oracore.UnpickleContext;
import oracle.sql.CLOB;
import oracle.sql.Datum;

public class OracleTypeCLOB
extends OracleType
implements Serializable {
    static final long serialVersionUID = 1122821330765834411L;
    static int fixed_data_size;
    transient OracleConnection m_conn;
    int form;

    protected OracleTypeCLOB() {
    }

    public OracleTypeCLOB(OracleConnection conn) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)2, (int)32, (String)("OracleTypeCLOB (" + conn + ")"));
        }
        this.m_conn = conn;
    }

    public Datum toDatum(Object value, OracleConnection conn) throws SQLException {
        CLOB datum = null;
        if (value != null) {
            if (value instanceof CLOB) {
                datum = (CLOB)value;
            } else {
                DBError.check_error((int)59, (Object)value);
            }
        }
        return datum;
    }

    public int getTypeCode() {
        return 2005;
    }

    protected int pickle81(PickleContext ctx, Datum data) throws SQLException {
        byte[] b2 = data.shareBytes();
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)8, (int)16, (String)("OracleTypeCLOB.pickle81(context = " + ctx + ", datum = " + data + ", len: " + (((b2[0] << 8 | b2[1]) & 0xFFFF) + 2) + ")"));
        }
        int llen = ((b2[0] << 8 | b2[1]) & 0xFFFF) + 2;
        int len = ctx.writeLength_pctx(llen);
        len += ctx.write_data_pctx(b2, 0, llen);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)8, (int)16, (String)("OracleTypeCLOB.pickle81:return " + len));
        }
        return len;
    }

    protected Object unpickle80rec(UnpickleContext context, int format, int type, Map map) throws SQLException {
        return OracleTypeBLOB.lobUnpickle80rec((OracleType)this, (int)this.null_offset, (int)this.lds_offset, (UnpickleContext)context, (int)format, (int)type, (int)fixed_data_size);
    }

    protected Object toObject(byte[] bytes, int type, Map map) throws SQLException {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        if (type == 1 || type == 2) {
            return new CLOB(this.m_conn, bytes);
        }
        if (type == 3) {
            return bytes;
        }
        DBError.check_error((int)59, (Object)bytes);
        return null;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)256, (int)32, (String)"OracleTypeCLOB.writeObject()");
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)256, (int)32, (String)"OracleTypeCLOB.readObject()");
        }
    }

    public void setConnection(OracleConnection conn) throws SQLException {
        this.m_conn = conn;
    }

    public boolean isNCHAR() throws SQLException {
        return this.form == 2;
    }

    static {
        serialVersionUID = 1122821330765834411L;
        fixed_data_size = 86;
    }
}

