/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.PickleContext;
import oracle.jdbc.oracore.StreamInfo;
import oracle.jdbc.oracore.UnpickleContext;
import oracle.sql.CHAR;
import oracle.sql.CharacterSet;
import oracle.sql.Datum;

public class OracleTypeCHAR
extends OracleType
implements Serializable {
    static final long serialVersionUID = -6899444518695804629L;
    int form;
    int charset;
    int length;
    int character_semantic;
    private transient OracleConnection conn;
    private short pickle_cs_id;
    private transient CharacterSet pickle_cs;
    private short pickle_ncs_id;
    static final int SQLCS_IMPLICIT = 1;
    static final int SQLCS_NCHAR = 2;
    static final int SQLCS_EXPLICIT = 3;
    static final int SQLCS_FLEXIBLE = 4;
    static final int SQLCS_LIT_NULL = 5;

    protected OracleTypeCHAR() {
    }

    public OracleTypeCHAR(OracleConnection connection) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)2, (int)32, (String)("OracleTypeCHAR (" + connection + ")"));
        }
        this.form = 0;
        this.charset = 0;
        this.length = 0;
        this.conn = connection;
        this.pickle_cs_id = 0;
        this.pickle_ncs_id = 0;
        this.pickle_cs = null;
        try {
            this.pickle_cs_id = this.conn.getStructAttrCsId();
        }
        catch (SQLException ex) {
            if (OracleLog.TRACE) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                ex.printStackTrace(pw);
                OracleLog.print((Object)this, (int)16, (int)32, (int)64, (String)("OracleTypeCHAR( " + ex.toString() + sw.toString()));
            }
            this.pickle_cs_id = (short)-1;
        }
        this.pickle_cs = CharacterSet.make(this.pickle_cs_id);
    }

    protected OracleTypeCHAR(OracleConnection connection, int typecode) {
        super(typecode);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)2, (int)32, (String)("OracleTypeCHAR (connection = " + connection + ", typecode = " + typecode + ")"));
        }
        this.form = 0;
        this.charset = 0;
        this.length = 0;
        this.conn = connection;
        this.pickle_cs_id = 0;
        this.pickle_ncs_id = 0;
        this.pickle_cs = null;
        try {
            this.pickle_cs_id = this.conn.getStructAttrCsId();
        }
        catch (SQLException ex) {
            if (OracleLog.TRACE) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                ex.printStackTrace(pw);
                OracleLog.print((Object)this, (int)16, (int)32, (int)64, (String)("OracleTypeCHAR( " + ex.toString() + sw.toString()));
            }
            this.pickle_cs_id = (short)-1;
        }
        this.pickle_cs = CharacterSet.make(this.pickle_cs_id);
    }

    public Datum toDatum(Object value, OracleConnection conn) throws SQLException {
        CHAR datum;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)32, (int)64, (String)("OracleTypeCHAR.toDatum( object = " + value + ", connection = " + conn + ")"));
        }
        if (value == null) {
            return null;
        }
        CHAR cHAR = datum = value instanceof CHAR ? (CHAR)value : new CHAR(value, this.pickle_cs);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)32, (int)64, (String)("OracleTypeCHAR.toDatum:return " + datum));
        }
        return datum;
    }

    public Datum[] toDatumArray(Object obj, OracleConnection conn, long beginIdx, int count) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)32, (int)64, (String)("OracleTypeCHAR.toDatumArray( object = " + obj + ", connection = " + conn + ", begin index = " + beginIdx + ", count = " + count + ")"));
        }
        Datum[] datumArray = null;
        if (obj != null) {
            if (obj instanceof Object[] && !(obj instanceof char[][])) {
                return super.toDatumArray(obj, conn, beginIdx, count);
            }
            datumArray = this.cArrayToDatumArray(obj, conn, beginIdx, count);
        }
        return datumArray;
    }

    public void parseTDSrec(StreamInfo offset) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)128, (int)64, (String)("OracleTypeCHAR.parseTDSrec( streamInfo  = " + offset + ")"));
        }
        super.parseTDSrec(offset);
        try {
            this.length = offset.readShort();
            this.form = offset.readByte();
            this.character_semantic = this.form & 0x80;
            this.form &= 0x7F;
            this.charset = offset.readShort();
        }
        catch (SQLException ex) {
            DBError.check_error((int)47, (Object)"parseTDS");
        }
        if (this.form != 2 || this.pickle_ncs_id != 0) {
            return;
        }
        try {
            this.pickle_ncs_id = this.conn.getStructAttrNCsId();
        }
        catch (SQLException ex) {
            if (OracleLog.TRACE) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                ex.printStackTrace(pw);
                OracleLog.print((Object)this, (int)16, (int)32, (int)64, (String)("OracleTypeCHAR( " + ex.toString() + sw.toString()));
            }
            this.pickle_ncs_id = (short)2000;
        }
        this.pickle_cs_id = this.pickle_ncs_id;
        this.pickle_cs = CharacterSet.make(this.pickle_cs_id);
    }

    protected Object unpickle80rec(UnpickleContext context, int format, int type, Map map) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)16, (int)64, (String)("OracleTypeCHAR.unpickle80rec( context = " + context + ", format = " + format + ", type = " + type + ", map = " + map + ")"));
        }
        switch (format) {
            case 1: {
                if (context.is_null(this.null_offset)) {
                    return null;
                }
                context.skip_to(context.m_ldsOffsets[this.lds_offset]);
                if (type == 9) {
                    context.skip_bytes(6);
                    return null;
                }
                long offset = context.read_long();
                if (offset == 0L) {
                    context.skip_bytes(2);
                    context.mark();
                } else {
                    context.markAndSkip(offset);
                }
                byte[] val = context.read_lengthBytes();
                context.reset();
                return this.toObject(val, type, map);
            }
            case 2: {
                if ((context.read_byte() & 1) == 1) {
                    context.skip_bytes(4);
                    return null;
                }
            }
            case 3: {
                if (type == 9) {
                    context.skip_lengthBytes();
                    return null;
                }
                return this.toObject(context.read_lengthBytes(), type, map);
            }
        }
        DBError.throwSqlException((int)1, (Object)("format=" + format));
        return null;
    }

    protected int pickle81(PickleContext context, Datum data) throws SQLException {
        CHAR dbchar = this.getDbCHAR(data);
        if (this.character_semantic != 0 && this.form != 2) {
            if (dbchar.getString().length() > this.length) {
                DBError.check_error((int)72, (Object)("\"" + dbchar.getString() + "\""));
            }
        } else if (dbchar.getLength() > (long)this.length) {
            DBError.check_error((int)72, (Object)("\"" + dbchar.getString() + "\""));
        }
        return super.pickle81(context, dbchar);
    }

    protected Object toObject(byte[] bytes, int type, Map map) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)32, (int)64, (String)("OracleTypeCHAR.toObject( bytes = " + bytes + ", type = " + type + ", map = " + map + ")"));
        }
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        CHAR result = null;
        switch (this.form) {
            case 1: 
            case 2: {
                result = new CHAR(bytes, this.pickle_cs);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                result = new CHAR(bytes, null);
            }
        }
        if (type == 1) {
            return result;
        }
        if (type == 2) {
            return result.stringValue();
        }
        if (type == 3) {
            return bytes;
        }
        DBError.check_error((int)59, (Object)bytes);
        return null;
    }

    private CHAR getDbCHAR(Datum data) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)32, (int)64, (String)("OracleTypeCHAR.getDbCHAR( datum = " + data + ") and form = " + this.form + " character semantic = " + this.character_semantic + " length = " + this.length));
        }
        CHAR in_char_obj = (CHAR)data;
        CHAR db_char_obj = null;
        if (in_char_obj.getCharacterSet().getOracleId() == this.pickle_cs_id) {
            db_char_obj = in_char_obj;
        } else {
            try {
                db_char_obj = new CHAR(in_char_obj.toString(), this.pickle_cs);
            }
            catch (SQLException ex) {
                if (OracleLog.TRACE) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    ex.printStackTrace(pw);
                    OracleLog.print((Object)this, (int)16, (int)32, (int)64, (String)("OracleTypeCHAR.getDbCHAR( " + ex.toString() + sw.toString()));
                }
                db_char_obj = in_char_obj;
            }
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)32, (int)64, (String)("OracleTypeCHAR.getDbCHAR:return " + db_char_obj));
        }
        return db_char_obj;
    }

    private Datum[] cArrayToDatumArray(Object obj, OracleConnection conn, long beginIdx, int count) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)32, (int)64, (String)("OracleTypeCHAR.cArrayToDatumArray( object = " + obj + ", connection = " + conn + ", begin index = " + beginIdx + ", count = " + count + ")"));
        }
        Datum[] datumArray = null;
        if (obj != null) {
            if (obj instanceof char[][]) {
                char[][] parray = (char[][])obj;
                int len = (int)(count == -1 ? (long)parray.length : Math.min((long)parray.length - beginIdx + 1L, (long)count));
                datumArray = new Datum[len];
                int i2 = 0;
                while (i2 < len) {
                    datumArray[i2] = new CHAR(new String(parray[(int)beginIdx + i2 - 1]), this.pickle_cs);
                    ++i2;
                }
            } else if (obj instanceof boolean[]) {
                boolean[] parray = (boolean[])obj;
                int len = (int)(count == -1 ? (long)parray.length : Math.min((long)parray.length - beginIdx + 1L, (long)count));
                datumArray = new Datum[len];
                int i3 = 0;
                while (i3 < len) {
                    datumArray[i3] = new CHAR(new Boolean(parray[(int)beginIdx + i3 - 1]), this.pickle_cs);
                    ++i3;
                }
            } else if (obj instanceof short[]) {
                short[] parray = (short[])obj;
                int len = (int)(count == -1 ? (long)parray.length : Math.min((long)parray.length - beginIdx + 1L, (long)count));
                datumArray = new Datum[len];
                int i4 = 0;
                while (i4 < len) {
                    datumArray[i4] = new CHAR(new Integer(parray[(int)beginIdx + i4 - 1]), this.pickle_cs);
                    ++i4;
                }
            } else if (obj instanceof int[]) {
                int[] parray = (int[])obj;
                int len = (int)(count == -1 ? (long)parray.length : Math.min((long)parray.length - beginIdx + 1L, (long)count));
                datumArray = new Datum[len];
                int i5 = 0;
                while (i5 < len) {
                    datumArray[i5] = new CHAR(new Integer(parray[(int)beginIdx + i5 - 1]), this.pickle_cs);
                    ++i5;
                }
            } else if (obj instanceof long[]) {
                long[] parray = (long[])obj;
                int len = (int)(count == -1 ? (long)parray.length : Math.min((long)parray.length - beginIdx + 1L, (long)count));
                datumArray = new Datum[len];
                int i6 = 0;
                while (i6 < len) {
                    datumArray[i6] = new CHAR(new Long(parray[(int)beginIdx + i6 - 1]), this.pickle_cs);
                    ++i6;
                }
            } else if (obj instanceof float[]) {
                float[] parray = (float[])obj;
                int len = (int)(count == -1 ? (long)parray.length : Math.min((long)parray.length - beginIdx + 1L, (long)count));
                datumArray = new Datum[len];
                int i7 = 0;
                while (i7 < len) {
                    datumArray[i7] = new CHAR(new Float(parray[(int)beginIdx + i7 - 1]), this.pickle_cs);
                    ++i7;
                }
            } else if (obj instanceof double[]) {
                double[] parray = (double[])obj;
                int len = (int)(count == -1 ? (long)parray.length : Math.min((long)parray.length - beginIdx + 1L, (long)count));
                datumArray = new Datum[len];
                int i8 = 0;
                while (i8 < len) {
                    datumArray[i8] = new CHAR(new Double(parray[(int)beginIdx + i8 - 1]), this.pickle_cs);
                    ++i8;
                }
            } else {
                DBError.check_error((int)59, (Object)obj);
            }
        }
        return datumArray;
    }

    public int getLength() {
        return this.length;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)256, (int)32, (String)"OracleTypeCHAR.writeObject()");
        }
        out.writeInt(this.form);
        out.writeInt(this.charset);
        out.writeInt(this.length);
        out.writeInt(this.character_semantic);
        out.writeShort(this.pickle_cs_id);
        out.writeShort(this.pickle_ncs_id);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)256, (int)32, (String)"OracleTypeCHAR.readObject()");
        }
        this.form = in.readInt();
        this.charset = in.readInt();
        this.length = in.readInt();
        this.character_semantic = in.readInt();
        this.pickle_cs_id = in.readShort();
        this.pickle_ncs_id = in.readShort();
        this.pickle_cs = this.pickle_ncs_id != 0 ? CharacterSet.make(this.pickle_ncs_id) : CharacterSet.make(this.pickle_cs_id);
    }

    public void setConnection(OracleConnection conn) throws SQLException {
        this.conn = conn;
    }

    public boolean isNCHAR() throws SQLException {
        return this.form == 2;
    }

    static {
        serialVersionUID = -6899444518695804629L;
        SQLCS_IMPLICIT = 1;
        SQLCS_NCHAR = 2;
        SQLCS_EXPLICIT = 3;
        SQLCS_FLEXIBLE = 4;
        SQLCS_LIT_NULL = 5;
    }
}

