/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.PickleContext;
import oracle.jdbc.oracore.UnpickleContext;
import oracle.sql.BLOB;
import oracle.sql.Datum;

public class OracleTypeBLOB
extends OracleType
implements Serializable {
    static final long serialVersionUID = -2311211431562030662L;
    static int fixed_data_size;
    transient OracleConnection m_conn;

    protected OracleTypeBLOB() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)2, (int)32, (String)"OracleTypeBLOB ()");
        }
    }

    public OracleTypeBLOB(OracleConnection conn) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)2, (int)32, (String)("OracleTypeBLOB (" + conn + ")"));
        }
        this.m_conn = conn;
    }

    public Datum toDatum(Object value, OracleConnection conn) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)32, (int)32, (String)("OracleTypeBLOB.toDatum(value = " + value + ", connection = " + conn + ")"));
        }
        BLOB datum = null;
        if (value != null) {
            if (value instanceof BLOB) {
                datum = (BLOB)value;
            } else {
                DBError.check_error((int)59, (Object)value);
            }
        }
        return datum;
    }

    public int getTypeCode() {
        return 2004;
    }

    protected int pickle81(PickleContext ctx, Datum data) throws SQLException {
        byte[] b2 = data.shareBytes();
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)8, (int)16, (String)("OracleTypeBLOB.pickle81(context = " + ctx + ", datum = " + data + ", len: " + (((b2[0] << 8 | b2[1]) & 0xFFFF) + 2) + ")"));
        }
        int llen = ((b2[0] << 8 | b2[1]) & 0xFFFF) + 2;
        int len = ctx.writeLength_pctx(llen);
        len += ctx.write_data_pctx(b2, 0, llen);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)8, (int)16, (String)("OracleTypeBLOB.pickle81:return " + len));
        }
        return len;
    }

    protected Object unpickle80rec(UnpickleContext context, int format, int type, Map map) throws SQLException {
        return OracleTypeBLOB.lobUnpickle80rec((OracleType)this, (int)this.null_offset, (int)this.lds_offset, (UnpickleContext)context, (int)format, (int)type, (int)fixed_data_size);
    }

    protected static Object lobUnpickle80rec(OracleType t, int null_offset, int lds_offset, UnpickleContext context, int format, int style, int data_size) throws SQLException {
        switch (format) {
            case 1: {
                if (context.is_null(null_offset)) {
                    return null;
                }
                context.skip_to(context.m_ldsOffsets[lds_offset]);
                if (style == 9) {
                    context.skip_bytes(4);
                    return null;
                }
                context.markAndSkip();
                byte[] final_locator = context.read_ptrBytes();
                context.reset();
                return t.toObject(final_locator, style, null);
            }
            case 2: {
                if ((context.read_byte() & 1) == 1) {
                    context.skip_ptrBytes();
                    return null;
                }
            }
            case 3: {
                long endOffset = context.offset() + data_size;
                if (style == 9) {
                    context.skip_to(endOffset);
                    return null;
                }
                byte[] final_locator2 = context.read_ptrBytes();
                if ((long)context.offset() < endOffset) {
                    context.skip_to(endOffset);
                }
                return t.toObject(final_locator2, style, null);
            }
        }
        DBError.throwSqlException((int)1, (Object)("format=" + format));
        return null;
    }

    protected Object toObject(byte[] bytes, int style, Map map) throws SQLException {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        switch (style) {
            case 1: 
            case 2: {
                return new BLOB(this.m_conn, bytes);
            }
            case 3: {
                return bytes;
            }
        }
        DBError.throwSqlException((int)59, (Object)bytes);
        return null;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)256, (int)32, (String)"OracleTypeBLOB.readObject()");
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)256, (int)32, (String)"OracleTypeBLOB.readObject()");
        }
    }

    public void setConnection(OracleConnection conn) throws SQLException {
        this.m_conn = conn;
    }

    static {
        serialVersionUID = -2311211431562030662L;
        fixed_data_size = 86;
    }
}

