/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeBLOB;
import oracle.jdbc.oracore.PickleContext;
import oracle.jdbc.oracore.UnpickleContext;
import oracle.sql.BFILE;
import oracle.sql.Datum;

public class OracleTypeBFILE
extends OracleType
implements Serializable {
    static final long serialVersionUID = -707073491109554687L;
    static int fixed_data_size;
    transient OracleConnection m_conn;

    public OracleTypeBFILE() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)2, (int)32, (String)"OracleTypeBFILE ()");
        }
    }

    public OracleTypeBFILE(OracleConnection conn) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)2, (int)32, (String)("OracleTypeBFILE (" + conn + ")"));
        }
        this.m_conn = conn;
    }

    public Datum toDatum(Object value, OracleConnection conn) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)32, (int)32, (String)("OracleTypeBFILE.toDatum(value = " + value + ", connection = " + conn + ")"));
        }
        BFILE datum = null;
        if (value != null) {
            if (value instanceof BFILE) {
                datum = (BFILE)value;
            } else {
                DBError.check_error((int)59, (Object)value);
            }
        }
        return datum;
    }

    public int getTypeCode() {
        return -13;
    }

    protected int pickle81(PickleContext ctx, Datum data) throws SQLException {
        byte[] b2 = data.shareBytes();
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)8, (int)16, (String)("OracleTypeBFILE.pickle81(context = " + ctx + ", datum = " + data + ", len: " + (((b2[0] << 8 | b2[1]) & 0xFFFF) + 2) + ")"));
        }
        int llen = ((b2[0] << 8 | b2[1]) & 0xFFFF) + 2;
        int len = ctx.writeLength_pctx(llen);
        len += ctx.write_data_pctx(b2, 0, llen);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)8, (int)16, (String)("OracleTypeBFILE.pickle81:return " + len));
        }
        return len;
    }

    protected Object unpickle80rec(UnpickleContext context, int format, int type, Map map) throws SQLException {
        return OracleTypeBLOB.lobUnpickle80rec((OracleType)this, (int)this.null_offset, (int)this.lds_offset, (UnpickleContext)context, (int)format, (int)type, (int)fixed_data_size);
    }

    protected Object toObject(byte[] bytes, int style, Map map) throws SQLException {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        if (style == 1 || style == 2) {
            return new BFILE(this.m_conn, bytes);
        }
        if (style == 3) {
            return bytes;
        }
        DBError.check_error((int)59, (Object)bytes);
        return null;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)256, (int)32, (String)"OracleTypeBFILE.writeObject()");
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)256, (int)32, (String)"OracleTypeBFILE.readObject()");
        }
    }

    public void setConnection(OracleConnection conn) throws SQLException {
        this.m_conn = conn;
    }

    static {
        serialVersionUID = -707073491109554687L;
        fixed_data_size = 530;
    }
}

