/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.Vector;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleCallableStatement;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.ObjectData;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleNamedType;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeBFILE;
import oracle.jdbc.oracore.OracleTypeBLOB;
import oracle.jdbc.oracore.OracleTypeCHAR;
import oracle.jdbc.oracore.OracleTypeCLOB;
import oracle.jdbc.oracore.OracleTypeCOLLECTION;
import oracle.jdbc.oracore.OracleTypeDATE;
import oracle.jdbc.oracore.OracleTypeFLOAT;
import oracle.jdbc.oracore.OracleTypeINTERVAL;
import oracle.jdbc.oracore.OracleTypeNUMBER;
import oracle.jdbc.oracore.OracleTypeOPAQUE;
import oracle.jdbc.oracore.OracleTypeRAW;
import oracle.jdbc.oracore.OracleTypeREF;
import oracle.jdbc.oracore.OracleTypeSINT32;
import oracle.jdbc.oracore.OracleTypeUPT;
import oracle.jdbc.oracore.PickleContext;
import oracle.jdbc.oracore.StreamInfo;
import oracle.jdbc.oracore.TDSPatch;
import oracle.jdbc.oracore.UnpickleContext;
import oracle.jdbc.oracore.Util;
import oracle.sql.Datum;
import oracle.sql.JAVA_STRUCT;
import oracle.sql.NUMBER;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.sql.TypeDescriptor;

public class OracleTypeADT
extends OracleNamedType
implements Serializable {
    static final long serialVersionUID = 3031304012507165702L;
    static final int S_TOP = 1;
    static final int S_EMBEDDED = 2;
    static final int S_UPT_ADT = 4;
    static final int S_JAVA_OBJECT = 16;
    static final int S_FINAL_TYPE = 32;
    static final int S_SUB_TYPE = 64;
    static final int S_ATTR_TDS = 128;
    static final int S_HAS_METADATA = 256;
    static final int S_TDS_PARSED = 512;
    private int m_status = 1;
    int m_tds_version = -1;
    static final int KOPT_V80 = 1;
    static final int KOPT_V81 = 2;
    static final int KOPT_VNFT = 3;
    static final int KOPT_VERSION = 3;
    boolean endOfAdt = false;
    int m_type_version = -1;
    byte[] m_LDS = null;
    long[] m_ldsOffsetArray = null;
    long m_fixedDataSize = -1L;
    int m_alignmentReq = -1;
    transient byte[] m_TDS = null;
    OracleType[] m_attrTypes = null;
    String[] m_attrNames;
    String[] m_attrTypeNames;
    public long tdo_c_state = 0L;
    byte[] m_toid = null;
    byte[] fdo;
    int char_set_if;
    int char_set_form;
    boolean big_endian;
    int flattened_attr_num;
    transient StreamInfo m_tdsContext;
    transient int m_opcode;
    transient int idx = 1;
    static final int CURRENT_USER_OBJECT = 0;
    static final int CURRENT_USER_SYNONYM = 1;
    static final int CURRENT_USER_PUBLIC_SYNONYM = 2;
    static final int OTHER_USER_OBJECT = 3;
    static final int OTHER_USER_SYNONYM = 4;
    static final int PUBLIC_SYNONYM = 5;
    static final int BREAK = 6;
    static final String[] sqlString;
    static final int TDS_SIZE = 4;
    static final int TDS_NUMBER = 1;
    static final int KOPM_OTS_SQL_CHAR = 1;
    static final int KOPM_OTS_DATE = 2;
    static final int KOPM_OTS_DECIMAL = 3;
    static final int KOPM_OTS_DOUBLE = 4;
    static final int KOPM_OTS_FLOAT = 5;
    static final int KOPM_OTS_NUMBER = 6;
    static final int KOPM_OTS_SQL_VARCHAR2 = 7;
    static final int KOPM_OTS_SINT32 = 8;
    static final int KOPM_OTS_REF = 9;
    static final int KOPM_OTS_VARRAY = 10;
    static final int KOPM_OTS_UINT8 = 11;
    static final int KOPM_OTS_SINT8 = 12;
    static final int KOPM_OTS_UINT16 = 13;
    static final int KOPM_OTS_UINT32 = 14;
    static final int KOPM_OTS_LOB = 15;
    static final int KOPM_OTS_MLSLABEL = 16;
    static final int KOPM_OTS_CANONICAL = 17;
    static final int KOPM_OTS_OCTET = 18;
    static final int KOPM_OTS_RAW = 19;
    static final int KOPM_OTS_ROWID = 20;
    static final int KOPM_OTS_SINGLE = 21;
    static final int KOPM_OTS_LVARCHAR2 = 22;
    static final int KOPM_OTS_FARRAY = 23;
    static final int KOPM_OTS_INTERVAL = 24;
    static final int KOPM_OTS_PTR = 25;
    static final int KOPM_OTS_SINT16 = 26;
    static final int KOPM_OTS_UPT = 27;
    static final int KOPM_OTS_COLLECTION = 28;
    static final int KOPM_OTS_CLOB = 29;
    static final int KOPM_OTS_BLOB = 30;
    static final int KOPM_OTS_BFILE = 31;
    static final int KOPM_OTS_BINARY_INTEGE = 32;
    static final int KOPM_OTS_IMPTZSTAMP = 33;
    static final int KOTTCOPQ = 58;
    static final int KOPT_OP_STARTEMBADT = 39;
    static final int KOPT_OP_ENDEMBADT = 40;
    static final int KOPT_OP_STARTADT = 41;
    static final int KOPT_OP_ENDADT = 42;
    static final int KOPT_OP_SUBTYPE_MARKER = 43;
    static final int KOPT_OP_EMBADT_INFO = 44;
    static final int KOPT_OPCODE_START = 38;
    static final int KOPT_OP_VERSION = 38;
    static final int REGULAR_PATCH = 0;
    static final int SIMPLE_PATCH = 1;

    protected OracleTypeADT() {
    }

    public OracleTypeADT(byte[] toid, int vsn, int csi, short csfrm, String fullName) throws SQLException {
        this(fullName, (Connection)null);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)2, (int)32, (String)("OracleTypeADT (toid = " + toid + ", vsn = " + vsn + ", csi = " + csi + ", csfrm = " + csfrm + ", fullName =" + fullName + ")"));
        }
        this.m_toid = toid;
        this.m_type_version = vsn;
        this.char_set_if = csi;
        this.char_set_form = csfrm;
    }

    public OracleTypeADT(String sql_name) throws SQLException {
        super(sql_name, null);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)2, (int)32, (String)("OracleTypeADT(sqlName = " + sql_name + ")"));
        }
    }

    public OracleTypeADT(String sql_name, Connection conn) throws SQLException {
        super(sql_name, (OracleConnection)conn);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)2, (int)32, (String)("OracleTypeADT (sql_name = " + sql_name + ", connection = " + conn + ")"));
        }
    }

    public OracleTypeADT(String sql_name, Connection conn, byte[] fdo) throws SQLException {
        this(sql_name, conn);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)2, (int)32, (String)("OracleTypeADT (sql_name = " + sql_name + ", connection = " + conn + ", fdo = " + fdo + ")"));
        }
        this.fdo = fdo;
        this.initEndianess(fdo);
    }

    public OracleTypeADT(OracleTypeADT parent, int idx, Connection conn) throws SQLException {
        super(parent, idx, (OracleConnection)conn);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)2, (int)32, (String)("OracleTypeADT (parent = " + parent + ", idx = " + idx + ", connection = " + conn + ")"));
        }
    }

    public OracleTypeADT(OracleTypeADT parent, int idx, Connection conn, byte[] fdo) throws SQLException {
        this(parent, idx, conn);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)2, (int)32, (String)("OracleTypeADT (parent = " + parent + ", idx = " + idx + ", connection = " + conn + ", fdo = " + fdo + ")"));
        }
        this.fdo = fdo;
        this.initEndianess(fdo);
    }

    public Datum toDatum(Object value, OracleConnection conn) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)32, (int)32, (String)("OracleTypeADT.toDatum(value = " + value + ", connection = " + conn + ")"));
        }
        if (value != null) {
            if (value instanceof STRUCT) {
                return (STRUCT)value;
            }
            if (value instanceof SQLData || value instanceof ObjectData) {
                return STRUCT.toSTRUCT(value, conn);
            }
            if (value instanceof Object[]) {
                StructDescriptor desc = this.createStructDescriptor();
                STRUCT result = this.createObjSTRUCT(desc, (Object[])value);
                if (OracleLog.TRACE) {
                    OracleLog.print((Object)this, (int)16, (int)32, (int)32, (String)"OracleTypeADT.toDatum:return + result");
                }
                return result;
            }
            DBError.check_error((int)59, (Object)value);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)32, (int)32, (String)"OracleTypeADT.toDatum:return null");
        }
        return null;
    }

    public Datum[] toDatumArray(Object obj, OracleConnection conn, long beginIdx, int count) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)32, (int)32, (String)("OracleTypeADT.toDatumArray(object = " + obj + ", connection = " + conn + ")"));
        }
        Datum[] datumArray = null;
        if (obj != null) {
            if (obj instanceof Object[]) {
                Object[] objArray = (Object[])obj;
                int length = (int)(count == -1 ? (long)objArray.length : Math.min((long)objArray.length - beginIdx + 1L, (long)count));
                datumArray = new Datum[length];
                int i2 = 0;
                while (i2 < length) {
                    datumArray[i2] = this.toDatum(objArray[(int)beginIdx + i2 - 1], conn);
                    ++i2;
                }
            } else {
                DBError.check_error((int)59, (Object)obj);
            }
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)32, (int)32, (String)("OracleTypeADT.toDatumArray:return " + datumArray));
        }
        return datumArray;
    }

    public int getTypeCode() throws SQLException {
        if ((this.getStatus() & 0x10) != 0) {
            return 2008;
        }
        return 2002;
    }

    public OracleType[] getAttrTypes() throws SQLException {
        if (this.m_attrTypes == null) {
            this.init(this.m_conn);
        }
        return this.m_attrTypes;
    }

    public boolean isInHierarchyOf(OracleType anOracleType) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)32, (int)32, (String)("OracleTypeADT.isInHierarchyOf(" + anOracleType + ")"));
        }
        if (anOracleType == null) {
            return false;
        }
        if (!anOracleType.isObjectType()) {
            return false;
        }
        StructDescriptor theOtherDesc = (StructDescriptor)anOracleType.getTypeDescriptor();
        return this.m_descriptor.isInHierarchyOf(theOtherDesc.getName());
    }

    public boolean isInHierarchyOf(StructDescriptor aStructDescriptor) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)32, (int)32, (String)("OracleTypeADT.isInHierarchyOf(" + aStructDescriptor + ")"));
        }
        if (aStructDescriptor == null) {
            return false;
        }
        return this.m_descriptor.isInHierarchyOf(aStructDescriptor.getName());
    }

    public boolean isObjectType() {
        return true;
    }

    public TypeDescriptor getTypeDescriptor() {
        return this.m_descriptor;
    }

    public synchronized void init(OracleConnection conn) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)2, (int)32, (String)("OracleTypeADT.init(" + conn + ")"));
        }
        this.m_status = 1;
        this.m_conn = conn;
        this.initMetadata(conn);
        if (this.m_TDS != null) {
            this.parseTDS(this.m_TDS, 0L);
            this.m_TDS = null;
            this.m_tdsContext = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initMetadata(OracleConnection conn) throws SQLException {
        if ((this.m_status & 0x100) != 0) {
            return;
        }
        if (!this.m_hasName) {
            this.getFullName();
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)2, (int)32, (String)("OracleTypeADT.initMetadata(connection = " + conn + ", m_fullName = " + this.m_fullName + ")"));
        }
        Object desc = null;
        OracleConnection oracleConnection = conn;
        synchronized (oracleConnection) {
            OracleTypeADT oracleTypeADT = this;
            synchronized (oracleTypeADT) {
                block26: {
                    if ((this.m_status & 0x100) == 0) {
                        Statement cstmt = null;
                        try {
                            block25: {
                                int returnCode;
                                if (this.tdo_c_state == 0L) {
                                    this.m_conn.getDBAccess().getOracleTypeADT(this);
                                }
                                String sql_query = null;
                                this.fdo = this.m_conn.getFDO(false);
                                boolean handleFDO = this.fdo == null;
                                sql_query = !handleFDO ? "begin :1 := dbms_pickler.get_type_shape(:2,:3,:4,:5,:6,:7); end;" : "begin :1 := dbms_pickler.get_type_shape(:2,:3,:4,:5,:6,:7);       :8 := dbms_pickler.get_format(:9); end;";
                                cstmt = this.m_conn.prepareCall(sql_query);
                                int _tries = 0;
                                do {
                                    if (_tries >= 2) {
                                        break block25;
                                    }
                                    cstmt.registerOutParameter(1, 2);
                                    cstmt.registerOutParameter(4, -4);
                                    cstmt.registerOutParameter(5, 4);
                                    if (++_tries <= 1) {
                                        cstmt.registerOutParameter(6, -4);
                                    } else {
                                        cstmt.registerOutParameter(6, 2004);
                                    }
                                    cstmt.registerOutParameter(7, -4);
                                    if (handleFDO) {
                                        cstmt.registerOutParameter(8, 2);
                                        cstmt.registerOutParameter(9, -4);
                                    }
                                    cstmt.setString(2, this.m_schemaName);
                                    cstmt.setString(3, this.m_typeName);
                                    if (OracleLog.TRACE) {
                                        OracleLog.print(null, (int)16, (int)4, (int)64, (String)("OracleTypeADT.initMetadata: qualified_name=" + this.m_fullName + " schema=" + this.m_schemaName + " type=" + this.m_typeName));
                                    }
                                    cstmt.execute();
                                    returnCode = cstmt.getInt(1);
                                    if (returnCode == 0) break;
                                    if (OracleLog.TRACE) {
                                        OracleLog.print(null, (int)16, (int)4, (int)64, (String)("OracleTypeADT.initMetadata: describing type: _tries=" + _tries + "returnCode=" + returnCode));
                                    }
                                    if (_tries <= 1 && returnCode == 24331) continue;
                                    DBError.throwSqlException((int)74, (Object)this.m_fullName);
                                } while (returnCode == 24331);
                                if (handleFDO && cstmt.getInt(8) != 0) {
                                    DBError.throwSqlException((int)1, (Object)"dbms_pickler.get_format()");
                                }
                                this.m_toid = cstmt.getBytes(4);
                                this.m_type_version = NUMBER.toInt(cstmt.getBytes(5));
                                if (_tries <= 1) {
                                    this.m_TDS = cstmt.getBytes(6);
                                } else {
                                    try {
                                        Blob l_blob = ((OracleCallableStatement)cstmt).getBlob(6);
                                        InputStream l_OutputStream = l_blob.getBinaryStream();
                                        this.m_TDS = new byte[(int)l_blob.length()];
                                        l_OutputStream.read(this.m_TDS);
                                        l_OutputStream.close();
                                    }
                                    catch (IOException ea) {
                                        DBError.throwSqlException((IOException)ea);
                                    }
                                }
                                if (OracleLog.TRACE) {
                                    OracleLog.print((Object)this, (int)16, (int)2, (int)64, (String)("OracleTypeADT.initMetadata: m_tds = " + OracleLog.bytesToPrintableForm("", this.m_TDS)));
                                }
                                if (handleFDO) {
                                    this.fdo = cstmt.getBytes(9);
                                    this.m_conn.setFDO(this.fdo);
                                }
                                this.big_endian = this.m_conn.getBigEndian();
                                this.flattened_attr_num = Util.getUnsignedByte(this.m_TDS[8]) * 256 + Util.getUnsignedByte(this.m_TDS[9]);
                                this.m_LDS = cstmt.getBytes(7);
                            }
                            Object var13_13 = null;
                            if (cstmt == null) break block26;
                        }
                        catch (Throwable throwable) {
                            Object var13_14 = null;
                            if (cstmt == null) throw throwable;
                            cstmt.close();
                            throw throwable;
                        }
                        cstmt.close();
                    }
                }
                this.setStatusBits(256);
                return;
            }
        }
    }

    private void initEndianess(byte[] fdo) {
        int[] ub1fdo = Util.toJavaUnsignedBytes(fdo);
        int kopfdo_auxinfo = ub1fdo[6 + ub1fdo[5] + ub1fdo[6] + 5];
        int offset = kopfdo_auxinfo & 0x10;
        if (offset < 0) {
            offset += 256;
        }
        this.big_endian = offset > 0;
    }

    void parseLDS(InputStream stream) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)128, (int)32, (String)("OracleTypeADT.parseLDS(" + stream + ")"));
        }
        long lds_num = Util.read_long((InputStream)stream);
        this.m_fixedDataSize = Util.read_long((InputStream)stream);
        this.m_ldsOffsetArray = new long[this.flattened_attr_num];
        int i2 = 0;
        while (i2 < this.flattened_attr_num) {
            this.m_ldsOffsetArray[i2] = Util.read_long((InputStream)stream);
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)16, (int)128, (int)64, (String)("OracleTypeADT.parseLDS(): lds_offset_array[" + i2 + "]=" + this.m_ldsOffsetArray[i2]));
            }
            ++i2;
        }
    }

    public void generateLDS() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)128, (int)32, (String)("OracleTypeADT.generateLDS() " + this.m_fullName));
        }
        Vector V = this.generateLDSrec();
        this.m_ldsOffsetArray = new long[V.size()];
        int ctr = 0;
        while (ctr < V.size()) {
            Integer I = (Integer)V.elementAt(ctr);
            this.m_ldsOffsetArray[ctr] = I.longValue();
            ++ctr;
        }
    }

    private Vector generateLDSrec() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)128, (int)32, (String)("OracleTypeADT.generateLDSrec() " + this.m_fullName));
        }
        int adtsize = 0;
        int adtalign = 0;
        Vector<Integer> offsets = new Vector<Integer>();
        int size = this.getNumAttrs();
        int ctr = 0;
        while (ctr < size) {
            int attrsize;
            int attralign;
            Vector emboffsets = null;
            OracleType this_attr = this.getAttrTypeAt(ctr);
            if (this_attr instanceof OracleTypeADT && !(this_attr instanceof OracleTypeCOLLECTION) && !(this_attr instanceof OracleTypeUPT)) {
                emboffsets = ((OracleTypeADT)this_attr).generateLDSrec();
                attralign = ((OracleTypeADT)this_attr).getAlignmentReq();
                attrsize = (int)((OracleTypeADT)this_attr).getFixedDataSize();
            } else {
                attrsize = this_attr.getSizeLDS(this.fdo);
                attralign = this_attr.getAlignLDS(this.fdo);
            }
            if ((adtsize & attralign) > 0) {
                adtsize = Util.LDSRound((int)adtsize, (int)attralign);
            }
            if (this_attr instanceof OracleTypeADT && !(this_attr instanceof OracleTypeCOLLECTION) && !(this_attr instanceof OracleTypeUPT)) {
                int vctr = 0;
                while (vctr < emboffsets.size()) {
                    Integer elt = (Integer)emboffsets.elementAt(vctr);
                    Integer newval = new Integer(elt + adtsize);
                    offsets.addElement(newval);
                    ++vctr;
                }
            } else {
                offsets.addElement(new Integer(adtsize));
            }
            adtsize += attrsize;
            if (attralign > adtalign) {
                adtalign = attralign;
            }
            ++ctr;
        }
        if ((adtsize & adtalign) > 0) {
            adtsize = Util.LDSRound((int)adtsize, (int)adtalign);
        }
        this.m_alignmentReq = adtalign;
        this.m_fixedDataSize = adtsize;
        return offsets;
    }

    void parseTDS(byte[] tds_bytes, long index) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)128, (int)32, (String)("OracleTypeADT.parseTDS(" + OracleLog.bytesToPrintableForm("", tds_bytes) + "," + index + ") " + this.m_fullName + " flattened_attr_num=" + this.flattened_attr_num));
        }
        if (this.m_attrTypes != null) {
            return;
        }
        this.m_tdsContext = new StreamInfo(tds_bytes, index);
        long _endOffset = this.m_tdsContext.readLong() + this.m_tdsContext.offset();
        this.m_tdsContext.checkNextByte((byte)38);
        this.m_tds_version = this.m_tdsContext.readByte();
        this.m_tdsContext.skipBytes(2);
        this.flattened_attr_num = this.m_tdsContext.readShort();
        if ((this.m_tdsContext.readByte() & 0xFF) == 255) {
            this.setStatusBits(128);
        }
        long _tdsStart = this.m_tdsContext.offset();
        this.m_tdsContext.checkNextByte((byte)41);
        if (this.m_tdsContext.readShort() != 0) {
            DBError.check_error((int)47, (Object)"parseTDS");
        }
        long _offsetIndexTable = this.m_tdsContext.readLong();
        this.parseTDSrec(this.m_tdsContext);
        if (this.m_tds_version >= 3) {
            this.m_tdsContext.skip_to(_tdsStart + _offsetIndexTable + 2L);
            this.m_tdsContext.skipBytes(2 * this.flattened_attr_num);
            byte _flag = this.m_tdsContext.readByte();
            if (this.m_tdsContext.isJavaObject(this.m_tds_version, _flag)) {
                this.setStatusBits(16);
            }
            if (this.m_tdsContext.isFinalType(this.m_tds_version, _flag)) {
                this.setStatusBits(32);
            }
            if (this.m_tdsContext.readByte() != 1) {
                this.setStatusBits(64);
            }
        } else {
            this.setStatusBits(32);
        }
        this.m_tdsContext.skip_to(_endOffset);
    }

    public void parseTDSrec(StreamInfo offset) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)128, (int)32, (String)("OracleTypeADT.parseTDSrec(" + offset + ") " + this.m_fullName));
        }
        Vector<OracleType> type_tree = new Vector<OracleType>(5);
        OracleType type_object = null;
        this.null_offset = offset.null_offset++;
        this.lds_offset = offset.lds_offset;
        this.idx = 1;
        while ((type_object = this.getNextTypeObject(offset)) != null) {
            type_tree.addElement(type_object);
        }
        if (this.m_opcode == 42) {
            this.endOfAdt = true;
            this.applyTDSpatches(offset);
        }
        this.m_attrTypes = new OracleType[type_tree.size()];
        type_tree.copyInto(this.m_attrTypes);
    }

    private void applyTDSpatches(StreamInfo offset) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)4, (int)32, (String)("OracleTypeADT.applyTDSpatches(" + offset + ") " + this.m_fullName));
        }
        TDSPatch _patch = offset.getNextPatch();
        while (_patch != null) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)16, (int)4, (int)64, (String)("OracleTypeADT.applyTDSpatches(): " + this.m_fullName));
            }
            offset.moveToPatchPos(_patch);
            int patchSystem = _patch.getType();
            if (patchSystem == 0) {
                if (OracleLog.TRACE) {
                    OracleLog.print((Object)this, (int)16, (int)4, (int)64, (String)"OracleTypeADT.applyTDSpatches(): normal");
                }
                offset.readByte();
                byte UPTcode = _patch.getUptTypeCode();
                switch (UPTcode) {
                    case -6: {
                        offset.readLong();
                    }
                    case -5: {
                        OracleNamedType patchElem = _patch.getOwner();
                        OracleTypeADT newAdt = null;
                        newAdt = patchElem.hasName() ? new OracleTypeADT(patchElem.getFullName(), (Connection)this.m_conn, this.fdo) : new OracleTypeADT(patchElem.getParent(), patchElem.getOrder(), (Connection)this.m_conn, this.fdo);
                        newAdt.setUptADT();
                        newAdt.parseTDS(offset.tds(), offset.absolute_offset());
                        offset.skipBytes((int)newAdt.m_tdsContext.offset());
                        _patch.apply(newAdt.cleanup());
                        break;
                    }
                    case 58: {
                        OracleNamedType patchElem = _patch.getOwner();
                        OracleTypeOPAQUE opaque = null;
                        opaque = patchElem.hasName() ? new OracleTypeOPAQUE(patchElem.getFullName(), this.m_conn) : new OracleTypeOPAQUE(patchElem.getParent(), patchElem.getOrder(), this.m_conn);
                        opaque.parseTDSrec(offset);
                        _patch.apply(opaque);
                        break;
                    }
                    default: {
                        DBError.throwSqlException((int)1);
                        break;
                    }
                }
            } else if (patchSystem == 1) {
                if (OracleLog.TRACE) {
                    OracleLog.print((Object)this, (int)16, (int)4, (int)64, (String)"OracleTypeADT.applyTDSpatches(): simple");
                }
                OracleType newType = this.getNextTypeObject(offset);
                _patch.apply(newType, this.m_opcode);
            } else {
                DBError.check_error((int)47, (Object)"parseTDS");
            }
            _patch = offset.getNextPatch();
        }
    }

    public synchronized OracleNamedType cleanup() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)4, (int)32, (String)("OracleTypeADT.cleanup() " + this.m_fullName));
        }
        if (this.m_attrTypes.length == 1 && this.m_attrTypes[0] instanceof OracleTypeCOLLECTION) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)16, (int)4, (int)64, (String)("OracleTypeADT.cleanup() " + this.m_fullName + " is collection"));
            }
            OracleTypeCOLLECTION col = (OracleTypeCOLLECTION)this.m_attrTypes[0];
            col.copy_properties(this);
            return col;
        }
        if (this.m_attrTypes.length == 1 && (this.m_status & 0x80) != 0 && this.m_attrTypes[0] instanceof OracleTypeUPT && ((OracleTypeUPT)this.m_attrTypes[0]).m_realType instanceof OracleTypeOPAQUE) {
            OracleTypeOPAQUE opq = (OracleTypeOPAQUE)((OracleTypeUPT)this.m_attrTypes[0]).m_realType;
            opq.copy_properties(this);
            return opq;
        }
        return this;
    }

    void copy_properties(OracleTypeADT source) {
        this.m_fullName = source.m_fullName;
        this.m_schemaName = source.m_schemaName;
        this.m_typeName = source.m_typeName;
        this.m_hasName = source.m_hasName;
        this.m_parent = source.m_parent;
        this.m_idx = source.m_idx;
        this.m_conn = source.m_conn;
        this.m_LDS = source.m_LDS;
        this.m_TDS = source.m_TDS;
        this.m_toid = source.m_toid;
        this.fdo = source.fdo;
        this.m_tds_version = source.m_tds_version;
        this.m_type_version = source.m_type_version;
        this.tdo_c_state = source.tdo_c_state;
        this.null_offset = source.null_offset;
        this.big_endian = source.big_endian;
        this.endOfAdt = source.endOfAdt;
    }

    OracleType getNextTypeObject(StreamInfo offset) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)4, (int)32, (String)("OracleTypeADT.getNextTypeObject(" + offset + ") " + this.m_fullName));
        }
        while (true) {
            this.m_opcode = offset.readByte();
            if (this.m_opcode == 43) continue;
            if (this.m_opcode != 44) break;
            byte _flag = offset.readByte();
            if (!offset.isJavaObject(3, _flag)) continue;
            this.setStatusBits(16);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)4, (int)64, (String)("OracleTypeADT.getNextTypeObject(): opcode=" + this.m_opcode));
        }
        switch (this.m_opcode) {
            case 40: 
            case 42: {
                return null;
            }
            case 2: {
                OracleTypeDATE odate = new OracleTypeDATE();
                odate.parseTDSrec(offset);
                ++this.idx;
                return odate;
            }
            case 7: {
                OracleTypeCHAR ochar = new OracleTypeCHAR(this.m_conn, 12);
                ochar.parseTDSrec(offset);
                ++this.idx;
                return ochar;
            }
            case 1: {
                OracleTypeCHAR ochar = new OracleTypeCHAR(this.m_conn, 1);
                ochar.parseTDSrec(offset);
                ++this.idx;
                return ochar;
            }
            case 39: {
                OracleTypeADT oadt = new OracleTypeADT(this, this.idx, (Connection)this.m_conn, this.fdo);
                oadt.setEmbeddedADT();
                oadt.parseTDSrec(offset);
                ++this.idx;
                return oadt;
            }
            case 6: {
                OracleTypeNUMBER onum = new OracleTypeNUMBER(2);
                onum.parseTDSrec(offset);
                ++this.idx;
                return onum;
            }
            case 3: {
                OracleTypeNUMBER onum = new OracleTypeNUMBER(3);
                onum.parseTDSrec(offset);
                ++this.idx;
                return onum;
            }
            case 4: {
                OracleTypeNUMBER onum = new OracleTypeNUMBER(8);
                onum.parseTDSrec(offset);
                ++this.idx;
                return onum;
            }
            case 5: {
                OracleTypeFLOAT onum = new OracleTypeFLOAT();
                onum.parseTDSrec(offset);
                ++this.idx;
                return onum;
            }
            case 8: {
                OracleTypeSINT32 onum = new OracleTypeSINT32();
                onum.parseTDSrec(offset);
                ++this.idx;
                return onum;
            }
            case 9: {
                OracleTypeREF oref = new OracleTypeREF(this, this.idx, this.m_conn);
                oref.parseTDSrec(offset);
                ++this.idx;
                return oref;
            }
            case 31: {
                OracleTypeBFILE obfile = new OracleTypeBFILE(this.m_conn);
                obfile.parseTDSrec(offset);
                ++this.idx;
                return obfile;
            }
            case 19: {
                OracleTypeRAW oraw = new OracleTypeRAW();
                oraw.parseTDSrec(offset);
                ++this.idx;
                return oraw;
            }
            case 29: {
                OracleTypeCLOB oclob = new OracleTypeCLOB(this.m_conn);
                oclob.parseTDSrec(offset);
                if (this.m_typeName != null && !this.endOfAdt) {
                    this.m_conn.getDBAccess().getForm(this, oclob, this.idx);
                }
                ++this.idx;
                return oclob;
            }
            case 30: {
                OracleTypeBLOB oblob = new OracleTypeBLOB(this.m_conn);
                oblob.parseTDSrec(offset);
                ++this.idx;
                return oblob;
            }
            case 24: {
                OracleTypeINTERVAL interval = new OracleTypeINTERVAL(this.m_conn);
                interval.parseTDSrec(offset);
                ++this.idx;
                return interval;
            }
            case 28: {
                OracleTypeCOLLECTION ocollection = new OracleTypeCOLLECTION(this, this.idx, this.m_conn);
                ocollection.big_endian = this.big_endian;
                ocollection.parseTDSrec(offset);
                ++this.idx;
                return ocollection;
            }
            case 27: {
                OracleTypeUPT oupt = new OracleTypeUPT(this, this.idx, this.m_conn);
                oupt.big_endian = this.big_endian;
                oupt.parseTDSrec(offset);
                ++this.idx;
                return oupt;
            }
        }
        Object type_object = null;
        DBError.check_error((int)48, (Object)"get_next_type");
        return null;
    }

    public synchronized byte[] linearize(Datum data) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)8, (int)32, (String)("OracleTypeADT.lindarize(" + data + ") " + this.m_fullName));
        }
        return this.pickle81(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Datum unlinearize(byte[] pickled_bytes, long offset, Datum container, int style, Map map) throws SQLException {
        OracleConnection mc = this.getConnection();
        Datum ret = null;
        if (mc == null) {
            ret = this._unlinearize(pickled_bytes, offset, container, style, map);
        } else {
            OracleConnection oracleConnection = mc;
            synchronized (oracleConnection) {
                ret = this._unlinearize(pickled_bytes, offset, container, style, map);
            }
        }
        return ret;
    }

    public synchronized Datum _unlinearize(byte[] pickled_bytes, long offset, Datum container, int style, Map map) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)16, (int)32, (String)("OracleTypeADT.unlinearize() " + this.m_fullName));
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)16, (int)64, (String)("OracleTypeADT.unlinearize(" + OracleLog.bytesToPrintableForm("", pickled_bytes) + ") " + this.m_fullName));
        }
        if (pickled_bytes == null) {
            return null;
        }
        if ((pickled_bytes[0] & 0x80) > 0) {
            PickleContext context = new PickleContext(pickled_bytes, offset);
            return this.unpickle81(context, (STRUCT)container, 1, style, map);
        }
        UnpickleContext newContext = new UnpickleContext(pickled_bytes, (int)offset, null, null, this.big_endian);
        return this.unpickle80(newContext, (STRUCT)container, 1, style, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected STRUCT unpickle80(UnpickleContext context, STRUCT container, int style, int attrStyle, Map attrMap) throws SQLException {
        long endOffset;
        STRUCT struct_obj;
        block9: {
            STRUCT sTRUCT;
            long length;
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)16, (int)16, (int)32, (String)("OracleTypeADT.unpickle80(context = " + context + ", container =" + container + ", m_full_name = " + this.m_fullName));
            }
            struct_obj = container;
            if (style == 3) {
                if (struct_obj == null) {
                    StructDescriptor desc = this.createStructDescriptor();
                    struct_obj = this.createByteSTRUCT(desc, null);
                }
                struct_obj.setImage(context.image(), context.absolute_offset(), 0L);
            }
            if ((length = context.read_long()) == 0L) {
                return null;
            }
            if (style == 9) {
                context.skip_bytes((int)length);
                return struct_obj;
            }
            if (style == 3) {
                struct_obj.setImageLength(length + 4L);
                context.skip_bytes((int)length);
                return struct_obj;
            }
            context.skip_bytes(1);
            byte flag = context.read_byte();
            boolean[] null_array = this.unpickle_nulls(context);
            long data_length = context.read_long();
            endOffset = (long)context.offset() + data_length;
            try {
                if (null_array[0]) break block9;
                UnpickleContext newContext = new UnpickleContext(context.image(), context.absolute_offset(), null_array, this.getLdsOffsetArray(), this.big_endian);
                sTRUCT = this.unpickle80rec(newContext, struct_obj, attrStyle, attrMap);
                Object var18_15 = null;
            }
            catch (Throwable throwable) {
                Object var18_17 = null;
                context.skip_to(endOffset);
                throw throwable;
            }
            context.skip_to(endOffset);
            return sTRUCT;
        }
        Object var18_16 = null;
        context.skip_to(endOffset);
        return struct_obj;
    }

    protected Object unpickle80rec(UnpickleContext context, int format, int style, Map map) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)16, (int)32, (String)("OracleTypeADT.unpicklerec(" + context + ") " + this.m_fullName));
        }
        STRUCT s2 = this.unpickle80rec(context, null, 1, map);
        return this.toObject(s2, style, map);
    }

    private STRUCT unpickle80rec(UnpickleContext context, STRUCT structDatum, int attrStyle, Map attrMap) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)16, (int)32, (String)("OracleTypeADT.unpicklerec(context = " + context + ", struct = " + structDatum + ", m_fullName = " + this.m_fullName));
        }
        if (context.is_null(this.null_offset)) {
            return null;
        }
        context.skip_to(context.m_ldsOffsets[this.lds_offset]);
        int size = this.getNumAttrs();
        STRUCT struct_obj = structDatum;
        if (struct_obj == null) {
            StructDescriptor desc = this.createStructDescriptor();
            struct_obj = this.createByteSTRUCT(desc, null);
        }
        switch (attrStyle) {
            case 1: {
                Datum[] datums = new Datum[size];
                int i2 = 0;
                while (i2 < size) {
                    datums[i2] = (Datum)this.getAttrTypeAt(i2).unpickle80rec(context, 1, attrStyle, attrMap);
                    ++i2;
                }
                struct_obj.setDatumArray(datums);
                break;
            }
            case 2: {
                Object[] oarray = new Object[size];
                int i3 = 0;
                while (i3 < size) {
                    oarray[i3] = this.getAttrTypeAt(i3).unpickle80rec(context, 1, attrStyle, attrMap);
                    ++i3;
                }
                struct_obj.setObjArray(oarray);
                break;
            }
            default: {
                DBError.throwSqlException((int)1);
            }
        }
        return struct_obj;
    }

    private boolean[] unpickle_nulls(UnpickleContext context) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)16, (int)32, (String)("OracleTypeADT.unpickle_nulls(" + context + ") " + this.m_fullName));
        }
        context.skip_bytes(4);
        byte[] bytes = context.read_lengthBytes();
        boolean[] null_bytes = new boolean[(bytes.length - 2) * 4];
        int b2 = 0;
        int i2 = 0;
        while (i2 < null_bytes.length) {
            if (i2 % 4 == 0) {
                b2 = bytes[2 + i2 / 4];
            }
            null_bytes[i2] = (b2 & 3) != 0;
            b2 = (byte)(b2 >> 2);
            ++i2;
        }
        return null_bytes;
    }

    protected STRUCT unpickle81(PickleContext context, STRUCT container, int style, int attrStyle, Map attrMap) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)8, (int)32, (String)("OracleTypeADT.unpickle81(" + context + ") " + this.m_fullName));
        }
        STRUCT the_adt = container;
        long _offset = context.offset();
        byte flags = context.readByte_pctx();
        if (!PickleContext.is81format_pctx((byte)flags)) {
            DBError.throwSqlException((int)1, (Object)"Image is not in 8.1 format");
        }
        if (PickleContext.isCollectionImage_pctx(flags)) {
            DBError.throwSqlException((int)1, (Object)"Image is a collection image, expecting ADT");
        }
        if (!context.readAndCheckVersion_pctx()) {
            DBError.throwSqlException((int)1, (Object)"Image version is not recognized");
        }
        block0 : switch (style) {
            case 9: {
                context.skip_bytes(context.readLength_pctx(true) - 2);
                break;
            }
            case 3: {
                long length = context.readLength_pctx();
                the_adt = this.unpickle81_prefix(context, the_adt, flags);
                if (the_adt == null) {
                    StructDescriptor desc = this.createStructDescriptor();
                    the_adt = this.createByteSTRUCT(desc, null);
                }
                the_adt.setImage(context.image(), _offset, 0L);
                the_adt.setImageLength(length);
                context.skip_to(_offset + length);
                break;
            }
            default: {
                context.skipLength_pctx();
                the_adt = this.unpickle81_prefix(context, the_adt, flags);
                if (the_adt == null) {
                    StructDescriptor desc = this.createStructDescriptor();
                    the_adt = this.createByteSTRUCT(desc, null);
                }
                OracleType[] _attrs = the_adt.getDescriptor().getOracleTypeADT().getAttrTypes();
                switch (attrStyle) {
                    case 1: {
                        Datum[] datums = new Datum[_attrs.length];
                        int i2 = 0;
                        while (i2 < _attrs.length) {
                            datums[i2] = (Datum)_attrs[i2].unpickle81rec(context, attrStyle, attrMap);
                            ++i2;
                        }
                        the_adt.setDatumArray(datums);
                        break block0;
                    }
                    case 2: {
                        Object[] oarray = new Object[_attrs.length];
                        int i3 = 0;
                        while (i3 < _attrs.length) {
                            oarray[i3] = _attrs[i3].unpickle81rec(context, attrStyle, attrMap);
                            ++i3;
                        }
                        the_adt.setObjArray(oarray);
                        break block0;
                    }
                }
                DBError.throwSqlException((int)1);
            }
        }
        return the_adt;
    }

    protected STRUCT unpickle81_prefix(PickleContext context, STRUCT container, byte flags) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)16, (int)32, (String)("OracleTypeADT.unpickle81_prefix( context = " + context + ", container =  " + container + ", flags = " + flags + ")"));
        }
        STRUCT the_adt = container;
        if (PickleContext.hasPrefix_pctx((byte)flags)) {
            boolean hasTypeVersion;
            long _endOffset = context.readLength_pctx() + context.absolute_offset();
            byte _prefixFlag = context.readByte_pctx();
            byte _TypeInfoEncodedBits = (byte)(_prefixFlag & 0xC);
            boolean hasTypeInfoNONE = _TypeInfoEncodedBits == 0;
            boolean hasTypeInfoTOID = _TypeInfoEncodedBits == 4;
            boolean hasTypeInfoTOBJN = _TypeInfoEncodedBits == 8;
            boolean hasTypeInfoTDS = _TypeInfoEncodedBits == 12;
            boolean bl = hasTypeVersion = (_prefixFlag & 0x10) != 0;
            if (hasTypeInfoTOID) {
                byte[] _toid = context.readBytes_pctx(16);
                String _subTypename = OracleTypeADT.toid2typename(this.m_conn, _toid);
                StructDescriptor desc = (StructDescriptor)TypeDescriptor.getTypeDescriptor(_subTypename, this.m_conn);
                if (the_adt == null) {
                    the_adt = this.createByteSTRUCT(desc, null);
                } else {
                    the_adt.setDescriptor(desc);
                }
            }
            this.m_type_version = hasTypeVersion ? context.readLength_pctx() : 1;
            if (hasTypeInfoTOBJN | hasTypeInfoTDS) {
                DBError.throwSqlException((int)23);
            }
            context.skip_to(_endOffset);
        }
        return the_adt;
    }

    protected Object unpickle81rec(PickleContext context, int type, Map map) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)16, (int)32, (String)("OracleTypeADT.unpickle81rec( context = " + context + ", type =  " + type + ", map = " + map + ")"));
        }
        byte firstbyte = context.readByte_pctx();
        byte immemb = 0;
        if (PickleContext.isAtomicNull_pctx((byte)firstbyte)) {
            return null;
        }
        if (PickleContext.isImmEmbNull_pctx((byte)firstbyte)) {
            immemb = context.readByte_pctx();
        }
        STRUCT s2 = this.unpickle81datum(context, firstbyte, immemb);
        return this.toObject(s2, type, map);
    }

    protected Object unpickle81rec(PickleContext context, byte len_flags, int type, Map map) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)8, (int)32, (String)("OracleTypeADT.unpickle81rec(context = " + context + ", len_flags = " + len_flags + ", m_fullName = " + this.m_fullName));
        }
        STRUCT s2 = this.unpickle81datum(context, len_flags, (byte)0);
        return this.toObject(s2, type, map);
    }

    private STRUCT unpickle81datum(PickleContext context, byte len_flags, byte immemb) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)8, (int)32, (String)("OracleTypeADT.unpickle81rec(context = " + context + ", len_flags = " + len_flags + ", immemb = " + immemb + ", m_fullName = " + this.m_fullName));
        }
        int size = this.getNumAttrs();
        StructDescriptor desc = this.createStructDescriptor();
        STRUCT the_adt = this.createByteSTRUCT(desc, null);
        OracleType this_attr = this.getAttrTypeAt(0);
        Object firstElem = null;
        firstElem = PickleContext.isImmEmbNull_pctx((byte)len_flags) && immemb == 1 ? null : (PickleContext.isImmEmbNull_pctx((byte)len_flags) ? ((OracleTypeADT)this_attr).unpickle81datum(context, len_flags, (byte)(immemb - 1)) : (PickleContext.isElementNull_pctx((byte)len_flags) ? (this_attr.getTypeCode() == 2002 || this_attr.getTypeCode() == 2008 ? ((OracleTypeADT)this_attr).unpickle81datum(context, len_flags, immemb) : null) : this_attr.unpickle81rec(context, len_flags, 1, null)));
        Datum[] oarray = new Datum[size];
        oarray[0] = (Datum)firstElem;
        int ctr = 1;
        while (ctr < size) {
            this_attr = this.getAttrTypeAt(ctr);
            oarray[ctr] = (Datum)this_attr.unpickle81rec(context, 1, null);
            ++ctr;
        }
        the_adt.setDatumArray(oarray);
        return the_adt;
    }

    public byte[] pickle81(Datum data) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)8, (int)32, (String)("OracleTypeADT.pickle81(" + data + ") " + this.m_fullName + "m_status" + this.m_status));
        }
        PickleContext ctx = new PickleContext();
        ctx.initStream_pctx();
        this.pickle81(ctx, data);
        byte[] pickledBytes = ctx.stream2bytes_pctx();
        data.setShareBytes(pickledBytes);
        return pickledBytes;
    }

    protected int pickle81(PickleContext ctx, Datum data) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)8, (int)32, (String)("OracleTypeADT.pickle81(context = " + ctx + ", datum = " + data + ", m_fullName =  " + this.m_fullName));
        }
        int lenOffset = ctx.offset() + 2;
        int imglen = 0;
        imglen += ctx.writeImageHeader_pctx(this.shouldHavePrefix());
        imglen += this.pickle81_prefix(ctx);
        ctx.patchImageLen_pctx(lenOffset, imglen += this.pickle81rec(ctx, data, 0));
        return imglen;
    }

    private boolean has_type_version() {
        return this.m_type_version > 1;
    }

    private boolean needs_toid() {
        return (this.m_status & 0x40) != 0 || (this.m_status & 0x20) == 0 || this.has_type_version();
    }

    private boolean shouldHavePrefix() {
        return this.has_type_version() || this.needs_toid();
    }

    protected int pickle81_prefix(PickleContext context) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)8, (int)32, (String)("OracleTypeADT.pickle81_prefix(context = " + context + ")"));
        }
        if (this.shouldHavePrefix()) {
            int len = 0;
            int _prefix_flag = 1;
            int precalculated_length = 1;
            if (this.needs_toid()) {
                precalculated_length += this.getTOID().length;
                _prefix_flag |= 4;
            }
            if (this.has_type_version()) {
                _prefix_flag |= 0x10;
                precalculated_length = this.m_type_version > PickleContext.KOPI20_LN_MAXV ? (precalculated_length += 5) : ++precalculated_length;
            }
            len = context.writeLength_pctx(precalculated_length);
            len += context.write_data_pctx((byte)_prefix_flag);
            if (this.needs_toid()) {
                len += context.write_data_pctx(this.m_toid);
            }
            if (this.has_type_version()) {
                len += context.writeLength_pctx(this.m_type_version);
            }
            return len;
        }
        return 0;
    }

    private int pickle81rec(PickleContext ctx, Datum data, int depth) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)8, (int)32, (String)("OracleTypeADT.pickle81rec(context = " + ctx + ", datum = " + data + ", depth = " + depth + ", m_fullName = " + this.m_fullName));
        }
        int imglen = 0;
        Datum[] values = ((STRUCT)data).getOracleAttributes();
        int field_num = values.length;
        int ctr = 0;
        OracleType this_attr = this.getAttrTypeAt(0);
        if (this_attr instanceof OracleTypeADT && !(this_attr instanceof OracleTypeCOLLECTION) && !(this_attr instanceof OracleTypeUPT)) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)16, (int)8, (int)64, (String)("OracleTypeADT.pickle81rec(): " + this.m_fullName + " check first null case and this attr=" + values[0] + " depth=" + depth));
            }
            ctr = 1;
            imglen = values[0] == null ? (depth > 0 ? (imglen += ctx.writeIEmbNull_pctx((byte)depth)) : (imglen += ctx.writeAtomicNull_pctx())) : (imglen += ((OracleTypeADT)this_attr).pickle81rec(ctx, values[0], depth + 1));
        }
        while (ctr < field_num) {
            this_attr = this.getAttrTypeAt(ctr);
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)16, (int)8, (int)64, (String)("OracleTypeADT.pickle81rec(): " + this.m_fullName + " check idx=" + ctr + "  attr=" + values[ctr] + " depth=" + depth));
            }
            imglen = values[ctr] == null ? (this_attr instanceof OracleTypeADT && !(this_attr instanceof OracleTypeCOLLECTION) && !(this_attr instanceof OracleTypeUPT) ? (imglen += ctx.writeAtomicNull_pctx()) : (imglen += ctx.writeEltNull_pctx())) : (this_attr instanceof OracleTypeADT && !(this_attr instanceof OracleTypeCOLLECTION) && !(this_attr instanceof OracleTypeUPT) ? (imglen += ((OracleTypeADT)this_attr).pickle81rec(ctx, values[ctr], 1)) : (imglen += this_attr.pickle81(ctx, values[ctr])));
            ++ctr;
        }
        return imglen;
    }

    private Object toObject(STRUCT s2, int type, Map map) throws SQLException {
        switch (type) {
            case 1: {
                return s2;
            }
            case 2: {
                if (s2 == null) break;
                return s2.toJdbc(map);
            }
            default: {
                DBError.throwSqlException((int)1);
            }
        }
        return null;
    }

    public String getAttributeType(int idx) throws SQLException {
        if (!this.m_hasName) {
            this.getFullName();
        }
        if (this.m_attrNames == null) {
            this.initADTAttrNames();
        }
        if (idx < 1 || idx > this.m_attrTypeNames.length) {
            DBError.check_error((int)1, (Object)"Invalid index");
        }
        return this.m_attrTypeNames[idx - 1];
    }

    public String getAttributeType(int idx, boolean force) throws SQLException {
        if (force) {
            return this.getAttributeType(idx);
        }
        if (idx < 1 || this.m_attrTypeNames != null && idx > this.m_attrTypeNames.length) {
            DBError.check_error((int)1, (Object)"Invalid index");
        }
        if (this.m_attrTypeNames != null) {
            return this.m_attrTypeNames[idx - 1];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAttributeName(int idx) throws SQLException {
        if (this.m_attrNames == null) {
            this.initADTAttrNames();
        }
        OracleTypeADT oracleTypeADT = this;
        synchronized (oracleTypeADT) {
            if (idx < 1 || idx > this.m_attrNames.length) {
                DBError.check_error((int)1, (Object)"Invalid index");
            }
        }
        return this.m_attrNames[idx - 1];
    }

    public String getAttributeName(int idx, boolean force) throws SQLException {
        if (force) {
            return this.getAttributeName(idx);
        }
        if (idx < 1 || this.m_attrNames != null && idx > this.m_attrNames.length) {
            DBError.check_error((int)1, (Object)"Invalid index");
        }
        if (this.m_attrNames != null) {
            return this.m_attrNames[idx - 1];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initADTAttrNames() throws SQLException {
        CallableStatement cstmt = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String[] temp_attrNames = new String[this.m_attrTypes.length];
        String[] temp_attrTypeNames = new String[this.m_attrTypes.length];
        int state = 0;
        int l_index = 0;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)2, (int)64, (String)"OracleTypeADT.initADTAttrNames()");
        }
        OracleConnection oracleConnection = this.m_conn;
        synchronized (oracleConnection) {
            OracleTypeADT oracleTypeADT = this;
            synchronized (oracleTypeADT) {
                if (this.m_attrNames == null) {
                    state = this.m_schemaName.equalsIgnoreCase(this.m_conn.getUserName()) ? 0 : 3;
                    while (state != 6) {
                        block29: {
                            Object var11_10;
                            switch (state) {
                                case 0: {
                                    ps = this.m_conn.prepareStatement(sqlString[state]);
                                    ps.setString(1, this.m_typeName);
                                    rs = ps.executeQuery();
                                    state = 1;
                                    break;
                                }
                                case 1: {
                                    ps = this.m_conn.prepareStatement(sqlString[state]);
                                    ps.setString(1, this.m_typeName);
                                    ps.setString(2, this.m_typeName);
                                    rs = ps.executeQuery();
                                    state = 2;
                                    break;
                                }
                                case 2: {
                                    ps = this.m_conn.prepareStatement(sqlString[state]);
                                    ps.setString(1, this.m_typeName);
                                    ps.setString(2, this.m_typeName);
                                    rs = ps.executeQuery();
                                    state = 5;
                                    break;
                                }
                                case 3: {
                                    ps = this.m_conn.prepareStatement(sqlString[state]);
                                    ps.setString(1, this.m_schemaName);
                                    ps.setString(2, this.m_typeName);
                                    rs = ps.executeQuery();
                                    state = 4;
                                    break;
                                }
                                case 4: {
                                    ps = this.m_conn.prepareStatement(sqlString[state]);
                                    ps.setString(1, this.m_typeName);
                                    ps.setString(2, this.m_typeName);
                                    rs = ps.executeQuery();
                                    state = 5;
                                    break;
                                }
                                case 5: {
                                    cstmt = this.m_conn.prepareCall(sqlString[state]);
                                    cstmt.setString(1, this.m_typeName);
                                    cstmt.registerOutParameter(2, -10);
                                    cstmt.execute();
                                    rs = ((OracleCallableStatement)cstmt).getCursor(2);
                                    state = 6;
                                }
                            }
                            try {
                                l_index = 0;
                                while (l_index < this.m_attrTypes.length && rs.next()) {
                                    if (rs.getInt(1) != l_index + 1) {
                                        DBError.throwSqlException((int)1, (Object)"inconsistent ADT attribute");
                                    }
                                    temp_attrNames[l_index] = rs.getString(2);
                                    temp_attrTypeNames[l_index] = rs.getString(4) + "." + rs.getString(3);
                                    ++l_index;
                                }
                                if (l_index != 0) {
                                    this.m_attrTypeNames = temp_attrTypeNames;
                                    this.m_attrNames = temp_attrNames;
                                    state = 6;
                                } else {
                                    if (rs != null) {
                                        rs.close();
                                    }
                                    if (ps != null) {
                                        ps.close();
                                    }
                                }
                                var11_10 = null;
                                if (rs == null) break block29;
                            }
                            catch (Throwable throwable) {
                                var11_10 = null;
                                if (rs != null) {
                                    rs.close();
                                }
                                if (ps != null) {
                                    ps.close();
                                }
                                if (cstmt != null) {
                                    cstmt.close();
                                }
                                throw throwable;
                            }
                            rs.close();
                        }
                        if (ps != null) {
                            ps.close();
                        }
                        if (cstmt == null) continue;
                        cstmt.close();
                        {
                        }
                    }
                }
            }
        }
    }

    StructDescriptor createStructDescriptor() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)2, (int)64, (String)"OracleTypeADT.createStructDescriptor()");
        }
        if (this.m_descriptor == null) {
            if (!this.m_hasName && this.getFullName(false) == null) {
                OracleTypeADT otype = new OracleTypeADT(this.getParent(), this.getOrder(), (Connection)this.m_conn);
                this.m_descriptor = new StructDescriptor(otype, (Connection)this.m_conn);
            } else {
                this.m_descriptor = StructDescriptor.createDescriptor(this.m_fullName, (Connection)this.m_conn);
            }
        }
        return (StructDescriptor)this.m_descriptor;
    }

    STRUCT createObjSTRUCT(StructDescriptor desc, Object[] value) throws SQLException {
        if ((this.m_status & 0x10) != 0) {
            return new JAVA_STRUCT(desc, (Connection)this.m_conn, value);
        }
        return new STRUCT(desc, (Connection)this.m_conn, value);
    }

    STRUCT createByteSTRUCT(StructDescriptor desc, byte[] value) throws SQLException {
        if ((this.m_status & 0x10) != 0) {
            return new JAVA_STRUCT(desc, value, this.m_conn);
        }
        return new STRUCT(desc, value, this.m_conn);
    }

    public static String getSubtypeName(Connection conn, byte[] image, long offset) throws SQLException {
        PickleContext context;
        byte flags;
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)16, (int)2, (int)64, (String)("OracleTypeADT.getSubtypeName( connection = " + conn + ", image = " + image + ", offset = " + offset + ")"));
        }
        if (!PickleContext.is81format_pctx((byte)(flags = (context = new PickleContext(image, offset)).readByte_pctx())) || PickleContext.isCollectionImage_pctx(flags) || !PickleContext.hasPrefix_pctx((byte)flags)) {
            return null;
        }
        if (!context.readAndCheckVersion_pctx()) {
            DBError.throwSqlException((int)1, (Object)"Image version is not recognized");
        }
        context.skipLength_pctx();
        context.skipLength_pctx();
        flags = context.readByte_pctx();
        if ((flags & 4) != 0) {
            byte[] _toid = context.readBytes_pctx(16);
            return OracleTypeADT.toid2typename(conn, _toid);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toid2typename(Connection conn, byte[] toid) throws SQLException {
        String typename = (String)((OracleConnection)conn).getDescriptor(toid);
        if (typename == null) {
            PreparedStatement pstmt;
            block8: {
                pstmt = null;
                ResultSet rset = null;
                try {
                    pstmt = conn.prepareStatement("select owner, type_name from all_types where type_oid = ?");
                    pstmt.setBytes(1, toid);
                    rset = pstmt.executeQuery();
                    if (rset.next()) {
                        typename = rset.getString(1) + "." + rset.getString(2);
                        ((OracleConnection)conn).putDescriptor(toid, (Object)typename);
                    } else {
                        DBError.throwSqlException((int)1, (Object)"Invalid type oid");
                    }
                    Object var6_5 = null;
                    if (rset == null) break block8;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    if (rset != null) {
                        rset.close();
                    }
                    if (pstmt != null) {
                        pstmt.close();
                    }
                    throw throwable;
                }
                rset.close();
            }
            if (pstmt != null) {
                pstmt.close();
            }
        }
        return typename;
    }

    public void printDebug() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)2, (int)32, (String)("OracleTypeADT.printDebug(): " + this.debugText()));
        }
    }

    private String debugText() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("OracleTypeADT = " + this);
        pw.println("m_fullName = " + this.m_fullName);
        pw.println("OracleType[] : ");
        if (this.m_attrTypes != null) {
            int i2 = 0;
            while (i2 < this.m_attrTypes.length) {
                pw.println("[" + i2 + "] = " + this.m_attrTypes[i2]);
                ++i2;
            }
        } else {
            pw.println("null");
        }
        pw.println("LDS : ");
        if (this.m_LDS != null) {
            this.printUnsignedByteArray(this.m_LDS, pw);
        } else {
            pw.println("null");
        }
        pw.println("TDS : ");
        if (this.m_TDS != null) {
            this.printUnsignedByteArray(this.m_TDS, pw);
        } else {
            pw.println("null");
        }
        pw.println("toid : ");
        if (this.m_toid != null) {
            this.printUnsignedByteArray(this.m_toid, pw);
        } else {
            pw.println("null");
        }
        pw.println("fdo : ");
        if (this.fdo != null) {
            this.printUnsignedByteArray(this.fdo, pw);
        } else {
            pw.println("null");
        }
        pw.println("tds version : " + this.m_tds_version);
        pw.println("type version : " + this.m_type_version);
        pw.println("type version : " + this.m_type_version);
        pw.println("big_endian : " + (this.big_endian ? "true" : "false"));
        pw.println("opcode : " + this.m_opcode);
        pw.println("tdo_c_state : " + this.tdo_c_state);
        return sw.toString();
    }

    public byte[] getTOID() {
        try {
            if (this.m_toid == null) {
                this.initMetadata(this.m_conn);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return this.m_toid;
    }

    public int getImageFormatVersion() {
        return PickleContext.KOPI20_VERSION;
    }

    public int getTypeVersion() {
        try {
            if (this.m_type_version == -1) {
                this.initMetadata(this.m_conn);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return this.m_type_version;
    }

    public int getCharSet() {
        return this.char_set_if;
    }

    public int getCharSetForm() {
        return this.char_set_form;
    }

    public synchronized long getTDO_C_STATE() {
        try {
            if (this.tdo_c_state == 0L) {
                this.m_conn.getDBAccess().getOracleTypeADT(this);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return this.tdo_c_state;
    }

    public void setTDO_C_STATE(long val) {
        this.tdo_c_state = val;
    }

    public long getFIXED_DATA_SIZE() {
        try {
            return this.getFixedDataSize();
        }
        catch (SQLException sQLException) {
            return 0L;
        }
    }

    public long[] getLDS_OFFSET_ARRAY() {
        try {
            return this.getLdsOffsetArray();
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    public synchronized long[] getLdsOffsetArray() throws SQLException {
        if (this.m_ldsOffsetArray == null && this.m_conn != null) {
            if ((this.m_status & 1) != 0) {
                if (this.m_LDS == null) {
                    this.init(this.m_conn);
                }
                this.parseLDS(new ByteArrayInputStream(this.m_LDS));
            } else if (this.isEmbeddedADT() || this.isUptADT()) {
                this.generateLDS();
            } else {
                DBError.throwSqlException((int)1);
            }
        }
        return this.m_ldsOffsetArray;
    }

    public long getFixedDataSize() throws SQLException {
        return this.m_fixedDataSize;
    }

    public int getAlignmentReq() throws SQLException {
        return this.m_alignmentReq;
    }

    public int getNumAttrs() throws SQLException {
        if (this.m_attrTypes == null && this.m_conn != null) {
            this.init(this.m_conn);
        }
        return this.m_attrTypes.length;
    }

    public OracleType getAttrTypeAt(int idx) throws SQLException {
        if (this.m_attrTypes == null && this.m_conn != null) {
            this.init(this.m_conn);
        }
        return this.m_attrTypes[idx];
    }

    public boolean isEmbeddedADT() throws SQLException {
        return (this.m_status & 2) != 0;
    }

    public boolean isUptADT() throws SQLException {
        return (this.m_status & 4) != 0;
    }

    public boolean isTopADT() throws SQLException {
        return (this.m_status & 1) != 0;
    }

    public void setStatus(int status) throws SQLException {
        this.m_status = status;
    }

    void setEmbeddedADT() throws SQLException {
        this.maskAndSetStatusBits(-16, 2);
    }

    void setUptADT() throws SQLException {
        this.maskAndSetStatusBits(-16, 4);
    }

    public boolean isSubType() throws SQLException {
        return (this.m_status & 0x40) != 0;
    }

    public boolean isFinalType() throws SQLException {
        return (this.m_status & 0x20) != 0;
    }

    public boolean isJavaObject() throws SQLException {
        return (this.m_status & 0x10) != 0;
    }

    public int getStatus() throws SQLException {
        if ((this.m_status & 1) != 0 && (this.m_status & 0x100) == 0) {
            this.init(this.m_conn);
        }
        return this.m_status;
    }

    public static OracleTypeADT shallow_clone(OracleTypeADT adt) throws SQLException {
        OracleTypeADT newADT = new OracleTypeADT();
        OracleTypeADT.shallow_copy((OracleTypeADT)adt, (OracleTypeADT)newADT);
        return newADT;
    }

    public static void shallow_copy(OracleTypeADT from, OracleTypeADT to) throws SQLException {
        to.m_conn = from.m_conn;
        to.m_hasName = from.m_hasName;
        to.m_fullName = from.m_fullName;
        to.m_schemaName = from.m_schemaName;
        to.m_typeName = from.m_typeName;
        to.m_parent = from.m_parent;
        to.m_idx = from.m_idx;
        to.m_descriptor = from.m_descriptor;
        to.m_status = from.m_status;
        to.null_offset = from.null_offset;
        to.lds_offset = from.lds_offset;
        to.size_for_lds = from.size_for_lds;
        to.align_for_lds = from.align_for_lds;
        to.m_typeCode = from.m_typeCode;
        to.m_dbtypeCode = from.m_dbtypeCode;
        to.m_tds_version = from.m_tds_version;
        to.m_type_version = from.m_type_version;
        to.m_LDS = from.m_LDS;
        to.m_ldsOffsetArray = from.m_ldsOffsetArray;
        to.m_fixedDataSize = from.m_fixedDataSize;
        to.m_alignmentReq = from.m_alignmentReq;
        to.m_TDS = from.m_TDS;
        to.m_attrTypes = from.m_attrTypes;
        to.tdo_c_state = from.tdo_c_state;
        to.m_toid = from.m_toid;
        to.fdo = from.fdo;
        to.char_set_if = from.char_set_if;
        to.char_set_form = from.char_set_form;
        to.big_endian = from.big_endian;
        to.flattened_attr_num = from.flattened_attr_num;
        to.m_tdsContext = from.m_tdsContext;
        to.m_status = from.m_status;
        to.m_attrNames = from.m_attrNames;
        to.m_attrTypeNames = from.m_attrTypeNames;
        to.m_opcode = from.m_opcode;
        to.idx = from.idx;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)256, (int)32, (String)"OracleTypeADT.writeObject()");
        }
        out.writeInt(this.m_status);
        out.writeInt(this.m_tds_version);
        out.writeInt(this.m_type_version);
        out.writeObject(this.m_LDS);
        out.writeObject(this.m_ldsOffsetArray);
        out.writeLong(this.m_fixedDataSize);
        out.writeInt(this.m_alignmentReq);
        out.writeObject(this.m_attrTypes);
        out.writeObject(this.m_attrNames);
        out.writeObject(this.m_attrTypeNames);
        out.writeLong(this.tdo_c_state);
        out.writeObject(this.m_toid);
        out.writeObject(this.fdo);
        out.writeInt(this.char_set_if);
        out.writeInt(this.char_set_form);
        out.writeBoolean(this.big_endian);
        out.writeInt(this.flattened_attr_num);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)256, (int)32, (String)"OracleTypeADT.readObject()");
        }
        this.m_status = in.readInt();
        this.m_tds_version = in.readInt();
        this.m_type_version = in.readInt();
        this.m_LDS = (byte[])in.readObject();
        this.m_ldsOffsetArray = (long[])in.readObject();
        this.m_fixedDataSize = in.readLong();
        this.m_alignmentReq = in.readInt();
        this.m_attrTypes = (OracleType[])in.readObject();
        this.m_attrNames = (String[])in.readObject();
        this.m_attrTypeNames = (String[])in.readObject();
        this.tdo_c_state = in.readLong();
        this.m_toid = (byte[])in.readObject();
        this.fdo = (byte[])in.readObject();
        this.char_set_if = in.readInt();
        this.char_set_form = in.readInt();
        this.big_endian = in.readBoolean();
        this.flattened_attr_num = in.readInt();
    }

    public synchronized void setConnection(OracleConnection conn) throws SQLException {
        this.m_conn = conn;
        int i2 = 0;
        while (i2 < this.m_attrTypes.length) {
            this.m_attrTypes[i2].setConnection(conn);
            ++i2;
        }
    }

    private synchronized void setStatusBits(int bits) {
        this.m_status |= bits;
    }

    private synchronized void maskAndSetStatusBits(int mask, int bits) {
        this.m_status &= mask;
        this.m_status |= bits;
    }

    private void printUnsignedByteArray(byte[] b2, PrintWriter pw) {
        int length = b2.length;
        int[] intArray = Util.toJavaUnsignedBytes(b2);
        int i2 = 0;
        while (i2 < length) {
            pw.print("0x" + Integer.toHexString(intArray[i2]) + " ");
            ++i2;
        }
        pw.println();
        i2 = 0;
        while (i2 < length) {
            pw.print(intArray[i2] + " ");
            ++i2;
        }
        pw.println();
    }

    static {
        serialVersionUID = 3031304012507165702L;
        S_TOP = 1;
        S_EMBEDDED = 2;
        S_UPT_ADT = 4;
        S_JAVA_OBJECT = 16;
        S_FINAL_TYPE = 32;
        S_SUB_TYPE = 64;
        S_ATTR_TDS = 128;
        S_HAS_METADATA = 256;
        S_TDS_PARSED = 512;
        KOPT_V80 = 1;
        KOPT_V81 = 2;
        KOPT_VNFT = 3;
        KOPT_VERSION = 3;
        CURRENT_USER_OBJECT = 0;
        CURRENT_USER_SYNONYM = 1;
        CURRENT_USER_PUBLIC_SYNONYM = 2;
        OTHER_USER_OBJECT = 3;
        OTHER_USER_SYNONYM = 4;
        PUBLIC_SYNONYM = 5;
        BREAK = 6;
        sqlString = new String[]{"SELECT /*+ RULE */ATTR_NO, ATTR_NAME, ATTR_TYPE_NAME, ATTR_TYPE_OWNER FROM USER_TYPE_ATTRS WHERE TYPE_NAME = :1 ORDER BY ATTR_NO", "SELECT /*+ RULE */ATTR_NO, ATTR_NAME, ATTR_TYPE_NAME, ATTR_TYPE_OWNER FROM USER_TYPE_ATTRS WHERE TYPE_NAME in (SELECT TABLE_NAME FROM USER_SYNONYMS START WITH SYNONYM_NAME = :1 CONNECT BY PRIOR TABLE_NAME = SYNONYM_NAME UNION SELECT :1 FROM DUAL) ORDER BY ATTR_NO", "SELECT /*+RULE*/ATTR_NO, ATTR_NAME, ATTR_TYPE_NAME, ATTR_TYPE_OWNER FROM USER_TYPE_ATTRS WHERE TYPE_NAME IN (SELECT TABLE_NAME FROM ALL_SYNONYMS START WITH SYNONYM_NAME = :1 AND  OWNER = 'PUBLIC' CONNECT BY PRIOR TABLE_NAME = SYNONYM_NAME AND TABLE_OWNER = OWNER UNION SELECT :2  FROM DUAL) ORDER BY ATTR_NO", "SELECT /*+ RULE */ ATTR_NO, ATTR_NAME, ATTR_TYPE_NAME, ATTR_TYPE_OWNER FROM ALL_TYPE_ATTRS WHERE OWNER = :1 AND TYPE_NAME = :2 ORDER BY ATTR_NO", "SELECT /*+ RULE */ ATTR_NO, ATTR_NAME, ATTR_TYPE_NAME, ATTR_TYPE_OWNER FROM ALL_TYPE_ATTRS WHERE OWNER = (SELECT TABLE_OWNER FROM ALL_SYNONYMS WHERE SYNONYM_NAME=:1) AND TYPE_NAME = (SELECT TABLE_NAME FROM ALL_SYNONYMS WHERE SYNONYM_NAME=:2) ORDER BY ATTR_NO", "DECLARE /*+RULE*/  the_owner VARCHAR2(100);   the_type  VARCHAR2(100); begin  SELECT /*+ RULE */TABLE_NAME, TABLE_OWNER INTO THE_TYPE, THE_OWNER  FROM ALL_SYNONYMS  WHERE TABLE_NAME IN (SELECT TYPE_NAME FROM ALL_TYPES)  START WITH SYNONYM_NAME = :1 AND OWNER = 'PUBLIC'  CONNECT BY PRIOR TABLE_NAME = SYNONYM_NAME AND TABLE_OWNER = OWNER; OPEN :2 FOR SELECT ATTR_NO, ATTR_NAME, ATTR_TYPE_NAME,  ATTR_TYPE_OWNER FROM ALL_TYPE_ATTRS  WHERE TYPE_NAME = THE_TYPE and OWNER = THE_OWNER; END;"};
        TDS_SIZE = 4;
        TDS_NUMBER = 1;
        KOPM_OTS_SQL_CHAR = 1;
        KOPM_OTS_DATE = 2;
        KOPM_OTS_DECIMAL = 3;
        KOPM_OTS_DOUBLE = 4;
        KOPM_OTS_FLOAT = 5;
        KOPM_OTS_NUMBER = 6;
        KOPM_OTS_SQL_VARCHAR2 = 7;
        KOPM_OTS_SINT32 = 8;
        KOPM_OTS_REF = 9;
        KOPM_OTS_VARRAY = 10;
        KOPM_OTS_UINT8 = 11;
        KOPM_OTS_SINT8 = 12;
        KOPM_OTS_UINT16 = 13;
        KOPM_OTS_UINT32 = 14;
        KOPM_OTS_LOB = 15;
        KOPM_OTS_MLSLABEL = 16;
        KOPM_OTS_CANONICAL = 17;
        KOPM_OTS_OCTET = 18;
        KOPM_OTS_RAW = 19;
        KOPM_OTS_ROWID = 20;
        KOPM_OTS_SINGLE = 21;
        KOPM_OTS_LVARCHAR2 = 22;
        KOPM_OTS_FARRAY = 23;
        KOPM_OTS_INTERVAL = 24;
        KOPM_OTS_PTR = 25;
        KOPM_OTS_SINT16 = 26;
        KOPM_OTS_UPT = 27;
        KOPM_OTS_COLLECTION = 28;
        KOPM_OTS_CLOB = 29;
        KOPM_OTS_BLOB = 30;
        KOPM_OTS_BFILE = 31;
        KOPM_OTS_BINARY_INTEGE = 32;
        KOPM_OTS_IMPTZSTAMP = 33;
        KOTTCOPQ = 58;
        KOPT_OP_STARTEMBADT = 39;
        KOPT_OP_ENDEMBADT = 40;
        KOPT_OP_STARTADT = 41;
        KOPT_OP_ENDADT = 42;
        KOPT_OP_SUBTYPE_MARKER = 43;
        KOPT_OP_EMBADT_INFO = 44;
        KOPT_OPCODE_START = 38;
        KOPT_OP_VERSION = 38;
        REGULAR_PATCH = 0;
        SIMPLE_PATCH = 1;
    }
}

