/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.PickleContext;
import oracle.jdbc.oracore.StreamInfo;
import oracle.jdbc.oracore.UnpickleContext;
import oracle.jdbc.oracore.Util;
import oracle.sql.Datum;
import oracle.sql.StructDescriptor;
import oracle.sql.TypeDescriptor;

public abstract class OracleType
implements Serializable {
    static final long serialVersionUID = -6719430495533003861L;
    static final int STYLE_ARRAY_LENGTH = 0;
    static final int STYLE_DATUM = 1;
    static final int STYLE_JAVA = 2;
    static final int STYLE_RAWBYTE = 3;
    static final int STYLE_INT = 4;
    static final int STYLE_DOUBLE = 5;
    static final int STYLE_FLOAT = 6;
    static final int STYLE_LONG = 7;
    static final int STYLE_SHORT = 8;
    static final int STYLE_SKIP = 9;
    static final int FORMAT_ADT_ATTR = 1;
    static final int FORMAT_COLL_ELEM = 2;
    static final int FORMAT_COLL_ELEM_NO_INDICATOR = 3;
    int null_offset;
    int lds_offset;
    int size_for_lds;
    int align_for_lds;
    int m_typeCode;
    int m_dbtypeCode;
    static final int KOPMAP_FLOAT = 2;
    static final int KOPMAP_SB4 = 4;
    static final int KOPMAP_PTR = 5;
    static final int KOPMAP_ORLD = 11;
    static final int KOPMAP_ORLN = 12;

    public OracleType() {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)16, (int)2, (int)32, (String)"OracleType ()");
        }
        this.null_offset = 0;
        this.lds_offset = 0;
        this.size_for_lds = 0;
    }

    public OracleType(int typecode) {
        this();
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)16, (int)2, (int)32, (String)("OracleType (" + typecode + ")"));
        }
        this.m_typeCode = typecode;
    }

    public boolean isInHierarchyOf(OracleType anOracleType) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)64, (int)16, (String)("OracleTypeADT.isInHierarchyOf(" + anOracleType + "):return false"));
        }
        return false;
    }

    public boolean isInHierarchyOf(StructDescriptor aStructDescriptor) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)64, (int)16, (String)("OracleTypeADT.isInHierarchyOf(" + aStructDescriptor + "):return false"));
        }
        return false;
    }

    public boolean isObjectType() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)64, (int)16, (String)"OracleTypeADT.isObjectType():return false");
        }
        return false;
    }

    public TypeDescriptor getTypeDescriptor() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)64, (int)16, (String)"OracleTypeADT.getTypeDescriptor():return null");
        }
        return null;
    }

    public abstract Datum toDatum(Object var1, OracleConnection var2) throws SQLException;

    public Datum[] toDatumArray(Object obj, OracleConnection conn, long beginIdx, int count) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)32, (int)16, (String)("OracleTypeADT.toDatumArray(object = " + obj + ", connection = " + conn + ")"));
        }
        Datum[] datumArray = null;
        if (obj != null) {
            if (obj instanceof Object[]) {
                Object[] objArray = (Object[])obj;
                int length = (int)(count == -1 ? (long)objArray.length : Math.min((long)objArray.length - beginIdx + 1L, (long)count));
                datumArray = new Datum[length];
                int i2 = 0;
                while (i2 < length) {
                    datumArray[i2] = this.toDatum(objArray[(int)beginIdx + i2 - 1], conn);
                    ++i2;
                }
            } else {
                DBError.check_error((int)59, (Object)obj);
            }
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)32, (int)16, (String)("OracleTypeADT.toDatumArray:return " + datumArray));
        }
        return datumArray;
    }

    public void setTypeCode(int code) {
        this.m_typeCode = code;
    }

    public int getTypeCode() throws SQLException {
        return this.m_typeCode;
    }

    public void setDBTypeCode(int code) {
        this.m_dbtypeCode = code;
    }

    public int getDBTypeCode() throws SQLException {
        return this.m_dbtypeCode;
    }

    public void parseTDSrec(StreamInfo offset) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)128, (int)16, (String)("OracleTypeADT.parseTDSrec(" + offset + ")"));
        }
        this.null_offset = offset.null_offset++;
        this.lds_offset = offset.lds_offset++;
    }

    public int getSizeLDS(byte[] FDO) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)128, (int)16, (String)("OracleTypeADT.getSizeLDS(" + FDO + ")"));
        }
        if (this.size_for_lds == 0) {
            this.size_for_lds = Util.FDO_get_size((byte[])FDO, (int)5);
            this.align_for_lds = Util.FDO_get_align((byte[])FDO, (int)5);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)128, (int)16, (String)("OracleTypeADT.getSizeLDS:return " + this.size_for_lds));
        }
        return this.size_for_lds;
    }

    public int getAlignLDS(byte[] FDO) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)128, (int)16, (String)("OracleTypeADT.getAlignLDS(" + FDO + ")"));
        }
        if (this.size_for_lds == 0) {
            this.size_for_lds = Util.FDO_get_size((byte[])FDO, (int)5);
            this.align_for_lds = Util.FDO_get_align((byte[])FDO, (int)5);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)128, (int)16, (String)("OracleTypeADT.getAlignLDS:return " + this.align_for_lds));
        }
        return this.align_for_lds;
    }

    protected abstract Object unpickle80rec(UnpickleContext var1, int var2, int var3, Map var4) throws SQLException;

    protected Object unpickle81rec(PickleContext context, int type, Map map) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)16, (int)16, (String)("OracleTypeADT.unpickle81rec(context = " + context + ", type = " + type + ", " + ", map = " + map + ")"));
        }
        if (type == 9) {
            context.skipDataValue_pctx();
            return null;
        }
        byte[] val = context.readDataValue_pctx();
        return this.toObject(val, type, map);
    }

    protected Object unpickle81rec(PickleContext context, byte byte1, int type, Map map) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)16, (int)16, (String)("OracleTypeADT.unpickle81rec(context = " + context + ", byte1 = " + byte1 + ", type = " + type + ", " + ", map = " + map + ")"));
        }
        if (type == 9) {
            context.skipDataValue_pctx();
            return null;
        }
        byte[] val = context.readDataValue_pctx(byte1);
        return this.toObject(val, type, map);
    }

    protected Object toObject(byte[] bytes, int type, Map map) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)16, (int)16, (String)("OracleTypeADT.toObject(bytes = " + bytes + ", type = " + type + ", map = " + map + "):return null"));
        }
        return null;
    }

    protected int pickle81(PickleContext ctx, Datum data) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)8, (int)16, (String)("OracleTypeADT.pickle81(context = " + ctx + ", datum = " + data + ")"));
        }
        int len = ctx.writeLength_pctx((int)data.getLength());
        len += ctx.write_data_pctx(data.shareBytes());
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)8, (int)16, (String)("OracleTypeADT.pickle81:return " + len));
        }
        return len;
    }

    void writeSerializedFields(ObjectOutputStream out) throws IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)8, (int)16, (String)"OracleTypeADT.writeSerializedFields()");
        }
        out.writeInt(this.null_offset);
        out.writeInt(this.lds_offset);
        out.writeInt(this.size_for_lds);
        out.writeInt(this.align_for_lds);
        out.writeInt(this.m_typeCode);
        out.writeInt(this.m_dbtypeCode);
    }

    void readSerializedFields(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)8, (int)16, (String)"OracleTypeADT.readSerializedFields()");
        }
        this.null_offset = in.readInt();
        this.lds_offset = in.readInt();
        this.size_for_lds = in.readInt();
        this.align_for_lds = in.readInt();
        this.m_typeCode = in.readInt();
        this.m_dbtypeCode = in.readInt();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)256, (int)32, (String)"OracleType.writeObject()");
        }
        out.writeInt(this.null_offset);
        out.writeInt(this.lds_offset);
        out.writeInt(this.size_for_lds);
        out.writeInt(this.align_for_lds);
        out.writeInt(this.m_typeCode);
        out.writeInt(this.m_dbtypeCode);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)256, (int)32, (String)"OracleType.readObject()");
        }
        this.null_offset = in.readInt();
        this.lds_offset = in.readInt();
        this.size_for_lds = in.readInt();
        this.align_for_lds = in.readInt();
        this.m_typeCode = in.readInt();
        this.m_dbtypeCode = in.readInt();
    }

    public void setConnection(OracleConnection conn) throws SQLException {
    }

    public boolean isNCHAR() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)256, (int)32, (String)"OracleType.isNCHAR ()  false");
        }
        return false;
    }

    public int getPrecision() throws SQLException {
        return 0;
    }

    public int getScale() throws SQLException {
        return 0;
    }

    static {
        serialVersionUID = -6719430495533003861L;
        STYLE_ARRAY_LENGTH = 0;
        STYLE_DATUM = 1;
        STYLE_JAVA = 2;
        STYLE_RAWBYTE = 3;
        STYLE_INT = 4;
        STYLE_DOUBLE = 5;
        STYLE_FLOAT = 6;
        STYLE_LONG = 7;
        STYLE_SHORT = 8;
        STYLE_SKIP = 9;
        FORMAT_ADT_ATTR = 1;
        FORMAT_COLL_ELEM = 2;
        FORMAT_COLL_ELEM_NO_INDICATOR = 3;
        KOPMAP_FLOAT = 2;
        KOPMAP_SB4 = 4;
        KOPMAP_PTR = 5;
        KOPMAP_ORLD = 11;
        KOPMAP_ORLN = 12;
    }
}

