/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.sql.Datum;
import oracle.sql.TypeDescriptor;

public abstract class OracleNamedType
extends OracleType
implements Serializable {
    transient OracleConnection m_conn;
    transient boolean m_hasName;
    String m_fullName;
    transient String m_schemaName;
    transient String m_typeName;
    transient OracleTypeADT m_parent;
    transient int m_idx;
    transient TypeDescriptor m_descriptor;

    protected OracleNamedType() {
    }

    public OracleNamedType(String fullName, OracleConnection conn) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)2, (int)32, (String)("OracleNamedType(fullName = " + fullName + ", connection = " + conn + ")"));
        }
        this._setConnection(conn);
        this.m_fullName = fullName;
        this.initNames();
        this.m_hasName = true;
        this.m_parent = null;
        this.m_descriptor = null;
    }

    protected OracleNamedType(OracleTypeADT parent, int idx, OracleConnection conn) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)2, (int)32, (String)("OracleNamedType(parent = " + parent + ", idx = " + idx + ", connection = " + conn + ")"));
        }
        this._setConnection(conn);
        this.m_parent = parent;
        this.m_idx = idx;
        this.m_hasName = false;
        this.m_descriptor = null;
    }

    private void initNames() {
        int idxDot;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)2, (int)32, (String)"initNames()");
        }
        if ((idxDot = this.m_fullName.indexOf(".")) >= 0) {
            this.m_schemaName = this.m_fullName.substring(0, idxDot);
            this.m_typeName = this.m_fullName.substring(idxDot + 1);
        } else {
            this.m_typeName = this.m_fullName;
        }
    }

    public String getFullName() throws SQLException {
        return this.getFullName(false);
    }

    public String getFullName(boolean force) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)64, (int)32, (String)("getFullName(" + force + ")"));
        }
        String temp_fullName = null;
        if (force | !this.m_hasName) {
            temp_fullName = this.m_parent.getAttributeType(this.m_idx);
            if (temp_fullName != null) {
                this.m_fullName = temp_fullName;
                this.initNames();
                this.m_hasName = true;
            } else {
                DBError.throwSqlException((int)1, (Object)"Unable to resolve name");
            }
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)64, (int)32, (String)("getFullName:return " + this.m_fullName));
        }
        return this.m_fullName;
    }

    public String getSchemaName() throws SQLException {
        if (!this.m_hasName) {
            this.getFullName();
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)64, (int)32, (String)("getSchemaName:return " + this.m_schemaName));
        }
        return this.m_schemaName;
    }

    public String getSimpleName() throws SQLException {
        if (!this.m_hasName) {
            this.getFullName();
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)64, (int)32, (String)("getSimpleName:return " + this.m_typeName));
        }
        return this.m_typeName;
    }

    public boolean hasName() throws SQLException {
        return this.m_hasName;
    }

    public OracleTypeADT getParent() throws SQLException {
        return this.m_parent;
    }

    public void setParent(OracleTypeADT parent) throws SQLException {
        this.m_parent = parent;
    }

    public int getOrder() throws SQLException {
        return this.m_idx;
    }

    public void setOrder(int order) throws SQLException {
        this.m_idx = order;
    }

    public OracleConnection getConnection() throws SQLException {
        return this.m_conn;
    }

    public void setConnection(OracleConnection conn) throws SQLException {
        this._setConnection(conn);
    }

    public void _setConnection(OracleConnection conn) {
        this.m_conn = conn;
    }

    public Datum unlinearize(byte[] pickled_bytes, long offset, Datum container, int type, Map objmap) throws SQLException {
        DBError.throwSqlException((int)23);
        return null;
    }

    public Datum unlinearize(byte[] pickled_bytes, long offset, Datum container, long idx, int cnt, int type, Map objmap) throws SQLException {
        DBError.throwSqlException((int)23);
        return null;
    }

    public byte[] linearize(Datum data) throws SQLException {
        DBError.throwSqlException((int)23);
        return null;
    }

    public TypeDescriptor getDescriptor() throws SQLException {
        return this.m_descriptor;
    }

    public void setDescriptor(TypeDescriptor desc) throws SQLException {
        this.m_descriptor = desc;
    }

    public int getTypeVersion() {
        return 1;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)256, (int)32, (String)"OracleNamedType.writeObject()");
        }
        try {
            out.writeUTF(this.getFullName());
        }
        catch (SQLException e2) {
            DBError.SQLToIOException((SQLException)e2);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)16, (int)256, (int)32, (String)"OracleNamedType.readObject()");
        }
        this.m_fullName = in.readUTF();
        this.initNames();
        this.m_hasName = true;
        this.m_parent = null;
        this.m_idx = -1;
    }
}

