/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oci8;

import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBData;
import oracle.jdbc.dbaccess.DBDataSet;
import oracle.jdbc.dbaccess.DBDataSetImpl;
import oracle.jdbc.dbaccess.DBItem;
import oracle.jdbc.dbaccess.DBType;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.oci8.OCIDBItem;
import oracle.jdbc.oci8.OCIDBType;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.SQLUtil;

public class OCIDBDataSet
extends DBDataSetImpl {
    private short _versionNum = 0;

    public OCIDBDataSet(OracleConnection conn, OracleStatement stmt, int batchSize, int dataSetType, short vNum) {
        super(conn, stmt, batchSize, dataSetType);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)4, (int)16, (String)("OCIDBDataSet(conn = " + conn + ", stmt = " + stmt + ", batchSize = " + batchSize + ", dataSetType = " + dataSetType + ", vNum = " + vNum + ") -- after super()"));
        }
        this._versionNum = vNum;
    }

    public boolean setPlsqlIndexTableItem(int index, int rank, Datum[] indextable_data, int maxarr_len, int curarr_len, int elemInternalType, int elemMaxLen) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)4, (int)16, (String)("OCIDBDataSet.setPlsqlIndexTableItem(index = " + index + ", rank = " + rank + ", indextable_data = " + indextable_data + ", maxarr_len = " + maxarr_len + ", curarr_len = " + curarr_len + ", elemInternalType = " + elemInternalType + ", elemMaxLen = " + elemMaxLen + ")"));
        }
        OCIDBType dbtype = (OCIDBType)this._createOrGetBindDBType(index, 998);
        if (this.m_first_row) {
            dbtype.setPlsqlIndexTableTypeFields(maxarr_len, elemMaxLen, elemInternalType, this._versionNum);
            this._setBindDBType(index, (DBType)dbtype);
        } else {
            if (maxarr_len > 0 && maxarr_len > dbtype.max_length_plsqlindextable) {
                dbtype.max_length_plsqlindextable = maxarr_len;
            }
            if (elemMaxLen > 0 && elemMaxLen > dbtype.max_length) {
                dbtype.max_length = elemMaxLen;
            }
        }
        OCIDBItem dbitem = (OCIDBItem)this._createOrGetDBItem(index, (DBType)dbtype, rank);
        dbitem.setPlsqlIndexTableItemFields(indextable_data, curarr_len, dbtype);
        this._setBindDBItem(index, (DBItem)dbitem);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)4, (int)16, (String)"OCIDBDataSet.setPlsqlIndexTableItem(_, _, _, _, _, _, _) return: true");
        }
        return true;
    }

    public int getPlsqlIndexTableType(int index) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)4, (int)16, (String)("OCIDBDataSet.getPlsqlIndexTableType(index = " + index + ")"));
        }
        return ((OCIDBType)this.getDBTypes()[index]).element_type_plsqlindextable;
    }

    public void setPlsqlIndexTableType(int index, int maxarr_len, int elemMaxLen, int elemSqlType) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)4, (int)16, (String)("OCIDBDataSet.setPlsqlIndexTableType(index = " + index + ", maxarr_len = " + maxarr_len + ", elemMaxLen = " + elemMaxLen + ", elemSqlType = " + elemSqlType + ")"));
        }
        OCIDBType dbtype = (OCIDBType)this._createOrGetBindDBType(index, 998);
        dbtype.setPlsqlIndexTableTypeFields(maxarr_len, elemMaxLen, elemSqlType, this._versionNum);
        this._setBindDBType(index, (DBType)dbtype);
    }

    public Datum[] getPlsqlIndexTableItem(int index, int rank) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)4, (int)16, (String)("OCIDBDataSet.getPlsqlIndexTableItem(index = " + index + ", rank = " + rank + ")"));
        }
        DBData[] out_values = this.getDBData();
        DBType[] out_types = this.getDBTypes();
        int elemtype = this.getPlsqlIndexTableType(index);
        OCIDBItem dbitem = (OCIDBItem)out_values[index].getItem(rank);
        Datum[] value = new Datum[dbitem.cur_length_plsqlindextable];
        int i2 = 0;
        while (i2 < dbitem.cur_length_plsqlindextable) {
            switch (elemtype) {
                case 2: 
                case 6: {
                    value[i2] = new NUMBER((byte[])dbitem.indextable_value[i2]);
                    break;
                }
                default: {
                    value[i2] = SQLUtil.makeDatum((OracleConnection)this.m_connection, (byte[])((byte[])dbitem.indextable_value[i2]), (int)elemtype, null, (int)0);
                }
            }
            ++i2;
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)4, (int)16, (String)("OCIDBDataSet.getPlsqlIndexTableItem(index, rank) return: " + value));
        }
        return value;
    }

    boolean isTypeChanged(OCIDBDataSet dbset, int index, int maxLen, int elemMaxLen, int elemSqlType) throws SQLException {
        OCIDBType bind_type;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)4, (int)16, (String)("OCIDBDataSet.isTypeChanged(dbset " + dbset + "index = " + index + ", maxLen = " + maxLen + ", elemMaxLen = " + elemMaxLen + ", elemSqlType = " + elemSqlType + ")"));
        }
        return dbset.types != null && dbset.types.length > index && (bind_type = (OCIDBType)dbset.getDBTypes()[index]) != null && (bind_type.element_type_plsqlindextable != elemSqlType || bind_type.max_length_plsqlindextable < maxLen || bind_type.max_length < elemMaxLen);
    }

    public int checkPlsqlIndexTableBindTypes(DBDataSet _dbset, int index, int maxLen, int elemMaxLen, int elemSqlType) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)4, (int)16, (String)("OCIDBDataSet.checkPlsqlIndexTableBindTypes(dbset2 = " + _dbset + ", index = " + index + ", maxLen = " + maxLen + ", elemMaxLen = " + elemMaxLen + ", elemSqlType = " + elemSqlType + ")"));
        }
        if (this.m_first_row) {
            return 0;
        }
        if (this.isTypeChanged(this, index, maxLen, elemMaxLen, elemSqlType)) {
            return -1;
        }
        if (_dbset != null && this.isTypeChanged((OCIDBDataSet)_dbset, index, maxLen, elemMaxLen, elemSqlType)) {
            return -1;
        }
        return 0;
    }
}

