/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oci8;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleOCIFailover;
import oracle.jdbc.dbaccess.DBAccess;
import oracle.jdbc.dbaccess.DBColumn;
import oracle.jdbc.dbaccess.DBConversion;
import oracle.jdbc.dbaccess.DBData;
import oracle.jdbc.dbaccess.DBDataSet;
import oracle.jdbc.dbaccess.DBDataSetImpl;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.dbaccess.DBItem;
import oracle.jdbc.dbaccess.DBStatement;
import oracle.jdbc.dbaccess.DBType;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.oci.OracleOCIConnection;
import oracle.jdbc.oci8.OCIDBDataSet;
import oracle.jdbc.oci8.OCIDBError;
import oracle.jdbc.oci8.OCIDBItem;
import oracle.jdbc.oci8.OCIDBStatement;
import oracle.jdbc.oci8.OCIDBType;
import oracle.jdbc.oci8.OCIEnv;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCLOB;
import oracle.sql.ArrayDescriptor;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.Datum;
import oracle.sql.DatumWithConnection;
import oracle.sql.OpaqueDescriptor;
import oracle.sql.SQLName;
import oracle.sql.StructDescriptor;
import oracle.sql.TypeDescriptor;

public class OCIDBAccess
extends DBAccess {
    boolean new_connection;
    Properties dbinfo;
    DBConversion conversion;
    DBData[] curr_out_values;
    DBType[] curr_out_types;
    static final int KGHMAX = 0x3FFFFFC;
    int m_streamChunkSize = 16384;
    int start_index;
    int end_index;
    short char_set = 0;
    short db_char_set;
    short db_nchar_set;
    short version_num;
    short m_pointerSize;
    int m_c2s_nls_ratio;
    int m_s2c_nls_ratio;
    public boolean shared_env;
    int logon_mode;
    long OCIEnvHandle;
    long c_state;
    OracleOCIFailover m_appCbk = null;
    Object m_cbkObj = null;
    Connection m_conn = null;
    oracle.jdbc.driver.OracleConnection m_connection;
    private static boolean loaded_library;
    static final int EOJ_LOGON_MODE_DEFAULT = 0;
    static final int EOJ_LOGON_MODE_SYSDBA = 2;
    static final int EOJ_LOGON_MODE_SYSOPER = 4;
    public static final int EOJ_LOGON_MODE_CONNECTION_POOL = 5;
    public static final int EOJ_LOGON_MODE_CONNPOOL_CONNECTION = 6;
    public static final int EOJ_LOGON_MODE_CONNPOOL_PROXY_CONNECTION = 7;
    public static final int EOJ_LOGON_MODE_CONNPOOL_ALIASED_CONNECTION = 8;
    static final int EOJ_SUCCESS = 0;
    static final int EOJ_ERROR = -1;
    static final int EOJ_CLOSED_CONNECTION = -8;
    static final int EOJ_CLOSED_STATEMENT = -9;
    static final int EOJ_WARN_SUCCESS_WITH_INFO = -93;

    public OCIDBAccess() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)"OCIDBAccess()");
        }
        this.c_state = 0L;
        this.m_pointerSize = 0;
        this.dbinfo = new Properties();
        this.OCIEnvHandle = 0L;
        this.shared_env = false;
    }

    native int make_c_state(boolean var1, boolean var2);

    native int register_TAF();

    native int free_c_state(boolean var1);

    public synchronized DBConversion logon(String user, String password, String database, Properties info) throws SQLException, IOException {
        String envString;
        block39: {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)("OCIDBAccess.logon(user = " + user + ", password = " + password + ", database = " + database + ", info = " + info + ")"));
            }
            if (database == null) {
                DBError.throwSqlException((int)64);
            }
            try {
                if (System.getProperty("oracle.jserver.version") == null && !loaded_library) {
                    String dll_str = info.getProperty("dll");
                    System.loadLibrary(dll_str);
                    loaded_library = true;
                }
            }
            catch (SecurityException e2) {
                if (loaded_library) break block39;
                String dll_str = info.getProperty("dll");
                System.loadLibrary(dll_str);
                loaded_library = true;
            }
        }
        String stream_size = info.getProperty("oracle.jdbc.StreamChunkSize");
        if (stream_size != null) {
            int _size = Integer.parseInt(stream_size);
            this.m_streamChunkSize = _size < 4096 ? 4096 : (_size > 0x3FFFFFC ? 0x3FFFFFC : _size);
        }
        long OCISvcCtxHandle = 0L;
        long OCIErrHandle = 0L;
        String svcCtxString = info.getProperty("OCISvcCtxHandle");
        if (svcCtxString != null && (envString = info.getProperty("OCIEnvHandle")) != null) {
            this.new_connection = false;
            OCISvcCtxHandle = Long.parseLong(svcCtxString);
            this.OCIEnvHandle = Long.parseLong(envString);
        } else {
            this.new_connection = true;
        }
        if (this.new_connection) {
            this.char_set = (short)this.get_char_set(true);
        } else {
            String errString = info.getProperty("OCIErrHandle");
            OCIErrHandle = errString != null ? Long.parseLong(errString) : 0L;
            String CCCString = info.getProperty("ClientCharSet");
            short ClientCharSet = CCCString != null ? (short)Integer.parseInt(CCCString) : (short)0;
            if (ClientCharSet == 0) {
                short cli_char_set = (short)this.get_char_set(false);
                if (cli_char_set == -1) {
                    this.check_error(-1, null);
                } else {
                    this.char_set = cli_char_set;
                }
            } else if (ClientCharSet == 1 || ClientCharSet == 31 || ClientCharSet == 870 || ClientCharSet == 871) {
                this.char_set = ClientCharSet;
            } else {
                this.check_error(-1, null);
            }
        }
        if (this.c_state == 0L) {
            if (info != null && info.getProperty("is_connection_pooling") == "true") {
                OCIEnv envobj = OCIEnv.getEnv((OCIDBAccess)this);
                envobj.envCharSetId = this.char_set;
                if (!this.new_connection) {
                    this.check_error(-1, null);
                }
                this.OCIEnvHandle = envobj.getEnvHandle();
                this.shared_env = true;
            } else {
                this.shared_env = false;
            }
            this.make_c_state(this.new_connection, this.shared_env);
        }
        this.conversion = new DBConversion(31, this.char_set, 871);
        if (this.new_connection) {
            byte[] user_bytearray = DBConversion.stringToAccessCharBytes((String)user, (short)this.char_set);
            byte[] passwd_bytearray = DBConversion.stringToAccessCharBytes((String)password, (short)31);
            byte[] db_bytearray = DBConversion.stringToAccessCharBytes((String)database, (short)31);
            byte[] npasswd_bytearray = null;
            String newPassword = info.getProperty("OCINewPassword");
            if (newPassword != null) {
                npasswd_bytearray = DBConversion.stringToAccessCharBytes((String)newPassword, (short)31);
            }
            String log_as_int = info.getProperty("internal_logon");
            this.logon_mode = 0;
            if (log_as_int != null) {
                this.logon_mode = log_as_int.equalsIgnoreCase("sysoper") ? 4 : 2;
            }
            if (info.getProperty("is_connection_pooling") == "true") {
                String logon_property = info.getProperty("connection_pool");
                OCIDBAccess cpool = (OCIDBAccess)info.get("connpool_object");
                if (logon_property == "connection_pool") {
                    this.logon_mode = 5;
                } else if (logon_property == "connpool_connection") {
                    this.logon_mode = 6;
                } else if (logon_property == "connpool_proxy_connection") {
                    this.logon_mode = 7;
                } else if (logon_property == "connpool_alias_connection") {
                    this.logon_mode = 6;
                } else {
                    DBError.throwSqlException((int)23, (Object)"connection-pool-logon");
                }
            }
            try {
                this.check_error(this.do_open(this.OCIEnvHandle, user_bytearray, user_bytearray == null ? 0 : user_bytearray.length, passwd_bytearray, passwd_bytearray == null ? 0 : passwd_bytearray.length, npasswd_bytearray, npasswd_bytearray == null ? 0 : npasswd_bytearray.length, db_bytearray, db_bytearray.length, this.logon_mode, (Object)info), null);
            }
            catch (SQLWarning warn) {
                this.setConnectionWarning(warn);
            }
        } else {
            this.check_error(this.use_connection(this.OCIEnvHandle, OCISvcCtxHandle, OCIErrHandle), null);
        }
        this.m_c2s_nls_ratio = this.getC2SNlsRatio();
        this.m_s2c_nls_ratio = this.getS2CNlsRatio();
        if (info != null && info.getProperty("connection_pool") != "connection_pool") {
            this.db_char_set = (short)this.get_db_char_set();
            this.db_nchar_set = (short)this.get_db_nchar_set();
            this.conversion = new DBConversion(this.db_char_set, this.char_set, this.db_nchar_set);
            this.version_num = this.getVersionNumber();
            if (this.version_num == -1 || this.version_num == -8) {
                this.version_num = 0;
            }
        } else {
            this.version_num = 0;
            this.db_char_set = (short)31;
            this.db_nchar_set = (short)871;
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)("OCIDBAccess.logon(user, passwd, db, info) returns: " + this.conversion));
        }
        return this.conversion;
    }

    native int do_open(long var1, byte[] var3, int var4, byte[] var5, int var6, byte[] var7, int var8, byte[] var9, int var10, int var11, Object var12);

    native int use_connection(long var1, long var3, long var5);

    native int get_char_set(boolean var1);

    native int get_db_char_set();

    native int get_db_nchar_set();

    public synchronized void logoff() throws SQLException, IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)"OCIDBAccess.logoff()");
        }
        if (this.new_connection) {
            this.check_error(this.free_c_state(true), null);
            if (this.shared_env) {
                OCIEnv.getEnv((OCIDBAccess)this).freeEnvHandle();
                this.shared_env = false;
            }
        } else {
            this.check_error(this.free_c_state(false), null);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)"OCIDBAccess.logoff() return");
        }
    }

    public synchronized void initNls(oracle.jdbc.driver.OracleConnection conn) throws SQLException {
        this.setNlsParamsClient(conn);
    }

    public synchronized void commit() throws SQLException, IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)"OCIDBAccess.commit()");
        }
        this.check_error(this.do_commit(), null);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)"OCIDBAccess.commit() return");
        }
    }

    native int do_commit();

    public synchronized void rollback() throws SQLException, IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)"OCIDBAccess.rollback()");
        }
        this.check_error(this.do_rollback(), null);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)"OCIDBAccess.rollback() return");
        }
    }

    native int do_rollback();

    public synchronized void setAutoCommit(boolean auto_commit) throws SQLException, IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)"OCIDBAccess.setAutoCommit()");
        }
        this.check_error(this.set_auto_commit(auto_commit), null);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)"OCIDBAccess.setAutoCommit() return");
        }
    }

    native int set_auto_commit(boolean var1);

    public synchronized DBStatement open() throws SQLException, IOException {
        OCIDBStatement stmt = new OCIDBStatement(this);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)"OCIDBAccess.open()");
        }
        this.check_error(this.make_statement_c_state(stmt), stmt);
        this.check_error(this.open_statement(stmt), stmt);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)("OCIDBAccess.open() return: " + stmt));
        }
        return stmt;
    }

    native int make_statement_c_state(OCIDBStatement var1);

    native int open_statement(OCIDBStatement var1);

    public synchronized void closeQuery(DBStatement dbstmt) throws SQLException, IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)("OCIDBAccess.closeQuery(dbstmt = " + dbstmt + ")"));
        }
        this.check_error(this.close_query((OCIDBStatement)dbstmt), (OCIDBStatement)dbstmt);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)"OCIDBAccess.closeQuery(dbstmt) return");
        }
    }

    native int close_query(OCIDBStatement var1);

    public synchronized void close(DBStatement stmt) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)("OCIDBAccess.close(stmt = " + stmt + ")"));
        }
        ((OCIDBStatement)stmt).binds_initialized = false;
        ((OCIDBStatement)stmt).defines_initialized = false;
        this.check_error(this.close_stmt((OCIDBStatement)stmt), (OCIDBStatement)stmt);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)"OCIDBAccess.close(stmt) return");
        }
    }

    native int close_stmt(OCIDBStatement var1);

    native int do_parse(OCIDBStatement var1, byte[] var2);

    int getByteArrayLength(byte[] barray) {
        return barray.length;
    }

    public synchronized DBColumn[] describe(DBStatement dbstmt) throws SQLException, IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)("OCIDBAccess.describe(dbstmt = " + dbstmt + ")"));
        }
        int num_columns = this.get_column_count((OCIDBStatement)dbstmt);
        this.check_error(num_columns, (OCIDBStatement)dbstmt);
        DBColumn[] Columns = new DBColumn[num_columns];
        ((OCIDBStatement)dbstmt).defines_initialized = false;
        int i2 = 0;
        while (i2 < Columns.length) {
            Columns[i2] = new DBColumn();
            byte[] bytearray = this.get_describe((OCIDBStatement)dbstmt, Columns[i2], i2 + 1);
            if (bytearray != null) {
                this.enterColumnName(bytearray, Columns[i2]);
            } else {
                this.check_error(-1, (OCIDBStatement)dbstmt);
            }
            ++i2;
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)("OCIDBAccess.describe(dbstmt) return: " + Columns));
        }
        return Columns;
    }

    native int get_column_count(OCIDBStatement var1);

    native byte[] get_describe(OCIDBStatement var1, DBColumn var2, int var3);

    void enterColumnName(byte[] bytearray, DBColumn column) throws SQLException {
        column.name = this.conversion.CharBytesToString(bytearray, bytearray.length);
    }

    void initObjectFields(DBColumn column, byte[] obj_type_name) throws SQLException {
        String type_name_str = this.conversion.CharBytesToString(obj_type_name, obj_type_name.length);
        column.otype = new OracleTypeADT(type_name_str);
    }

    void setObjectFields(DBType value_type, byte[] obj_type_name, long tdo_ptr) throws SQLException {
        String type_name_str = this.conversion.CharBytesToString(obj_type_name, obj_type_name.length);
        value_type.otype = new OracleTypeADT(type_name_str);
        ((OracleTypeADT)value_type.otype).setTDO_C_STATE(tdo_ptr);
    }

    void initRefFields(DBColumn column, byte[] obj_type_name) throws SQLException {
        String type_name_str = this.conversion.CharBytesToString(obj_type_name, obj_type_name.length);
        column.otype = new OracleTypeADT(type_name_str);
    }

    long getTDOPtr(DBType type) {
        if (type != null && type.otype != null) {
            return ((OracleTypeADT)type.otype).getTDO_C_STATE();
        }
        return 0L;
    }

    public void getForm(OracleTypeADT otypeADT, OracleTypeCLOB otype, int attrIndex) throws SQLException {
        boolean value = false;
        if (otype != null) {
            SQLName sqlname = new SQLName(otypeADT.getFullName(), otypeADT.getConnection());
            String fullname = "\"" + sqlname.getSchema() + "\".\"" + sqlname.getSimpleName() + "\"";
            byte[] utf8bytes = this.conversion.StringToCharBytes(fullname);
            this.check_error(this.getFormOfUse(otype, utf8bytes, utf8bytes.length, attrIndex), null);
        } else if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)2, (String)("OCIDBAccess.getFrom(otype, attrIndex = " + attrIndex + "): otype is null"));
        }
    }

    native int getFormOfUse(OracleTypeCLOB var1, byte[] var2, int var3, int var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized DBColumn[] parseExecuteDescribe(DBStatement dbstmt, byte[] sqlstmt, DBDataSet inDBSet) throws SQLException, IOException {
        DBColumn[] dBColumnArray;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)("OCIDBAccess.parseExecuteDescribe(dbstmt = " + dbstmt + ", sqlstmt = " + sqlstmt + ", inDBSet = " + inDBSet + ")"));
        }
        DBType[] in_types = null;
        DBData[] in_values = null;
        if (inDBSet != null) {
            in_types = ((DBDataSetImpl)inDBSet).getDBTypes();
            in_values = ((DBDataSetImpl)inDBSet).getDBData();
        }
        try {
            int i2;
            int batch = 1;
            this.start_index = 0;
            this.end_index = 0;
            ((OCIDBStatement)dbstmt).defines_initialized = false;
            ((OCIDBStatement)dbstmt).binds_initialized = false;
            this.check_error(this.do_parse((OCIDBStatement)dbstmt, sqlstmt), (OCIDBStatement)dbstmt);
            int len = in_types != null ? in_types.length : 0;
            if (len != 0 && !((OCIDBStatement)dbstmt).binds_initialized) {
                this.check_error(this.initialize_bind_columns((OCIDBStatement)dbstmt, len, batch), null);
                i2 = 0;
                while (i2 < in_types.length) {
                    this.check_error(this.set_up_bind_column((OCIDBStatement)dbstmt, i2, in_types[i2], batch, (byte)1, (byte)0, this.getTDOPtr(in_types[i2])), (OCIDBStatement)dbstmt);
                    int j2 = 0;
                    while (j2 < batch) {
                        DBItem item = in_values[i2].getItem(j2);
                        int value_length = 0;
                        if (item != null) {
                            value_length = item.getBytesLength();
                        }
                        this.check_error(this.set_up_bind_rows((OCIDBStatement)dbstmt, i2, j2, item, value_length), (OCIDBStatement)dbstmt);
                        ++j2;
                    }
                    ++i2;
                }
                ((OCIDBStatement)dbstmt).binds_initialized = true;
            }
            int status = this.do_execute((OCIDBStatement)dbstmt, 0);
            int rp = this.get_number_of_rows_processed((OCIDBStatement)dbstmt);
            dbstmt.rows_processed = rp < 0 ? 0 : rp;
            this.check_error(status, (OCIDBStatement)dbstmt);
            int num_columns = this.check_error(this.get_column_count((OCIDBStatement)dbstmt), (OCIDBStatement)dbstmt);
            DBColumn[] Columns = new DBColumn[num_columns];
            i2 = 0;
            while (i2 < Columns.length) {
                Columns[i2] = new DBColumn();
                byte[] bytearray = this.get_describe((OCIDBStatement)dbstmt, Columns[i2], i2 + 1);
                if (bytearray != null) {
                    this.enterColumnName(bytearray, Columns[i2]);
                } else {
                    this.check_error(-1, (OCIDBStatement)dbstmt);
                }
                ++i2;
            }
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)("OCIDBAccess.parseExecuteDescribe(_, _, _) return: " + Columns));
            }
            dBColumnArray = Columns;
            Object var17_17 = null;
        }
        catch (Throwable throwable) {
            Object var17_18 = null;
            this.free_temp_alloc();
            throw throwable;
        }
        this.free_temp_alloc();
        return dBColumnArray;
    }

    native int initialize_bind_columns(OCIDBStatement var1, int var2, int var3);

    native int set_up_bind_column(OCIDBStatement var1, int var2, DBType var3, int var4, byte var5, byte var6, long var7);

    native int set_up_bind_rows(OCIDBStatement var1, int var2, int var3, DBItem var4, int var5);

    native int do_execute(OCIDBStatement var1, int var2);

    void copy_back_to_next_stream(OCIDBStatement dbstmt, int status) throws SQLException {
        if (this.curr_out_types != null) {
            this.end_index = this.start_index;
            while (this.end_index < this.curr_out_types.length) {
                if (this.curr_out_types[this.end_index] != null) {
                    int item_value_length;
                    DBItem item;
                    if (status > 0) {
                        int row = 0;
                        while (row < status) {
                            item = this.curr_out_values[this.end_index].getItem(row);
                            item_value_length = 0;
                            if (item.byte_value != null) {
                                item_value_length = item.byte_value.length;
                            }
                            this.copy_value_from_defines(dbstmt, this.end_index, row, item, item_value_length);
                            ++row;
                        }
                    } else {
                        item = this.curr_out_values[this.end_index].getItem(0);
                        item_value_length = 0;
                        if (item.byte_value != null) {
                            item_value_length = item.byte_value.length;
                        }
                        this.copy_value_from_defines(dbstmt, this.end_index, 0, item, item_value_length);
                        if (this.curr_out_types[this.end_index].is_stream) {
                            return;
                        }
                    }
                }
                ++this.end_index;
            }
        }
    }

    public native String get_anydata_type(OCIDBStatement var1, int var2, int var3);

    public native int get_anydata_typecode(OCIDBStatement var1, int var2, int var3);

    public native int get_anydata_offset_of_type(OCIDBStatement var1, int var2, int var3);

    void copy_back_to_next_stream_from_binds(OCIDBStatement dbstmt) throws SQLException {
        if (this.curr_out_types != null) {
            this.end_index = this.start_index;
            while (this.end_index < this.curr_out_types.length) {
                if (this.curr_out_types[this.end_index] != null) {
                    DBItem item = this.curr_out_values[this.end_index].getItem(0);
                    int item_value_length = 0;
                    if (item.byte_value != null) {
                        item_value_length = item.byte_value.length;
                    }
                    this.copy_value_from_binds(dbstmt, this.end_index, 0, item, item_value_length, this.end_index == this.curr_out_types.length - 1);
                    if (this.curr_out_types[this.end_index].is_stream) {
                        return;
                    }
                }
                ++this.end_index;
            }
        }
    }

    public synchronized int executeFetch(DBStatement dbstmt, byte type, DBDataSet inDBSet, int batch, DBDataSet outDBSet, int rows) throws SQLException, IOException {
        DBItem item;
        int j2;
        int i2;
        int olen;
        int error_status = 0;
        int maxlen = 0;
        int status = 0;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)("OCIDBAccess.executeFetch(dbstmt = " + dbstmt + ", type = " + type + ", inDBSet = " + inDBSet + ", batch = " + batch + ", outDBSet = " + outDBSet + ", rows = " + rows + ")"));
        }
        DBType[] in_types = null;
        DBData[] in_values = null;
        DBType[] out_types = null;
        DBData[] out_values = null;
        if (inDBSet != null) {
            in_types = ((DBDataSetImpl)inDBSet).getDBTypes();
            in_values = ((DBDataSetImpl)inDBSet).getDBData();
        }
        if (outDBSet != null) {
            out_types = ((DBDataSetImpl)outDBSet).getDBTypes();
            out_values = ((DBDataSetImpl)outDBSet).getDBData();
        }
        int len = in_types != null ? in_types.length : 0;
        if (out_types != null) {
            this.curr_out_values = out_values;
            this.curr_out_types = out_types;
            this.start_index = 0;
            this.end_index = 0;
            olen = out_types.length;
        } else {
            olen = 0;
        }
        maxlen = len < olen ? olen : len;
        if (type == 1 || type == 3) {
            if (!((OCIDBStatement)dbstmt).binds_initialized) {
                this.check_error(this.initialize_bind_columns((OCIDBStatement)dbstmt, maxlen, batch), null);
            }
            i2 = 0;
            while (i2 < maxlen) {
                if (i2 < len && i2 < olen) {
                    if (in_values[i2] != null) {
                        if (out_values[i2] == null) {
                            if (!((OCIDBStatement)dbstmt).binds_initialized) {
                                this.check_error(this.set_up_bind_column((OCIDBStatement)dbstmt, i2, in_types[i2], batch, (byte)1, type, this.getTDOPtr(in_types[i2])), (OCIDBStatement)dbstmt);
                            }
                            j2 = 0;
                            while (j2 < batch) {
                                item = in_values[i2].getItem(j2);
                                int value_length = 0;
                                if (item != null) {
                                    value_length = item.getBytesLength();
                                }
                                this.check_error(this.set_up_bind_rows((OCIDBStatement)dbstmt, i2, j2, item, value_length), (OCIDBStatement)dbstmt);
                                ++j2;
                            }
                        } else {
                            DBType my_type = in_types[i2];
                            if (in_types[i2].type == out_types[i2].type && in_types[i2].max_length < out_types[i2].max_length) {
                                my_type = out_types[i2];
                            }
                            if (!((OCIDBStatement)dbstmt).binds_initialized) {
                                this.check_error(this.set_up_bind_column((OCIDBStatement)dbstmt, i2, my_type, batch, (byte)17, type, this.getTDOPtr(my_type)), (OCIDBStatement)dbstmt);
                            }
                            j2 = 0;
                            while (j2 < batch) {
                                DBItem item2 = in_values[i2].getItem(j2);
                                int value_length = 0;
                                if (item2 != null) {
                                    value_length = item2.getBytesLength();
                                }
                                if (in_types[i2].type == 998) {
                                    ((OCIDBItem)out_values[i2].getItem(j2)).setPlsqlIndexTableItemFields((Datum[])null, 0, (OCIDBType)out_types[i2]);
                                }
                                this.check_error(this.set_up_bind_rows((OCIDBStatement)dbstmt, i2, j2, item2, value_length), (OCIDBStatement)dbstmt);
                                ++j2;
                            }
                        }
                    } else {
                        if (out_values[i2] == null) {
                            if (OracleLog.TRACE) {
                                OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)"OCIDBAccess.executeFetch(_, _, _, _, _, _) returns: 0");
                            }
                            return 0;
                        }
                        if (!((OCIDBStatement)dbstmt).binds_initialized) {
                            this.check_error(this.set_up_bind_column((OCIDBStatement)dbstmt, i2, out_types[i2], batch, (byte)16, type, this.getTDOPtr(out_types[i2])), (OCIDBStatement)dbstmt);
                        }
                        j2 = 0;
                        while (j2 < batch) {
                            item = out_values[i2].getItem(j2);
                            int value_length = 0;
                            if (item != null) {
                                value_length = item.getBytesLength();
                            }
                            if (out_types[i2].type == 998) {
                                ((OCIDBItem)item).setPlsqlIndexTableItemFields((Datum[])null, 0, (OCIDBType)out_types[i2]);
                            }
                            this.check_error(this.set_up_bind_rows((OCIDBStatement)dbstmt, i2, j2, item, value_length), (OCIDBStatement)dbstmt);
                            ++j2;
                        }
                    }
                } else if (i2 >= len && i2 < olen) {
                    if (!((OCIDBStatement)dbstmt).binds_initialized) {
                        this.check_error(this.set_up_bind_column((OCIDBStatement)dbstmt, i2, out_types[i2], batch, (byte)16, type, this.getTDOPtr(out_types[i2])), (OCIDBStatement)dbstmt);
                    }
                    j2 = 0;
                    while (j2 < batch) {
                        int value_length = 0;
                        item = out_values[i2].getItem(j2);
                        if (item != null) {
                            value_length = item.getBytesLength();
                        }
                        if (out_types[i2].type == 998) {
                            ((OCIDBItem)item).setPlsqlIndexTableItemFields((Datum[])null, 0, (OCIDBType)out_types[i2]);
                        }
                        this.check_error(this.set_up_bind_rows((OCIDBStatement)dbstmt, i2, j2, item, value_length), (OCIDBStatement)dbstmt);
                        ++j2;
                    }
                } else if (i2 >= olen && i2 < len) {
                    if (!((OCIDBStatement)dbstmt).binds_initialized) {
                        this.check_error(this.set_up_bind_column((OCIDBStatement)dbstmt, i2, in_types[i2], batch, (byte)1, type, this.getTDOPtr(in_types[i2])), (OCIDBStatement)dbstmt);
                    }
                    j2 = 0;
                    while (j2 < batch) {
                        item = in_values[i2].getItem(j2);
                        int value_length = 0;
                        if (item != null) {
                            value_length = item.getBytesLength();
                        }
                        this.check_error(this.set_up_bind_rows((OCIDBStatement)dbstmt, i2, j2, item, value_length), (OCIDBStatement)dbstmt);
                        ++j2;
                    }
                }
                ++i2;
            }
        } else if (len != 0) {
            if (!((OCIDBStatement)dbstmt).binds_initialized) {
                this.check_error(this.initialize_bind_columns((OCIDBStatement)dbstmt, in_types.length, batch), null);
            }
            i2 = 0;
            while (i2 < in_types.length) {
                if (in_types[i2] != null) {
                    if (!((OCIDBStatement)dbstmt).binds_initialized) {
                        this.check_error(this.set_up_bind_column((OCIDBStatement)dbstmt, i2, in_types[i2], batch, (byte)1, type, this.getTDOPtr(in_types[i2])), (OCIDBStatement)dbstmt);
                    }
                    j2 = 0;
                    while (j2 < batch) {
                        item = in_values[i2].getItem(j2);
                        int value_length = 0;
                        if (item != null) {
                            value_length = item.getBytesLength();
                        }
                        this.check_error(this.set_up_bind_rows((OCIDBStatement)dbstmt, i2, j2, item, value_length), (OCIDBStatement)dbstmt);
                        ++j2;
                    }
                }
                ++i2;
            }
        }
        ((OCIDBStatement)dbstmt).binds_initialized = true;
        if (type != 1 && type != 3 && out_values != null && (len = out_values != null ? out_values.length : 0) != 0 && !((OCIDBStatement)dbstmt).defines_initialized) {
            this.check_error(this.initialize_define_columns((OCIDBStatement)dbstmt, out_types.length, rows), null);
            i2 = 0;
            while (i2 < out_types.length) {
                if (out_types[i2] != null) {
                    this.check_error(this.set_up_define_column((OCIDBStatement)dbstmt, i2, out_types[i2], rows, this.getTDOPtr(out_types[i2])), (OCIDBStatement)dbstmt);
                }
                ++i2;
            }
            ((OCIDBStatement)dbstmt).defines_initialized = true;
        }
        status = this.do_execute((OCIDBStatement)dbstmt, rows);
        int rp = this.get_number_of_rows_processed((OCIDBStatement)dbstmt);
        dbstmt.rows_processed = rp < 0 ? 0 : rp;
        this.check_error(status, (OCIDBStatement)dbstmt);
        if (type != 1 && type != 3 && olen > 0) {
            ((OCIDBStatement)dbstmt).row_prefetch = rows;
            status = this.do_fetch((OCIDBStatement)dbstmt, rows, error_status);
            if (status != -2 && status < 0) {
                this.check_error(status, (OCIDBStatement)dbstmt);
            }
        }
        if (out_values != null) {
            if (type == 0) {
                this.copy_back_to_next_stream((OCIDBStatement)dbstmt, status);
            } else if (type == 1 || type == 3) {
                this.copy_back_to_next_stream_from_binds((OCIDBStatement)dbstmt);
            }
        }
        if (status != -2 && type != 1 && type != 3) {
            this.free_temp_alloc();
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)("OCIDBAccess.executeFetch(_, _, _, _, _, _) returns: " + status));
        }
        return status;
    }

    native void free_temp_alloc();

    native int initialize_define_columns(OCIDBStatement var1, int var2, int var3);

    native int get_number_of_rows_processed(OCIDBStatement var1);

    native int set_up_define_column(OCIDBStatement var1, int var2, DBType var3, int var4, long var5);

    native void copy_value_from_binds(OCIDBStatement var1, int var2, int var3, DBItem var4, int var5, boolean var6);

    native void copy_value_from_defines(OCIDBStatement var1, int var2, int var3, DBItem var4, int var5);

    public synchronized int parseExecuteFetch(DBStatement dbstmt, byte type, byte[] sqlstmt, DBDataSet inDBSet, int batch, DBDataSet outDBSet, int rows) throws SQLException, IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)("OCIDBAccess.parseExecuteFetch(dbstmt = " + dbstmt + ", type = " + type + ", sqlstmt = " + sqlstmt + ", inDBSet = " + inDBSet + ", batch = " + batch + ", outDBSet = " + outDBSet + ", rows = " + rows + ")"));
        }
        this.check_error(this.do_parse((OCIDBStatement)dbstmt, sqlstmt), (OCIDBStatement)dbstmt);
        ((OCIDBStatement)dbstmt).defines_initialized = false;
        ((OCIDBStatement)dbstmt).binds_initialized = false;
        int status = this.executeFetch(dbstmt, type, inDBSet, batch, outDBSet, rows);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)("OCIDBAccess.parseExecuteFetch(_, _,  _, _, _, _, _) returns: " + status));
        }
        return status;
    }

    native int do_fetch(OCIDBStatement var1, int var2, int var3);

    public synchronized int fetch(DBStatement dbstmt, DBDataSet outDBSet, int rows) throws SQLException, IOException {
        int len;
        int error_status = 0;
        int status = 0;
        DBType[] out_types = null;
        DBData[] out_values = null;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)("OCIDBAccess.fetch(dbstmt = " + dbstmt + ", outDBSet = " + outDBSet + ", rows = " + rows + ")"));
        }
        if (outDBSet != null) {
            out_types = ((DBDataSetImpl)outDBSet).getDBTypes();
            out_values = ((DBDataSetImpl)outDBSet).getDBData();
        }
        if ((len = out_types != null ? out_types.length : 0) != 0) {
            this.curr_out_values = out_values;
            this.curr_out_types = out_types;
            this.start_index = 0;
            this.end_index = 0;
            if (!((OCIDBStatement)dbstmt).defines_initialized || ((OCIDBStatement)dbstmt).row_prefetch != rows) {
                this.check_error(this.initialize_define_columns((OCIDBStatement)dbstmt, out_types.length, rows), null);
                int i2 = 0;
                while (i2 < out_types.length) {
                    if (out_types[i2] != null) {
                        this.check_error(this.set_up_define_column((OCIDBStatement)dbstmt, i2, out_types[i2], rows, this.getTDOPtr(out_types[i2])), (OCIDBStatement)dbstmt);
                    }
                    ++i2;
                }
                ((OCIDBStatement)dbstmt).defines_initialized = true;
            }
            ((OCIDBStatement)dbstmt).row_prefetch = rows;
            status = this.do_fetch((OCIDBStatement)dbstmt, rows, error_status);
            if (status != -2 && status < 0) {
                this.check_error(status, (OCIDBStatement)dbstmt);
            } else {
                this.copy_back_to_next_stream((OCIDBStatement)dbstmt, status);
            }
        }
        if (status != -2 || status < rows) {
            this.free_temp_alloc();
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)("OCIDBAccess.fetch(dbstmt, outDBSet, rows) returns: " + status));
        }
        return status;
    }

    public int fetch(DBStatement dbstmt, DBDataSet outDBSet, int from_col, int to_col) throws SQLException, IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)("OCIDBAccess.fetch(dbstmt = " + dbstmt + ", outDBSet = " + outDBSet + ", from_col = " + from_col + ", to_col = " + to_col + ")"));
        }
        return 0;
    }

    public synchronized int read(DBStatement dbstmt, byte[] buffer, int length) throws SQLException, IOException {
        DBError.throwSqlException((int)89);
        return -1;
    }

    public synchronized int read(DBStatement dbstmt, byte[] buffer, int length, int colIndex) throws SQLException, IOException {
        int stat;
        int status = 0;
        int min = length;
        int max_length = 0;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)("OCIDBAccess.read(dbstmt = " + dbstmt + ", buffer = " + buffer + ", length = " + length + ")"));
        }
        if (this.curr_out_values != null) {
            max_length = this.curr_out_values[this.end_index].getItem((int)0).max_out_size;
            min = max_length < length ? max_length : length;
        }
        if (min > 0x3FFFFFC) {
            DBError.throwSqlException((int)68);
        }
        if ((stat = this.do_read((OCIDBStatement)dbstmt, buffer, min, status, colIndex)) == -1) {
            this.check_error(stat, (OCIDBStatement)dbstmt);
        }
        if (stat == 0) {
            this.start_index = this.end_index + 1;
            this.copy_back_to_next_stream((OCIDBStatement)dbstmt, stat);
            if (this.curr_out_values != null && this.end_index >= this.curr_out_values.length) {
                this.free_temp_alloc();
                this.start_index = 0;
                this.end_index = 0;
                this.curr_out_values = null;
                this.curr_out_types = null;
            }
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)"OCIDBAccess.read(dbstmt, buffer, length) returns: -1");
            }
            return -1;
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)("OCIDBAccess.read(dbstmt, buffer, length) returns: " + stat));
        }
        return stat;
    }

    native int do_read(OCIDBStatement var1, byte[] var2, int var3, int var4, int var5);

    public synchronized byte[] getVersion() throws SQLException, IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)"OCIDBAccess.getVersion()");
        }
        return this.get_database_version();
    }

    native byte[] get_database_version();

    byte[] makeByteArray(int size) {
        if (size == 0) {
            return null;
        }
        return new byte[size];
    }

    public int getDefaultPrefetch() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)"OCIDBAccess.getDefaultPrefetch()");
        }
        return 10;
    }

    public int getDefaultStreamChunkSize() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)"OCIDBAccess.getDefaultStreamChunkSize()");
        }
        return this.m_streamChunkSize;
    }

    public static Connection defaultConnection() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)1024, (int)2, (int)16, (String)"OCIDBAccess.defaultConnection()");
        }
        return DriverManager.getConnection("jdbc:oracle:oci8:@", "scott", "tiger");
    }

    public void cancel() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)1024, (int)2, (int)16, (String)"OCIDBAccess.cancel()");
        }
        this.check_error(this.conn_cancel(), null);
    }

    native int conn_cancel();

    int check_error(int status, OCIDBStatement stmt) throws SQLException {
        if (status >= 0) {
            return status;
        }
        this.free_temp_alloc();
        switch (status) {
            case -93: 
            case -1: {
                String sqlstate_string;
                OCIDBError description = new OCIDBError();
                this.describe_error(stmt, description);
                byte[] reason_bytearr = description.reason;
                String reason_string = this.conversion.CharBytesToString(reason_bytearr, reason_bytearr.length);
                if (description.SQLState == null || description.SQLState.length == 0) {
                    sqlstate_string = DBError.ErrorToSQLState((int)description.vendorCode);
                } else {
                    byte[] sqlstate_bytearr = description.SQLState;
                    sqlstate_string = this.conversion.CharBytesToString(sqlstate_bytearr, sqlstate_bytearr.length);
                }
                switch (description.vendorCode) {
                    case 28: 
                    case 600: 
                    case 1012: 
                    case 3113: 
                    case 3114: {
                        if (this.m_connection == null) break;
                        this.m_connection.internalClose((DBAccess)this);
                    }
                }
                if (status == -1) {
                    DBError.throwSqlException((String)reason_string, (String)sqlstate_string, (int)description.vendorCode);
                    break;
                }
                SQLWarning currentWarning = stmt == null ? this.getConnectionWarning() : this.getStatementWarning();
                currentWarning = DBError.addSqlWarning((SQLWarning)currentWarning, (String)reason_string, (String)sqlstate_string, (int)description.vendorCode);
                if (stmt == null) {
                    this.connectionWarning = currentWarning;
                    break;
                }
                this.statementWarning = currentWarning;
                break;
            }
            default: {
                DBError.throwSqlException((int)(-1 * status), (Object)stmt);
            }
        }
        return 0;
    }

    native void describe_error(OCIDBStatement var1, OCIDBError var2);

    public synchronized DBStatement RefCursorBytesToDBStatement(byte[] array) throws SQLException {
        return this.RefCursorBytesToDBStatement(null, array);
    }

    public synchronized DBStatement RefCursorBytesToDBStatement(DBStatement dbstmt, byte[] array) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)("OCIDBAccess.RefCursorBytesToDBStatement(array = " + array + ")"));
        }
        OCIDBStatement stmt = new OCIDBStatement(this);
        long parent = 0L;
        if (dbstmt != null) {
            parent = ((OCIDBStatement)dbstmt).c_state;
        }
        this.make_statement(stmt, array, parent);
        int num_columns = this.get_column_count(stmt);
        try {
            this.check_error(num_columns, stmt);
        }
        catch (SQLException ex) {
            this.close((DBStatement)stmt);
            throw ex;
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)("OCIDBAccess.RefCursorBytesToDBStatement(array) return: " + stmt));
        }
        return stmt;
    }

    native int make_statement(OCIDBStatement var1, byte[] var2, long var3);

    public synchronized byte[] DBStatementToRefCursorBytes(DBStatement dbstmt) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)("OCIDBAccess.DBStatementToRefCursorBytes(dbstmt = " + dbstmt + ")"));
        }
        return this.get_cursor_bytes((OCIDBStatement)dbstmt);
    }

    native byte[] get_cursor_bytes(OCIDBStatement var1);

    native int get_cursor_size();

    public synchronized void startup(String startup_str, int mode) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)("OCIDBAccess.startup(startup_str = " + startup_str + ", mode = " + mode + ")"));
        }
        int strlen = startup_str.length();
        byte[] bytearr = new byte[strlen];
        startup_str.getBytes(0, strlen, bytearr, 0);
        this.check_error(this.startup_db(bytearr, strlen, mode), null);
    }

    native int startup_db(byte[] var1, int var2, int var3);

    public synchronized void shutdown(int mode) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)("OCIDBAccess.shutdown(mode = " + mode + ")"));
        }
        this.check_error(this.shutdown_db(mode), null);
    }

    native int shutdown_db(int var1);

    public synchronized void archive(int mode, int aseq, String acstext) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)("OCIDBAccess.archive(mode = " + mode + ", aseq = " + aseq + ", acstext = " + acstext + ")"));
        }
        int acstextlen = acstext.length();
        byte[] bytearr = new byte[acstextlen];
        acstext.getBytes(0, acstextlen, bytearr, 0);
        this.check_error(this.archive_db(mode, aseq, bytearr, acstextlen), null);
    }

    native int archive_db(int var1, int var2, byte[] var3, int var4);

    public synchronized void getOracleTypeADT(OracleTypeADT otype) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)("OCIDBAccess.getOracleTypeADT(otype = " + otype + ")"));
        }
        if (otype != null) {
            SQLName sqlname = new SQLName(otype.getFullName(), otype.getConnection());
            String fullname = "\"" + sqlname.getSchema() + "\".\"" + sqlname.getSimpleName() + "\"";
            byte[] utf8bytes = this.conversion.StringToCharBytes(fullname);
            this.check_error(this.get_tdo_ptr(otype, utf8bytes, utf8bytes.length), null);
        } else if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)2, (String)"OCIDBAccess.getOracleTypeADT(otype): otype is null");
        }
    }

    native int get_tdo_ptr(OracleTypeADT var1, byte[] var2, int var3);

    public synchronized void getObjectValueFromRef(DBItem ref_item, DBType ref_type, DBItem value_item, DBType value_type) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)("OCIDBAccess.getObjectValueFromRef(ref_item = " + ref_item + ", ref_type = " + ref_type + ", value_item = " + value_item + ", value_type = " + value_type + ")"));
        }
    }

    public void setObjectValueFromRef(DBItem ref_item, DBType ref_type, DBItem value_item, DBType value_type) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)("OCIDBAccess.setObjectValueFromRef(ref_item = " + ref_item + ", ref_type = " + ref_type + ", value_item = " + value_item + ", value_type = " + value_type + ")"));
        }
    }

    public synchronized short getVersionNumber() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)"OCIDBAccess.getVersionNumber()");
        }
        if (this.version_num == 0) {
            try {
                byte[] version = this.getVersion();
                if (this.logon_mode == 5) {
                    return 9000;
                }
                String ver_str = this.conversion.CharBytesToString(version, version.length);
                StringTokenizer st = new StringTokenizer(ver_str.trim(), " .", false);
                String tk = null;
                int ct = 0;
                short num = 0;
                while (st.hasMoreTokens()) {
                    tk = st.nextToken();
                    try {
                        num = Integer.decode(tk).shortValue();
                        this.version_num = (short)(this.version_num * 10 + num);
                        if (++ct != 4) continue;
                        break;
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                }
            }
            catch (NoSuchElementException ne) {
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        if (this.version_num == -1 || this.version_num == -8) {
            this.version_num = 0;
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)("OCIDBAccess.getVersionNumber() return: " + this.version_num));
        }
        return this.version_num;
    }

    native short get_pointer_size();

    private short getPointerSize() {
        if (this.m_pointerSize == 0) {
            this.m_pointerSize = this.get_pointer_size();
        }
        return this.m_pointerSize;
    }

    public DBType createDBType(int type, boolean isBind) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)("OCIDBAccess.createDBType(type = " + type + ", isBind = " + isBind + ")"));
        }
        if (type == 102) {
            return new OCIDBType(this, type, this.get_cursor_size(), this.version_num, isBind);
        }
        switch (type) {
            case 104: {
                return new OCIDBType(this, 104, 4096, this.version_num, isBind);
            }
            case 112: 
            case 113: 
            case 114: {
                return new OCIDBType(this, type, 1024, this.version_num, isBind);
            }
        }
        return new OCIDBType(this, type, this.version_num, isBind);
    }

    public synchronized DBType createDBType(int type, boolean isInBind, boolean isPlsql) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)("OCIDBAccess.createDBType(type = " + type + ", isInBind = " + isInBind + ", isPlsql = " + isPlsql + ")"));
        }
        DBType newType = this.createDBType(type, true);
        if (isPlsql && !isInBind) {
            newType.setPlsqlMaxLength();
        }
        return newType;
    }

    public DBItem createDBItem(DBType dbtype) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)("OCIDBAccess.createDBItem(dbtype = " + dbtype + ")"));
        }
        if (dbtype.type == 109) {
            OracleTypeADT ntype = (OracleTypeADT)dbtype.otype;
            if (ntype != null && ntype.getSimpleName().equals("ANYDATA")) {
                return new OCIDBItem();
            }
            return new DBItem(dbtype.max_length);
        }
        if (dbtype.type == 998) {
            return new OCIDBItem();
        }
        return new DBItem(dbtype.max_length);
    }

    native long blob_read(byte[] var1, int var2, long var3, long var5, byte[] var7, int var8);

    native long clob_read(byte[] var1, int var2, long var3, long var5, char[] var7, int var8, boolean var9, int var10);

    public synchronized long lobRead(BLOB blob, long offset, long amount, byte[] buffer) throws SQLException {
        byte[] locator = null;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)("OCIDBAccess.lobRead(blob = " + blob + ", offset = " + offset + ", amount = " + amount + ", buffer = " + buffer + ")"));
        }
        if (blob == null || (locator = blob.getLocator()) == null) {
            DBError.throwSqlException((int)54);
        }
        if (amount <= 0L || buffer == null) {
            return 0L;
        }
        if (amount > (long)buffer.length) {
            amount = buffer.length;
        }
        return this.blobRead(locator, offset, amount, buffer);
    }

    public synchronized long lobRead(BFILE bfile, long offset, long amount, byte[] buffer) throws SQLException {
        byte[] locator = null;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)("OCIDBAccess.lobRead(bfile = " + bfile + ", offset = " + offset + ", amount = " + amount + ", buffer = " + buffer + ")"));
        }
        if (bfile == null || (locator = bfile.getLocator()) == null) {
            DBError.throwSqlException((int)54);
        }
        if (amount <= 0L || buffer == null) {
            return 0L;
        }
        if (amount > (long)buffer.length) {
            amount = buffer.length;
        }
        return this.blobRead(locator, offset, amount, buffer);
    }

    public synchronized long lobRead(CLOB clob, long offset, long amount, char[] buffer) throws SQLException {
        byte[] locator = null;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)("OCIDBAccess.lobRead(clob = " + clob + ", offset = " + offset + ", amount = " + amount + ", buffer = " + buffer + ")"));
        }
        if (clob == null || (locator = clob.getLocator()) == null) {
            DBError.throwSqlException((int)54);
        }
        if (amount <= 0L || buffer == null) {
            return 0L;
        }
        if (amount > (long)buffer.length) {
            amount = buffer.length;
        }
        return this.clobRead(locator, offset, amount, buffer, clob.isNCLOB());
    }

    private long blobRead(byte[] locator, long offset, long amount, byte[] buffer) throws SQLException {
        long result = 0L;
        if (amount > 0x3FFFFFCL) {
            DBError.throwSqlException((int)68);
        }
        if ((result = this.blob_read(locator, locator.length, offset, amount, buffer, buffer.length)) < 0L) {
            this.check_error((int)result, null);
        }
        return result;
    }

    private long clobRead(byte[] locator, long offset, long amount, char[] buffer, boolean isNclob) throws SQLException {
        long result = 0L;
        if (amount > 0x3FFFFFCL) {
            DBError.throwSqlException((int)68);
        }
        if ((result = this.clob_read(locator, locator.length, offset, amount, buffer, buffer.length, isNclob, (int)(isNclob ? this.db_nchar_set : (short)0))) < 0L) {
            this.check_error((int)result, null);
        }
        return result;
    }

    native long blob_write(byte[] var1, int var2, long var3, long var5, byte[] var7, byte[] var8, int var9);

    native long clob_write(byte[] var1, int var2, long var3, long var5, char[] var7, byte[] var8, int var9, boolean var10, int var11);

    public synchronized long lobWrite(BLOB blob, long offset, byte[] buffer, int length) throws SQLException {
        byte[] locator = null;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)("OCIDBAccess.lobWrite(blob = " + blob + ", offset = " + offset + ", buffer = " + buffer + ", length = " + length + ")"));
        }
        if (blob == null || (locator = blob.getLocator()) == null) {
            DBError.throwSqlException((int)54);
        }
        if (buffer == null) {
            return 0L;
        }
        DBType blobType = this.createDBType(113, false);
        byte[] newLocator = new byte[blobType.max_length];
        long result = this.blobWrite(locator, offset, buffer, newLocator, length);
        blob.setLocator(newLocator);
        return result;
    }

    public synchronized long lobWrite(CLOB clob, long offset, char[] buffer, int length) throws SQLException {
        byte[] locator = null;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)("OCIDBAccess.lobWrite(clob = " + clob + ", offset = " + offset + ", buffer = " + buffer + ", length = " + length + ")"));
        }
        if (clob == null || (locator = clob.getLocator()) == null) {
            DBError.throwSqlException((int)54);
        }
        if (buffer == null) {
            return 0L;
        }
        DBType clobType = this.createDBType(112, false);
        byte[] newLocator = new byte[clobType.max_length];
        long result = this.clobWrite(locator, offset, buffer, newLocator, clob.isNCLOB(), length);
        clob.setLocator(newLocator);
        return result;
    }

    private long blobWrite(byte[] locator, long offset, byte[] buffer, byte[] newLocator, int amount) throws SQLException {
        long result = 0L;
        result = this.blob_write(locator, locator.length, offset, (long)amount, buffer, newLocator, newLocator.length);
        if (result < 0L) {
            this.check_error((int)result, null);
        }
        return result;
    }

    private long clobWrite(byte[] locator, long offset, char[] buffer, byte[] newLocator, boolean isNclob, int amount) throws SQLException {
        long result = 0L;
        result = this.clob_write(locator, locator.length, offset, (long)amount, buffer, newLocator, newLocator.length, isNclob, (int)(isNclob ? this.db_nchar_set : (short)0));
        if (result < 0L) {
            this.check_error((int)result, null);
        }
        return result;
    }

    public synchronized long lobLength(BLOB blob) throws SQLException {
        byte[] locator = null;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)("OCIDBAccess.lobLength(blob = " + blob + ")"));
        }
        if (blob == null || (locator = blob.getLocator()) == null) {
            DBError.throwSqlException((int)54);
        }
        return this.lobLength(locator);
    }

    public synchronized long lobLength(BFILE bfile) throws SQLException {
        byte[] locator = null;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)("OCIDBAccess.lobLength(bfile = " + bfile + ")"));
        }
        if (bfile == null || (locator = bfile.getLocator()) == null) {
            DBError.throwSqlException((int)54);
        }
        return this.lobLength(locator);
    }

    public synchronized long lobLength(CLOB clob) throws SQLException {
        byte[] locator = null;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)("OCIDBAccess.lobLength(clob = " + clob + ")"));
        }
        if (clob == null || (locator = clob.getLocator()) == null) {
            DBError.throwSqlException((int)54);
        }
        return this.lobLength(locator);
    }

    native long lob_getlength(byte[] var1, int var2);

    private long lobLength(byte[] locator) throws SQLException {
        long result = 0L;
        result = this.lob_getlength(locator, locator.length);
        if (result < 0L) {
            this.check_error((int)result, null);
        }
        return result;
    }

    public synchronized void fileOpen(BFILE bfile) throws SQLException {
        byte[] locator = null;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)("OCIDBAccess.fileOpen(bfile = " + bfile + ")"));
        }
        if (bfile == null || (locator = bfile.getLocator()) == null) {
            DBError.throwSqlException((int)54);
        }
        DBType bfileType = this.createDBType(114, false);
        byte[] newLocator = new byte[bfileType.max_length];
        this.check_error(this.bfile_open(locator, locator.length, newLocator, newLocator.length), null);
        bfile.setLocator(newLocator);
    }

    native int bfile_open(byte[] var1, int var2, byte[] var3, int var4);

    public synchronized boolean fileIsOpen(BFILE bfile) throws SQLException {
        byte[] locator = null;
        int result = 0;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)("OCIDBAccess.fileIsOpen(bfile = " + bfile + ")"));
        }
        if (bfile == null || (locator = bfile.getLocator()) == null) {
            DBError.throwSqlException((int)54);
        }
        result = this.bfile_isOpen(locator, locator.length);
        this.check_error(result, null);
        return result == 1;
    }

    native int bfile_isOpen(byte[] var1, int var2);

    public synchronized boolean fileExists(BFILE bfile) throws SQLException {
        int result = 0;
        byte[] locator = null;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)("OCIDBAccess.fileExists(bfile = " + bfile + ")"));
        }
        if (bfile == null || (locator = bfile.getLocator()) == null) {
            DBError.throwSqlException((int)54);
        }
        result = this.bfile_exists(locator, locator.length);
        this.check_error(result, null);
        return result == 1;
    }

    native int bfile_exists(byte[] var1, int var2);

    public synchronized String fileGetName(BFILE bfile) throws SQLException {
        byte[] locator = null;
        String fileName = null;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)("OCIDBAccess.fileGetName(bfile = " + bfile + ")"));
        }
        if (bfile == null || (locator = bfile.getLocator()) == null) {
            DBError.throwSqlException((int)54);
        }
        fileName = this.bfile_getName(locator, locator.length);
        this.check_error(fileName.length(), null);
        return fileName;
    }

    native String bfile_getName(byte[] var1, int var2);

    public synchronized String fileGetDirAlias(BFILE bfile) throws SQLException {
        byte[] locator = null;
        String aliasName = null;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)("OCIDBAccess.fileGetDirAlias(bfile = " + bfile + ")"));
        }
        if (bfile == null || (locator = bfile.getLocator()) == null) {
            DBError.throwSqlException((int)54);
        }
        aliasName = this.bfile_getDirAlias(locator, locator.length);
        this.check_error(aliasName.length(), null);
        return aliasName;
    }

    native String bfile_getDirAlias(byte[] var1, int var2);

    public synchronized void fileClose(BFILE bfile) throws SQLException {
        byte[] locator = null;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)("OCIDBAccess.fileClose(bfile = " + bfile + ")"));
        }
        if (bfile == null || (locator = bfile.getLocator()) == null) {
            DBError.throwSqlException((int)54);
        }
        DBType bfileType = this.createDBType(114, false);
        byte[] newLocator = new byte[bfileType.max_length];
        this.check_error(this.bfile_close(locator, locator.length, newLocator, newLocator.length), null);
        bfile.setLocator(newLocator);
    }

    native int bfile_close(byte[] var1, int var2, byte[] var3, int var4);

    public long getLobChunkSize(BLOB blob) throws SQLException {
        byte[] locator = null;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)("OCIDBAccess.getLobChunkSize(blob = " + blob + ")"));
        }
        if (blob == null || (locator = blob.getLocator()) == null) {
            DBError.throwSqlException((int)54);
        }
        return this.lobGetChunkSize(locator);
    }

    public long getLobChunkSize(CLOB clob) throws SQLException {
        byte[] locator = null;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)("OCIDBAccess.getLobChunkSize(clob = " + clob + ")"));
        }
        if (clob == null || (locator = clob.getLocator()) == null) {
            DBError.throwSqlException((int)54);
        }
        return this.lobGetChunkSize(locator);
    }

    private synchronized long lobGetChunkSize(byte[] locator) throws SQLException {
        int result = 0;
        result = this.lob_getChunkSize(locator, locator.length);
        this.check_error(result, null);
        return result;
    }

    native int lob_getChunkSize(byte[] var1, int var2);

    public synchronized void trimLob(Connection conn, Datum lob, int type, long newlen) throws SQLException {
        byte[] locator = null;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)("OCIDBAccess.trimLob(conn = " + conn + ", lob = " + lob + ", type = " + type + ", newlen = " + newlen + ")"));
        }
        if (lob == null || (locator = lob.shareBytes()) == null) {
            DBError.throwSqlException((int)54);
        }
        DBType lobType = null;
        switch (type) {
            case 2004: {
                lobType = this.createDBType(113, false);
                break;
            }
            case 2005: {
                lobType = this.createDBType(112, false);
                break;
            }
            case -13: {
                lobType = this.createDBType(114, false);
                break;
            }
            default: {
                return;
            }
        }
        byte[] newLocator = new byte[lobType.max_length];
        this.check_error(this.lob_trim(type, newlen, locator, locator.length, newLocator, newLocator.length), null);
        lob.setShareBytes(newLocator);
    }

    native int lob_trim(int var1, long var2, byte[] var4, int var5, byte[] var6, int var7);

    public synchronized Datum createTemporaryLob(Connection conn, boolean cache, int duration, int type, short form) throws SQLException {
        DatumWithConnection lob = null;
        DBType lobType = null;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)("OCIDBAccess.createTemporaryLob(conn = " + conn + ", cache = " + cache + ", duration = " + duration + ", type = " + type + ", form = " + form + ")"));
        }
        switch (type) {
            case 2004: {
                lobType = this.createDBType(113, false);
                lob = new BLOB((oracle.jdbc.driver.OracleConnection)conn);
                break;
            }
            case 2005: {
                lobType = this.createDBType(112, false);
                lobType.FormOfUse = form;
                lob = new CLOB((OracleConnection)((oracle.jdbc.driver.OracleConnection)conn), form);
                break;
            }
            case -13: {
                lobType = this.createDBType(114, false);
                lob = new BFILE((oracle.jdbc.driver.OracleConnection)conn);
                break;
            }
            default: {
                return null;
            }
        }
        byte[] newLocator = new byte[lobType.max_length];
        this.check_error(this.lob_createTemporary(type, cache, duration, newLocator, newLocator.length, form), null);
        lob.setShareBytes(newLocator);
        return lob;
    }

    native int lob_createTemporary(int var1, boolean var2, int var3, byte[] var4, int var5, short var6);

    public synchronized void freeTemporaryLob(Connection conn, Datum temp_lob, int type) throws SQLException {
        byte[] locator = null;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)("OCIDBAccess.freeTemporaryLob(conn = " + conn + ", temp_lob = " + temp_lob + ", type = " + type + ")"));
        }
        if (temp_lob == null || (locator = temp_lob.shareBytes()) == null) {
            DBError.throwSqlException((int)54);
        }
        DBType lobType = null;
        switch (type) {
            case 2004: {
                lobType = this.createDBType(113, false);
                break;
            }
            case 2005: {
                lobType = this.createDBType(112, false);
                break;
            }
            case -13: {
                lobType = this.createDBType(114, false);
                break;
            }
            default: {
                return;
            }
        }
        byte[] newLocator = new byte[lobType.max_length];
        this.check_error(this.lob_freeTemporary(type, locator, locator.length, newLocator, newLocator.length), null);
        temp_lob.setShareBytes(newLocator);
    }

    native int lob_freeTemporary(int var1, byte[] var2, int var3, byte[] var4, int var5);

    public synchronized boolean isTemporaryLob(Connection conn, Datum lob, int type) throws SQLException {
        byte[] locator = null;
        int result = 0;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)("OCIDBAccess.isTemporaryLob(conn = " + conn + ", lob = " + lob + ", type = " + type + ")"));
        }
        if (lob == null || (locator = lob.shareBytes()) == null) {
            DBError.throwSqlException((int)54);
        }
        result = this.lob_isTemporary(type, locator, locator.length);
        this.check_error(result, null);
        return result == 1;
    }

    native int lob_isTemporary(int var1, byte[] var2, int var3);

    public synchronized void openLob(Connection conn, Datum lob, int mode, int type) throws SQLException {
        byte[] locator = null;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)("OCIDBAccess.openLob(conn = " + conn + ", lob = " + lob + ", mode = " + mode + ", type = " + type + ")"));
        }
        if (lob == null || (locator = lob.shareBytes()) == null) {
            DBError.throwSqlException((int)54);
        }
        DBType lobType = null;
        switch (type) {
            case 2004: {
                lobType = this.createDBType(113, false);
                break;
            }
            case 2005: {
                lobType = this.createDBType(112, false);
                break;
            }
            case -13: {
                lobType = this.createDBType(114, false);
                break;
            }
            default: {
                return;
            }
        }
        byte[] newLocator = new byte[lobType.max_length];
        this.check_error(this.lob_open(type, locator, locator.length, mode, newLocator, newLocator.length), null);
        lob.setShareBytes(newLocator);
    }

    native int lob_open(int var1, byte[] var2, int var3, int var4, byte[] var5, int var6);

    public synchronized boolean isLobOpen(Connection conn, Datum lob, int type) throws SQLException {
        byte[] locator = null;
        int result = 0;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)("OCIDBAccess.isLobOpen(conn = " + conn + ", lob = " + lob + ", type = " + type + ")"));
        }
        if (lob == null || (locator = lob.shareBytes()) == null) {
            DBError.throwSqlException((int)54);
        }
        result = this.lob_isOpen(type, locator, locator.length);
        this.check_error(result, null);
        return result == 1;
    }

    native int lob_isOpen(int var1, byte[] var2, int var3);

    public synchronized void closeLob(Connection conn, Datum lob, int type) throws SQLException {
        byte[] locator = null;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)("OCIDBAccess.closeLob(conn = " + conn + ", lob = " + lob + ", type = " + type + ")"));
        }
        if (lob == null || (locator = lob.shareBytes()) == null) {
            DBError.throwSqlException((int)54);
        }
        DBType lobType = null;
        switch (type) {
            case 2004: {
                lobType = this.createDBType(113, false);
                break;
            }
            case 2005: {
                lobType = this.createDBType(112, false);
                break;
            }
            case -13: {
                lobType = this.createDBType(114, false);
                break;
            }
            default: {
                return;
            }
        }
        byte[] newLocator = new byte[lobType.max_length];
        this.check_error(this.lob_close(type, locator, locator.length, newLocator, newLocator.length), null);
        lob.setShareBytes(newLocator);
    }

    native int lob_close(int var1, byte[] var2, int var3, byte[] var4, int var5);

    native int get_client_server_nls_ratio(int var1);

    public synchronized int getC2SNlsRatio() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)"OCIDBAccess.getC2SNlsRatio()");
        }
        if (this.m_c2s_nls_ratio == 0) {
            this.m_c2s_nls_ratio = this.get_client_server_nls_ratio((int)this.char_set);
        }
        return this.m_c2s_nls_ratio;
    }

    native int get_server_client_nls_ratio(int var1);

    public synchronized int getS2CNlsRatio() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)"OCIDBAccess.getS2CNlsRatio()");
        }
        if (this.m_s2c_nls_ratio == 0) {
            this.m_s2c_nls_ratio = this.get_server_client_nls_ratio((int)this.char_set);
        }
        return this.m_s2c_nls_ratio;
    }

    public synchronized Properties getDBAccessProperties() throws SQLException {
        long[] handles = new long[3];
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)"OCIDBAccess.getDBAccessProperties()");
        }
        this.check_error(this.getHandles(handles), null);
        this.dbinfo.put("OCIEnvHandle", String.valueOf(handles[0]));
        this.dbinfo.put("OCISvcCtxHandle", String.valueOf(handles[1]));
        this.dbinfo.put("OCIErrHandle", String.valueOf(handles[2]));
        this.dbinfo.put("ClientCharSet", String.valueOf(this.char_set));
        return this.dbinfo;
    }

    public synchronized byte[] getConnectionId() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)"OCIDBAccess.getConnectionId()");
        }
        byte[] connId = this.get_connection_id();
        return connId;
    }

    public synchronized Properties getConnectionPoolInfo() throws SQLException {
        Properties info = new Properties();
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)"OCIDBAccess.getConnectionPoolInfo()");
        }
        this.check_error(this.get_conn_pool_info(info), null);
        return info;
    }

    public void setConnectionPoolInfo(Properties info, OracleOCIConnection cpool) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)("OCIDBAccess.setConnectionPoolInfo(info = " + info + ", cpool = " + cpool + ")"));
        }
        this.check_error(this.set_conn_pool_info(info, (OCIDBAccess)cpool.db_access), null);
    }

    native int getHandles(long[] var1);

    native byte[] get_connection_id();

    native int get_conn_pool_info(Properties var1);

    native int set_conn_pool_info(Properties var1, OCIDBAccess var2);

    public synchronized int callTAFCallbackMethod(int type, int event) {
        int retCode = 0;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)("OCIDBAccess.callTAFCallbackMethod(type = " + type + ", event = " + event + ")"));
        }
        if (this.m_appCbk != null) {
            retCode = this.m_appCbk.callbackFn(this.m_conn, this.m_cbkObj, type, event);
        }
        return retCode;
    }

    public void registerTAFCallback(Connection conn, OracleOCIFailover cbk, Object obj) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)("OCIDBAccess.registerTAFCallback(conn = " + conn + ", cbk = " + cbk + ", obj = " + obj + ")"));
        }
        this.m_conn = conn;
        this.m_appCbk = cbk;
        this.m_cbkObj = obj;
        this.check_error(this.register_TAF(), null);
    }

    public int getAnyDataEmbDataPos(DBStatement stmt, int row_index, int col_index) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)("OCIDBAccess.getAnyDataEmbDataPos(stmt=" + stmt + ",ridx=" + row_index + ", cidx=" + col_index + ")"));
        }
        return this.get_anydata_offset_of_type((OCIDBStatement)stmt, row_index, col_index);
    }

    public TypeDescriptor getAnyDataEmbTypeDesc(DBStatement stmt, DBDataSet dbset, OracleTypeADT otype, int row_index, int col_index) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)("DBAccess.getAnyDataEmbTypeDesc(stmt=" + stmt + ", dbst=" + dbset + ", ridx=" + row_index + ", cidx=" + col_index + ")"));
        }
        OCIDBItem dbitem = (OCIDBItem)((DBDataSetImpl)dbset)._getDBItem(col_index, row_index);
        String adt_name = this.get_anydata_type((OCIDBStatement)stmt, row_index, col_index);
        int typecode = this.get_anydata_typecode((OCIDBStatement)stmt, row_index, col_index);
        switch (typecode) {
            case 2003: {
                dbitem.m_anydata_desc = ArrayDescriptor.createDescriptor(adt_name, (Connection)otype.getConnection());
                break;
            }
            case 2002: 
            case 2008: {
                dbitem.m_anydata_desc = StructDescriptor.createDescriptor(adt_name, (Connection)otype.getConnection());
                break;
            }
            case 2007: {
                dbitem.m_anydata_desc = OpaqueDescriptor.createDescriptor(adt_name, (Connection)otype.getConnection());
                break;
            }
            default: {
                DBError.throwSqlException((int)23);
            }
        }
        return dbitem.m_anydata_desc;
    }

    public DBDataSet createDBDataSet(oracle.jdbc.driver.OracleConnection conn, OracleStatement stmt, int batchSize, int dataSetType) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1024, (int)2, (int)16, (String)("OCIDBAccess.createDBDataSet(conn = " + conn + ", stmt = " + stmt + ", batchSize = " + batchSize + ", dataSetType = " + dataSetType + ")"));
        }
        return new OCIDBDataSet(conn, stmt, batchSize, dataSetType, this.version_num);
    }

    public Class safelyGetClassForName(String name) throws ClassNotFoundException {
        return Class.forName(name);
    }

    public void registerConnection(oracle.jdbc.driver.OracleConnection conn) {
        this.m_connection = conn;
    }

    static {
        KGHMAX = 0x3FFFFFC;
        loaded_library = false;
        EOJ_LOGON_MODE_DEFAULT = 0;
        EOJ_LOGON_MODE_SYSDBA = 2;
        EOJ_LOGON_MODE_SYSOPER = 4;
        EOJ_LOGON_MODE_CONNECTION_POOL = 5;
        EOJ_LOGON_MODE_CONNPOOL_CONNECTION = 6;
        EOJ_LOGON_MODE_CONNPOOL_PROXY_CONNECTION = 7;
        EOJ_LOGON_MODE_CONNPOOL_ALIASED_CONNECTION = 8;
        EOJ_SUCCESS = 0;
        EOJ_ERROR = -1;
        EOJ_CLOSED_CONNECTION = -8;
        EOJ_CLOSED_STATEMENT = -9;
        EOJ_WARN_SUCCESS_WITH_INFO = -93;
    }
}

