/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oci;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Properties;
import oracle.jdbc.dbaccess.DBAccess;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.oci8.OCIDBAccess;
import oracle.jdbc.pool.OracleOCIConnectionPool;

public class OracleOCIConnection
extends OracleConnection {
    public static final String NEW_PASSWORD = "OCINewPassword";
    private OracleOCIConnectionPool m_connection_pool = null;
    private boolean m_is_pool = false;
    private boolean m_aliasing = false;

    public OracleOCIConnection(DBAccess access, String ur, String us, String p2, String db, Properties info) throws SQLException {
        super(access, ur, us, p2, db, info);
    }

    public synchronized byte[] getConnectionId() throws SQLException {
        byte[] connId = ((OCIDBAccess)this.db_access).getConnectionId();
        this.m_aliasing = true;
        return connId;
    }

    public synchronized void passwordChange(String user, String oldPassword, String newPassword) throws SQLException, IOException {
        Properties info = new Properties();
        info.put(NEW_PASSWORD, newPassword);
        this.db_access.logon(user, oldPassword, this.database, info);
    }

    public synchronized void close() throws SQLException {
        if (this.closed || this.m_aliasing) {
            return;
        }
        super.close();
        this.m_connection_pool.connectionClosed(this);
    }

    public synchronized void setConnectionPool(OracleOCIConnectionPool cpool) {
        this.m_connection_pool = cpool;
    }

    public synchronized void setStmtCacheSize(int size, boolean clearMetaData) throws SQLException {
        super.setStmtCacheSize(size, clearMetaData);
    }

    static {
        NEW_PASSWORD = NEW_PASSWORD;
    }
}

