/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import oracle.jdbc.dbaccess.DBConversion;
import oracle.jdbc.dbaccess.DBDataSet;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.BaseResultSet;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleResultSetImpl;
import oracle.jdbc.driver.OracleResultSetMetaData;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.ScrollRsetStatement;
import oracle.jdbc.driver.ScrollableResultSet;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.SQLUtil;
import oracle.sql.STRUCT;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

public class UpdatableResultSet
extends BaseResultSet {
    static final int s_concurrencyType = 1008;
    static final int s_beginColumnIndex = 1;
    OracleConnection m_conn;
    OracleResultSet m_rset;
    boolean m_isCachedRset;
    ScrollRsetStatement m_scrollStmt;
    ResultSetMetaData m_metadata;
    private int m_type;
    private int m_columnCount;
    private OraclePreparedStatement m_deleteStmt;
    private OraclePreparedStatement m_insertStmt;
    private String m_updateSql1;
    private String m_updateSql2;
    private OraclePreparedStatement m_updateStmt;
    private int[] m_idxColsChanged;
    private Object[] m_rowBuffer;
    private boolean[] m_nullIndicator;
    private int[][] m_typeInfo;
    private boolean m_isInserting;
    private boolean m_isUpdating;
    private int m_wasNull;
    private static final int VALUE_NULL = 1;
    private static final int VALUE_NOT_NULL = 2;
    private static final int VALUE_UNKNOWN = 3;
    private static final int VALUE_IN_RSET = 4;
    private static final int ASCII_STREAM = 1;
    private static final int BINARY_STREAM = 2;
    private static final int UNICODE_STREAM = 3;
    private static int _MIN_STREAM_SIZE;

    public UpdatableResultSet(ScrollRsetStatement scrollStmt, ScrollableResultSet rset, int type, int update) throws SQLException {
        this.init(scrollStmt, rset, type, update);
        rset.resetBeginColumnIndex();
        this.m_isCachedRset = true;
    }

    public UpdatableResultSet(ScrollRsetStatement scrollStmt, OracleResultSetImpl rset, int type, int update) throws SQLException {
        this.init(scrollStmt, rset, type, update);
        this.m_isCachedRset = false;
    }

    private void init(ScrollRsetStatement scrollStmt, OracleResultSet rset, int type, int update) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)16, (String)("UpdatableResultSet.UpdatableResultSet(scrollStmt, rset, type= " + type + " update=" + update + ")"));
        }
        if (scrollStmt == null || rset == null || update != 1008) {
            DBError.throwSqlException((int)68);
        }
        this.m_conn = (OracleConnection)scrollStmt.getConnection();
        this.m_rset = rset;
        this.m_scrollStmt = scrollStmt;
        this.m_type = type;
        this.m_autoRefetch = scrollStmt.getAutoRefetch();
        this.m_deleteStmt = null;
        this.m_insertStmt = null;
        this.m_updateSql1 = null;
        this.m_updateSql2 = null;
        this.m_updateStmt = null;
        this.m_idxColsChanged = null;
        this.m_rowBuffer = null;
        this.m_nullIndicator = null;
        this.m_typeInfo = null;
        this.m_isInserting = false;
        this.m_isUpdating = false;
        this.m_wasNull = -1;
        this.m_metadata = null;
        this.m_columnCount = 0;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)16, (String)"UpdatableResultSet.UpdatableResultSet:return");
        }
    }

    public synchronized void close() throws SQLException {
        if (this.m_rset != null) {
            this.m_rset.close();
        }
        if (this.m_insertStmt != null) {
            this.m_insertStmt.close();
        }
        if (this.m_updateStmt != null) {
            this.m_updateStmt.close();
        }
        if (this.m_deleteStmt != null) {
            this.m_deleteStmt.close();
        }
        if (this.m_scrollStmt != null) {
            this.m_scrollStmt.notify_close_rset();
        }
        this.cancelRowInserts();
        this.m_conn = null;
        this.m_rset = null;
        this.m_scrollStmt = null;
        this.m_metadata = null;
        this.m_scrollStmt = null;
        this.m_deleteStmt = null;
        this.m_insertStmt = null;
        this.m_updateSql1 = null;
        this.m_updateSql2 = null;
        this.m_updateStmt = null;
        this.m_idxColsChanged = null;
        this.m_rowBuffer = null;
        this.m_nullIndicator = null;
        this.m_typeInfo = null;
    }

    public synchronized boolean wasNull() throws SQLException {
        switch (this.m_wasNull) {
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            case 4: {
                return this.m_rset.wasNull();
            }
        }
        DBError.throwSqlException((int)24);
        return false;
    }

    public int getFirstUserColumnIndex() {
        return 1;
    }

    public synchronized Statement getStatement() throws SQLException {
        return (Statement)((Object)this.m_scrollStmt);
    }

    public SQLWarning getWarnings() throws SQLException {
        SQLWarning innerWarnings = this.m_rset.getWarnings();
        if (this.m_warning == null) {
            return innerWarnings;
        }
        SQLWarning thisWarning = this.m_warning;
        while (thisWarning.getNextWarning() != null) {
            thisWarning = thisWarning.getNextWarning();
        }
        thisWarning.setNextWarning(innerWarnings);
        return this.m_warning;
    }

    public void clearWarnings() throws SQLException {
        this.m_warning = null;
        this.m_rset.clearWarnings();
    }

    public synchronized boolean next() throws SQLException {
        this.cancelRowChanges();
        return this.m_rset.next();
    }

    public synchronized boolean isBeforeFirst() throws SQLException {
        return this.m_rset.isBeforeFirst();
    }

    public synchronized boolean isAfterLast() throws SQLException {
        return this.m_rset.isAfterLast();
    }

    public synchronized boolean isFirst() throws SQLException {
        return this.m_rset.isFirst();
    }

    public synchronized boolean isLast() throws SQLException {
        return this.m_rset.isLast();
    }

    public synchronized void beforeFirst() throws SQLException {
        this.cancelRowChanges();
        this.m_rset.beforeFirst();
    }

    public synchronized void afterLast() throws SQLException {
        this.cancelRowChanges();
        this.m_rset.afterLast();
    }

    public synchronized boolean first() throws SQLException {
        this.cancelRowChanges();
        return this.m_rset.first();
    }

    public synchronized boolean last() throws SQLException {
        this.cancelRowChanges();
        return this.m_rset.last();
    }

    public synchronized int getRow() throws SQLException {
        return this.m_rset.getRow();
    }

    public synchronized boolean absolute(int row) throws SQLException {
        this.cancelRowChanges();
        return this.m_rset.absolute(row);
    }

    public synchronized boolean relative(int rows) throws SQLException {
        this.cancelRowChanges();
        return this.m_rset.relative(rows);
    }

    public synchronized boolean previous() throws SQLException {
        this.cancelRowChanges();
        return this.m_rset.previous();
    }

    public synchronized Datum getOracleObject(int columnIndex) throws SQLException {
        Datum value = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
            this.setIsNull(value == null);
            value = this.getRowBufferDatumAt(columnIndex);
        } else {
            this.setIsNull(4);
            value = this.m_rset.getOracleObject(columnIndex + 1);
        }
        return value;
    }

    public synchronized String getString(int columnIndex) throws SQLException {
        String value = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
            Datum datum = this.getRowBufferDatumAt(columnIndex);
            this.setIsNull(datum == null);
            if (datum != null) {
                value = datum.stringValue();
            }
        } else {
            this.setIsNull(4);
            value = this.m_rset.getString(columnIndex + 1);
        }
        return value;
    }

    public synchronized boolean getBoolean(int columnIndex) throws SQLException {
        boolean value = false;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
            Datum datum = this.getRowBufferDatumAt(columnIndex);
            this.setIsNull(datum == null);
            if (datum != null) {
                value = datum.booleanValue();
            }
        } else {
            this.setIsNull(4);
            value = this.m_rset.getBoolean(columnIndex + 1);
        }
        return value;
    }

    public synchronized byte getByte(int columnIndex) throws SQLException {
        byte value = 0;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
            Datum datum = this.getRowBufferDatumAt(columnIndex);
            this.setIsNull(datum == null);
            if (datum != null) {
                value = datum.byteValue();
            }
        } else {
            this.setIsNull(4);
            value = this.m_rset.getByte(columnIndex + 1);
        }
        return value;
    }

    public synchronized short getShort(int columnIndex) throws SQLException {
        short value = 0;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
            long longvalue = this.getLong(columnIndex);
            if (longvalue > 65537L || longvalue < -65538L) {
                DBError.check_error((int)26, (Object)"getShort");
            }
            value = (short)longvalue;
        } else {
            this.setIsNull(4);
            value = this.m_rset.getShort(columnIndex + 1);
        }
        return value;
    }

    public synchronized int getInt(int columnIndex) throws SQLException {
        int value = 0;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
            Datum datum = this.getRowBufferDatumAt(columnIndex);
            this.setIsNull(datum == null);
            if (datum != null) {
                value = datum.intValue();
            }
        } else {
            this.setIsNull(4);
            value = this.m_rset.getInt(columnIndex + 1);
        }
        return value;
    }

    public synchronized long getLong(int columnIndex) throws SQLException {
        long value = 0L;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
            Datum datum = this.getRowBufferDatumAt(columnIndex);
            this.setIsNull(datum == null);
            if (datum != null) {
                value = datum.longValue();
            }
        } else {
            this.setIsNull(4);
            value = this.m_rset.getLong(columnIndex + 1);
        }
        return value;
    }

    public synchronized float getFloat(int columnIndex) throws SQLException {
        float value = 0.0f;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
            Datum datum = this.getRowBufferDatumAt(columnIndex);
            this.setIsNull(datum == null);
            if (datum != null) {
                value = datum.floatValue();
            }
        } else {
            this.setIsNull(4);
            value = this.m_rset.getFloat(columnIndex + 1);
        }
        return value;
    }

    public synchronized double getDouble(int columnIndex) throws SQLException {
        double value = 0.0;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
            Datum datum = this.getRowBufferDatumAt(columnIndex);
            this.setIsNull(datum == null);
            if (datum != null) {
                value = datum.doubleValue();
            }
        } else {
            this.setIsNull(4);
            value = this.m_rset.getDouble(columnIndex + 1);
        }
        return value;
    }

    public synchronized BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        BigDecimal value = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
            Datum datum = this.getRowBufferDatumAt(columnIndex);
            this.setIsNull(datum == null);
            if (datum != null) {
                value = datum.bigDecimalValue();
            }
        } else {
            this.setIsNull(4);
            value = this.m_rset.getBigDecimal(columnIndex + 1);
        }
        return value;
    }

    public synchronized byte[] getBytes(int columnIndex) throws SQLException {
        byte[] value = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
            Datum datum = this.getRowBufferDatumAt(columnIndex);
            this.setIsNull(datum == null);
            if (datum != null) {
                value = datum.getBytes();
            }
        } else {
            this.setIsNull(4);
            value = this.m_rset.getBytes(columnIndex + 1);
        }
        return value;
    }

    public synchronized Date getDate(int columnIndex) throws SQLException {
        Date value = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
            Datum datum = this.getRowBufferDatumAt(columnIndex);
            this.setIsNull(datum == null);
            if (datum != null) {
                value = datum.dateValue();
            }
        } else {
            this.setIsNull(4);
            value = this.m_rset.getDate(columnIndex + 1);
        }
        return value;
    }

    public synchronized Time getTime(int columnIndex) throws SQLException {
        Time value = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
            Datum datum = this.getRowBufferDatumAt(columnIndex);
            this.setIsNull(datum == null);
            if (datum != null) {
                value = datum.timeValue();
            }
        } else {
            this.setIsNull(4);
            value = this.m_rset.getTime(columnIndex + 1);
        }
        return value;
    }

    public synchronized Timestamp getTimestamp(int columnIndex) throws SQLException {
        Timestamp value = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
            Datum datum = this.getRowBufferDatumAt(columnIndex);
            this.setIsNull(datum == null);
            if (datum != null) {
                value = datum.timestampValue();
            }
        } else {
            this.setIsNull(4);
            value = this.m_rset.getTimestamp(columnIndex + 1);
        }
        return value;
    }

    public synchronized InputStream getAsciiStream(int columnIndex) throws SQLException {
        InputStream value = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
            Object obj = this.getRowBufferAt(columnIndex);
            this.setIsNull(obj == null);
            if (obj != null) {
                if (obj instanceof InputStream) {
                    value = (InputStream)obj;
                } else {
                    Datum datum = this.getRowBufferDatumAt(columnIndex);
                    value = datum.asciiStreamValue();
                }
            }
        } else {
            this.setIsNull(4);
            value = this.m_rset.getAsciiStream(columnIndex + 1);
        }
        return value;
    }

    public synchronized InputStream getUnicodeStream(int columnIndex) throws SQLException {
        InputStream value = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
            Object obj = this.getRowBufferAt(columnIndex);
            this.setIsNull(obj == null);
            if (obj != null) {
                if (obj instanceof InputStream) {
                    value = (InputStream)obj;
                } else {
                    Datum datum = this.getRowBufferDatumAt(columnIndex);
                    DBConversion dbconv = this.m_conn.conversion;
                    byte[] bytes = datum.shareBytes();
                    if (datum instanceof RAW) {
                        value = dbconv.ConvertStream((InputStream)new ByteArrayInputStream(bytes), 3);
                    } else if (datum instanceof CHAR) {
                        value = dbconv.ConvertStream((InputStream)new ByteArrayInputStream(bytes), 1);
                    } else {
                        DBError.check_error((int)4, (Object)"getUnicodeStream");
                    }
                }
            }
        } else {
            this.setIsNull(4);
            value = this.m_rset.getUnicodeStream(columnIndex + 1);
        }
        return value;
    }

    public synchronized InputStream getBinaryStream(int columnIndex) throws SQLException {
        InputStream value = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
            Object obj = this.getRowBufferAt(columnIndex);
            this.setIsNull(obj == null);
            if (obj != null) {
                if (obj instanceof InputStream) {
                    value = (InputStream)obj;
                } else {
                    Datum datum = this.getRowBufferDatumAt(columnIndex);
                    value = datum.binaryStreamValue();
                }
            }
        } else {
            this.setIsNull(4);
            value = this.m_rset.getBinaryStream(columnIndex + 1);
        }
        return value;
    }

    public synchronized Object getObject(int columnIndex) throws SQLException {
        Object value = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
            Datum datum = this.getOracleObject(columnIndex);
            this.setIsNull(datum == null);
            if (datum != null) {
                value = datum.toJdbc();
            }
        } else {
            this.setIsNull(4);
            value = this.m_rset.getObject(columnIndex + 1);
        }
        return value;
    }

    public synchronized Reader getCharacterStream(int columnIndex) throws SQLException {
        Reader value = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
            Object obj = this.getRowBufferAt(columnIndex);
            this.setIsNull(obj == null);
            if (obj != null) {
                if (obj instanceof Reader) {
                    value = (Reader)obj;
                } else {
                    Datum datum = this.getRowBufferDatumAt(columnIndex);
                    value = datum.characterStreamValue();
                }
            }
        } else {
            this.setIsNull(4);
            value = this.m_rset.getCharacterStream(columnIndex + 1);
        }
        return value;
    }

    public synchronized BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        BigDecimal value = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
            Datum datum = this.getRowBufferDatumAt(columnIndex);
            this.setIsNull(datum == null);
            if (datum != null) {
                value = datum.bigDecimalValue();
            }
        } else {
            this.setIsNull(4);
            value = this.m_rset.getBigDecimal(columnIndex + 1);
        }
        return value;
    }

    public synchronized Object getObject(int columnIndex, Map map) throws SQLException {
        Object value = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
            Datum datum = this.getOracleObject(columnIndex);
            this.setIsNull(datum == null);
            if (datum != null) {
                value = datum instanceof STRUCT ? ((STRUCT)datum).toJdbc(map) : datum.toJdbc();
            }
        } else {
            this.setIsNull(4);
            value = this.m_rset.getObject(columnIndex + 1, map);
        }
        return value;
    }

    public synchronized Ref getRef(int columnIndex) throws SQLException {
        return this.getREF(columnIndex);
    }

    public synchronized Blob getBlob(int columnIndex) throws SQLException {
        return this.getBLOB(columnIndex);
    }

    public synchronized Clob getClob(int columnIndex) throws SQLException {
        return this.getCLOB(columnIndex);
    }

    public synchronized Array getArray(int columnIndex) throws SQLException {
        return this.getARRAY(columnIndex);
    }

    public synchronized Date getDate(int columnIndex, Calendar cal) throws SQLException {
        Date value = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
            Datum datum = this.getOracleObject(columnIndex);
            this.setIsNull(datum == null);
            if (datum != null) {
                if (datum instanceof DATE) {
                    value = ((DATE)datum).dateValue(cal);
                } else {
                    DATE d2 = new DATE(datum.stringValue());
                    if (d2 != null) {
                        value = d2.dateValue(cal);
                    }
                }
            }
        } else {
            this.setIsNull(4);
            value = this.m_rset.getDate(columnIndex + 1, cal);
        }
        return value;
    }

    public synchronized Time getTime(int columnIndex, Calendar cal) throws SQLException {
        Time value = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
            Datum datum = this.getOracleObject(columnIndex);
            this.setIsNull(datum == null);
            if (datum != null) {
                if (datum instanceof DATE) {
                    value = ((DATE)datum).timeValue(cal);
                } else {
                    DATE d2 = new DATE(datum.stringValue());
                    if (d2 != null) {
                        value = d2.timeValue(cal);
                    }
                }
            }
        } else {
            this.setIsNull(4);
            value = this.m_rset.getTime(columnIndex + 1, cal);
        }
        return value;
    }

    public synchronized Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        Timestamp value = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
            Datum datum = this.getOracleObject(columnIndex);
            this.setIsNull(datum == null);
            if (datum != null) {
                if (datum instanceof DATE) {
                    value = ((DATE)datum).timestampValue(cal);
                } else {
                    DATE d2 = new DATE(datum.stringValue());
                    if (d2 != null) {
                        value = d2.timestampValue(cal);
                    }
                }
            }
        } else {
            this.setIsNull(4);
            value = this.m_rset.getTimestamp(columnIndex + 1, cal);
        }
        return value;
    }

    public synchronized ResultSet getCursor(int columnIndex) throws SQLException {
        ResultSet value = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
            Datum datum = this.getOracleObject(columnIndex);
            this.setIsNull(datum == null);
            DBError.check_error((int)4, (Object)"getCursor");
        } else {
            this.setIsNull(4);
            value = this.m_rset.getCursor(columnIndex + 1);
        }
        return value;
    }

    public synchronized ROWID getROWID(int columnIndex) throws SQLException {
        ROWID value = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
            Datum datum = this.getRowBufferDatumAt(columnIndex);
            this.setIsNull(datum == null);
            if (datum != null && !(datum instanceof ROWID)) {
                DBError.check_error((int)4, (Object)"getROWID");
            }
            value = (ROWID)datum;
        } else {
            this.setIsNull(4);
            value = this.m_rset.getROWID(columnIndex + 1);
        }
        return value;
    }

    public synchronized NUMBER getNUMBER(int columnIndex) throws SQLException {
        NUMBER value = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
            Datum datum = this.getRowBufferDatumAt(columnIndex);
            this.setIsNull(datum == null);
            if (datum != null && !(datum instanceof NUMBER)) {
                DBError.check_error((int)4, (Object)"getNUMBER");
            }
            value = (NUMBER)datum;
        } else {
            this.setIsNull(4);
            value = this.m_rset.getNUMBER(columnIndex + 1);
        }
        return value;
    }

    public synchronized DATE getDATE(int columnIndex) throws SQLException {
        DATE value = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
            Datum datum = this.getRowBufferDatumAt(columnIndex);
            this.setIsNull(datum == null);
            if (datum != null && !(datum instanceof DATE)) {
                DBError.check_error((int)4, (Object)"getDATE");
            }
            value = (DATE)datum;
        } else {
            this.setIsNull(4);
            value = this.m_rset.getDATE(columnIndex + 1);
        }
        return value;
    }

    public synchronized ARRAY getARRAY(int columnIndex) throws SQLException {
        ARRAY value = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
            Datum datum = this.getRowBufferDatumAt(columnIndex);
            this.setIsNull(datum == null);
            if (datum != null && !(datum instanceof ARRAY)) {
                DBError.check_error((int)4, (Object)"getARRAY");
            }
            value = (ARRAY)datum;
        } else {
            this.setIsNull(4);
            value = this.m_rset.getARRAY(columnIndex + 1);
        }
        return value;
    }

    public synchronized STRUCT getSTRUCT(int columnIndex) throws SQLException {
        STRUCT value = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
            Datum datum = this.getRowBufferDatumAt(columnIndex);
            this.setIsNull(datum == null);
            if (datum != null && !(datum instanceof STRUCT)) {
                DBError.check_error((int)4, (Object)"getSTRUCT");
            }
            value = (STRUCT)datum;
        } else {
            this.setIsNull(4);
            value = this.m_rset.getSTRUCT(columnIndex + 1);
        }
        return value;
    }

    public synchronized OPAQUE getOPAQUE(int columnIndex) throws SQLException {
        OPAQUE value = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
            Datum datum = this.getRowBufferDatumAt(columnIndex);
            this.setIsNull(datum == null);
            if (datum != null && !(datum instanceof OPAQUE)) {
                DBError.check_error((int)4, (Object)"getOPAQUE");
            }
            value = (OPAQUE)datum;
        } else {
            this.setIsNull(4);
            value = this.m_rset.getOPAQUE(columnIndex + 1);
        }
        return value;
    }

    public synchronized REF getREF(int columnIndex) throws SQLException {
        REF value = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
            Datum datum = this.getRowBufferDatumAt(columnIndex);
            this.setIsNull(datum == null);
            if (datum != null && !(datum instanceof REF)) {
                DBError.check_error((int)4, (Object)"getREF");
            }
            value = (REF)datum;
        } else {
            this.setIsNull(4);
            value = this.m_rset.getREF(columnIndex + 1);
        }
        return value;
    }

    public synchronized CHAR getCHAR(int columnIndex) throws SQLException {
        CHAR value = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
            Datum datum = this.getRowBufferDatumAt(columnIndex);
            this.setIsNull(datum == null);
            if (datum != null && !(datum instanceof CHAR)) {
                DBError.check_error((int)4, (Object)"getCHAR");
            }
            value = (CHAR)datum;
        } else {
            this.setIsNull(4);
            value = this.m_rset.getCHAR(columnIndex + 1);
        }
        return value;
    }

    public synchronized RAW getRAW(int columnIndex) throws SQLException {
        RAW value = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
            Datum datum = this.getRowBufferDatumAt(columnIndex);
            this.setIsNull(datum == null);
            if (datum != null && !(datum instanceof RAW)) {
                DBError.check_error((int)4, (Object)"getRAW");
            }
            value = (RAW)datum;
        } else {
            this.setIsNull(4);
            value = this.m_rset.getRAW(columnIndex + 1);
        }
        return value;
    }

    public synchronized BLOB getBLOB(int columnIndex) throws SQLException {
        BLOB value = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
            Datum datum = this.getRowBufferDatumAt(columnIndex);
            this.setIsNull(datum == null);
            if (datum != null && !(datum instanceof BLOB)) {
                DBError.check_error((int)4, (Object)"getBLOB");
            }
            value = (BLOB)datum;
        } else {
            this.setIsNull(4);
            value = this.m_rset.getBLOB(columnIndex + 1);
        }
        return value;
    }

    public synchronized CLOB getCLOB(int columnIndex) throws SQLException {
        CLOB value = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
            Datum datum = this.getRowBufferDatumAt(columnIndex);
            this.setIsNull(datum == null);
            if (datum != null && !(datum instanceof CLOB)) {
                DBError.check_error((int)4, (Object)"getCLOB");
            }
            value = (CLOB)datum;
        } else {
            this.setIsNull(4);
            value = this.m_rset.getCLOB(columnIndex + 1);
        }
        return value;
    }

    public synchronized BFILE getBFILE(int columnIndex) throws SQLException {
        BFILE value = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
            Datum datum = this.getRowBufferDatumAt(columnIndex);
            this.setIsNull(datum == null);
            if (datum != null && !(datum instanceof BFILE)) {
                DBError.check_error((int)4, (Object)"getBFILE");
            }
            value = (BFILE)datum;
        } else {
            this.setIsNull(4);
            value = this.m_rset.getBFILE(columnIndex + 1);
        }
        return value;
    }

    public synchronized BFILE getBfile(int columnIndex) throws SQLException {
        return this.getBFILE(columnIndex);
    }

    public synchronized CustomDatum getCustomDatum(int columnIndex, CustomDatumFactory factory) throws SQLException {
        if (factory == null) {
            DBError.throwSqlException((int)68);
        }
        CustomDatum value = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
            Datum datum = this.getRowBufferDatumAt(columnIndex);
            this.setIsNull(datum == null);
            value = factory.create(datum, 0);
        } else {
            this.setIsNull(4);
            value = this.m_rset.getCustomDatum(columnIndex + 1, factory);
        }
        return value;
    }

    public synchronized ORAData getORAData(int columnIndex, ORADataFactory factory) throws SQLException {
        if (factory == null) {
            DBError.throwSqlException((int)68);
        }
        ORAData value = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
            Datum datum = this.getRowBufferDatumAt(columnIndex);
            this.setIsNull(datum == null);
            value = factory.create(datum, 0);
        } else {
            this.setIsNull(4);
            value = this.m_rset.getORAData(columnIndex + 1, factory);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSetMetaData getMetaData() throws SQLException {
        if (((OracleStatement)this.m_scrollStmt).closed) {
            DBError.check_error((int)9, (Object)"getMetaData");
        }
        OracleConnection oracleConnection = this.m_conn;
        synchronized (oracleConnection) {
            UpdatableResultSet updatableResultSet = this;
            synchronized (updatableResultSet) {
                OracleResultSetMetaData oracleResultSetMetaData = new OracleResultSetMetaData((oracle.jdbc.internal.OracleConnection)this.m_conn, (oracle.jdbc.internal.OracleStatement)((OracleStatement)this.m_scrollStmt), 1);
                return oracleResultSetMetaData;
            }
        }
    }

    public synchronized int findColumn(String columnName) throws SQLException {
        return this.m_rset.findColumn(columnName) - 1;
    }

    public synchronized void setFetchDirection(int direction) throws SQLException {
        this.m_rset.setFetchDirection(direction);
    }

    public synchronized int getFetchDirection() throws SQLException {
        return this.m_rset.getFetchDirection();
    }

    public synchronized void setFetchSize(int rows) throws SQLException {
        this.m_rset.setFetchSize(rows);
    }

    public synchronized int getFetchSize() throws SQLException {
        return this.m_rset.getFetchSize();
    }

    public int getType() throws SQLException {
        return this.m_type;
    }

    public int getConcurrency() throws SQLException {
        return 1008;
    }

    public boolean rowUpdated() throws SQLException {
        return false;
    }

    public boolean rowInserted() throws SQLException {
        return false;
    }

    public boolean rowDeleted() throws SQLException {
        return false;
    }

    public synchronized void insertRow() throws SQLException {
        if (!this.isOnInsertRow()) {
            DBError.throwSqlException((int)83);
        }
        this.prepare_insertRow_statement();
        this.prepare_insertRow_binds();
        this.execute_insertRow();
    }

    public synchronized void updateRow() throws SQLException {
        int _numColsChanged;
        if (this.isOnInsertRow()) {
            DBError.throwSqlException((int)84);
        }
        if ((_numColsChanged = this.get_num_columns_changed()) > 0) {
            this.prepare_updateRow_statement(_numColsChanged);
            this.prepare_updateRow_binds(_numColsChanged);
            this.execute_updateRow();
        }
    }

    public synchronized void deleteRow() throws SQLException {
        if (this.isOnInsertRow()) {
            DBError.throwSqlException((int)84);
        }
        this.prepare_deleteRow_statement();
        this.prepare_deleteRow_binds();
        this.execute_deleteRow();
    }

    public synchronized void refreshRow() throws SQLException {
        if (this.isOnInsertRow()) {
            DBError.throwSqlException((int)84);
        }
        this.m_rset.refreshRow();
    }

    public synchronized void cancelRowUpdates() throws SQLException {
        if (this.m_isUpdating) {
            this.m_isUpdating = false;
            this.clearRowBuffer();
        }
    }

    public synchronized void moveToInsertRow() throws SQLException {
        if (this.isOnInsertRow()) {
            return;
        }
        this.m_isInserting = true;
        if (this.m_rowBuffer == null) {
            this.m_rowBuffer = new Object[this.getColumnCount()];
        }
        if (this.m_nullIndicator == null) {
            this.m_nullIndicator = new boolean[this.getColumnCount()];
        }
        this.clearRowBuffer();
    }

    public synchronized void moveToCurrentRow() throws SQLException {
        this.cancelRowInserts();
    }

    public synchronized void updateString(int columnIndex, String x) throws SQLException {
        this.updateObject(columnIndex, (Object)x);
    }

    public synchronized void updateNull(int columnIndex) throws SQLException {
        this.setRowBufferAt(columnIndex, null);
    }

    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.updateObject(columnIndex, (Object)new Boolean(x));
    }

    public void updateByte(int columnIndex, byte x) throws SQLException {
        this.updateObject(columnIndex, (Object)new Integer(x));
    }

    public void updateShort(int columnIndex, short x) throws SQLException {
        this.updateObject(columnIndex, (Object)new Integer(x));
    }

    public void updateInt(int columnIndex, int x) throws SQLException {
        this.updateObject(columnIndex, (Object)new Integer(x));
    }

    public void updateLong(int columnIndex, long x) throws SQLException {
        this.updateObject(columnIndex, (Object)new Long(x));
    }

    public void updateFloat(int columnIndex, float x) throws SQLException {
        this.updateObject(columnIndex, (Object)new Float(x));
    }

    public void updateDouble(int columnIndex, double x) throws SQLException {
        this.updateObject(columnIndex, (Object)new Double(x));
    }

    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.updateObject(columnIndex, (Object)x);
    }

    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.updateObject(columnIndex, (Object)x);
    }

    public void updateDate(int columnIndex, Date x) throws SQLException {
        this.updateObject(columnIndex, (Object)x);
    }

    public void updateTime(int columnIndex, Time x) throws SQLException {
        this.updateObject(columnIndex, (Object)x);
    }

    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.updateObject(columnIndex, (Object)x);
    }

    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        int type = this.getInternalMetadata().getColumnType(1 + columnIndex);
        if (x != null && length > 0) {
            if (!this.isStreamType(type)) {
                byte[] asciiBytes = new byte[length];
                try {
                    int len = x.read(asciiBytes);
                    x.close();
                    String str = new String(asciiBytes, 0, len);
                    this.updateString(columnIndex, str);
                }
                catch (IOException e2) {
                    DBError.throwSqlException((IOException)e2);
                }
            } else {
                int[] infoArray = new int[]{length, 1};
                this.setRowBufferAt(columnIndex, x, infoArray);
            }
        } else {
            this.setRowBufferAt(columnIndex, null);
        }
    }

    final boolean isStreamType(int type) {
        return type == 2004 || type == 2005 || type == -4 || type == -1;
    }

    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        int type = this.getInternalMetadata().getColumnType(1 + columnIndex);
        if (x != null && length > 0) {
            if (!this.isStreamType(type)) {
                byte[] rawBytes = new byte[length];
                try {
                    int len = x.read(rawBytes);
                    x.close();
                    this.updateBytes(columnIndex, rawBytes);
                }
                catch (IOException e2) {
                    DBError.throwSqlException((IOException)e2);
                }
            } else {
                int[] infoArray = new int[]{length, 2};
                this.setRowBufferAt(columnIndex, x, infoArray);
            }
        } else {
            this.setRowBufferAt(columnIndex, null);
        }
    }

    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        int type = this.getInternalMetadata().getColumnType(1 + columnIndex);
        if (x != null && length > 0) {
            if (!this.isStreamType(type)) {
                char[] chars = new char[length];
                try {
                    int len = x.read(chars);
                    x.close();
                    this.updateString(columnIndex, new String(chars));
                }
                catch (IOException e2) {
                    DBError.throwSqlException((IOException)e2);
                }
            } else {
                int[] infoArray = new int[]{length};
                this.setRowBufferAt(columnIndex, x, infoArray);
            }
        } else {
            this.setRowBufferAt(columnIndex, null);
        }
    }

    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        this.updateObject(columnIndex, x);
    }

    public synchronized void updateObject(int columnIndex, Object x) throws SQLException {
        Datum datum = null;
        if (x != null) {
            datum = x instanceof Datum ? (Datum)x : SQLUtil.makeOracleDatum((OracleConnection)this.m_conn, (Object)x, (int)this.getInternalMetadata().getColumnType(columnIndex + 1), null);
        }
        this.setRowBufferAt(columnIndex, datum);
    }

    public synchronized void updateOracleObject(int columnIndex, Datum x) throws SQLException {
        this.setRowBufferAt(columnIndex, x);
    }

    public void updateROWID(int columnIndex, ROWID x) throws SQLException {
        this.updateOracleObject(columnIndex, (Datum)x);
    }

    public void updateNUMBER(int columnIndex, NUMBER x) throws SQLException {
        this.updateOracleObject(columnIndex, (Datum)x);
    }

    public void updateDATE(int columnIndex, DATE x) throws SQLException {
        this.updateOracleObject(columnIndex, (Datum)x);
    }

    public void updateINTERVALYM(int columnIndex, INTERVALYM x) throws SQLException {
        this.updateOracleObject(columnIndex, (Datum)x);
    }

    public void updateTIMESTAMP(int columnIndex, TIMESTAMP x) throws SQLException {
        this.updateOracleObject(columnIndex, (Datum)x);
    }

    public void updateTIMESTAMPTZ(int columnIndex, TIMESTAMPTZ x) throws SQLException {
        this.updateOracleObject(columnIndex, (Datum)x);
    }

    public void updateTIMESTAMPLTZ(int columnIndex, TIMESTAMPLTZ x) throws SQLException {
        this.updateOracleObject(columnIndex, (Datum)x);
    }

    public void updateARRAY(int columnIndex, ARRAY x) throws SQLException {
        this.updateOracleObject(columnIndex, (Datum)x);
    }

    public void updateSTRUCT(int columnIndex, STRUCT x) throws SQLException {
        this.updateOracleObject(columnIndex, (Datum)x);
    }

    public void updateOPAQUE(int columnIndex, OPAQUE x) throws SQLException {
        this.updateOracleObject(columnIndex, (Datum)x);
    }

    public void updateREF(int columnIndex, REF x) throws SQLException {
        this.updateOracleObject(columnIndex, (Datum)x);
    }

    public void updateCHAR(int columnIndex, CHAR x) throws SQLException {
        this.updateOracleObject(columnIndex, (Datum)x);
    }

    public void updateRAW(int columnIndex, RAW x) throws SQLException {
        this.updateOracleObject(columnIndex, (Datum)x);
    }

    public void updateBLOB(int columnIndex, BLOB x) throws SQLException {
        this.updateOracleObject(columnIndex, (Datum)x);
    }

    public void updateCLOB(int columnIndex, CLOB x) throws SQLException {
        this.updateOracleObject(columnIndex, (Datum)x);
    }

    public void updateBFILE(int columnIndex, BFILE x) throws SQLException {
        this.updateOracleObject(columnIndex, (Datum)x);
    }

    public void updateBfile(int columnIndex, BFILE x) throws SQLException {
        this.updateOracleObject(columnIndex, (Datum)x);
    }

    public void updateCustomDatum(int columnIndex, CustomDatum x) throws SQLException {
        Datum d2 = x.toDatum(this.m_conn);
        this.updateOracleObject(columnIndex, d2);
    }

    public void updateORAData(int columnIndex, ORAData x) throws SQLException {
        Datum d2 = x.toDatum(this.m_conn);
        this.updateOracleObject(columnIndex, d2);
    }

    public void updateRef(int columnIndex, Ref x) throws SQLException {
        this.updateREF(columnIndex, (REF)x);
    }

    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        this.updateBLOB(columnIndex, (BLOB)x);
    }

    public void updateClob(int columnIndex, Clob x) throws SQLException {
        this.updateCLOB(columnIndex, (CLOB)x);
    }

    public void updateArray(int columnIndex, Array x) throws SQLException {
        this.updateARRAY(columnIndex, (ARRAY)x);
    }

    private int getColumnCount() throws SQLException {
        if (this.m_columnCount == 0) {
            this.m_columnCount = this.m_rset instanceof OracleResultSetImpl ? (((OracleResultSetImpl)this.m_rset).statement.defines != null ? ((OracleResultSetImpl)this.m_rset).statement.defines.getNoOfArgs() : this.getInternalMetadata().getColumnCount()) : ((ScrollableResultSet)this.m_rset).getColumnCount();
        }
        return this.m_columnCount;
    }

    private ResultSetMetaData getInternalMetadata() throws SQLException {
        if (this.m_metadata == null) {
            this.m_metadata = this.m_rset.getMetaData();
        }
        return this.m_metadata;
    }

    private void cancelRowChanges() throws SQLException {
        if (this.m_isInserting) {
            this.cancelRowInserts();
        }
        if (this.m_isUpdating) {
            this.cancelRowUpdates();
        }
    }

    boolean isOnInsertRow() {
        return this.m_isInserting;
    }

    private void cancelRowInserts() {
        if (this.m_isInserting) {
            this.m_isInserting = false;
            this.clearRowBuffer();
        }
    }

    boolean isUpdatingRow() {
        return this.m_isUpdating;
    }

    private void clearRowBuffer() {
        int i2;
        if (this.m_rowBuffer != null) {
            i2 = 0;
            while (i2 < this.m_rowBuffer.length) {
                this.m_rowBuffer[i2] = null;
                ++i2;
            }
        }
        if (this.m_nullIndicator != null) {
            i2 = 0;
            while (i2 < this.m_nullIndicator.length) {
                this.m_nullIndicator[i2] = false;
                ++i2;
            }
        }
        if (this.m_typeInfo != null) {
            i2 = 0;
            while (i2 < this.m_typeInfo.length) {
                if (this.m_typeInfo[i2] != null) {
                    int j2 = 0;
                    while (j2 < this.m_typeInfo[i2].length) {
                        this.m_typeInfo[i2][j2] = 0;
                        ++j2;
                    }
                }
                ++i2;
            }
        }
    }

    private void setRowBufferAt(int idx, Datum value) throws SQLException {
        this.setRowBufferAt(idx, value, null);
    }

    private void setRowBufferAt(int idx, Object value, int[] info) throws SQLException {
        if (!this.m_isInserting) {
            if (this.isBeforeFirst() || this.isAfterLast() || this.getRow() == 0) {
                DBError.throwSqlException((int)82);
            } else {
                this.m_isUpdating = true;
            }
        }
        if (idx < 1 || idx > this.getColumnCount() - 1) {
            DBError.throwSqlException((int)68, (Object)"setRowBufferAt");
        }
        if (this.m_rowBuffer == null) {
            this.m_rowBuffer = new Object[this.getColumnCount()];
        }
        if (this.m_nullIndicator == null) {
            this.m_nullIndicator = new boolean[this.getColumnCount()];
            int i2 = 0;
            while (i2 < this.getColumnCount()) {
                this.m_nullIndicator[i2] = false;
                ++i2;
            }
        }
        if (info != null) {
            if (this.m_typeInfo == null) {
                this.m_typeInfo = new int[this.getColumnCount()][];
            }
            this.m_typeInfo[idx] = info;
        }
        this.m_rowBuffer[idx] = value;
        this.m_nullIndicator[idx] = value == null;
    }

    private Datum getRowBufferDatumAt(int idx) throws SQLException {
        Object value;
        if (idx < 1 || idx > this.getColumnCount() - 1) {
            DBError.throwSqlException((int)68, (Object)"getRowBufferDatumAt");
        }
        Datum datum = null;
        if (this.m_rowBuffer != null && (value = this.m_rowBuffer[idx]) != null) {
            if (value instanceof Datum) {
                datum = (Datum)value;
            } else {
                datum = SQLUtil.makeOracleDatum((OracleConnection)this.m_conn, (Object)value, (int)this.getInternalMetadata().getColumnType(idx + 1), null);
                this.m_rowBuffer[idx] = datum;
            }
        }
        return datum;
    }

    private Object getRowBufferAt(int idx) throws SQLException {
        if (idx < 1 || idx > this.getColumnCount() - 1) {
            DBError.throwSqlException((int)68, (Object)"getRowBufferDatumAt");
        }
        if (this.m_rowBuffer != null) {
            return this.m_rowBuffer[idx];
        }
        return null;
    }

    private boolean isRowBufferUpdatedAt(int idx) {
        if (this.m_rowBuffer == null) {
            return false;
        }
        return this.m_rowBuffer[idx] != null || this.m_nullIndicator[idx];
    }

    private void prepare_insertRow_statement() throws SQLException {
        if (this.m_insertStmt == null) {
            StringBuffer insertSql = new StringBuffer();
            insertSql.append("insert into (");
            insertSql.append(this.m_scrollStmt.getOriginalSql());
            insertSql.append(") values ( ");
            int i2 = 1;
            while (i2 < this.getColumnCount()) {
                if (i2 != 1) {
                    insertSql.append(", ");
                }
                insertSql.append("?");
                ++i2;
            }
            insertSql.append(")");
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)1, (int)32, (int)128, (String)("insertSql: " + insertSql.toString()));
            }
            this.m_insertStmt = (OraclePreparedStatement)this.m_conn.prepareStatement(insertSql.toString());
            this.m_insertStmt.setQueryTimeout(((Statement)((Object)this.m_scrollStmt)).getQueryTimeout());
        }
    }

    private void prepare_insertRow_binds() throws SQLException {
        int idxBound = 1;
        idxBound = this.prepare_subquery_binds(this.m_insertStmt, idxBound);
        int i2 = 1;
        while (i2 < this.getColumnCount()) {
            Object value = this.getRowBufferAt(i2);
            if (value != null) {
                if (value instanceof Reader) {
                    this.m_insertStmt.setCharacterStream(idxBound + i2 - 1, (Reader)value, this.m_typeInfo[i2][0]);
                } else if (value instanceof InputStream) {
                    if (this.m_typeInfo[i2][1] == 2) {
                        this.m_insertStmt.setBinaryStream(idxBound + i2 - 1, (InputStream)value, this.m_typeInfo[i2][0]);
                    } else if (this.m_typeInfo[i2][1] == 1) {
                        this.m_insertStmt.setAsciiStream(idxBound + i2 - 1, (InputStream)value, this.m_typeInfo[i2][0]);
                    }
                } else {
                    Datum datum = this.getRowBufferDatumAt(i2);
                    this.m_insertStmt.setOracleObject(idxBound + i2 - 1, datum);
                }
            } else {
                int colType;
                if (OracleLog.TRACE) {
                    OracleLog.print((Object)this, (int)1, (int)32, (int)128, (String)("bind insert stmt to null at " + (idxBound + i2 - 1) + " with type" + this.getInternalMetadata().getColumnType(i2 + 1)));
                }
                if ((colType = this.getInternalMetadata().getColumnType(i2 + 1)) == 2006 || colType == 2002 || colType == 2008 || colType == 2007 || colType == 2003) {
                    this.m_insertStmt.setNull(idxBound + i2 - 1, colType, this.getInternalMetadata().getColumnTypeName(i2 + 1));
                } else {
                    this.m_insertStmt.setNull(idxBound + i2 - 1, colType);
                }
            }
            ++i2;
        }
    }

    private void execute_insertRow() throws SQLException {
        if (this.m_insertStmt.executeUpdate() != 1) {
            DBError.throwSqlException((int)85);
        }
    }

    private int get_num_columns_changed() throws SQLException {
        int i2;
        int _numColsChanged = 0;
        if (this.m_idxColsChanged == null) {
            this.m_idxColsChanged = new int[this.getColumnCount()];
        }
        if (this.m_rowBuffer != null) {
            i2 = 1;
            while (i2 < this.getColumnCount()) {
                if (this.m_rowBuffer[i2] != null || this.m_rowBuffer[i2] == null && this.m_nullIndicator[i2]) {
                    this.m_idxColsChanged[_numColsChanged++] = i2;
                }
                ++i2;
            }
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)32, (String)("numColsChanged = " + _numColsChanged));
            if (_numColsChanged != 0) {
                i2 = 0;
                while (i2 < _numColsChanged) {
                    OracleLog.print((Object)this, (int)1, (int)32, (int)64, (String)(" " + this.m_idxColsChanged[i2]));
                    ++i2;
                }
            }
        }
        return _numColsChanged;
    }

    private void prepare_updateRow_statement(int _numColsChanged) throws SQLException {
        if (this.m_updateStmt != null) {
            this.m_updateStmt.close();
        }
        StringBuffer updateSql = new StringBuffer();
        if (this.m_updateSql1 == null) {
            StringBuffer _updateSql1 = new StringBuffer();
            _updateSql1.append("update (");
            _updateSql1.append(this.m_scrollStmt.getRevisedSql());
            _updateSql1.append(") set ");
            this.m_updateSql1 = _updateSql1.toString();
        }
        updateSql.append(this.m_updateSql1);
        if (this.m_rowBuffer != null) {
            int i2 = 0;
            while (i2 < _numColsChanged) {
                if (i2 > 0) {
                    updateSql.append(", ");
                }
                updateSql.append(this.getInternalMetadata().getColumnName(this.m_idxColsChanged[i2] + 1));
                updateSql.append(" = ? ");
                ++i2;
            }
        }
        StringBuffer _updateSql2 = new StringBuffer();
        if (this.m_updateSql2 == null) {
            _updateSql2.append(" WHERE ");
            this.prepare_compare_self_sql(_updateSql2);
            this.m_updateSql2 = _updateSql2.toString();
        }
        updateSql.append(this.m_updateSql2);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)128, (String)("m_updateSql = " + updateSql.toString()));
        }
        this.m_updateStmt = (OraclePreparedStatement)this.m_conn.prepareStatement(updateSql.toString());
        this.m_updateStmt.setQueryTimeout(((Statement)((Object)this.m_scrollStmt)).getQueryTimeout());
    }

    private void prepare_updateRow_binds(int _numColsChanged) throws SQLException {
        int idxBound = 1;
        idxBound = this.prepare_subquery_binds(this.m_updateStmt, idxBound);
        int i2 = 0;
        while (i2 < _numColsChanged) {
            int idx = this.m_idxColsChanged[i2];
            Object value = this.getRowBufferAt(idx);
            if (value != null) {
                if (value instanceof Reader) {
                    this.m_updateStmt.setCharacterStream(idxBound++, (Reader)value, this.m_typeInfo[idx][0]);
                } else if (value instanceof InputStream) {
                    if (this.m_typeInfo[idx][1] == 2) {
                        this.m_updateStmt.setBinaryStream(idxBound++, (InputStream)value, this.m_typeInfo[idx][0]);
                    } else if (this.m_typeInfo[idx][1] == 1) {
                        this.m_updateStmt.setAsciiStream(idxBound++, (InputStream)value, this.m_typeInfo[idx][0]);
                    }
                } else {
                    Datum datum = this.getRowBufferDatumAt(idx);
                    this.m_updateStmt.setOracleObject(idxBound++, datum);
                }
            } else {
                int colType = this.getInternalMetadata().getColumnType(idx + 1);
                if (colType == 2006 || colType == 2002 || colType == 2008 || colType == 2007 || colType == 2003) {
                    this.m_updateStmt.setNull(idxBound++, colType, this.getInternalMetadata().getColumnTypeName(idx + 1));
                } else {
                    this.m_updateStmt.setNull(idxBound++, colType);
                }
            }
            ++i2;
        }
        this.prepare_compare_self_binds(this.m_updateStmt, idxBound);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute_updateRow() throws SQLException {
        try {
            if (this.m_updateStmt.executeUpdate() == 0) {
                DBError.throwSqlException((int)85);
            }
            if (this.m_isCachedRset) {
                if (this.m_autoRefetch) {
                    ((ScrollableResultSet)this.m_rset).refreshRowsInCache(this.getRow(), 1, 1000);
                    this.cancelRowUpdates();
                } else {
                    if (this.m_rowBuffer != null) {
                        int i2 = 1;
                        while (i2 < this.getColumnCount()) {
                            if (this.m_rowBuffer[i2] != null || this.m_rowBuffer[i2] == null && this.m_nullIndicator[i2]) {
                                ((ScrollableResultSet)this.m_rset).setCurrentRowValueAt(this, i2 + 1, this.m_rowBuffer[i2]);
                            }
                            ++i2;
                        }
                    }
                    this.cancelRowUpdates();
                }
            }
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.m_updateStmt.close();
            this.m_updateStmt = null;
            throw throwable;
        }
        this.m_updateStmt.close();
        this.m_updateStmt = null;
    }

    private void prepare_deleteRow_statement() throws SQLException {
        if (this.m_deleteStmt == null) {
            StringBuffer deleteSql = new StringBuffer();
            deleteSql.append("delete from (");
            deleteSql.append(this.m_scrollStmt.getRevisedSql());
            deleteSql.append(") where ");
            this.prepare_compare_self_sql(deleteSql);
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)1, (int)32, (int)128, (String)("deleteSql = " + deleteSql.toString()));
            }
            this.m_deleteStmt = (OraclePreparedStatement)this.m_conn.prepareStatement(deleteSql.toString());
            this.m_deleteStmt.setQueryTimeout(((Statement)((Object)this.m_scrollStmt)).getQueryTimeout());
        }
    }

    private void prepare_deleteRow_binds() throws SQLException {
        int idxBound = 1;
        idxBound = this.prepare_subquery_binds(this.m_deleteStmt, idxBound);
        this.prepare_compare_self_binds(this.m_deleteStmt, idxBound);
    }

    private void execute_deleteRow() throws SQLException {
        if (this.m_deleteStmt.executeUpdate() == 0) {
            DBError.throwSqlException((int)85);
        }
        if (this.m_isCachedRset) {
            ((ScrollableResultSet)this.m_rset).removeRowInCache(this.getRow());
        }
    }

    private void prepare_compare_self_sql(StringBuffer compareSelfSql) throws SQLException {
        compareSelfSql.append(" ROWID = ? ");
    }

    private int prepare_compare_self_binds(OraclePreparedStatement pstmt, int idxBound) throws SQLException {
        Datum datum = this.m_rset.getOracleObject(1);
        pstmt.setOracleObject(idxBound, this.m_rset.getOracleObject(1));
        return idxBound + 1;
    }

    private int prepare_subquery_binds(OraclePreparedStatement pstmt, int idxBound) throws SQLException {
        int _idxBound = idxBound - 1;
        int _numSubQueryBinds = 0;
        DBDataSet _subQueryBinds = this.m_scrollStmt.getBinds();
        if (_subQueryBinds != null) {
            _numSubQueryBinds = _subQueryBinds.getNoOfArgs();
            int i2 = 0;
            while (i2 < _numSubQueryBinds) {
                pstmt.setItem(_idxBound++, _subQueryBinds.getType(i2), _subQueryBinds.getBytesItem(i2, 0));
                ++i2;
            }
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)32, (String)("numSubQueryBinds = " + _numSubQueryBinds));
        }
        return _numSubQueryBinds + 1;
    }

    private void setIsNull(int status) {
        this.m_wasNull = status;
    }

    private void setIsNull(boolean isNull) {
        this.m_wasNull = isNull ? 1 : 2;
    }

    static {
        s_concurrencyType = 1008;
        s_beginColumnIndex = 1;
        VALUE_NULL = 1;
        VALUE_NOT_NULL = 2;
        VALUE_UNKNOWN = 3;
        VALUE_IN_RSET = 4;
        ASCII_STREAM = 1;
        BINARY_STREAM = 2;
        UNICODE_STREAM = 3;
        _MIN_STREAM_SIZE = 4000;
    }
}

