/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCHAR;
import oracle.jdbc.oracore.OracleTypeFLOAT;
import oracle.jdbc.oracore.OracleTypeNUMBER;
import oracle.jdbc.oracore.OracleTypeRAW;
import oracle.jdbc.oracore.OracleTypeREF;
import oracle.sql.StructDescriptor;

public class StructMetaData
implements oracle.jdbc.internal.StructMetaData {
    StructDescriptor m_desc;
    OracleTypeADT m_otype;
    OracleType[] m_types;

    public StructMetaData(StructDescriptor desc) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (String)("StructMetaData.StructMetaData(desc=" + desc + ")"));
        }
        if (desc == null) {
            DBError.check_error((int)1, (Object)"illegal operation: descriptor is null");
        }
        this.m_desc = desc;
        this.m_otype = desc.getOracleTypeADT();
        this.m_types = this.m_otype.getAttrTypes();
    }

    public int getColumnCount() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)1, (String)"StructMetaData.getColumnCount()");
        }
        return this.m_types.length;
    }

    public boolean isAutoIncrement(int column) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)1, (String)("StructMetaData.isAutoIncrement(column=" + column + "): return: false"));
        }
        return false;
    }

    public boolean isSearchable(int column) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)1, (String)("StructMetaData.isSearchable(column=" + column + "): TODO return: false"));
        }
        return false;
    }

    public boolean isCurrency(int column) throws SQLException {
        int idx;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)1, (String)("StructMetaData.isCurrency(column=" + column + ")"));
        }
        return this.m_types[idx = this.getValidColumnIndex(column)] instanceof OracleTypeNUMBER || this.m_types[idx] instanceof OracleTypeFLOAT;
    }

    public boolean isCaseSensitive(int column) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)1, (String)("StructMetaData.isCaseSensitive(column=" + column + ")"));
        }
        int idx = this.getValidColumnIndex(column);
        return this.m_types[idx] instanceof OracleTypeCHAR;
    }

    public int isNullable(int column) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)1, (String)("StructMetaData.isNullable(column=" + column + "): return: " + 1));
        }
        return 1;
    }

    public boolean isSigned(int column) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)1, (String)("StructMetaData.isSigned(column=" + column + "): return: true"));
        }
        return true;
    }

    public int getColumnDisplaySize(int column) throws SQLException {
        int idx;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)1, (String)("StructMetaData.getColumnDisplaySize(column=" + column + ")"));
        }
        if (this.m_types[idx = this.getValidColumnIndex(column)] instanceof OracleTypeCHAR) {
            return ((OracleTypeCHAR)this.m_types[idx]).getLength();
        }
        if (this.m_types[idx] instanceof OracleTypeRAW) {
            return ((OracleTypeRAW)this.m_types[idx]).getLength();
        }
        return 0;
    }

    public String getColumnLabel(int column) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)1, (String)("StructMetaData.getColumnLabel(column=" + column + ")"));
        }
        return this.getColumnName(column);
    }

    public String getColumnName(int column) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)1, (String)("StructMetaData.getColumnName(column=" + column + ")"));
        }
        int idx = this.getValidColumnIndex(column);
        return this.m_otype.getAttributeName(column);
    }

    public String getSchemaName(int column) throws SQLException {
        int idx;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)1, (String)("StructMetaData.getSchemaName(column=" + column + ")"));
        }
        if (this.m_types[idx = this.getValidColumnIndex(column)] instanceof OracleTypeADT) {
            return ((OracleTypeADT)this.m_types[idx]).getSchemaName();
        }
        return "";
    }

    public int getPrecision(int column) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)1, (String)("StructMetaData.getPrecision(column=" + column + ")"));
        }
        int idx = this.getValidColumnIndex(column);
        return this.m_types[idx].getPrecision();
    }

    public int getScale(int column) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)1, (String)("StructMetaData.getScale(column=" + column + ")"));
        }
        int idx = this.getValidColumnIndex(column);
        return this.m_types[idx].getScale();
    }

    public String getTableName(int column) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (String)("StructMetaData.getTableName(column=" + column + "): return: null"));
        }
        return null;
    }

    public String getCatalogName(int column) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (String)("StructMetaData.getCatalogName(column=" + column + "): return: null"));
        }
        return null;
    }

    public int getColumnType(int column) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)1, (String)("StructMetaData.getColumnType(column=" + column + ")"));
        }
        int idx = this.getValidColumnIndex(column);
        return this.m_types[idx].getTypeCode();
    }

    public String getColumnTypeName(int column) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)1, (String)("StructMetaData.getColumnTypeName(column=" + column + ")"));
        }
        int type = this.getColumnType(column);
        int idx = this.getValidColumnIndex(column);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)64, (String)("StructMetaData.getColumnTypeName(column=" + column + "): " + "type=" + type));
        }
        switch (type) {
            case 12: {
                return "VARCHAR";
            }
            case 1: {
                return "CHAR";
            }
            case -2: {
                return "RAW";
            }
            case 6: {
                return "FLOAT";
            }
            case 2: {
                return "NUMBER";
            }
            case 8: {
                return "DOUBLE";
            }
            case 3: {
                return "DECIMAL";
            }
            case 91: {
                return "DATE";
            }
            case -104: {
                return "INTERVALDS";
            }
            case -103: {
                return "INTERVALYM";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -101: {
                return "TIMESTAMPTZ";
            }
            case -102: {
                return "TIMESTAMPLTZ";
            }
            case 2004: {
                return "BLOB";
            }
            case 2005: {
                return "CLOB";
            }
            case -13: {
                return "BFILE";
            }
            case 2002: 
            case 2003: 
            case 2007: 
            case 2008: {
                return ((OracleTypeADT)this.m_types[idx]).getFullName();
            }
            case 2006: {
                return "REF " + ((OracleTypeREF)this.m_types[idx]).getFullName();
            }
        }
        return null;
    }

    public boolean isReadOnly(int column) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (String)("StructMetaData.isReadOnly(column=" + column + "): return: false"));
        }
        return false;
    }

    public boolean isWritable(int column) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (String)("StructMetaData.isWritable(column=" + column + "): return: false"));
        }
        return false;
    }

    public boolean isDefinitelyWritable(int column) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (String)("StructMetaData.isDefinitelyWritable(column=" + column + "): return: false"));
        }
        return false;
    }

    public String getColumnClassName(int column) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)1, (String)("StructMetaData.getColumnClassName(column=" + column + ")"));
        }
        int type = this.getColumnType(column);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)64, (String)("StructMetaData.getColumnClassName(column=" + column + "): " + "type=" + type));
        }
        switch (type) {
            case 1: 
            case 12: {
                return "java.lang.String";
            }
            case -2: {
                return "byte[]";
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: {
                return "java.math.BigDecimal";
            }
            case 91: {
                return "java.sql.Timestamp";
            }
            case -103: {
                return "oracle.sql.INTERVALYM";
            }
            case 93: {
                return "oracle.sql.TIMESTAMP";
            }
            case -101: {
                return "oracle.sql.TIMESTAMPTZ";
            }
            case -102: {
                return "oracle.sql.TIMESTAMPLTZ";
            }
            case 2004: {
                return "oracle.sql.BLOB";
            }
            case 2005: {
                return "oracle.sql.CLOB";
            }
            case -13: {
                return "oracle.sql.BFILE";
            }
            case 2002: 
            case 2008: {
                return "oracle.sql.STRUCT";
            }
            case 2007: {
                return "oracle.sql.OPAQUE";
            }
            case 2003: {
                return "oracle.sql.ARRAY";
            }
            case 2006: {
                return "oracle.sql.REF";
            }
        }
        return null;
    }

    public String getOracleColumnClassName(int column) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)1, (String)("StructMetaData.getOracleColumnClassName(column=" + column + ")"));
        }
        int type = this.getColumnType(column);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)64, (String)("StructMetaData.getOracleColumnClassName(column=" + column + "): " + "type=" + type));
        }
        switch (type) {
            case 1: 
            case 12: {
                return "CHAR";
            }
            case -2: {
                return "RAW";
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: {
                return "NUMBER";
            }
            case 91: {
                return "DATE";
            }
            case -103: {
                return "INTERVALYM";
            }
            case -104: {
                return "INTERVALDS";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -101: {
                return "TIMESTAMPTZ";
            }
            case -102: {
                return "TIMESTAMPLTZ";
            }
            case 2004: {
                return "BLOB";
            }
            case 2005: {
                return "CLOB";
            }
            case -13: {
                return "BFILE";
            }
            case 2002: {
                return "STRUCT";
            }
            case 2008: {
                return "JAVA_STRUCT";
            }
            case 2007: {
                return "OPAQUE";
            }
            case 2003: {
                return "ARRAY";
            }
            case 2006: {
                return "REF";
            }
        }
        return null;
    }

    public int getLocalColumnCount() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (String)("StructMetaData.getLocalColumnCount(): return: " + this.m_desc.getLocalAttributeCount()));
        }
        return this.m_desc.getLocalAttributeCount();
    }

    public boolean isInherited(int column) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (String)("StructMetaData.isInherited(): return: " + (column <= this.getColumnCount() - this.getLocalColumnCount())));
        }
        return column <= this.getColumnCount() - this.getLocalColumnCount();
    }

    public String getAttributeJavaName(int column) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)1, (String)("StructMetaData.getAttributeJavaName(column=" + column + ")"));
        }
        int idx = this.getValidColumnIndex(column);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (String)("StructMetaData.getAttributeJavaName(column=" + column + "): return: " + this.m_desc.getAttributeJavaName(idx)));
        }
        return this.m_desc.getAttributeJavaName(idx);
    }

    private int getValidColumnIndex(int column) throws SQLException {
        int index;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)1, (String)("StructMetaData.getValidColumnIndex(column=" + column + ")"));
        }
        if ((index = column - 1) < 0 || index >= this.m_types.length) {
            DBError.check_error((int)3, (Object)"getValidColumnIndex");
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (String)("StructMetaData.getValidColumnIndex: return: " + index));
        }
        return index;
    }

    public boolean isNCHAR(int column) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)1, (String)("StructMetaData.isNCHAR(column=" + column + ")"));
        }
        int idx = this.getValidColumnIndex(column);
        return this.m_types[idx].isNCHAR();
    }
}

