/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleResultSetImpl;
import oracle.jdbc.driver.ScrollRsetStatement;
import oracle.jdbc.driver.ScrollableResultSet;

public class SensitiveScrollableResultSet
extends ScrollableResultSet {
    public static boolean DEBUG = false;
    private int m_beginLastFetchedIdx;
    private int m_endLastFetchedIdx;

    public SensitiveScrollableResultSet(ScrollRsetStatement scrollStmt, OracleResultSetImpl rset, int type, int update) throws SQLException {
        super(scrollStmt, rset, type, update);
        int valid_rows;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)16, (String)("SensitiveScrollableResultSet.SensitiveScrollableResultSet(scrollStmt, rset, type= " + type + " update=" + update + ")"));
        }
        if ((valid_rows = rset.getValidRows()) > 0) {
            this.m_beginLastFetchedIdx = 1;
            this.m_endLastFetchedIdx = valid_rows;
        } else {
            this.m_beginLastFetchedIdx = 0;
            this.m_endLastFetchedIdx = 0;
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)16, (String)"SensitiveScrollableResultSet.SensitiveScrollableResultSet:return");
        }
    }

    public synchronized boolean next() throws SQLException {
        if (super.next()) {
            this.handle_refetch();
            return true;
        }
        return false;
    }

    public synchronized boolean first() throws SQLException {
        if (super.first()) {
            this.handle_refetch();
            return true;
        }
        return false;
    }

    public synchronized boolean last() throws SQLException {
        if (super.last()) {
            this.handle_refetch();
            return true;
        }
        return false;
    }

    public synchronized boolean absolute(int row) throws SQLException {
        if (super.absolute(row)) {
            this.handle_refetch();
            return true;
        }
        return false;
    }

    public synchronized boolean relative(int rows) throws SQLException {
        if (super.relative(rows)) {
            this.handle_refetch();
            return true;
        }
        return false;
    }

    public synchronized boolean previous() throws SQLException {
        if (super.previous()) {
            this.handle_refetch();
            return true;
        }
        return false;
    }

    public synchronized void refreshRow() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)16, (String)"refreshRow()");
        }
        if (!this.isValidRow(this.m_currentRow)) {
            DBError.throwSqlException((int)11);
        }
        int direction = this.getFetchDirection();
        int realSz = 0;
        try {
            realSz = this.refreshRowsInCache(this.m_currentRow, this.getFetchSize(), direction);
        }
        catch (SQLException e2) {
            DBError.throwSqlException((SQLException)e2, (int)90, (Object)"Unsupported syntax for refreshRow()");
        }
        if (realSz != 0) {
            this.m_beginLastFetchedIdx = this.m_currentRow;
            this.m_endLastFetchedIdx = this.m_currentRow + realSz - 1;
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)16, (String)"refreshRow:return");
        }
    }

    synchronized int removeRowInCache(int rowIdx) throws SQLException {
        int retval = super.removeRowInCache(rowIdx);
        if (retval != 0) {
            if (rowIdx >= this.m_beginLastFetchedIdx && rowIdx <= this.m_endLastFetchedIdx && this.m_beginLastFetchedIdx != this.m_endLastFetchedIdx) {
                --this.m_endLastFetchedIdx;
            } else {
                this.m_endLastFetchedIdx = 0;
                this.m_beginLastFetchedIdx = 0;
            }
        }
        return retval;
    }

    private boolean handle_refetch() throws SQLException {
        if (this.m_currentRow >= this.m_beginLastFetchedIdx && this.m_currentRow <= this.m_endLastFetchedIdx || this.m_currentRow >= this.m_endLastFetchedIdx && this.m_currentRow <= this.m_beginLastFetchedIdx) {
            return false;
        }
        this.refreshRow();
        return true;
    }
}

