/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.Vector;
import oracle.jdbc.dbaccess.DBConversion;
import oracle.jdbc.dbaccess.DBDataSet;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.BaseResultSet;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleResultSetCache;
import oracle.jdbc.driver.OracleResultSetCacheImpl;
import oracle.jdbc.driver.OracleResultSetImpl;
import oracle.jdbc.driver.OracleResultSetMetaData;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.ScrollRsetStatement;
import oracle.jdbc.driver.UpdatableResultSet;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.SQLUtil;
import oracle.sql.STRUCT;

public class ScrollableResultSet
extends BaseResultSet {
    public OracleConnection m_conn;
    OracleResultSetImpl m_rset;
    ScrollRsetStatement m_scrollStmt;
    ResultSetMetaData m_metadata;
    private int m_type;
    private int m_update;
    private int m_beginColumnIndex;
    private int m_columnCount;
    private int m_wasNull;
    OracleResultSetCache m_cache;
    int m_currentRow;
    private int m_numRowsCached;
    private boolean m_allRowsCached;
    private int m_lastRefetchSz;
    private Vector m_refetchRowids;
    private OraclePreparedStatement m_refetchStmt;
    private int m_usrFetchDirection;

    public ScrollableResultSet(ScrollRsetStatement scrollStmt, OracleResultSetImpl rset, int type, int update) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ScrollableResultSet.ScrollableResultSet(scrollStmt=" + scrollStmt + ", rset=" + rset + ", type=" + type + ", update=" + update));
        }
        this.m_conn = (OracleConnection)scrollStmt.getConnection();
        this.m_rset = rset;
        this.m_metadata = null;
        this.m_scrollStmt = scrollStmt;
        this.m_type = type;
        this.m_update = update;
        this.m_autoRefetch = scrollStmt.getAutoRefetch();
        this.m_beginColumnIndex = ScrollableResultSet.needIdentifier(type, update) ? 1 : 0;
        this.m_columnCount = 0;
        this.m_wasNull = -1;
        this.m_cache = scrollStmt.getResultSetCache();
        if (this.m_cache == null) {
            this.m_cache = new OracleResultSetCacheImpl();
        } else {
            try {
                this.m_cache.clear();
            }
            catch (IOException e2) {
                DBError.throwSqlException((IOException)e2);
            }
        }
        this.m_currentRow = 0;
        this.m_numRowsCached = 0;
        this.m_allRowsCached = false;
        this.m_lastRefetchSz = 0;
        this.m_refetchRowids = null;
        this.m_refetchStmt = null;
        this.m_usrFetchDirection = 1000;
    }

    public synchronized void close() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)"ScrollableResultSet.close()");
        }
        if (this.m_rset != null) {
            this.m_rset.close();
        }
        if (this.m_refetchStmt != null) {
            this.m_refetchStmt.close();
        }
        if (this.m_scrollStmt != null) {
            this.m_scrollStmt.notify_close_rset();
        }
        if (this.m_refetchRowids != null) {
            this.m_refetchRowids.removeAllElements();
        }
        this.m_rset = null;
        this.m_scrollStmt = null;
        this.m_refetchStmt = null;
        this.m_refetchRowids = null;
        this.m_metadata = null;
        this.m_conn = null;
        try {
            if (this.m_cache != null) {
                this.m_cache.clear();
                this.m_cache.close();
            }
        }
        catch (IOException e2) {
            DBError.throwSqlException((IOException)e2);
        }
        this.m_cache = null;
    }

    public synchronized boolean wasNull() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)"ScrollableResultSet.wasNull()");
        }
        if (this.m_wasNull == -1) {
            DBError.throwSqlException((int)24);
        }
        return this.m_wasNull == 1;
    }

    public synchronized Statement getStatement() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)16, (String)("ScrollableResultSet.getStatement: return: " + (Statement)((Object)this.m_scrollStmt)));
        }
        return (Statement)((Object)this.m_scrollStmt);
    }

    synchronized void resetBeginColumnIndex() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)"ScrollableResultSet.resetBeginColumnIndex()");
        }
        this.m_beginColumnIndex = 0;
    }

    synchronized ResultSet getResultSet() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)16, (String)("ScrollableResultSet.getResultSet: return: " + this.m_rset));
        }
        return this.m_rset;
    }

    synchronized int removeRowInCache(int rowIdx) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ScrollableResultSet.removeRowInCache(rowIdx=" + rowIdx + ")"));
        }
        if (!this.isEmptyResultSet() && this.isValidRow(rowIdx)) {
            this.removeCachedRowAt(rowIdx);
            --this.m_numRowsCached;
            if (rowIdx >= this.m_currentRow) {
                --this.m_currentRow;
            }
            return 1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    synchronized int refreshRowsInCache(int beginIdx, int count, int direction) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ScrollableResultSet.removeRowInCache(beginIdx=" + beginIdx + ", count=" + count + ", direction=" + direction + ")"));
        }
        OracleResultSet refetchRset = null;
        int actualRefetchSize = 0;
        actualRefetchSize = this.get_refetch_size(beginIdx, count, direction);
        try {
            if (actualRefetchSize > 0) {
                if (actualRefetchSize != this.m_lastRefetchSz) {
                    if (this.m_refetchStmt != null) {
                        this.m_refetchStmt.close();
                    }
                    this.m_refetchStmt = this.prepare_refetch_statement(actualRefetchSize);
                    this.m_lastRefetchSz = actualRefetchSize;
                    this.m_refetchStmt.setQueryTimeout(((OracleStatement)this.m_scrollStmt).getQueryTimeout());
                }
                this.prepare_refetch_binds(this.m_refetchStmt, actualRefetchSize);
                refetchRset = (OracleResultSet)this.m_refetchStmt.executeQuery();
                this.save_refetch_results(refetchRset, beginIdx, actualRefetchSize, direction);
            }
            Object var7_6 = null;
            if (refetchRset == null) return actualRefetchSize;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (refetchRset == null) throw throwable;
            refetchRset.close();
            throw throwable;
        }
        refetchRset.close();
        return actualRefetchSize;
    }

    public synchronized boolean next() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)"ScrollableResultSet.next()");
        }
        if (this.isEmptyResultSet()) {
            return false;
        }
        this.m_currentRow = this.m_currentRow < 1 ? 1 : ++this.m_currentRow;
        return this.isValidRow(this.m_currentRow);
    }

    public synchronized boolean isBeforeFirst() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)"ScrollableResultSet.isBeforeFirst()");
        }
        return !this.isEmptyResultSet() && this.m_currentRow < 1;
    }

    public synchronized boolean isAfterLast() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)"ScrollableResultSet.isAfterLast()");
        }
        return !this.isEmptyResultSet() && this.m_currentRow > 0 && !this.isValidRow(this.m_currentRow);
    }

    public synchronized boolean isFirst() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)16, (String)("ScrollableResultSet.isFirst: return: " + (this.m_currentRow == 1)));
        }
        return this.m_currentRow == 1;
    }

    public synchronized boolean isLast() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)"ScrollableResultSet.isLast()");
        }
        return !this.isEmptyResultSet() && this.isValidRow(this.m_currentRow) && !this.isValidRow(this.m_currentRow + 1);
    }

    public synchronized void beforeFirst() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)"ScrollableResultSet.beforeFirst()");
        }
        if (!this.isEmptyResultSet()) {
            this.m_currentRow = 0;
        }
    }

    public synchronized void afterLast() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)"ScrollableResultSet.afterLast()");
        }
        if (!this.isEmptyResultSet()) {
            this.m_currentRow = this.getLastRow() + 1;
        }
    }

    public synchronized boolean first() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)"ScrollableResultSet.first()");
        }
        if (this.isEmptyResultSet()) {
            return false;
        }
        this.m_currentRow = 1;
        return this.isValidRow(this.m_currentRow);
    }

    public synchronized boolean last() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)"ScrollableResultSet.last()");
        }
        if (this.isEmptyResultSet()) {
            return false;
        }
        this.m_currentRow = this.getLastRow();
        return this.isValidRow(this.m_currentRow);
    }

    public synchronized int getRow() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)"ScrollableResultSet.getRow()");
        }
        if (this.isValidRow(this.m_currentRow)) {
            return this.m_currentRow;
        }
        return 0;
    }

    public synchronized boolean absolute(int row) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ScrollableResultSet.absolute(row=" + row + ")"));
        }
        if (row == 0) {
            DBError.throwSqlException((int)68, (Object)"absolute (0)");
        }
        if (this.isEmptyResultSet()) {
            return false;
        }
        if (row > 0) {
            this.m_currentRow = row;
        } else if (row < 0) {
            this.m_currentRow = this.getLastRow() + 1 + row;
        }
        return this.isValidRow(this.m_currentRow);
    }

    public synchronized boolean relative(int rows) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ScrollableResultSet.relative(rows=" + rows + ")"));
        }
        if (this.isEmptyResultSet()) {
            return false;
        }
        if (this.isValidRow(this.m_currentRow)) {
            this.m_currentRow += rows;
            return this.isValidRow(this.m_currentRow);
        }
        DBError.throwSqlException((int)82, (Object)"relative");
        return false;
    }

    public synchronized boolean previous() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)"ScrollableResultSet.previous()");
        }
        if (this.isEmptyResultSet()) {
            return false;
        }
        this.m_currentRow = this.isAfterLast() ? this.getLastRow() : --this.m_currentRow;
        return this.isValidRow(this.m_currentRow);
    }

    public synchronized Datum getOracleObject(int columnIndex) throws SQLException {
        Datum value;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ScrollableResultSet.getOracleObject(columnIndex=" + columnIndex + "): m_currentRow=" + this.m_currentRow));
        }
        this.m_wasNull = -1;
        if (!this.isValidRow(this.m_currentRow)) {
            DBError.throwSqlException((int)11);
        }
        if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
            DBError.throwSqlException((int)3);
        }
        this.m_wasNull = (value = this.getCachedDatumValueAt(this.m_currentRow, columnIndex + this.m_beginColumnIndex)) == null ? 1 : 0;
        return value;
    }

    public synchronized String getString(int columnIndex) throws SQLException {
        Datum value;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ScrollableResultSet.getString(columnIndex=" + columnIndex + ")"));
        }
        if ((value = this.getOracleObject(columnIndex)) != null) {
            return value.stringValue();
        }
        return null;
    }

    public synchronized boolean getBoolean(int columnIndex) throws SQLException {
        Datum datum;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ScrollableResultSet.getBoolean(columnIndex=" + columnIndex + ")"));
        }
        if ((datum = this.getOracleObject(columnIndex)) != null) {
            return datum.booleanValue();
        }
        return false;
    }

    public synchronized byte getByte(int columnIndex) throws SQLException {
        Datum datum;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ScrollableResultSet.getByte(columnIndex=" + columnIndex + ")"));
        }
        if ((datum = this.getOracleObject(columnIndex)) != null) {
            return datum.byteValue();
        }
        return 0;
    }

    public synchronized short getShort(int columnIndex) throws SQLException {
        long result;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ScrollableResultSet.getShort(columnIndex=" + columnIndex + ")"));
        }
        if ((result = this.getLong(columnIndex)) > 65537L || result < -65538L) {
            DBError.check_error((int)26, (Object)"getShort");
        }
        return (short)result;
    }

    public synchronized int getInt(int columnIndex) throws SQLException {
        Datum datum;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ScrollableResultSet.getInt(columnIndex=" + columnIndex + ")"));
        }
        if ((datum = this.getOracleObject(columnIndex)) != null) {
            return datum.intValue();
        }
        return 0;
    }

    public synchronized long getLong(int columnIndex) throws SQLException {
        Datum datum;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ScrollableResultSet.getLong(columnIndex=" + columnIndex + ")"));
        }
        if ((datum = this.getOracleObject(columnIndex)) != null) {
            return datum.longValue();
        }
        return 0L;
    }

    public synchronized float getFloat(int columnIndex) throws SQLException {
        Datum datum;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ScrollableResultSet.getFloat(columnIndex=" + columnIndex + ")"));
        }
        if ((datum = this.getOracleObject(columnIndex)) != null) {
            return datum.floatValue();
        }
        return 0.0f;
    }

    public synchronized double getDouble(int columnIndex) throws SQLException {
        Datum datum;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ScrollableResultSet.getBouble(columnIndex=" + columnIndex + ")"));
        }
        if ((datum = this.getOracleObject(columnIndex)) != null) {
            return datum.doubleValue();
        }
        return 0.0;
    }

    public synchronized BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        Datum datum;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ScrollableResultSet.getBigDecimal(columnIndex=" + columnIndex + ")"));
        }
        if ((datum = this.getOracleObject(columnIndex)) != null) {
            return datum.bigDecimalValue();
        }
        return null;
    }

    public synchronized byte[] getBytes(int columnIndex) throws SQLException {
        Datum datum;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ScrollableResultSet.getBytes(columnIndex=" + columnIndex + ")"));
        }
        if ((datum = this.getOracleObject(columnIndex)) != null) {
            if (datum instanceof RAW) {
                return ((RAW)datum).shareBytes();
            }
            DBError.check_error((int)4, (Object)"getBytes");
        }
        return null;
    }

    public synchronized Date getDate(int columnIndex) throws SQLException {
        Datum datum;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ScrollableResultSet.getDate(columnIndex=" + columnIndex + ")"));
        }
        if ((datum = this.getOracleObject(columnIndex)) != null) {
            return datum.dateValue();
        }
        return null;
    }

    public synchronized Time getTime(int columnIndex) throws SQLException {
        Datum datum;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ScrollableResultSet.getTime(columnIndex=" + columnIndex + ")"));
        }
        if ((datum = this.getOracleObject(columnIndex)) != null) {
            return datum.timeValue();
        }
        return null;
    }

    public synchronized Timestamp getTimestamp(int columnIndex) throws SQLException {
        Datum datum;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ScrollableResultSet.getTimestamp(columnIndex=" + columnIndex + ")"));
        }
        if ((datum = this.getOracleObject(columnIndex)) != null) {
            return datum.timestampValue();
        }
        return null;
    }

    public synchronized InputStream getAsciiStream(int columnIndex) throws SQLException {
        Datum datum;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ScrollableResultSet.getAsciiStream(columnIndex=" + columnIndex + ")"));
        }
        if ((datum = this.getOracleObject(columnIndex)) != null) {
            return datum.asciiStreamValue();
        }
        return null;
    }

    public synchronized InputStream getUnicodeStream(int columnIndex) throws SQLException {
        Datum datum;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ScrollableResultSet.getUnicodeStream(columnIndex=" + columnIndex + ")"));
        }
        if ((datum = this.getOracleObject(columnIndex)) != null) {
            DBConversion dbconv = this.m_conn.conversion;
            byte[] bytes = datum.shareBytes();
            if (datum instanceof RAW) {
                return dbconv.ConvertStream((InputStream)new ByteArrayInputStream(bytes), 3);
            }
            if (datum instanceof CHAR) {
                return dbconv.ConvertStream((InputStream)new ByteArrayInputStream(bytes), 1);
            }
            DBError.check_error((int)4, (Object)"getUnicodeStream");
        }
        return null;
    }

    public synchronized InputStream getBinaryStream(int columnIndex) throws SQLException {
        Datum datum;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ScrollableResultSet.getBinaryStream(columnIndex=" + columnIndex + ")"));
        }
        if ((datum = this.getOracleObject(columnIndex)) != null) {
            return datum.binaryStreamValue();
        }
        return null;
    }

    public synchronized Object getObject(int columnIndex) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ScrollableResultSet.getObject(columnIndex=" + columnIndex + ")"));
        }
        return this.getObject(columnIndex, this.m_conn.getTypeMap());
    }

    public synchronized Reader getCharacterStream(int columnIndex) throws SQLException {
        Datum datum;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ScrollableResultSet.getCharacterStream(columnIndex=" + columnIndex + ")"));
        }
        if ((datum = this.getOracleObject(columnIndex)) != null) {
            return datum.characterStreamValue();
        }
        return null;
    }

    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ScrollableResultSet.getBigDecimal(columnIndex=" + columnIndex + ")"));
        }
        return this.getBigDecimal(columnIndex, 0);
    }

    public synchronized Object getObject(int columnIndex, Map map) throws SQLException {
        Datum datum;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ScrollableResultSet.getObject(columnIndex=" + columnIndex + ", map=" + map + ")"));
        }
        if ((datum = this.getOracleObject(columnIndex)) != null) {
            if (datum instanceof STRUCT) {
                return ((STRUCT)datum).toJdbc(map);
            }
            return datum.toJdbc();
        }
        return null;
    }

    public synchronized Ref getRef(int columnIndex) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ScrollableResultSet.getRef(columnIndex=" + columnIndex + ")"));
        }
        return this.getREF(columnIndex);
    }

    public synchronized Blob getBlob(int columnIndex) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ScrollableResultSet.getBlob(columnIndex=" + columnIndex + ")"));
        }
        return this.getBLOB(columnIndex);
    }

    public synchronized Clob getClob(int columnIndex) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ScrollableResultSet.getClob(columnIndex=" + columnIndex + ")"));
        }
        return this.getCLOB(columnIndex);
    }

    public synchronized Array getArray(int columnIndex) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ScrollableResultSet.getArray(columnIndex=" + columnIndex + ")"));
        }
        return this.getARRAY(columnIndex);
    }

    public synchronized Date getDate(int columnIndex, Calendar cal) throws SQLException {
        DATE d2;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ScrollableResultSet.getDate(columnIndex=" + columnIndex + ", cal=" + cal + ")"));
        }
        return (d2 = this.getDATE(columnIndex)) != null ? d2.dateValue(cal) : null;
    }

    public synchronized Time getTime(int columnIndex, Calendar cal) throws SQLException {
        DATE d2;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ScrollableResultSet.getTime(columnIndex=" + columnIndex + ", cal=" + cal + ")"));
        }
        return (d2 = this.getDATE(columnIndex)) != null ? d2.timeValue(cal) : null;
    }

    public synchronized Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        DATE d2;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ScrollableResultSet.getTimestamp(columnIndex=" + columnIndex + ", cal=" + cal + ")"));
        }
        return (d2 = this.getDATE(columnIndex)) != null ? d2.timestampValue(cal) : null;
    }

    public synchronized ResultSet getCursor(int columnIndex) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ScrollableResultSet.getCursor(columnIndex=" + columnIndex + ")"));
        }
        DBError.check_error((int)4, (Object)"getCursor");
        return null;
    }

    public synchronized ROWID getROWID(int columnIndex) throws SQLException {
        Datum datum;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ScrollableResultSet.getROWID(columnIndex=" + columnIndex + ")"));
        }
        if ((datum = this.getOracleObject(columnIndex)) != null) {
            if (datum instanceof ROWID) {
                return (ROWID)datum;
            }
            DBError.check_error((int)4, (Object)"getROWID");
        }
        return null;
    }

    public synchronized NUMBER getNUMBER(int columnIndex) throws SQLException {
        Datum datum;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ScrollableResultSet.getNUMBER(columnIndex=" + columnIndex + ")"));
        }
        if ((datum = this.getOracleObject(columnIndex)) != null) {
            if (datum instanceof NUMBER) {
                return (NUMBER)datum;
            }
            DBError.check_error((int)4, (Object)"getNUMBER");
        }
        return null;
    }

    public synchronized DATE getDATE(int columnIndex) throws SQLException {
        Datum datum;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ScrollableResultSet.getDATE(columnIndex=" + columnIndex + ")"));
        }
        if ((datum = this.getOracleObject(columnIndex)) != null) {
            if (datum instanceof DATE) {
                return (DATE)datum;
            }
            DBError.check_error((int)4, (Object)"getDATE");
        }
        return null;
    }

    public synchronized ARRAY getARRAY(int columnIndex) throws SQLException {
        Datum datum;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ScrollableResultSet.getARRAY(columnIndex=" + columnIndex + ")"));
        }
        if ((datum = this.getOracleObject(columnIndex)) != null) {
            if (datum instanceof ARRAY) {
                return (ARRAY)datum;
            }
            DBError.check_error((int)4, (Object)"getARRAY");
        }
        return null;
    }

    public synchronized STRUCT getSTRUCT(int columnIndex) throws SQLException {
        Datum datum;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ScrollableResultSet.getSTRUCT(columnIndex=" + columnIndex + ")"));
        }
        if ((datum = this.getOracleObject(columnIndex)) != null) {
            if (datum instanceof STRUCT) {
                return (STRUCT)datum;
            }
            DBError.check_error((int)4, (Object)"getSTRUCT");
        }
        return null;
    }

    public synchronized OPAQUE getOPAQUE(int columnIndex) throws SQLException {
        Datum datum;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ScrollableResultSet.getOPAQUE(columnIndex=" + columnIndex + ")"));
        }
        if ((datum = this.getOracleObject(columnIndex)) != null) {
            if (datum instanceof OPAQUE) {
                return (OPAQUE)datum;
            }
            DBError.check_error((int)4, (Object)"getOPAQUE");
        }
        return null;
    }

    public synchronized REF getREF(int columnIndex) throws SQLException {
        Datum datum;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ScrollableResultSet.getREF(columnIndex=" + columnIndex + ")"));
        }
        if ((datum = this.getOracleObject(columnIndex)) != null) {
            if (datum instanceof REF) {
                return (REF)datum;
            }
            DBError.check_error((int)4, (Object)"getREF");
        }
        return null;
    }

    public synchronized CHAR getCHAR(int columnIndex) throws SQLException {
        Datum datum;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ScrollableResultSet.getCHAR(columnIndex=" + columnIndex + ")"));
        }
        if ((datum = this.getOracleObject(columnIndex)) != null) {
            if (datum instanceof CHAR) {
                return (CHAR)datum;
            }
            DBError.check_error((int)4, (Object)"getCHAR");
        }
        return null;
    }

    public synchronized RAW getRAW(int columnIndex) throws SQLException {
        Datum datum;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ScrollableResultSet.getRAW(columnIndex=" + columnIndex + ")"));
        }
        if ((datum = this.getOracleObject(columnIndex)) != null) {
            if (datum instanceof RAW) {
                return (RAW)datum;
            }
            DBError.check_error((int)4, (Object)"getRAW");
        }
        return null;
    }

    public synchronized BLOB getBLOB(int columnIndex) throws SQLException {
        Datum datum;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ScrollableResultSet.getBLOB(columnIndex=" + columnIndex + ")"));
        }
        if ((datum = this.getOracleObject(columnIndex)) != null) {
            if (datum instanceof BLOB) {
                return (BLOB)datum;
            }
            DBError.check_error((int)4, (Object)"getBLOB");
        }
        return null;
    }

    public synchronized CLOB getCLOB(int columnIndex) throws SQLException {
        Datum datum;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ScrollableResultSet.getCLOB(columnIndex=" + columnIndex + ")"));
        }
        if ((datum = this.getOracleObject(columnIndex)) != null) {
            if (datum instanceof CLOB) {
                return (CLOB)datum;
            }
            DBError.check_error((int)4, (Object)"getCLOB");
        }
        return null;
    }

    public synchronized BFILE getBFILE(int columnIndex) throws SQLException {
        Datum datum;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ScrollableResultSet.getBFILE(columnIndex=" + columnIndex + ")"));
        }
        if ((datum = this.getOracleObject(columnIndex)) != null) {
            if (datum instanceof BFILE) {
                return (BFILE)datum;
            }
            DBError.check_error((int)4, (Object)"getBFILE");
        }
        return null;
    }

    public synchronized BFILE getBfile(int columnIndex) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ScrollableResultSet.getBfile(columnIndex=" + columnIndex + ")"));
        }
        return this.getBFILE(columnIndex);
    }

    public synchronized CustomDatum getCustomDatum(int columnIndex, CustomDatumFactory factory) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ScrollableResultSet.getCustomDatum(columnIndex=" + columnIndex + ")"));
        }
        Datum d2 = this.getOracleObject(columnIndex);
        return factory.create(d2, 0);
    }

    public synchronized ORAData getORAData(int columnIndex, ORADataFactory factory) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ScrollableResultSet.getORAData(columnIndex=" + columnIndex + ")"));
        }
        Datum d2 = this.getOracleObject(columnIndex);
        return factory.create(d2, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSetMetaData getMetaData() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)"ScrollableResultSet.getMetaData()");
        }
        OracleConnection oracleConnection = this.m_conn;
        synchronized (oracleConnection) {
            ScrollableResultSet scrollableResultSet = this;
            synchronized (scrollableResultSet) {
                OracleResultSetMetaData oracleResultSetMetaData = new OracleResultSetMetaData((oracle.jdbc.internal.OracleConnection)this.m_conn, (oracle.jdbc.internal.OracleStatement)((OracleStatement)this.m_scrollStmt), this.m_beginColumnIndex);
                return oracleResultSetMetaData;
            }
        }
    }

    public synchronized int findColumn(String columnName) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ScrollableResultSet.findColumn(columnName=" + columnName + ")"));
        }
        return this.m_rset.findColumn(columnName) - this.m_beginColumnIndex;
    }

    public synchronized void setFetchDirection(int direction) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ScrollableResultSet.setFetchDirection(direction=" + direction + ")"));
        }
        if (direction == 1000) {
            this.m_usrFetchDirection = direction;
        } else if (direction == 1001 || direction == 1002) {
            this.m_usrFetchDirection = direction;
            this.m_warning = DBError.addSqlWarning((SQLWarning)this.m_warning, (int)87);
        } else {
            DBError.throwSqlException((int)68, (Object)"setFetchDirection");
        }
    }

    public synchronized int getFetchDirection() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)"ScrollableResultSet.getFetchDirection()");
        }
        return 1000;
    }

    public synchronized void setFetchSize(int rows) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ScrollableResultSet.setFetchSize(rows=" + rows + ")"));
        }
        this.m_rset.setFetchSize(rows);
    }

    public synchronized int getFetchSize() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)"ScrollableResultSet.getFetchSize()");
        }
        return this.m_rset.getFetchSize();
    }

    public int getType() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)16, (String)("ScrollableResultSet.getType: return: " + this.m_type));
        }
        return this.m_type;
    }

    public int getConcurrency() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)16, (String)("ScrollableResultSet.getConcurrency: return: " + this.m_update));
        }
        return this.m_update;
    }

    public void refreshRow() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)"ScrollableResultSet.refreshRow()");
        }
        if (!ScrollableResultSet.needIdentifier(this.m_type, this.m_update)) {
            DBError.check_error((int)23, (Object)"refreshRow");
        }
        if (this.isValidRow(this.m_currentRow)) {
            int direction = this.getFetchDirection();
            try {
                this.refreshRowsInCache(this.m_currentRow, this.getFetchSize(), direction);
            }
            catch (SQLException e2) {
                DBError.throwSqlException((SQLException)e2, (int)90, (Object)"Unsupported syntax for refreshRow()");
            }
        } else {
            DBError.throwSqlException((int)82, (Object)"refreshRow");
        }
    }

    public void setCurrentRowValueAt(Object caller, int columnIdx, Object value) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ScrollableResultSet.setCurrentRowValueAt(caller=" + caller + ", columnIdx=" + columnIdx + ", value=" + value));
        }
        if (caller instanceof UpdatableResultSet) {
            this.putCachedValueAt(this.m_currentRow, columnIdx, value);
        } else {
            DBError.throwSqlException((int)1);
        }
    }

    private boolean isEmptyResultSet() throws SQLException {
        if (this.m_numRowsCached != 0) {
            return false;
        }
        if (this.m_numRowsCached == 0 && this.m_allRowsCached) {
            return true;
        }
        return !this.isValidRow(1);
    }

    boolean isValidRow(int idx) throws SQLException {
        if (idx > 0 && idx <= this.m_numRowsCached) {
            return true;
        }
        if (idx <= 0) {
            return false;
        }
        return this.cacheRowAt(idx);
    }

    private boolean cacheRowAt(int idx) throws SQLException {
        while (this.m_numRowsCached < idx && this.m_rset.next()) {
            int i2 = 0;
            while (i2 < this.getColumnCount()) {
                byte[] bytes = this.m_rset.getBytes(i2 + 1);
                this.putCachedValueAt(this.m_numRowsCached + 1, i2 + 1, bytes);
                ++i2;
            }
            ++this.m_numRowsCached;
        }
        if (this.m_numRowsCached < idx) {
            this.m_allRowsCached = true;
            return false;
        }
        return true;
    }

    private int cacheAllRows() throws SQLException {
        while (this.m_rset.next()) {
            int i2 = 0;
            while (i2 < this.getColumnCount()) {
                this.putCachedValueAt(this.m_numRowsCached + 1, i2 + 1, this.m_rset.getBytes(i2 + 1));
                ++i2;
            }
            ++this.m_numRowsCached;
        }
        this.m_allRowsCached = true;
        return this.m_numRowsCached;
    }

    int getColumnCount() throws SQLException {
        if (this.m_columnCount == 0) {
            int numberOfArgs = this.m_rset.statement.defines.getNoOfArgs();
            this.m_columnCount = this.m_rset.statement.defines != null && numberOfArgs > 0 ? numberOfArgs : this.getInternalMetadata().getColumnCount();
        }
        return this.m_columnCount;
    }

    private ResultSetMetaData getInternalMetadata() throws SQLException {
        if (this.m_metadata == null) {
            this.m_metadata = this.m_rset.getMetaData();
        }
        return this.m_metadata;
    }

    private int getLastRow() throws SQLException {
        if (!this.m_allRowsCached) {
            this.cacheAllRows();
        }
        return this.m_numRowsCached;
    }

    private int get_refetch_size(int beginIdx, int count, int direction) throws SQLException {
        int _direction = direction == 1001 ? -1 : 1;
        int realRefreshSz = 0;
        if (this.m_refetchRowids == null) {
            this.m_refetchRowids = new Vector(10);
        } else {
            this.m_refetchRowids.removeAllElements();
        }
        while (realRefreshSz < count && this.isValidRow(beginIdx + realRefreshSz * _direction)) {
            this.m_refetchRowids.addElement(this.getCachedDatumValueAt(beginIdx + realRefreshSz * _direction, 1));
            ++realRefreshSz;
        }
        return realRefreshSz;
    }

    private OraclePreparedStatement prepare_refetch_statement(int realRefreshSz) throws SQLException {
        int i2;
        String tempSql;
        if (realRefreshSz < 1) {
            DBError.throwSqlException((int)68);
        }
        StringBuffer refreshSql = new StringBuffer();
        String orderbySql = tempSql = this.m_scrollStmt.getRevisedSql().toUpperCase();
        int orderIndex = 0;
        int byIndex = 0;
        boolean orderbyFound = false;
        boolean whereIndex = false;
        int newPosition = 0;
        int quoteIndex = 0;
        while (orderIndex != -1) {
            quoteIndex = orderbySql.indexOf("'", newPosition);
            orderIndex = orderbySql.indexOf("ORDER", newPosition);
            while (quoteIndex != -1 && orderIndex != -1 && quoteIndex < orderIndex && (newPosition = this.trimQuote(orderbySql, quoteIndex + 1)) > orderIndex) {
                orderIndex = orderbySql.indexOf("ORDER", newPosition);
                quoteIndex = orderbySql.indexOf("'", newPosition);
            }
            if (orderIndex <= 0) continue;
            i2 = this.trimWhiteSpace(orderbySql, orderIndex + 5);
            if (i2 > orderIndex + 5) {
                newPosition = i2;
                byIndex = orderbySql.lastIndexOf("BY", newPosition);
                if (byIndex <= 0 || byIndex != newPosition) continue;
                orderbyFound = true;
                orderbySql = orderbySql.substring(orderIndex, orderbySql.length());
                refreshSql.append(tempSql.substring(0, orderIndex));
                break;
            }
            newPosition = orderIndex + 1;
        }
        if (tempSql.indexOf("WHERE") == -1) {
            if (!orderbyFound) {
                refreshSql.append(this.m_scrollStmt.getRevisedSql());
            }
            refreshSql.append(" WHERE ( ROWID = ?");
        } else {
            if (!orderbyFound) {
                refreshSql.append(this.m_scrollStmt.getRevisedSql());
            }
            refreshSql.append(" AND ( rowid = ?");
        }
        i2 = 0;
        while (i2 < realRefreshSz - 1) {
            refreshSql.append(" OR rowid = ?");
            ++i2;
        }
        refreshSql.append(" ) ");
        if (orderbyFound) {
            refreshSql.append(orderbySql);
        }
        return (OraclePreparedStatement)this.m_conn.prepareStatement(refreshSql.toString());
    }

    private int trimQuote(String s2, int offset) {
        int lastIndex = offset;
        int quoteIndex1 = 0;
        while ((quoteIndex1 = s2.indexOf("'", lastIndex)) != -1) {
            if (s2.charAt(quoteIndex1) != '\'') continue;
            lastIndex = quoteIndex1 + 1;
        }
        return lastIndex;
    }

    private int trimWhiteSpace(String s2, int offset) {
        int lastIndex = offset;
        int sLength = s2.length();
        while (lastIndex < sLength) {
            char c2 = s2.charAt(lastIndex);
            if (c2 != ' ' && c2 != '\t' && c2 != '\n') {
                return lastIndex;
            }
            ++lastIndex;
        }
        return lastIndex;
    }

    private void prepare_refetch_binds(OraclePreparedStatement refetchStmt, int realRefreshSz) throws SQLException {
        int i2;
        int _numSubQueryBinds = 0;
        DBDataSet _subQueryBinds = this.m_scrollStmt.getBinds();
        if (_subQueryBinds != null) {
            _numSubQueryBinds = _subQueryBinds.getNoOfArgs();
            i2 = 0;
            while (i2 < _numSubQueryBinds) {
                refetchStmt.setItem(i2, _subQueryBinds.getType(i2), _subQueryBinds.getBytesItem(i2, 0));
                ++i2;
            }
        }
        i2 = 0;
        while (i2 < realRefreshSz) {
            refetchStmt.setROWID(_numSubQueryBinds + i2 + 1, (ROWID)this.m_refetchRowids.elementAt(i2));
            ++i2;
        }
    }

    private void save_refetch_results(OracleResultSet refetchRset, int _beginIdx, int _realFetchSz, int direction) throws SQLException {
        int _direction = direction == 1001 ? -1 : 1;
        while (refetchRset.next()) {
            ROWID thisRowid = refetchRset.getROWID(1);
            boolean found = false;
            int thisRow = _beginIdx;
            while (!found && thisRow < _beginIdx + _realFetchSz * _direction) {
                if (((ROWID)this.getCachedDatumValueAt(thisRow, 1)).stringValue().equals(thisRowid.stringValue())) {
                    found = true;
                    continue;
                }
                thisRow += _direction;
            }
            if (!found) continue;
            int i2 = 0;
            while (i2 < this.getColumnCount()) {
                this.putCachedValueAt(thisRow, i2 + 1, refetchRset.getOracleObject(i2 + 1));
                ++i2;
            }
        }
    }

    private Object getCachedValueAt(int row, int column) throws SQLException {
        try {
            return this.m_cache.get(row, column);
        }
        catch (IOException e2) {
            DBError.throwSqlException((IOException)e2);
            return null;
        }
    }

    private Datum getCachedDatumValueAt(int row, int column) throws SQLException {
        Object value = null;
        try {
            value = this.m_cache.get(row, column);
        }
        catch (IOException e2) {
            DBError.throwSqlException((IOException)e2);
        }
        Datum datumValue = null;
        if (value != null) {
            if (value instanceof Datum) {
                datumValue = (Datum)value;
            } else if (((byte[])value).length > 0) {
                int _colType = this.getInternalMetadata().getColumnType(column);
                int _colLength = this.getInternalMetadata().getColumnDisplaySize(column);
                int max = this.m_scrollStmt.getMaxFieldSize();
                if (max > 0 && max < _colLength) {
                    _colLength = max;
                }
                String _sqlType = null;
                if (_colType == 2006 || _colType == 2002 || _colType == 2008 || _colType == 2007 || _colType == 2003) {
                    _sqlType = this.getInternalMetadata().getColumnTypeName(column);
                }
                int sqlTypeCode = SQLUtil.get_internal_type(_colType);
                short form = this.m_rset.statement.getDBTypeForm(column - 1);
                datumValue = form == 2 && (sqlTypeCode == 96 || sqlTypeCode == 1 || sqlTypeCode == 8 || sqlTypeCode == 999 || sqlTypeCode == 112) ? SQLUtil.makeNDatum((OracleConnection)this.m_conn, (byte[])((byte[])value), (int)sqlTypeCode, (String)_sqlType, (short)form, (int)_colLength) : SQLUtil.makeDatum((OracleConnection)this.m_conn, (byte[])((byte[])value), (int)sqlTypeCode, (String)_sqlType, (int)_colLength);
                try {
                    this.m_cache.put(row, column, datumValue);
                }
                catch (IOException e3) {
                    DBError.throwSqlException((IOException)e3);
                }
            } else {
                try {
                    this.m_cache.put(row, column, null);
                }
                catch (IOException e4) {
                    DBError.throwSqlException((IOException)e4);
                }
            }
        }
        return datumValue;
    }

    private void putCachedValueAt(int row, int column, Object value) throws SQLException {
        try {
            this.m_cache.put(row, column, value);
        }
        catch (IOException e2) {
            DBError.throwSqlException((IOException)e2);
        }
    }

    private void removeCachedRowAt(int row) throws SQLException {
        try {
            this.m_cache.remove(row);
        }
        catch (IOException e2) {
            DBError.throwSqlException((IOException)e2);
        }
    }

    public static boolean needIdentifier(int type, int concur) {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)1, (int)32, (int)16, (String)("ScrollableResultSet.needIdentifier(type=" + type + ", concur=" + concur + ")"));
        }
        return (type != 1003 || concur != 1007) && (type != 1004 || concur != 1007);
    }

    public static boolean needCache(int type, int concur) {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)1, (int)32, (int)16, (String)("ScrollableResultSet.needCache(type=" + type + ", concur=" + concur + ")"));
        }
        return type != 1003 && (type != 1004 || concur != 1007);
    }

    public static boolean supportRefreshRow(int type, int concur) {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)1, (int)32, (int)16, (String)("ScrollableResultSet.supportRefreshRow(type=" + type + ", concur=" + concur + ")"));
        }
        return type != 1003 && (type != 1004 || concur != 1007);
    }

    public int getFirstUserColumnIndex() {
        return this.m_beginColumnIndex;
    }
}

