/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleResultSetImpl;
import oracle.jdbc.driver.ScrollRsetStatement;
import oracle.jdbc.driver.ScrollableResultSet;
import oracle.jdbc.driver.SensitiveScrollableResultSet;
import oracle.jdbc.driver.UpdatableResultSet;

class ResultSetUtil {
    static final int[][] s_allRsetTypes = new int[][]{{0, 0}, {1003, 1007}, {1003, 1008}, {1004, 1007}, {1004, 1008}, {1005, 1007}, {1005, 1008}};

    ResultSetUtil() {
    }

    static OracleResultSet createScrollResultSet(ScrollRsetStatement owner, OracleResultSet referencedRset, int rsetType) throws SQLException {
        switch (rsetType) {
            case 1: {
                return referencedRset;
            }
            case 2: {
                return new UpdatableResultSet(owner, (OracleResultSetImpl)referencedRset, ResultSetUtil.getScrollType(rsetType), ResultSetUtil.getUpdateConcurrency(rsetType));
            }
            case 3: {
                return new ScrollableResultSet(owner, (OracleResultSetImpl)referencedRset, ResultSetUtil.getScrollType(rsetType), ResultSetUtil.getUpdateConcurrency(rsetType));
            }
            case 4: {
                ScrollableResultSet _rset = new ScrollableResultSet(owner, (OracleResultSetImpl)referencedRset, ResultSetUtil.getScrollType(rsetType), ResultSetUtil.getUpdateConcurrency(rsetType));
                return new UpdatableResultSet(owner, _rset, ResultSetUtil.getScrollType(rsetType), ResultSetUtil.getUpdateConcurrency(rsetType));
            }
            case 5: {
                return new SensitiveScrollableResultSet(owner, (OracleResultSetImpl)referencedRset, ResultSetUtil.getScrollType(rsetType), ResultSetUtil.getUpdateConcurrency(rsetType));
            }
            case 6: {
                SensitiveScrollableResultSet _rset1 = new SensitiveScrollableResultSet(owner, (OracleResultSetImpl)referencedRset, ResultSetUtil.getScrollType(rsetType), ResultSetUtil.getUpdateConcurrency(rsetType));
                return new UpdatableResultSet(owner, _rset1, ResultSetUtil.getScrollType(rsetType), ResultSetUtil.getUpdateConcurrency(rsetType));
            }
        }
        DBError.check_error((int)23, null);
        return null;
    }

    static String addIdentifierToSql(String sql) throws SQLException {
        String lowerSql = sql.toLowerCase();
        int idx = lowerSql.indexOf("select");
        if (idx == -1) {
            DBError.throwSqlException((int)88);
        }
        return "select rowid," + sql.substring(idx + "select".length());
    }

    static String removeForUpdate(String sql) throws SQLException {
        String SQL = sql.toUpperCase();
        int last = SQL.lastIndexOf("UPDATE");
        if (last == -1) {
            return sql;
        }
        SQL = SQL + " '\"*/\n";
        int length = sql.length();
        boolean whitespace = true;
        int start = -1;
        int stop = -1;
        int i2 = 0;
        while (i2 <= last) {
            char c2;
            int j2 = ResultSetUtil.skipWhitespace((String)SQL, (int)i2, (int)length);
            if (i2 < j2) {
                whitespace = true;
                i2 = j2;
                if (i2 > last) break;
            }
            if ((c2 = SQL.charAt(i2++)) == '\'') {
                while ((c2 = SQL.charAt(i2++)) != '\'') {
                }
                continue;
            }
            if (c2 == '\"') {
                while ((c2 = SQL.charAt(i2++)) != '\"') {
                }
                whitespace = true;
                continue;
            }
            if (!ResultSetUtil.isSqlIdentifierChar((char)c2)) {
                whitespace = true;
                continue;
            }
            if (whitespace && c2 == 'F' && SQL.charAt(i2) == 'O' && SQL.charAt(++i2) == 'R') {
                int s2 = i2 - 2;
                if (++i2 == (j2 = ResultSetUtil.skipWhitespace((String)SQL, (int)i2, (int)last))) continue;
                i2 = j2;
                if (i2 == last) {
                    if (ResultSetUtil.isSqlIdentifierChar((char)SQL.charAt(i2 + 6))) break;
                    i2 = Math.min(length, i2 + 6);
                    start = s2;
                    stop = i2;
                    break;
                }
                if (SQL.charAt(i2) == 'U' && SQL.charAt(++i2) == 'P' && SQL.charAt(++i2) == 'D' && SQL.charAt(++i2) == 'A' && SQL.charAt(++i2) == 'T' && SQL.charAt(++i2) == 'E' && !ResultSetUtil.isSqlIdentifierChar((char)SQL.charAt(++i2))) {
                    start = s2;
                    stop = i2;
                    whitespace = true;
                    continue;
                }
                whitespace = !ResultSetUtil.isSqlIdentifierChar((char)SQL.charAt(i2));
                continue;
            }
            whitespace = false;
        }
        String result = start > -1 ? sql.substring(0, start) + sql.substring(stop, length) : sql;
        return result;
    }

    static boolean isSqlIdentifierChar(char c2) {
        return Character.isJavaIdentifierPart(c2) || c2 == '$' || c2 == '#' || c2 == '.' || c2 == '@';
    }

    static int skipWhitespace(String SQL, int start, int last) {
        int i2 = start;
        while (i2 < last) {
            char c2 = SQL.charAt(i2);
            if (!Character.isWhitespace(c2)) {
                if (c2 == '/' && SQL.charAt(i2 + 1) == '*') {
                    while ((c2 = SQL.charAt(++i2)) != '*' || SQL.charAt(++i2) != '/') {
                    }
                } else {
                    if (c2 == '-' && SQL.charAt(i2 + 1) == '-') {
                        i2 += 2;
                        while (SQL.charAt(i2++) != '\n') {
                        }
                    }
                    return i2;
                }
            }
            ++i2;
        }
        return i2;
    }

    static int getScrollType(int typeCode) {
        return s_allRsetTypes[typeCode][0];
    }

    static int getUpdateConcurrency(int typeCode) {
        return s_allRsetTypes[typeCode][1];
    }

    static int getRsetTypeCode(int scrollType, int updateConcurrency) throws SQLException {
        int i2 = 0;
        while (i2 < s_allRsetTypes.length) {
            if (s_allRsetTypes[i2][0] == scrollType && s_allRsetTypes[i2][1] == updateConcurrency) {
                return i2;
            }
            ++i2;
        }
        DBError.throwSqlException((int)68);
        return 0;
    }

    public static boolean needIdentifier(int typeCode) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)1, (int)32, (int)1, (String)("ResultSetUtil.needIdentifier(typeCode=" + typeCode + "): return: " + (typeCode != 1 && typeCode != 3)));
        }
        return typeCode != 1 && typeCode != 3;
    }

    public static boolean needIdentifier(int type, int concur) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)1, (int)32, (int)1, (String)("ResultSetUtil.needIdentifier(type=" + type + ", concur=" + concur + "): return: " + ResultSetUtil.needIdentifier(ResultSetUtil.getRsetTypeCode(type, concur))));
        }
        return ResultSetUtil.needIdentifier(ResultSetUtil.getRsetTypeCode(type, concur));
    }

    public static boolean needCache(int typeCode) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)1, (int)32, (int)1, (String)("ResultSetUtil.needCache(typeCode=" + typeCode + "): return: " + (typeCode >= 3)));
        }
        return typeCode >= 3;
    }

    public static boolean needCache(int type, int concur) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)1, (int)32, (int)1, (String)("ResultSetUtil.needCache(type=" + type + ", concur=" + concur + "); return: " + ResultSetUtil.needCache(ResultSetUtil.getRsetTypeCode(type, concur))));
        }
        return ResultSetUtil.needCache(ResultSetUtil.getRsetTypeCode(type, concur));
    }

    public static boolean supportRefreshRow(int typeCode) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)1, (int)32, (int)1, (String)("ResultSetUtil.supportRefreshRow(typeCode=" + typeCode + "): return: " + (typeCode >= 4)));
        }
        return typeCode >= 4;
    }

    public static boolean supportRefreshRow(int type, int concur) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)1, (int)32, (int)1, (String)("ResultSetUtil.supportRefreshRow(type=" + type + ", concur=" + concur + "): return: " + ResultSetUtil.supportRefreshRow(ResultSetUtil.getRsetTypeCode(type, concur))));
        }
        return ResultSetUtil.supportRefreshRow(ResultSetUtil.getRsetTypeCode(type, concur));
    }
}

