/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.OracleTimeout;
import oracle.jdbc.driver.OracleTimeoutPollingThread;

class OracleTimeoutThreadPerVM
extends OracleTimeout {
    private static final OracleTimeoutPollingThread watchdog = new OracleTimeoutPollingThread();
    private OracleStatement statement;
    private long interruptAfter;
    private String name;

    OracleTimeoutThreadPerVM(String name) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OracleTimeoutThreadPerVM(" + name + ")"));
        }
        this.name = name;
        this.interruptAfter = Long.MAX_VALUE;
        watchdog.addTimeout(this);
    }

    void close() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OracleTimeoutThreadPerVM.close<" + this.name + ">()"));
        }
        watchdog.removeTimeout(this);
    }

    synchronized void setTimeout(long milliseconds, OracleStatement stmt) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OracleTimeoutThreadPerVM.setTimeout<" + this.name + ">(" + milliseconds + ", " + stmt + ")"));
        }
        if (this.interruptAfter != Long.MAX_VALUE) {
            DBError.throwSqlException((int)131);
        }
        this.statement = stmt;
        this.interruptAfter = System.currentTimeMillis() + milliseconds;
    }

    synchronized void cancelTimeout() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OracleTimeoutThreadPerVM.cancelTimeout<" + this.name + ">()"));
        }
        this.statement = null;
        this.interruptAfter = Long.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void interruptIfAppropriate(long now) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OracleTimeoutThreadPerVM.interruptIfAppropriate<" + this.name + ">(" + now + ")"));
        }
        if (now > this.interruptAfter) {
            OracleTimeoutThreadPerVM oracleTimeoutThreadPerVM = this;
            synchronized (oracleTimeoutThreadPerVM) {
                if (now > this.interruptAfter) {
                    try {
                        if (OracleLog.TRACE) {
                            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OracleTimeoutThreadPerVM.interruptIfAppropriate<" + this.name + ">:INTERRUPTING"));
                        }
                        this.statement.cancel();
                        this.statement = null;
                        this.interruptAfter = Long.MAX_VALUE;
                    }
                    catch (SQLException e2) {
                        e2.printStackTrace();
                    }
                }
            }
        }
    }
}

