/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleTimeoutThreadPerVM;

class OracleTimeoutPollingThread
extends Thread {
    protected static final String threadName = "OracleTimeoutPollingThread";
    public static final String pollIntervalProperty = "oracle.jdbc.TimeoutPollInterval";
    public static final String pollIntervalDefault = "1000";
    private OracleTimeoutThreadPerVM[] knownTimeouts;
    private int count;
    private long sleepMillis;

    public OracleTimeoutPollingThread() {
        super(threadName);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)"OracleTimeoutPollingThread.OracleTimeoutPollingThread()");
        }
        this.setDaemon(true);
        this.setPriority(10);
        this.knownTimeouts = new OracleTimeoutThreadPerVM[2];
        this.count = 0;
        this.sleepMillis = Long.parseLong(OracleDriver.getSystemProperty((String)pollIntervalProperty, (String)pollIntervalDefault));
        this.start();
    }

    public synchronized void addTimeout(OracleTimeoutThreadPerVM t) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OracleTimeoutPollingThread.addTimeout(" + t + ")"));
        }
        int i2 = 0;
        if (this.count >= this.knownTimeouts.length) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OracleTimeoutPollingThread.addTimeout:growing knownTimeouts--new size = " + this.knownTimeouts.length * 4));
            }
            OracleTimeoutThreadPerVM[] bigger = new OracleTimeoutThreadPerVM[this.knownTimeouts.length * 4];
            System.arraycopy(this.knownTimeouts, 0, bigger, 0, this.knownTimeouts.length);
            i2 = this.knownTimeouts.length;
            this.knownTimeouts = bigger;
        }
        while (i2 < this.knownTimeouts.length) {
            if (this.knownTimeouts[i2] == null) {
                this.knownTimeouts[i2] = t;
                ++this.count;
                if (!OracleLog.TRACE) break;
                OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OracleTimeoutPollingThread.addTimeout:added at " + i2));
                break;
            }
            ++i2;
        }
    }

    public synchronized void removeTimeout(OracleTimeoutThreadPerVM t) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OracleTimeoutPollingThread.removeTimeout(" + t + ")"));
        }
        int i2 = 0;
        while (i2 < this.knownTimeouts.length) {
            if (this.knownTimeouts[i2] == t) {
                this.knownTimeouts[i2] = null;
                --this.count;
                if (!OracleLog.TRACE) break;
                OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OracleTimeoutPollingThread.removeTimeout:removed from " + i2));
                break;
            }
            ++i2;
        }
    }

    public void run() {
        while (true) {
            try {
                Thread.sleep(this.sleepMillis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.pollOnce();
        }
    }

    private void pollOnce() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)"OracleTimeoutPollingThread.pollOnce()");
        }
        if (this.count > 0) {
            long now = System.currentTimeMillis();
            int i2 = 0;
            while (i2 < this.knownTimeouts.length) {
                try {
                    if (this.knownTimeouts[i2] != null) {
                        this.knownTimeouts[i2].interruptIfAppropriate(now);
                    }
                }
                catch (NullPointerException e2) {
                    // empty catch block
                }
                ++i2;
            }
        }
    }

    static {
        threadName = threadName;
        pollIntervalProperty = pollIntervalProperty;
        pollIntervalDefault = pollIntervalDefault;
    }
}

