/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.core.lmx.CoreException;
import oracle.jdbc.OracleConnectionWrapper;
import oracle.jdbc.dbaccess.DBAccess;
import oracle.jdbc.dbaccess.DBColumn;
import oracle.jdbc.dbaccess.DBConversion;
import oracle.jdbc.dbaccess.DBDataSet;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.dbaccess.DBStatement;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleInputStream;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleResultSetCache;
import oracle.jdbc.driver.OracleResultSetImpl;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.ResultSetUtil;
import oracle.jdbc.driver.ScrollRsetStatement;
import oracle.jdbc.oracore.OracleNamedType;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.util.RepConversion;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CharacterSet;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALYM;
import oracle.sql.JAVA_STRUCT;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.OpaqueDescriptor;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;
import oracle.sql.TypeDescriptor;

public class OracleStatement
implements oracle.jdbc.internal.OracleStatement,
ScrollRsetStatement {
    static final int VALID_ROWS_UNINIT = -999;
    DBColumn[] dbdescription;
    DBDataSet binds_out = null;
    DBDataSet binds_in = null;
    public DBDataSet defines;
    OracleConnection connection;
    OracleInputStream streams;
    InputStream[] stream_array;
    OracleResultSetImpl current_result_set;
    boolean process_escapes;
    protected int m_queryTimeout;
    public DBStatement dbstmt;
    int batch;
    protected int m_currentRank;
    int current_row;
    int valid_rows;
    int max_field_size;
    int max_rows;
    int total_rows_visited;
    int row_prefetch;
    int default_row_prefetch;
    boolean row_prefetch_changed;
    boolean isCachable = false;
    int row_prefetch_at_execute = 0;
    boolean was_columns_defined_by_user = false;
    boolean got_last_batch;
    boolean clear_params;
    public boolean closed;
    protected boolean m_isOpen = false;
    boolean sql_string_changed;
    String sql_query;
    boolean need_to_parse;
    boolean need_to_prepare_define_buffer;
    boolean need_to_prepare_java_define_buffers = false;
    public boolean columns_defined_by_user;
    byte sql_kind = (byte)-1;
    int parameterCount;
    byte[] array_sql;
    public int auto_rollback;
    public int wait_option;
    private int m_lastFetchedColumn;
    private DBDataSet m_currentDataSet;
    int default_fetch_direction;
    boolean m_autoRefetch;
    boolean serverCursor;
    boolean fixedString = false;
    boolean noMoreUpdateCounts = false;
    boolean m_isExecuting = false;
    protected static final byte EXECUTE_NONE = -1;
    protected static final byte EXECUTE_QUERY = 1;
    protected static final byte EXECUTE_UPDATE = 2;
    protected static final byte EXECUTE_NORMAL = 3;
    protected byte executionType = (byte)-1;
    OracleResultSet m_scrollRset;
    oracle.jdbc.OracleResultSetCache m_cache;
    int m_userRsetType;
    int m_realRsetType;
    static int DEFAULT_RSET_TYPE;
    String m_originalSql;
    String m_revisedSql;
    boolean m_needToAddIdentifier;
    SQLWarning m_warning;
    static int CLOSED;
    static int ACTIVE;
    static int CACHED;
    static int NON_CACHED;
    int cacheState = ACTIVE;
    int m_creationState = 0;
    int statementType = 0;
    boolean columnSetNull = false;
    boolean last_was_column;
    int last_index;
    private Vector m_batchItems = new Vector();
    int CLOSE_CURRENT_RESULT = 1;
    int KEEP_CURRENT_RESULT = 2;
    int CLOSE_ALL_RESULTS = 3;
    int SUCCESS_NO_INFO = -2;
    int EXECUTE_FAILED = -3;
    int RETURN_GENERATED_KEYS = 1;
    int NO_GENERATED_KEYS = 2;

    void initialize(int batch_value, int row_prefetch_value, boolean serverCursor_value) throws SQLException {
        this.connection.add_statement(this);
        this.initializeState(batch_value, row_prefetch_value, this.connection.getDefaultAutoRefetch(), serverCursor_value);
        this.initializeMetaData();
    }

    void initializeState(int batch_value, int row_prefetch_value, boolean auto_refetch, boolean serverCursor_value) throws SQLException {
        this.current_result_set = null;
        this.last_index = 0;
        this.process_escapes = this.connection.m_process_escapes;
        this.m_queryTimeout = 0;
        this.auto_rollback = 2;
        this.wait_option = 0;
        this.row_prefetch_changed = false;
        this.m_currentRank = 0;
        this.current_row = 0;
        this.valid_rows = 0;
        this.max_rows = 0;
        this.total_rows_visited = 0;
        this.max_field_size = 0;
        this.parameterCount = 0;
        this.got_last_batch = false;
        this.closed = false;
        this.clear_params = true;
        this.serverCursor = serverCursor_value;
        this.m_scrollRset = null;
        this.m_needToAddIdentifier = false;
        this.default_fetch_direction = 1000;
        this.fixedString = OracleConnection.physicalConnectionWithin((Connection)this.connection).getDefaultFixedString();
        this.row_prefetch = row_prefetch_value;
        this.default_row_prefetch = row_prefetch_value;
        this.batch = batch_value;
        this.m_autoRefetch = auto_refetch;
        this.streams = null;
        this.stream_array = null;
    }

    void initializeMetaData() throws SQLException {
        if (this.binds_in != null) {
            this.binds_in.cleanup();
        }
        if (this.binds_out != null) {
            this.binds_out.cleanup();
        }
        if (this.defines != null) {
            this.defines.cleanup();
        }
        this.defines = this.connection.db_access.createDBDataSet((OracleConnection)this.connection, this, 0, 0);
        this.dbdescription = null;
        this.sql_string_changed = true;
        this.need_to_parse = true;
        this.need_to_prepare_define_buffer = true;
        this.columns_defined_by_user = false;
        if (this.m_userRsetType == 0) {
            this.m_userRsetType = DEFAULT_RSET_TYPE;
            this.m_realRsetType = 1;
        }
        this.m_originalSql = null;
        this.m_revisedSql = null;
    }

    public OracleStatement(OracleConnection conn, int batchValue, int rowPrefetchValue) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OracleStatement.OracleStatement(conn, batchValue=" + batchValue + ", rowPrefetchValue=" + rowPrefetchValue + ")"));
        }
        this.connection = conn;
        if (this.connection.getProtocolType().equals("kprb")) {
            this.open();
        }
        this.initialize(batchValue, rowPrefetchValue, false);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)"OracleStatement.OracleStatement(conn, batchValue, rowPrefetchValue):return");
        }
    }

    public OracleStatement(OracleConnection c2, int batch_value, int row_prefetch_value, int UserResultSetType, int UserResultSetConcur) throws SQLException {
        this(c2, batch_value, row_prefetch_value);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OracleStatement.OracleStatement(conn, batchValue=" + batch_value + ", rowPrefetchValue=" + row_prefetch_value + ", UserResultSetType=" + UserResultSetType + ")"));
        }
        this.m_realRsetType = 0;
        this.m_userRsetType = ResultSetUtil.getRsetTypeCode(UserResultSetType, UserResultSetConcur);
        this.m_needToAddIdentifier = ResultSetUtil.needIdentifier(this.m_userRsetType);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)"OracleStatement.OracleStatement(c, batch_value, UserResultSetType):return");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleStatement(OracleConnection conn, DBStatement cursorDbstmt, int batchValue, int rowPrefetchValue) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OracleStatement.OracleStatement(conn, cursorDbstmt, batchValue=" + batchValue + ", rowPrefetchValue=" + rowPrefetchValue + ")"));
        }
        this.sql_kind = 0;
        this.connection = conn;
        DBAccess db = this.connection.db_access;
        this.dbstmt = cursorDbstmt;
        boolean doFetch = db.getFetchOnNewRefCursor();
        this.m_isOpen = true;
        this.initialize(batchValue, rowPrefetchValue, true);
        this.prepare_for_new_result(true);
        this.current_result_set = new OracleResultSetImpl((OracleConnection)this.connection, this);
        this.current_result_set.close_statement_on_close = true;
        try {
            block9: {
                try {
                    this.connection.needLine();
                    this.dbdescription = this.connection.db_access.describe(this.dbstmt);
                    this.need_to_parse = false;
                    this.doDefaultTypes();
                    this.doDefinesFromTypes();
                    this.need_to_prepare_define_buffer = false;
                    if (!doFetch) break block9;
                    this.connection.needLine();
                    try {
                        this.m_isExecuting = true;
                        this.valid_rows = db.fetch(this.dbstmt, this.defines, this.row_prefetch);
                        Object var8_7 = null;
                        this.m_isExecuting = false;
                    }
                    catch (Throwable throwable) {
                        Object var8_8 = null;
                        this.m_isExecuting = false;
                        throw throwable;
                    }
                    this.fetchedFirstColumns();
                }
                catch (IOException e2) {
                    DBError.throwSqlException((IOException)e2);
                    Object var10_12 = null;
                }
            }
            Object var10_11 = null;
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            throw throwable;
        }
        if (doFetch) {
            this.checkValidRowsStatus();
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)"OracleStatement.OracleStatement:return");
        }
    }

    protected void open() throws SQLException {
        if (!this.m_isOpen) {
            try {
                this.connection.needLine();
                this.dbstmt = this.connection.db_access.open();
                this.m_isOpen = true;
            }
            catch (IOException e2) {
                DBError.throwSqlException((IOException)e2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResultSet executeQuery(String sql) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleStatement oracleStatement = this;
            synchronized (oracleStatement) {
                OracleResultSet oracleResultSet;
                block12: {
                    OracleResultSetImpl oracleResultSetImpl;
                    block11: {
                        OracleResultSetImpl oracleResultSetImpl2;
                        block10: {
                            try {
                                this.executionType = 1;
                                if (OracleLog.TRACE) {
                                    OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)"OracleStatement.executeQuery(sql)");
                                    OracleLog.print((Object)this, (int)1, (int)16, (int)128, (String)("SQL: \"" + sql + "\""));
                                }
                                this.connection.db_access.setStatementWarning(this.m_warning);
                                this.noMoreUpdateCounts = false;
                                this.checkIfJdbcBatchExists();
                                this.ensureOpen();
                                this.sendBatch();
                                this.need_to_parse = true;
                                this.sql_string_changed = true;
                                this.sql_query = sql;
                                this.sql_kind = (byte)-1;
                                this.prepare_for_new_result(true);
                                if (this.isRegularResultSet()) {
                                    this.doExecuteWithTimeout();
                                    oracleResultSetImpl2 = this.current_result_set = new OracleResultSetImpl((OracleConnection)this.connection, this);
                                    Object var6_7 = null;
                                    break block10;
                                }
                                this.m_scrollRset = this.doScrollStmtExecuteQuery(sql);
                                if (this.m_scrollRset == null) {
                                    oracleResultSetImpl = this.current_result_set = new OracleResultSetImpl((OracleConnection)this.connection, this);
                                    break block11;
                                }
                                oracleResultSet = this.m_scrollRset;
                                break block12;
                            }
                            catch (Throwable throwable) {
                                Object var6_10 = null;
                                this.executionType = (byte)-1;
                                this.m_warning = this.connection.db_access.getStatementWarning();
                                throw throwable;
                            }
                        }
                        this.executionType = (byte)-1;
                        this.m_warning = this.connection.db_access.getStatementWarning();
                        return oracleResultSetImpl2;
                    }
                    Object var6_8 = null;
                    this.executionType = (byte)-1;
                    this.m_warning = this.connection.db_access.getStatementWarning();
                    return oracleResultSetImpl;
                }
                Object var6_9 = null;
                this.executionType = (byte)-1;
                this.m_warning = this.connection.db_access.getStatementWarning();
                return oracleResultSet;
            }
        }
    }

    public void closeWithKey(String key) throws SQLException {
        DBError.throwSqlException((int)23);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleStatement oracleStatement = this;
            synchronized (oracleStatement) {
                if (OracleLog.TRACE) {
                    OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)"OracleStatement.close()");
                }
                if (this.closed) {
                    return;
                }
                this.closed = true;
                if (((OracleConnectionWrapper)this.connection).isClosed()) {
                    return;
                }
                try {
                    this.connection.needLine();
                    if (this.current_result_set != null) {
                        this.current_result_set.internal_close();
                        this.current_result_set = null;
                    }
                    this.internal_close();
                    if (this.m_isOpen) {
                        this.connection.db_access.close(this.dbstmt);
                    }
                }
                catch (IOException e2) {
                    DBError.throwSqlException((IOException)e2);
                }
            }
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)"OracleStatement.close():return");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeLeaveCursorOpen() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleStatement oracleStatement = this;
            synchronized (oracleStatement) {
                if (OracleLog.TRACE) {
                    OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)"OracleStatement.closeLeaveCursorOpen()");
                }
                if (this.closed) {
                    return;
                }
                this.internal_close();
                this.current_result_set = null;
            }
        }
    }

    private void internal_close() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)"OracleStatement.internal_close()");
        }
        this.closed = true;
        if (!this.connection.isStatementCacheInitialized() || this.connection.isStatementCacheInitialized() && this.statementType == 0 || this.cacheState == CLOSED || this.cacheState == NON_CACHED) {
            this.connection.remove_statement(this);
        }
        this.scrollStmt_cleanup(true);
        this.clearWarnings();
        this.cleanup();
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)"OracleStatement.internal_close()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int executeUpdate(String sql) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleStatement oracleStatement = this;
            synchronized (oracleStatement) {
                int n2;
                try {
                    if (this.executionType == -1) {
                        this.executionType = (byte)2;
                    }
                    if (OracleLog.TRACE) {
                        OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)"OracleStatement.executeUpdate(sql)");
                        OracleLog.print((Object)this, (int)1, (int)16, (int)128, (String)("SQL: \"" + sql + "\""));
                    }
                    this.connection.db_access.setStatementWarning(this.m_warning);
                    this.noMoreUpdateCounts = false;
                    this.checkIfJdbcBatchExists();
                    this.ensureOpen();
                    this.sendBatch();
                    this.need_to_parse = true;
                    this.sql_string_changed = true;
                    this.sql_query = sql;
                    this.sql_kind = (byte)-1;
                    this.prepare_for_new_result(true);
                    if (this.isRegularResultSet()) {
                        this.doExecuteWithTimeout();
                    } else {
                        this.doScrollStmtExecuteQuery(sql);
                    }
                    n2 = this.valid_rows;
                    Object var6_5 = null;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    this.executionType = (byte)-1;
                    this.m_warning = this.connection.db_access.getStatementWarning();
                    throw throwable;
                }
                this.executionType = (byte)-1;
                this.m_warning = this.connection.db_access.getStatementWarning();
                return n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute(String sql) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleStatement oracleStatement = this;
            synchronized (oracleStatement) {
                boolean bl;
                try {
                    this.executionType = (byte)3;
                    if (OracleLog.TRACE) {
                        OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)"OracleStatement.execute(sql)");
                        OracleLog.print((Object)this, (int)1, (int)16, (int)128, (String)("SQL: \"" + sql + "\""));
                    }
                    this.connection.db_access.setStatementWarning(this.m_warning);
                    this.noMoreUpdateCounts = false;
                    this.checkIfJdbcBatchExists();
                    this.ensureOpen();
                    this.sendBatch();
                    this.need_to_parse = true;
                    this.sql_string_changed = true;
                    this.sql_query = sql;
                    this.sql_kind = (byte)-1;
                    this.prepare_for_new_result(true);
                    if (this.isRegularResultSet()) {
                        this.doExecuteWithTimeout();
                    } else {
                        this.doScrollStmtExecuteQuery(sql);
                    }
                    if (OracleLog.TRACE) {
                        OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)"OracleStatement.execute(sql):return");
                    }
                    bl = this.sql_kind == 0;
                    Object var6_5 = null;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    this.executionType = (byte)-1;
                    this.m_warning = this.connection.db_access.getStatementWarning();
                    throw throwable;
                }
                this.executionType = (byte)-1;
                this.m_warning = this.connection.db_access.getStatementWarning();
                return bl;
            }
        }
    }

    public DBColumn[] getDBDescription() throws SQLException {
        if (this.dbdescription == null) {
            this.describe();
        }
        return this.dbdescription;
    }

    public byte getSqlKind() {
        return this.sql_kind;
    }

    byte getSqlKind(String sql) {
        String tk = null;
        try {
            StringTokenizer st = new StringTokenizer(sql.trim(), "\n \r \t ( ) /", true);
            while (st.hasMoreTokens()) {
                tk = st.nextToken();
                if (tk.equalsIgnoreCase("select") || tk.equalsIgnoreCase("with")) {
                    return 0;
                }
                if (tk.equalsIgnoreCase("call")) {
                    return 3;
                }
                if (tk.equalsIgnoreCase("begin") || tk.equalsIgnoreCase("declare")) {
                    return 1;
                }
                if (tk.equalsIgnoreCase("insert") || tk.equalsIgnoreCase("delete") || tk.equalsIgnoreCase("update")) {
                    return 2;
                }
                if (tk.equals("/")) {
                    tk = st.nextToken();
                    while (!tk.startsWith("*") || !st.nextToken().equals("/")) {
                        tk = st.nextToken();
                    }
                    continue;
                }
                if (tk.equals("--")) {
                    while (!st.nextToken().equals("\n")) {
                    }
                    continue;
                }
                if (tk.equals("\n") || tk.equals("\t") || tk.equals(" ") || tk.equals("\r") || tk.equals("(") || tk.equals(")")) continue;
                return 4;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return 4;
    }

    void doDefaultTypes() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)"OracleStatement.doDefaultTypes()");
        }
        Object current_stream = null;
        this.connection.trace("doDefaultTypes");
        int column_num = this.dbdescription.length;
        int nlsratio = this.connection.db_access.getNlsRatio();
        this.defines.setNoOfDefineCol(column_num);
        int column_index = 0;
        while (column_index < column_num) {
            DBColumn column_info = this.dbdescription[column_index];
            switch (column_info.type) {
                case 8: 
                case 24: {
                    this.defines.setType(column_index, column_info.type, this.max_field_size, column_info.FormOfUse);
                    break;
                }
                case 23: {
                    int size = column_info.max_length;
                    if (this.max_field_size != 0) {
                        size = Math.min(this.max_field_size, size);
                    }
                    this.defines.setType(column_index, column_info.type, size, column_info.FormOfUse);
                    break;
                }
                case 1: 
                case 96: {
                    int size = column_info.max_length;
                    size = this.max_field_size != 0 && this.max_field_size <= size ? this.max_field_size : (size *= nlsratio);
                    this.defines.setType(column_index, column_info.type, size, column_info.FormOfUse);
                    break;
                }
                case 2: 
                case 6: {
                    this.defines.setType(column_index, 6, 0, column_info.FormOfUse);
                    break;
                }
                case 12: 
                case 102: 
                case 104: 
                case 180: 
                case 181: 
                case 182: 
                case 183: 
                case 231: {
                    this.defines.setType(column_index, column_info.type, 0, column_info.FormOfUse);
                    break;
                }
                case 109: 
                case 111: {
                    this.defines.setType(column_index, column_info.type, column_info.otype);
                    break;
                }
                default: {
                    this.defines.setType(column_index, column_info.type, column_info.max_length, column_info.FormOfUse);
                }
            }
            ++column_index;
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)"OracleStatement.doDefaultTypes():return");
        }
    }

    void doDefinesFromTypes() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)"OracleStatement.doDefinesFromTypes()");
        }
        this.streams = null;
        int column_num = this.defines.getNoOfArgs();
        this.connection.trace("doDefinesFromTypes");
        if (this.defines.hasStreamType()) {
            this.row_prefetch = 1;
            this.stream_array = new InputStream[column_num];
        }
        this.defines.setBatchSize(this.row_prefetch);
        this.defines.rowCompleted(this.m_currentRank);
        if (this.defines.hasStreamType()) {
            this.initializeStreams(column_num);
        }
        this.initializeColumnsToFetch(this.defines);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)"OracleStatement.doDefinesFromTypes():return");
        }
    }

    protected void initializeStreams(int column_num) throws SQLException {
        if (this.stream_array == null && this.defines.hasStreamType()) {
            this.stream_array = new InputStream[column_num];
        }
        this.stream_array[0] = null;
        int column_index = 0;
        while (column_index < column_num) {
            if (this.defines.isStreamType(column_index)) {
                OracleInputStream newStream = new OracleInputStream(this, column_index + 1, this.streams);
                this.defines.setStreamItem(column_index, 0, (InputStream)newStream);
                this.streams = newStream;
                if (column_index + 1 < column_num) {
                    this.stream_array[column_index + 1] = newStream;
                }
            } else if (column_index + 1 < column_num) {
                this.stream_array[column_index + 1] = this.stream_array[column_index];
            }
            ++column_index;
        }
    }

    public synchronized void clearDefines() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)"OracleStatement.clearDefines()");
        }
        this.columns_defined_by_user = false;
        this.need_to_prepare_define_buffer = true;
        this.defines.cleanup();
        this.defines.setBatchSize(0);
        this.stream_array = null;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)"OracleStatement.clearDefines():return");
        }
    }

    public synchronized void defineColumnType(int column_index, int type) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OracleStatement.defineColumnType(column_index=" + column_index + "type=" + type + ")"));
        }
        if (type == 1 || type == 12) {
            this.m_warning = DBError.addSqlWarning((SQLWarning)this.m_warning, (int)108);
        }
        this.defineColumnType(column_index, type, null);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)"OracleStatement.defineColumnType(column_index, type):return");
        }
    }

    public void defineColumnType(int column_index, int type, int max_size) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OracleStatement.defineColumnType(column_index=" + column_index + "type=" + type + "max_size=" + max_size + ")"));
        }
        this.defineColumnTypeBytes(column_index, type, max_size * this.connection.dataSizeScale);
    }

    public synchronized void defineColumnTypeBytes(int column_index, int type, int max_size) throws SQLException {
        int prev_type;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OracleStatement.defineColumnTypeBytes(column_index=" + column_index + "type=" + type + "max_size=" + max_size + ")"));
        }
        if (max_size < 0) {
            DBError.throwSqlException((int)53);
        }
        if (!this.columns_defined_by_user) {
            this.clearDefines();
            this.columns_defined_by_user = true;
        }
        this.need_to_prepare_define_buffer = true;
        int max_len = max_size;
        if (this.max_field_size != 0 && this.max_field_size < max_size) {
            max_len = this.max_field_size;
        }
        if ((prev_type = this.defines.getType(column_index - 1)) != -1 && prev_type != type) {
            this.need_to_parse = true;
        }
        short form = this.dbdescription == null || column_index > this.dbdescription.length ? (short)1 : this.dbdescription[column_index - 1].FormOfUse;
        this.defines.setType(column_index - 1, this.get_internal_type(type), type, max_len, form, true);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)"OracleStatement.defineColumnType(column_index, type, max_size):return");
        }
    }

    public void defineColumnTypeChars(int column_index, int type, int max_size) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OracleStatement.defineColumnTypeChars(column_index=" + column_index + "type=" + type + "max_size=" + max_size + ")"));
        }
        int nlsratio = this.connection.db_access.getNlsRatio();
        if (type == 1 || type == 12) {
            this.defineColumnTypeBytes(column_index, type, max_size * nlsratio);
        } else {
            this.defineColumnTypeBytes(column_index, type, max_size);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)"OracleStatement.defineColumnTypeChars(column_index, type, max_size):return");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void defineColumnType(int column_index, int typeCode, String typeName) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OracleStatement.defineColumnType(column_index=" + column_index + ", typeCode=" + typeCode + ", typeName=" + typeName + ")"));
        }
        if (this.current_result_set != null && !this.current_result_set.closed) {
            DBError.throwSqlException((int)28);
        }
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleStatement oracleStatement = this;
            synchronized (oracleStatement) {
                if (!this.columns_defined_by_user) {
                    this.clearDefines();
                    this.columns_defined_by_user = true;
                }
                this.need_to_prepare_define_buffer = true;
                OracleNamedType otype = null;
                int internal_type = this.get_internal_type(typeCode);
                int prev_type = this.defines.getType(column_index - 1);
                if (prev_type != -1 && prev_type != typeCode) {
                    this.need_to_parse = true;
                }
                if (internal_type == 109 || internal_type == 111) {
                    TypeDescriptor desc = TypeDescriptor.getTypeDescriptor(typeName, this.connection);
                    otype = desc.getPickler();
                    this.defines.setType(column_index - 1, internal_type, (OracleType)otype);
                } else {
                    short form = this.dbdescription == null || column_index > this.dbdescription.length ? (short)1 : this.dbdescription[column_index - 1].FormOfUse;
                    this.defines.setType(column_index - 1, internal_type, typeCode, this.max_field_size, form);
                }
                if (OracleLog.TRACE) {
                    OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)"OracleStatement.defineColumnType(column_index, typeCode, typeName):return");
                }
            }
        }
    }

    protected void setPrefetchInternal(int new_value, boolean setRowPrefetch, boolean statement) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OracleStatement.setPrefetchInternal(new_value=" + new_value + ", setRowPrefetch=" + setRowPrefetch + ", statement=" + statement + ")"));
        }
        if (setRowPrefetch) {
            if (new_value <= 0) {
                DBError.throwSqlException((int)20);
            }
        } else if (new_value < 0) {
            DBError.throwSqlException((int)68, (Object)"setFetchSize");
        } else if (new_value == 0) {
            new_value = ((OracleConnectionWrapper)this.connection).getDefaultRowPrefetch();
        }
        if (statement) {
            if (new_value != this.default_row_prefetch) {
                this.default_row_prefetch = new_value;
            }
        } else if (new_value != this.row_prefetch && !this.defines.hasStreamType()) {
            this.row_prefetch = new_value;
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)"OracleStatement.setPrefetchInternal(new_value, setRowPrefetch, statement):return");
        }
    }

    public synchronized void setRowPrefetch(int value) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OracleStatement.setRowPrefetch(value=" + value + ")"));
        }
        this.setPrefetchInternal(value, true, true);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)"OracleStatement.setRowPrefetch(value):return");
        }
    }

    protected int getPrefetchInternal(boolean statement) {
        int ret_val;
        int n2 = ret_val = statement ? this.default_row_prefetch : this.row_prefetch;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)("OracleStatement.getPrefetchInternal(" + statement + ") returned " + ret_val));
        }
        return ret_val;
    }

    public synchronized int getRowPrefetch() {
        return this.getPrefetchInternal(true);
    }

    public void setFixedString(boolean fixedString_value) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)("OracleStatement.setDefaultFixedString(fixedString=" + fixedString_value));
        }
        this.fixedString = fixedString_value;
    }

    public boolean getFixedString() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)("OracleStatement.getFixedString() returning " + this.fixedString));
        }
        return this.fixedString;
    }

    void checkBindsInAndOut() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)32, (String)("OracleStatement.checkBindsInAndOut: clear_params is " + this.clear_params + " ,m_currentRank is " + this.m_currentRank));
        }
        if (!this.clear_params) {
            return;
        }
        this.clear_params = false;
        int missingPos = -1;
        if (this.binds_in != null) {
            missingPos = this.binds_in.checkBindsInAndOut(this.binds_out, this.m_currentRank);
        } else if (this.binds_out != null) {
            missingPos = this.binds_out.checkBindsInAndOut(null, this.m_currentRank);
        }
        if (missingPos != -1) {
            DBError.throwSqlException((int)41, (Object)new Integer(missingPos + 1));
        }
    }

    void doExecuteOther(boolean batchForPlsql) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OracleStatement.doExecuteOther(batchForPlsql=" + batchForPlsql + ")"));
            OracleLog.print((Object)this, (int)1, (int)16, (int)32, (String)("Before execute: m_currentRank=" + this.m_currentRank + ", sql_kind=" + this.sql_kind + ", need_to_parse=" + this.need_to_parse));
            if (this.binds_in != null) {
                OracleLog.print((Object)this, (int)1, (int)16, (int)64, (String)("binds_in: " + this.binds_in.getInfoString()));
            }
            if (this.binds_out != null) {
                OracleLog.print((Object)this, (int)1, (int)16, (int)64, (String)("binds_out: " + this.binds_out.getInfoString()));
            }
        }
        this.connection.needLine();
        if (!((OracleConnectionWrapper)this.connection).getAutoCommit()) {
            if (this.sql_kind == 2) {
                this.connection.switchTxnMode(0, 1);
            }
        }
        this.initializeColumnsToFetch(this.binds_out);
        this.executeNonQuery(batchForPlsql);
        this.need_to_parse = false;
        this.isCachable = true;
        this.fetchedFirstColumns();
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)32, (String)("After execute: valid_rows=" + this.valid_rows));
            if (this.binds_out != null) {
                OracleLog.print((Object)this, (int)1, (int)16, (int)64, (String)("binds_out: " + this.binds_out.getInfoString()));
            }
        }
        this.checkValidRowsStatus();
        if (this.sql_kind == 4) {
            this.connection.switchTxnMode(1, 0);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)"OracleStatement.doExecuteOther(batchForPlsql):return");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeNonQuery(boolean batchForPlsql) throws SQLException {
        block21: {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OracleStatement.executeNonQuery(batchForPlsql=" + batchForPlsql + ")"));
            }
            int nrows = this.m_currentRank;
            DBAccess db = this.connection.db_access;
            try {
                if (batchForPlsql && (this.sql_kind == 1 || this.sql_kind == 3) && nrows > 1) {
                    int i2 = 0;
                    while (i2 < nrows) {
                        Object var7_5;
                        try {
                            this.m_isExecuting = true;
                            if (this.need_to_parse) {
                                this.valid_rows = db.parseExecuteFetch(this.dbstmt, this.sql_kind, this.array_sql, this.binds_in, 1, this.binds_out, 1);
                            } else {
                                if (this.need_to_prepare_java_define_buffers) {
                                    if (this.defines != null) {
                                        this.defines.reallocOutBuffers();
                                    }
                                    if (this.binds_out != null) {
                                        this.binds_out.reallocOutBuffers();
                                    }
                                    this.need_to_prepare_java_define_buffers = false;
                                }
                                this.valid_rows = db.executeFetch(this.dbstmt, this.sql_kind, this.binds_in, 1, this.binds_out, 1);
                            }
                            var7_5 = null;
                            this.m_isExecuting = false;
                        }
                        catch (Throwable throwable) {
                            var7_5 = null;
                            this.m_isExecuting = false;
                            throw throwable;
                        }
                        this.binds_in.removeFirstRow();
                        ++i2;
                    }
                    break block21;
                }
                try {
                    this.m_isExecuting = true;
                    if (this.need_to_parse) {
                        this.valid_rows = db.parseExecuteFetch(this.dbstmt, this.sql_kind, this.array_sql, this.binds_in, nrows, this.binds_out, nrows);
                    } else {
                        if (this.need_to_prepare_java_define_buffers) {
                            if (this.defines != null) {
                                this.defines.reallocOutBuffers();
                            }
                            if (this.binds_out != null) {
                                this.binds_out.reallocOutBuffers();
                            }
                            this.need_to_prepare_java_define_buffers = false;
                        }
                        this.valid_rows = db.executeFetch(this.dbstmt, this.sql_kind, this.binds_in, nrows, this.binds_out, nrows);
                    }
                    Object var9_9 = null;
                    this.m_isExecuting = false;
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    this.m_isExecuting = false;
                    throw throwable;
                }
            }
            catch (IOException e2) {
                DBError.throwSqlException((IOException)e2);
            }
            catch (SQLException ea) {
                this.need_to_parse = true;
                this.isCachable = false;
                throw ea;
            }
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)"OracleStatement.executeNonQuery(batchForPlsql):return");
        }
    }

    protected final void cleanupForBatching() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)"OracleStatement.cleanupForBatching()");
        }
        if (this.binds_in != null && this.binds_in.getNoOfArgs() > 0 && this.binds_in.isDynamic()) {
            int l_rowNumber = this.m_currentRank - 1;
            while (l_rowNumber >= 0) {
                this.binds_in.clearItem(l_rowNumber, true);
                --l_rowNumber;
            }
        }
        this.m_currentRank = 0;
    }

    void check_defines() throws SQLException {
        int missingCol;
        if (this.defines.getNoOfArgs() == 0) {
            DBError.throwSqlException((int)21);
        }
        if ((missingCol = this.defines.getMissingType()) != -1) {
            DBError.throwSqlException((int)22, (Object)new Integer(missingCol + 1));
        }
    }

    protected void check_row_prefetch_changed() throws SQLException {
        if (this.row_prefetch_changed) {
            if (!this.defines.hasStreamType()) {
                this.defines.setBatchSize(this.row_prefetch);
            } else if (this.row_prefetch != 1) {
                this.row_prefetch = 1;
            }
            this.row_prefetch_changed = false;
            this.dbstmt.setDefinesInitialized(false);
        }
    }

    void check_row_prefetch_changed_for_resultset() throws SQLException {
        this.row_prefetch_changed = this.row_prefetch > this.row_prefetch_at_execute;
        this.check_row_prefetch_changed();
    }

    void printState(String message) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)64, (String)(this + ": " + message + ":" + "  sql_query=" + this.sql_query + "  sql_string_changed=" + this.sql_string_changed + "  row_prefetch=" + this.row_prefetch + "  default_row_prefetch=" + this.default_row_prefetch + "  row_prefetch_changed=" + this.row_prefetch_changed + "  batch=" + this.batch + "  m_currentRank=" + this.m_currentRank + "  current_row=" + this.current_row + "  valid_rows=" + this.valid_rows + "  m_autoRefetch=" + this.m_autoRefetch + "  serverCursor=" + this.serverCursor + "  current_result_set=" + this.current_result_set + "  process_escapes=" + this.process_escapes + "  m_queryTimeout=" + this.m_queryTimeout + "  dbstmt=" + this.dbstmt + "  streams=" + this.streams + "  stream_array=" + this.stream_array + "  need_to_parse=" + this.need_to_parse + "  need_to_prepare_define_buffer=" + this.need_to_prepare_define_buffer + "  columns_defined_by_user=" + this.columns_defined_by_user));
            if (this.array_sql != null) {
                OracleLog.print((Object)this, (int)1, (int)16, (int)64, (String)("  array_sql: " + OracleLog.bytesToFormattedStr(this.array_sql, this.array_sql.length, "  ")));
            } else {
                OracleLog.print((Object)this, (int)1, (int)16, (int)64, (String)"  array_sql: null");
            }
            if (this.binds_in != null) {
                OracleLog.print((Object)this, (int)1, (int)16, (int)64, (String)("  binds_in: " + this.binds_in.getInfoString()));
            } else {
                OracleLog.print((Object)this, (int)1, (int)16, (int)64, (String)"  binds_in: null");
            }
            if (this.defines != null) {
                OracleLog.print((Object)this, (int)1, (int)16, (int)64, (String)("  defines: " + this.defines.getInfoString()));
            } else {
                OracleLog.print((Object)this, (int)1, (int)16, (int)64, (String)"  defines: null");
            }
            OracleLog.print((Object)this, (int)1, (int)16, (int)64, (String)(this + ": end statement state"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doExecuteQuery() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)"OracleStatement.doExecuteQuery()");
            OracleLog.print((Object)this, (int)1, (int)16, (int)32, (String)("Before query: sql_kind=" + this.sql_kind + ", row_prefetch=" + this.row_prefetch + ", need_to_parse=" + this.need_to_parse + ", need_to_prepare_define_buffer=" + this.need_to_prepare_define_buffer + ", columns_defined_by_user=" + this.columns_defined_by_user));
            if (this.array_sql != null) {
                OracleLog.print((Object)this, (int)1, (int)16, (int)64, (String)("array_sql:\n" + OracleLog.bytesToFormattedStr(this.array_sql, this.array_sql.length, "  ")));
            }
            if (this.binds_in != null) {
                OracleLog.print((Object)this, (int)1, (int)16, (int)64, (String)("binds_in: " + this.binds_in.getInfoString()));
            }
            if (this.defines != null) {
                OracleLog.print((Object)this, (int)1, (int)16, (int)64, (String)("defines:  " + this.defines.getInfoString()));
            }
        }
        DBAccess db = this.connection.db_access;
        boolean piggybackFetch = this.dbstmt.getFetchOnExec();
        try {
            this.connection.needLine();
            if (!((OracleConnectionWrapper)this.connection).getAutoCommit()) {
                this.connection.switchTxnMode(0, 1);
            }
            if (this.columns_defined_by_user != this.was_columns_defined_by_user) {
                this.need_to_parse = true;
            }
            boolean bl = this.row_prefetch_changed = this.row_prefetch > this.row_prefetch_at_execute;
            if (!this.need_to_parse && this.row_prefetch_changed) {
                this.need_to_prepare_define_buffer = true;
            }
            if (this.need_to_parse) {
                if (this.need_to_prepare_define_buffer) {
                    if (this.columns_defined_by_user) {
                        if (OracleLog.TRACE) {
                            OracleLog.print((Object)this, (int)1, (int)16, (int)32, (String)"parseExecuteFetch");
                        }
                        this.check_defines();
                        this.check_row_prefetch_changed();
                        this.doDefinesFromTypes();
                        this.need_to_prepare_define_buffer = false;
                        try {
                            this.m_isExecuting = true;
                            this.valid_rows = db.parseExecuteFetch(this.dbstmt, this.sql_kind, this.array_sql, this.binds_in, 1, this.defines, this.row_prefetch);
                            Object var4_3 = null;
                            this.m_isExecuting = false;
                        }
                        catch (Throwable throwable) {
                            Object var4_4 = null;
                            this.m_isExecuting = false;
                            throw throwable;
                        }
                        this.need_to_parse = false;
                        this.isCachable = true;
                        if (piggybackFetch) {
                            this.fetchedFirstColumns();
                        }
                    } else {
                        if (OracleLog.TRACE) {
                            OracleLog.print((Object)this, (int)1, (int)16, (int)32, (String)"parseExecuteDescribe, Fetch");
                        }
                        try {
                            this.m_isExecuting = true;
                            this.dbdescription = db.parseExecuteDescribe(this.dbstmt, this.array_sql, this.binds_in);
                            Object var6_8 = null;
                            this.m_isExecuting = false;
                        }
                        catch (Throwable throwable) {
                            Object var6_9 = null;
                            this.m_isExecuting = false;
                            throw throwable;
                        }
                        this.need_to_parse = false;
                        this.isCachable = true;
                        this.doDefaultTypes();
                        this.check_row_prefetch_changed();
                        this.doDefinesFromTypes();
                        this.need_to_prepare_define_buffer = false;
                        if (piggybackFetch) {
                            try {
                                this.m_isExecuting = true;
                                this.valid_rows = db.fetch(this.dbstmt, this.defines, this.row_prefetch);
                                Object var8_11 = null;
                                this.m_isExecuting = false;
                            }
                            catch (Throwable throwable) {
                                Object var8_12 = null;
                                this.m_isExecuting = false;
                                throw throwable;
                            }
                            this.fetchedFirstColumns();
                        }
                    }
                } else {
                    if (OracleLog.TRACE) {
                        OracleLog.print((Object)this, (int)1, (int)16, (int)32, (String)"parseExecuteFetch");
                    }
                    this.check_row_prefetch_changed();
                    try {
                        this.m_isExecuting = true;
                        if (this.need_to_prepare_java_define_buffers) {
                            if (this.defines != null) {
                                this.defines.reallocOutBuffers();
                            }
                            if (this.binds_out != null) {
                                this.binds_out.reallocOutBuffers();
                            }
                            this.need_to_prepare_java_define_buffers = false;
                        }
                        this.valid_rows = db.parseExecuteFetch(this.dbstmt, this.sql_kind, this.array_sql, this.binds_in, 1, this.defines, this.row_prefetch);
                        Object var10_14 = null;
                        this.m_isExecuting = false;
                    }
                    catch (Throwable throwable) {
                        Object var10_15 = null;
                        this.m_isExecuting = false;
                        throw throwable;
                    }
                    this.need_to_parse = false;
                    this.isCachable = true;
                    if (piggybackFetch) {
                        this.fetchedFirstColumns();
                    }
                }
            } else if (this.need_to_prepare_define_buffer) {
                if (this.columns_defined_by_user) {
                    if (OracleLog.TRACE) {
                        OracleLog.print((Object)this, (int)1, (int)16, (int)32, (String)"executeFetch");
                    }
                    this.check_defines();
                    this.check_row_prefetch_changed();
                    this.doDefinesFromTypes();
                    this.need_to_prepare_define_buffer = false;
                    try {
                        this.m_isExecuting = true;
                        this.valid_rows = db.executeFetchNeedDefines(this.dbstmt, this.sql_kind, this.binds_in, 1, this.defines, this.row_prefetch);
                        Object var12_17 = null;
                        this.m_isExecuting = false;
                    }
                    catch (Throwable throwable) {
                        Object var12_18 = null;
                        this.m_isExecuting = false;
                        throw throwable;
                    }
                    this.need_to_parse = false;
                    this.isCachable = true;
                    if (piggybackFetch) {
                        this.fetchedFirstColumns();
                    }
                } else {
                    if (OracleLog.TRACE) {
                        OracleLog.print((Object)this, (int)1, (int)16, (int)32, (String)"executeDescribe, Fetch");
                    }
                    try {
                        this.m_isExecuting = true;
                        this.dbdescription = db.parseExecuteDescribe(this.dbstmt, this.array_sql, this.binds_in);
                        Object var14_20 = null;
                        this.m_isExecuting = false;
                    }
                    catch (Throwable throwable) {
                        Object var14_21 = null;
                        this.m_isExecuting = false;
                        throw throwable;
                    }
                    this.need_to_parse = false;
                    this.isCachable = true;
                    this.doDefaultTypes();
                    this.check_row_prefetch_changed();
                    this.doDefinesFromTypes();
                    this.need_to_prepare_define_buffer = false;
                    if (OracleLog.TRACE) {
                        OracleLog.print((Object)this, (int)1, (int)16, (int)32, (String)this.defines.getInfoString());
                    }
                    if (piggybackFetch) {
                        try {
                            this.m_isExecuting = true;
                            this.valid_rows = db.fetch(this.dbstmt, this.defines, this.row_prefetch);
                            Object var16_23 = null;
                            this.m_isExecuting = false;
                        }
                        catch (Throwable throwable) {
                            Object var16_24 = null;
                            this.m_isExecuting = false;
                            throw throwable;
                        }
                        this.fetchedFirstColumns();
                    }
                }
            } else {
                if (OracleLog.TRACE) {
                    OracleLog.print((Object)this, (int)1, (int)16, (int)32, (String)"executeFetch");
                }
                this.check_row_prefetch_changed();
                try {
                    if (this.need_to_prepare_java_define_buffers) {
                        if (this.defines != null) {
                            this.defines.reallocOutBuffers();
                        }
                        if (this.binds_out != null) {
                            this.binds_out.reallocOutBuffers();
                        }
                        this.need_to_prepare_java_define_buffers = false;
                    }
                    this.m_isExecuting = true;
                    this.valid_rows = db.executeFetch(this.dbstmt, this.sql_kind, this.binds_in, 1, this.defines, this.row_prefetch);
                    Object var18_26 = null;
                    this.m_isExecuting = false;
                }
                catch (Throwable throwable) {
                    Object var18_27 = null;
                    this.m_isExecuting = false;
                    throw throwable;
                }
                if (piggybackFetch) {
                    this.fetchedFirstColumns();
                }
            }
            this.row_prefetch_at_execute = this.row_prefetch;
        }
        catch (IOException e2) {
            DBError.throwSqlException((IOException)e2);
        }
        catch (SQLException ea) {
            this.need_to_parse = true;
            this.isCachable = false;
            throw ea;
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)32, (String)("After execute: valid_rows=" + this.valid_rows + ", piggyback_fetch is " + piggybackFetch));
            if (this.defines != null) {
                OracleLog.print((Object)this, (int)1, (int)16, (int)64, (String)("defines:  " + this.defines.getInfoString()));
            }
        }
        if (piggybackFetch) {
            this.checkValidRowsStatus();
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)"OracleStatement.doExecuteQuery():return");
        }
    }

    void checkValidRowsStatus() {
        if (this.valid_rows == -2) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)1, (int)16, (int)32, (String)("holding the linestreams = " + this.streams));
            }
            this.valid_rows = 1;
            this.connection.holdLine(this);
            if (this.streams != null) {
                this.streams.resetLong();
            }
        } else if (this.sql_kind == 0 && this.valid_rows < this.row_prefetch) {
            this.got_last_batch = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doExecuteWithTimeout() throws SQLException {
        block20: {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)"OracleStatement.doExecuteWithTimeout()");
            }
            if (this.sql_query == null || this.sql_query == "") {
                DBError.throwSqlException((int)104);
            }
            this.open();
            this.dbstmt.rows_processed = 0;
            this.checkBindsInAndOut();
            if (this.sql_string_changed) {
                this.parseSqlKind();
            }
            if (this.connection.m_j2ee13Compliant && this.sql_kind != 1 && this.sql_kind != 3 && this.executionType != 3) {
                if (this.sql_kind == 0 && this.executionType == 2) {
                    DBError.throwSqlException((int)129);
                } else if (this.sql_kind != 0 && this.executionType == 1) {
                    DBError.throwSqlException((int)128);
                }
            }
            if (this.sql_kind == 0) {
                if (this.m_queryTimeout != 0) {
                    try {
                        this.connection.getTimeout().setTimeout(this.m_queryTimeout * 1000, this);
                        this.doExecuteQuery();
                        Object var2_1 = null;
                    }
                    catch (Throwable throwable) {
                        Object var2_2 = null;
                        this.connection.getTimeout().cancelTimeout();
                        throw throwable;
                    }
                    this.connection.getTimeout().cancelTimeout();
                    {
                        break block20;
                    }
                }
                this.doExecuteQuery();
            } else {
                block21: {
                    ++this.m_currentRank;
                    if (this.m_currentRank >= this.batch) {
                        if (this.m_queryTimeout != 0) {
                            try {
                                this.connection.getTimeout().setTimeout(this.m_queryTimeout * 1000, this);
                                this.doExecuteOther(false);
                                Object var4_4 = null;
                            }
                            catch (Throwable throwable) {
                                Object var4_5 = null;
                                this.connection.getTimeout().cancelTimeout();
                                this.cleanupForBatching();
                                throw throwable;
                            }
                            this.connection.getTimeout().cancelTimeout();
                            this.cleanupForBatching();
                            {
                                break block21;
                            }
                        }
                        try {
                            this.doExecuteOther(false);
                            Object var6_7 = null;
                        }
                        catch (Throwable throwable) {
                            Object var6_8 = null;
                            this.cleanupForBatching();
                            throw throwable;
                        }
                        this.cleanupForBatching();
                        {
                        }
                    }
                }
                if (OracleLog.TRACE) {
                    OracleLog.print((Object)this, (int)1, (int)16, (int)32, (String)("End of doExecuteWithTimeout(): m_currentRank=" + this.m_currentRank));
                }
            }
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)"OracleStatement.doExecuteWithTimeout():return");
        }
    }

    private void cleanup() {
        int i2;
        if (this.defines != null) {
            this.defines.cleanup();
            this.defines = null;
        }
        this.streams = null;
        if (this.dbdescription != null) {
            i2 = 0;
            while (i2 < this.dbdescription.length) {
                this.dbdescription[i2] = null;
                ++i2;
            }
            this.dbdescription = null;
        }
        if (this.stream_array != null) {
            i2 = 0;
            while (i2 < this.stream_array.length) {
                this.stream_array[i2] = null;
                ++i2;
            }
            this.stream_array = null;
        }
        this.m_currentDataSet = null;
    }

    public synchronized int getMaxFieldSize() throws SQLException {
        return this.max_field_size;
    }

    public synchronized void setMaxFieldSize(int max) throws SQLException {
        if (max < 0) {
            DBError.throwSqlException((int)68);
        }
        this.max_field_size = max;
    }

    public int getMaxRows() throws SQLException {
        return this.max_rows;
    }

    public synchronized void setMaxRows(int max) throws SQLException {
        if (max < 0) {
            DBError.throwSqlException((int)68);
        }
        this.max_rows = max;
    }

    public synchronized void setEscapeProcessing(boolean enable) throws SQLException {
        this.connection.trace("Statement.setEscapeProcessing");
        this.process_escapes = enable;
    }

    public synchronized int getQueryTimeout() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)"OracleStatement.getQueryTimeout()");
        }
        return this.m_queryTimeout;
    }

    public synchronized void setQueryTimeout(int max) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)("OracleStatement.setQueryTimeout(max=" + max + ")"));
        }
        if (max < 0) {
            DBError.throwSqlException((int)68);
        }
        this.m_queryTimeout = max;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final int parseExecuteFetchWithTimeout(DBStatement dbstmt, byte type, byte[] sqlstmt, DBDataSet inDataSet, int batch, DBDataSet outDataSet, int rows) throws SQLException, IOException {
        int ret_val = -1;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)"OracleStatement.parseExcuteFetchWithTimeout(...)");
        }
        if (this.m_queryTimeout == 0) {
            try {
                this.m_isExecuting = true;
                ret_val = this.connection.db_access.parseExecuteFetch(dbstmt, type, sqlstmt, inDataSet, batch, outDataSet, rows);
                Object var10_9 = null;
                this.m_isExecuting = false;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                this.m_isExecuting = false;
                throw throwable;
            }
        }
        try {
            this.connection.getTimeout().setTimeout(this.m_queryTimeout * 1000, this);
            this.m_isExecuting = true;
            ret_val = this.connection.db_access.parseExecuteFetch(dbstmt, type, sqlstmt, inDataSet, batch, outDataSet, rows);
            Object var12_12 = null;
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            this.connection.getTimeout().cancelTimeout();
            throw throwable;
        }
        this.connection.getTimeout().cancelTimeout();
        {
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OracleStatement.parseExcuteFetchWithTimeout() returned " + ret_val));
        }
        return ret_val;
    }

    public void cancel() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)"OracleStatement.cancel()");
        }
        if (this.closed) {
            return;
        }
        try {
            if (this.connection.statement_holding_line != null) {
                this.freeLine();
            } else if (this.m_isExecuting) {
                this.connection.db_access.cancel();
            }
            this.connection.releaseLineForCancel();
        }
        catch (IOException e2) {
            DBError.throwSqlException((IOException)e2);
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)"OracleStatement.getWarnings()");
        }
        return this.m_warning;
    }

    public void clearWarnings() throws SQLException {
        this.m_warning = null;
    }

    public void setCursorName(String name) throws SQLException {
        this.connection.trace("Statement.setCursorName");
        DBError.throwSqlException((int)23);
    }

    public synchronized ResultSet getResultSet() throws SQLException {
        this.connection.trace("Statement.getResultSet");
        if (this.isRegularResultSet()) {
            if (this.sql_kind == 0) {
                if (this.current_result_set == null) {
                    this.current_result_set = new OracleResultSetImpl((OracleConnection)this.connection, this);
                }
                return this.current_result_set;
            }
        } else {
            return this.m_scrollRset;
        }
        return null;
    }

    public synchronized int getUpdateCount() throws SQLException {
        this.connection.trace("Statement.getUpdateCount");
        if (this.noMoreUpdateCounts) {
            return -1;
        }
        this.noMoreUpdateCounts = true;
        if (this.sql_kind == 4) {
            return 0;
        }
        if (this.sql_kind != 2) {
            return -1;
        }
        return this.dbstmt.rows_processed;
    }

    public boolean getMoreResults() throws SQLException {
        this.connection.trace("Statement.getMoreResults");
        return false;
    }

    public int sendBatch() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)"OracleStatement.sendBatch()");
        }
        return 0;
    }

    void prepare_for_new_result(boolean resetPrefetch) throws SQLException {
        this.clearWarnings();
        if (this.streams != null) {
            try {
                this.streams.close();
            }
            catch (IOException e2) {
                DBError.throwSqlException((IOException)e2);
            }
        }
        if (this.current_result_set != null) {
            this.current_result_set.internal_close();
            this.current_result_set = null;
        }
        this.current_row = -1;
        this.valid_rows = 0;
        this.total_rows_visited = 0;
        this.got_last_batch = false;
        if (!this.columns_defined_by_user && this.need_to_parse) {
            this.need_to_prepare_define_buffer = true;
        }
        if (this.need_to_parse) {
            this.dbdescription = null;
        }
        if (resetPrefetch && this.row_prefetch != this.default_row_prefetch && !this.defines.hasStreamType()) {
            this.row_prefetch_changed = this.row_prefetch < this.default_row_prefetch;
            this.row_prefetch = this.default_row_prefetch;
        }
    }

    void end_of_result_set() throws SQLException {
        if (this.closed) {
            return;
        }
        this.prepare_for_new_result(false);
        this.clearDefines();
    }

    boolean wasNullValue() throws SQLException {
        if (this.last_index == 0) {
            DBError.throwSqlException((int)24);
        }
        if (this.sql_kind == 0) {
            return this.defines.isNull(this.last_index - 1, this.current_row);
        }
        return this.binds_out.isNull(this.last_index - 1, this.m_currentRank);
    }

    void prepare_for_new_get(boolean getColumn, int column_index) throws SQLException {
        if (getColumn) {
            if (this.current_result_set == null || this.current_result_set.closed) {
                DBError.throwSqlException((int)11);
            }
            if (this.defines == null || column_index > this.defines.getNoOfArgs() || column_index <= 0) {
                DBError.throwSqlException((int)3);
            }
            if (this.current_row < 0) {
                DBError.throwSqlException((int)14);
            }
        } else if (this.binds_out == null || column_index > this.binds_out.getNoOfArgs() || column_index <= 0 || !this.binds_out.dataAllocated(column_index - 1)) {
            DBError.throwSqlException((int)3);
        }
        if (this.stream_array != null && this.stream_array[column_index - 1] != null) {
            try {
                this.stream_array[column_index - 1].close();
            }
            catch (IOException e2) {
                DBError.throwSqlException((IOException)e2);
            }
        }
        this.last_was_column = getColumn;
        this.last_index = column_index;
    }

    /*
     * WARNING - void declaration
     */
    byte[] getBytesInternal(boolean getColumn, int index) throws SQLException {
        DBDataSet useDataSet;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OracleStatement.getBytesInternal(getColumn=" + getColumn + ", index=" + index + ")"));
        }
        int col_index = index - 1;
        int row = 0;
        if (getColumn) {
            useDataSet = this.defines;
            row = this.current_row;
        } else {
            useDataSet = this.binds_out;
            row = this.m_currentRank;
        }
        if (useDataSet.isStreamType(col_index)) {
            OracleInputStream stream = (OracleInputStream)useDataSet.getStreamItem(col_index, row);
            ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
            byte[] buffer = new byte[1024];
            if (stream == null) {
                return null;
            }
            try {
                int length;
                while ((length = stream.read(buffer)) != -1) {
                    void var9_9;
                    out.write(buffer, 0, (int)var9_9);
                }
            }
            catch (IOException e2) {
                DBError.throwSqlException((IOException)e2);
            }
            return out.toByteArray();
        }
        return useDataSet.getBytesItem(col_index, row);
    }

    char[] getCharsInternal(boolean getColumn, int index, int[] char_size, short FormOfUse, int type) throws SQLException {
        DBDataSet useDataSet;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OracleStatement.getCharsInternal(getColumn=" + getColumn + ", index=" + index + ")"));
        }
        int col_index = index - 1;
        int row = 0;
        if (getColumn) {
            useDataSet = this.defines;
            row = this.current_row;
        } else {
            useDataSet = this.binds_out;
            row = this.m_currentRank;
        }
        if (useDataSet.isStreamType(col_index)) {
            return useDataSet.getCharsStreamItem(col_index, row, char_size);
        }
        char[] retval = useDataSet.getCharsItem(col_index, row, char_size, FormOfUse);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)64, (String)("OracleStatement.getCharsInternal: " + (retval != null ? "retval.length=" + retval.length + " " : "") + (char_size != null ? "char_size[0]=" + char_size[0] : "")));
        }
        if (getColumn && type == 96) {
            int actual_size;
            int chars_read = char_size[0];
            if (this.connection.db_access.getNlsRatio() > 1 && this.dbdescription != null && this.dbdescription.length >= index && FormOfUse != 2 && (actual_size = this.dbdescription[index - 1].max_length) > 0 && chars_read > actual_size) {
                chars_read = actual_size;
            }
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)1, (int)16, (int)64, (String)("OracleStatement.getCharsInternal: max_field_size=" + this.max_field_size + ", chars_read=" + chars_read));
            }
            char_size[0] = this.max_field_size > 0 && this.max_field_size < chars_read ? this.max_field_size : chars_read;
        }
        return retval;
    }

    public short getDBTypeForm(int index) {
        short form = this.sql_kind == 1 || this.sql_kind == 3 ? this.binds_out.getFormOfUse(index) : (this.dbdescription == null ? (short)1 : this.dbdescription[index].FormOfUse);
        return form;
    }

    String getStringValue(boolean getColumn, int index) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OracleStatement.getStringValue(getColumn=" + getColumn + ", index=" + index + ")"));
        }
        DBDataSet dbset = getColumn ? this.defines : this.binds_out;
        this.prepare_for_new_get(getColumn, index);
        char[] chars = null;
        int[] char_size = new int[1];
        byte[] array = null;
        int type = dbset.getType(index - 1);
        switch (type) {
            case 12: {
                array = this.getBytesInternal(getColumn, index);
                if (array == null || array.length == 0) {
                    return null;
                }
                Timestamp tstamp = ((OracleConnection)this.connection).conversion.DateBytesToTimestamp(array, array.length);
                return tstamp.toString();
            }
            case 2: 
            case 6: {
                array = this.getBytesInternal(getColumn, index);
                if (array == null || array.length == 0) {
                    return null;
                }
                NUMBER oranum = new NUMBER(array);
                String s2 = NUMBER.toString(array);
                int numlength = s2.length();
                if (s2.startsWith("0.") || s2.startsWith("-0.")) {
                    --numlength;
                }
                if (numlength > 38) {
                    s2 = oranum.toText(-44, null);
                    int idxe = s2.indexOf(69);
                    int idxpls = s2.indexOf(43);
                    if (idxe == -1) {
                        idxe = s2.indexOf(101);
                    }
                    int idx = idxe - 1;
                    while (s2.charAt(idx) == '0') {
                        --idx;
                    }
                    String left = s2.substring(0, idx + 1);
                    String right = null;
                    right = idxpls > 0 ? s2.substring(idxpls + 1) : s2.substring(idxe + 1);
                    return (left + "E" + right).trim();
                }
                return oranum.toText(38, null).trim();
            }
            case 23: 
            case 24: {
                array = this.getBytesInternal(getColumn, index);
                if (array == null || array.length == 0) {
                    return null;
                }
                return RepConversion.bArray2String(array);
            }
            case 1: 
            case 8: 
            case 96: 
            case 104: {
                String charString = null;
                boolean thin = this.connection.getProtocolType().equals("thin");
                short form = this.getDBTypeForm(index - 1);
                if (thin) {
                    chars = this.getCharsInternal(getColumn, index, char_size, form, type);
                    if (chars == null || chars.length == 0) {
                        return null;
                    }
                    charString = new String(chars, 0, char_size[0]);
                } else {
                    array = this.getBytesInternal(getColumn, index);
                    if (array == null || array.length == 0) {
                        return null;
                    }
                    charString = form == 2 ? ((OracleConnection)this.connection).conversion.NCharBytesToString(array, array.length) : ((OracleConnection)this.connection).conversion.CharBytesToString(array, array.length);
                }
                return charString;
            }
            case 182: {
                array = this.getBytesInternal(getColumn, index);
                if (array == null || array.length == 0) {
                    return null;
                }
                return INTERVALYM.toString(array);
            }
            case 180: {
                array = this.getBytesInternal(getColumn, index);
                if (array == null || array.length == 0) {
                    return null;
                }
                return TIMESTAMP.toString(array);
            }
            case 181: {
                array = this.getBytesInternal(getColumn, index);
                if (array == null || array.length == 0) {
                    return null;
                }
                return TIMESTAMPTZ.toString(this.connection, array);
            }
            case 231: {
                array = this.getBytesInternal(getColumn, index);
                if (array == null || array.length == 0) {
                    return null;
                }
                return TIMESTAMPLTZ.toString(this.connection, array);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResultSet getCursorValue(boolean getColumn, int index) throws SQLException {
        byte[] result;
        int row_index;
        DBDataSet dbset;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OracleStatement.getCursorValue(getColumn=" + getColumn + ", index=" + index + ")"));
        }
        int col_index = index - 1;
        if (getColumn) {
            dbset = this.defines;
            row_index = this.current_row;
        } else {
            dbset = this.binds_out;
            row_index = this.m_currentRank;
        }
        this.prepare_for_new_get(getColumn, index);
        if (dbset.getType(col_index) != 102) {
            DBError.throwSqlException((int)4);
        }
        if ((result = dbset.getBytesItem(col_index, row_index)) == null || result.length == 0) {
            return null;
        }
        DBAccess db = this.connection.db_access;
        DBStatement db_stmt = null;
        try {
            db_stmt = db.RefCursorBytesToDBStatement(this.dbstmt, result);
            db_stmt.setFetchOnExec(this.dbstmt.getFetchOnExec());
        }
        catch (IOException e2) {
            DBError.throwSqlException((IOException)e2);
        }
        catch (SQLException e3) {
            DBError.throwSqlException((int)62);
        }
        try {
            this.m_isExecuting = true;
            OracleStatement stmt = new OracleStatement((OracleConnection)this.connection, db_stmt, 1, this.connection.default_row_prefetch);
            ResultSet resultSet = stmt.getResultSet();
            Object var12_13 = null;
            this.m_isExecuting = false;
            return resultSet;
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            this.m_isExecuting = false;
            throw throwable;
        }
    }

    ROWID getROWIDValue(boolean getColumn, int index) throws SQLException {
        byte[] bytes;
        int row_index;
        DBDataSet dbset;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OracleStatement.getROWIDValue(getColumn=" + getColumn + ", index=" + index + ")"));
        }
        int col_index = index - 1;
        if (getColumn) {
            dbset = this.defines;
            row_index = this.current_row;
        } else {
            dbset = this.binds_out;
            row_index = this.m_currentRank;
        }
        this.prepare_for_new_get(getColumn, index);
        if (dbset.getType(col_index) != 104) {
            DBError.throwSqlException((int)4);
        }
        if ((bytes = dbset.getBytesItem(col_index, row_index)) == null || bytes.length == 0) {
            return null;
        }
        return new ROWID(bytes);
    }

    RAW getRAWValue(boolean getColumn, int index) throws SQLException {
        byte[] bytes;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OracleStatement.getValue(getColumn=" + getColumn + ", index=" + index + ")"));
        }
        DBDataSet dbset = getColumn ? this.defines : this.binds_out;
        this.prepare_for_new_get(getColumn, index);
        int type = dbset.getType(index - 1);
        if (type != 23 && type != 24) {
            DBError.throwSqlException((int)4);
        }
        if ((bytes = this.getBytesInternal(getColumn, index)) == null || bytes.length == 0) {
            return null;
        }
        return new RAW(bytes);
    }

    CHAR getCHARValue(boolean getColumn, int index) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OracleStatement.getCHARValue(getColumn=" + getColumn + ", index=" + index + ")"));
        }
        CharacterSet char_set = null;
        DBDataSet dbset = getColumn ? this.defines : this.binds_out;
        this.prepare_for_new_get(getColumn, index);
        int type = dbset.getType(index - 1);
        short form = this.getDBTypeForm(index - 1);
        switch (type) {
            case 1: 
            case 8: 
            case 96: {
                if (form == 2) {
                    char_set = ((OracleConnection)this.connection).conversion.getAccessNCharSetObj();
                    break;
                }
                char_set = ((OracleConnection)this.connection).conversion.getAccessCharSetObj();
                break;
            }
            case 23: {
                char_set = ((OracleConnection)this.connection).conversion.getDbCharSetObj();
                break;
            }
            default: {
                DBError.throwSqlException((int)4);
            }
        }
        boolean thin = this.connection.getProtocolType().equals("thin");
        if (thin) {
            char[] chars = null;
            int[] char_size = new int[1];
            chars = this.getCharsInternal(getColumn, index, char_size, form, type);
            if (chars == null || chars.length == 0) {
                return null;
            }
            return new CHAR(new String(chars, 0, char_size[0]), char_set);
        }
        byte[] bytes = this.getBytesInternal(getColumn, index);
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        return new CHAR(bytes, char_set);
    }

    DATE getDATEValue(boolean getColumn, int index) throws SQLException {
        byte[] bytes;
        int row_index;
        DBDataSet dbset;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OracleStatement.getDATEValue(getColumn=" + getColumn + ", index=" + index + ")"));
        }
        int col_index = index - 1;
        if (getColumn) {
            dbset = this.defines;
            row_index = this.current_row;
        } else {
            dbset = this.binds_out;
            row_index = this.m_currentRank;
        }
        this.prepare_for_new_get(getColumn, index);
        int l_type = dbset.getType(col_index);
        if (l_type != 12 && l_type != 180 && l_type != 181 && l_type != 231) {
            DBError.throwSqlException((int)4);
        }
        if ((bytes = dbset.getBytesItem(col_index, row_index)) == null || bytes.length == 0) {
            return null;
        }
        return new DATE(bytes);
    }

    REF getREFValue(boolean getColumn, int index) throws SQLException {
        byte[] bytes;
        DBDataSet dbset;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OracleStatement.getREFValue(getColumn=" + getColumn + ", index=" + index + ")"));
        }
        int col_index = index - 1;
        if (getColumn) {
            dbset = this.defines;
            int row_index = this.current_row;
        } else {
            dbset = this.binds_out;
            int row_index = this.m_currentRank;
        }
        this.prepare_for_new_get(getColumn, index);
        if (dbset.getType(col_index) != 111) {
            DBError.throwSqlException((int)4);
        }
        if ((bytes = this.getBytesInternal(getColumn, index)) == null || bytes.length == 0) {
            return null;
        }
        OracleTypeADT otype = (OracleTypeADT)dbset.getOtype(col_index);
        return new REF(otype.getFullName(), (Connection)this.connection, bytes);
    }

    private Datum getNamedTypeValue(boolean getColumn, int index) throws SQLException {
        byte[] bytes;
        int row_index;
        DBDataSet dbset;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OracleStatement.getNamedTypeValue(getColumn=" + getColumn + ", index=" + index + ")"));
        }
        int col_index = index - 1;
        if (getColumn) {
            dbset = this.defines;
            row_index = this.current_row;
        } else {
            dbset = this.binds_out;
            row_index = this.m_currentRank;
        }
        this.prepare_for_new_get(getColumn, index);
        if (dbset.getType(col_index) != 109) {
            DBError.throwSqlException((int)4);
        }
        if ((bytes = dbset.getBytesItem(col_index, row_index)) == null || bytes.length == 0) {
            return null;
        }
        OracleTypeADT otype = (OracleTypeADT)dbset.getOtype(col_index);
        TypeDescriptor desc = null;
        desc = TypeDescriptor.getTypeDescriptor(otype.getFullName(), this.connection, bytes, 0L);
        switch (desc.getTypeCode()) {
            case 2003: {
                return new ARRAY((ArrayDescriptor)desc, bytes, this.connection);
            }
            case 2002: {
                return new STRUCT((StructDescriptor)desc, bytes, this.connection);
            }
            case 2007: {
                return new OPAQUE((OpaqueDescriptor)desc, bytes, this.connection);
            }
            case 2008: {
                return new JAVA_STRUCT((StructDescriptor)desc, bytes, this.connection);
            }
        }
        DBError.throwSqlException((int)1);
        return null;
    }

    STRUCT getSTRUCTValue(boolean getColumn, int index) throws SQLException {
        return (STRUCT)this.getNamedTypeValue(getColumn, index);
    }

    ARRAY getARRAYValue(boolean getColumn, int index) throws SQLException {
        return (ARRAY)this.getNamedTypeValue(getColumn, index);
    }

    OPAQUE getOPAQUEValue(boolean getColumn, int index) throws SQLException {
        return (OPAQUE)this.getNamedTypeValue(getColumn, index);
    }

    NUMBER getNUMBERValue(boolean getColumn, int index) throws SQLException {
        byte[] bytes;
        int row_index;
        DBDataSet dbset;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OracleStatement.getNUMBERValue(getColumn=" + getColumn + ", index=" + index + ")"));
        }
        int col_index = index - 1;
        if (getColumn) {
            dbset = this.defines;
            row_index = this.current_row;
        } else {
            dbset = this.binds_out;
            row_index = this.m_currentRank;
        }
        this.prepare_for_new_get(getColumn, index);
        int type = dbset.getType(col_index);
        if (type != 2 && type != 6) {
            DBError.throwSqlException((int)4);
        }
        if ((bytes = dbset.getBytesItem(col_index, row_index)) == null || bytes.length == 0) {
            return null;
        }
        return new NUMBER(bytes);
    }

    BLOB getBLOBValue(boolean getColumn, int index) throws SQLException {
        int row_index;
        DBDataSet dbset;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OracleStatement.getBLOBValue(getColumn=" + getColumn + ", index=" + index + ")"));
        }
        int col_index = index - 1;
        if (getColumn) {
            dbset = this.defines;
            row_index = this.current_row;
        } else {
            dbset = this.binds_out;
            row_index = this.m_currentRank;
        }
        this.prepare_for_new_get(getColumn, index);
        if (dbset.getType(col_index) != 113) {
            DBError.throwSqlException((int)4);
        }
        return this.get_blob_value(dbset, col_index, row_index);
    }

    CLOB getCLOBValue(boolean getColumn, int index) throws SQLException {
        int row_index;
        DBDataSet dbset;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OracleStatement.getCLOBValue(getColumn=" + getColumn + ", index=" + index + ")"));
        }
        int col_index = index - 1;
        if (getColumn) {
            dbset = this.defines;
            row_index = this.current_row;
        } else {
            dbset = this.binds_out;
            row_index = this.m_currentRank;
        }
        this.prepare_for_new_get(getColumn, index);
        if (dbset.getType(col_index) != 112) {
            DBError.throwSqlException((int)4);
        }
        return this.get_clob_value(dbset, col_index, row_index);
    }

    BFILE getBFILEValue(boolean getColumn, int index) throws SQLException {
        int row_index;
        DBDataSet dbset;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OracleStatement.getBFILEValue(getColumn=" + getColumn + ", index=" + index + ")"));
        }
        int col_index = index - 1;
        if (getColumn) {
            dbset = this.defines;
            row_index = this.current_row;
        } else {
            dbset = this.binds_out;
            row_index = this.m_currentRank;
        }
        this.prepare_for_new_get(getColumn, index);
        if (dbset.getType(col_index) != 114) {
            DBError.throwSqlException((int)4);
        }
        return this.get_bfile_value(dbset, col_index, row_index);
    }

    boolean getBooleanValue(boolean getColumn, int index) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OracleStatement.getBooleanValue(getColumn=" + getColumn + ", index=" + index + ")"));
        }
        DBDataSet dbset = getColumn ? this.defines : this.binds_out;
        this.prepare_for_new_get(getColumn, index);
        byte[] result = this.getBytesInternal(getColumn, index);
        if (result == null || result.length == 0) {
            return false;
        }
        int type = dbset.getType(index - 1);
        switch (type) {
            case 1: 
            case 8: 
            case 96: {
                long val;
                String str = ((OracleConnection)this.connection).conversion.CharBytesToString(result, result.length);
                if (str == null) {
                    return false;
                }
                if (type == 96) {
                    str = str.trim();
                }
                return (val = Double.valueOf(str).longValue()) != 0L;
            }
            case 2: 
            case 6: {
                return DBConversion.NumberBytesToBoolean((byte[])result, (int)result.length);
            }
        }
        DBError.throwSqlException((int)4);
        return false;
    }

    byte getByteValue(boolean getColumn, int index) throws SQLException {
        long result = this.getLongValue(getColumn, index);
        if (result > 127L || result < -128L) {
            DBError.throwSqlException((int)26);
        }
        return (byte)result;
    }

    short getShortValue(boolean getColumn, int index) throws SQLException {
        long result = this.getLongValue(getColumn, index);
        if (result > 32767L || result < -32768L) {
            DBError.throwSqlException((int)26);
        }
        return (short)result;
    }

    int getIntValue(boolean getColumn, int index) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OracleStatement.getIntValue(getColumn=" + getColumn + ", index=" + index + ")"));
        }
        DBDataSet dbset = getColumn ? this.defines : this.binds_out;
        this.prepare_for_new_get(getColumn, index);
        byte[] result = this.getBytesInternal(getColumn, index);
        if (result == null || result.length == 0) {
            return 0;
        }
        int type = dbset.getType(index - 1);
        switch (type) {
            case 1: 
            case 8: 
            case 96: {
                String str = ((OracleConnection)this.connection).conversion.CharBytesToString(result, result.length);
                if (type == 96) {
                    str = str.trim();
                }
                long ret_val = 0L;
                try {
                    ret_val = Long.valueOf(str);
                }
                catch (NumberFormatException e2) {
                    DBError.throwSqlException((int)59);
                }
                if (ret_val > Integer.MAX_VALUE || ret_val < Integer.MIN_VALUE) {
                    DBError.throwSqlException((int)26);
                } else {
                    return (int)ret_val;
                }
            }
            case 2: 
            case 6: {
                try {
                    return DBConversion.NumberBytesToInt((byte[])result, (int)result.length);
                }
                catch (SQLException ex) {
                    if (ex.getMessage().equals(CoreException.getMessage((byte)3))) {
                        DBError.throwSqlException((int)26);
                        break;
                    }
                    throw ex;
                }
            }
        }
        DBError.throwSqlException((int)4);
        return 0;
    }

    long getLongValue(boolean getColumn, int index) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OracleStatement.getLongValue(getColumn=" + getColumn + ", index=" + index + ")"));
        }
        DBDataSet dbset = getColumn ? this.defines : this.binds_out;
        this.prepare_for_new_get(getColumn, index);
        byte[] result = this.getBytesInternal(getColumn, index);
        if (result == null || result.length == 0) {
            return 0L;
        }
        int type = dbset.getType(index - 1);
        switch (type) {
            case 1: 
            case 8: 
            case 96: {
                String str = ((OracleConnection)this.connection).conversion.CharBytesToString(result, result.length);
                if (type == 96) {
                    str = str.trim();
                }
                long ret_val = 0L;
                try {
                    ret_val = Long.valueOf(str);
                }
                catch (NumberFormatException e2) {
                    DBError.throwSqlException((int)59);
                }
                return ret_val;
            }
            case 2: 
            case 6: {
                return DBConversion.NumberBytesToLong((byte[])result, (int)result.length);
            }
        }
        DBError.throwSqlException((int)4);
        return 0L;
    }

    float getFloatValue(boolean getColumn, int index) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OracleStatement.getFloatValue(getColumn=" + getColumn + ", index=" + index + ")"));
        }
        DBDataSet dbset = getColumn ? this.defines : this.binds_out;
        this.prepare_for_new_get(getColumn, index);
        byte[] result = this.getBytesInternal(getColumn, index);
        if (result == null || result.length == 0) {
            return 0.0f;
        }
        int type = dbset.getType(index - 1);
        switch (type) {
            case 1: 
            case 8: 
            case 96: {
                String str = ((OracleConnection)this.connection).conversion.CharBytesToString(result, result.length);
                float ret_val = 0.0f;
                try {
                    ret_val = Float.valueOf(str).floatValue();
                }
                catch (NumberFormatException e2) {
                    DBError.throwSqlException((int)59);
                }
                return ret_val;
            }
            case 2: 
            case 6: {
                return DBConversion.NumberBytesToFloat((byte[])result, (int)result.length);
            }
        }
        DBError.throwSqlException((int)4);
        return 0.0f;
    }

    double getDoubleValue(boolean getColumn, int index) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OracleStatement.getDoubleValue(getColumn=" + getColumn + ", index=" + index + ")"));
        }
        DBDataSet dbset = getColumn ? this.defines : this.binds_out;
        this.prepare_for_new_get(getColumn, index);
        byte[] result = this.getBytesInternal(getColumn, index);
        if (result == null || result.length == 0) {
            return 0.0;
        }
        int type = dbset.getType(index - 1);
        switch (type) {
            case 1: 
            case 8: 
            case 96: {
                String str = ((OracleConnection)this.connection).conversion.CharBytesToString(result, result.length);
                double ret_val = 0.0;
                try {
                    ret_val = Double.valueOf(str);
                }
                catch (NumberFormatException e2) {
                    DBError.throwSqlException((int)59);
                }
                return ret_val;
            }
            case 2: 
            case 6: {
                return DBConversion.NumberBytesToDouble((byte[])result, (int)result.length);
            }
        }
        DBError.throwSqlException((int)4);
        return 0.0;
    }

    BigDecimal getBigDecimalValue(boolean getColumn, int index, int scale) throws SQLException {
        DBDataSet dbset;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OracleStatement.getBigDecimalValue(getColumn=" + getColumn + ", index=" + index + ")"));
        }
        int col_index = index - 1;
        if (getColumn) {
            dbset = this.defines;
            int row_index = this.current_row;
        } else {
            dbset = this.binds_out;
            int row_index = this.m_currentRank;
        }
        this.prepare_for_new_get(getColumn, index);
        byte[] result = this.getBytesInternal(getColumn, index);
        if (result == null || result.length == 0) {
            return null;
        }
        int type = dbset.getType(col_index);
        switch (type) {
            case 1: 
            case 8: 
            case 96: {
                String str = ((OracleConnection)this.connection).conversion.CharBytesToString(result, result.length);
                BigDecimal num = new BigDecimal(str);
                return num;
            }
            case 2: 
            case 6: {
                return DBConversion.NumberBytesToBigDecimal((byte[])result, (int)result.length);
            }
        }
        DBError.throwSqlException((int)4);
        return null;
    }

    byte[] getBytesValue(boolean getColumn, int index) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OracleStatement.getBytesValue(getColumn=" + getColumn + ", index=" + index + ")"));
        }
        this.prepare_for_new_get(getColumn, index);
        byte[] bytes = this.getBytesInternal(getColumn, index);
        return bytes;
    }

    Date getDateValue(boolean getColumn, int index) throws SQLException {
        DBDataSet dbset;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OracleStatement.getDateValue(getColumn=" + getColumn + ", index=" + index + ")"));
        }
        int col_index = index - 1;
        if (getColumn) {
            dbset = this.defines;
            int row_index = this.current_row;
        } else {
            dbset = this.binds_out;
            int row_index = this.m_currentRank;
        }
        this.prepare_for_new_get(getColumn, index);
        byte[] result = this.getBytesInternal(getColumn, index);
        if (result == null || result.length == 0) {
            return null;
        }
        int type = dbset.getType(col_index);
        switch (type) {
            case 1: 
            case 8: 
            case 96: {
                String str = ((OracleConnection)this.connection).conversion.CharBytesToString(result, result.length);
                return Date.valueOf(str);
            }
            case 12: {
                return ((OracleConnection)this.connection).conversion.DateBytesToDate(result, result.length);
            }
            case 180: {
                return TIMESTAMP.toDate(result);
            }
            case 181: {
                return TIMESTAMPTZ.toDate(this.connection, result);
            }
            case 231: {
                return TIMESTAMPLTZ.toDate(this.connection, result);
            }
        }
        DBError.throwSqlException((int)4);
        return null;
    }

    Date getDateValue(boolean getColumn, int index, Calendar cal) throws SQLException {
        DATE value;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OracleStatement.getDateValue(getColumn=" + getColumn + ", index=" + index + ", calendar)"));
        }
        return (value = this.getDATEValue(getColumn, index)) == null ? null : value.dateValue(cal);
    }

    Time getTimeValue(boolean getColumn, int index) throws SQLException {
        DBDataSet dbset;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OracleStatement.getTimeValue(getColumn=" + getColumn + ", index=" + index + ")"));
        }
        int col_index = index - 1;
        if (getColumn) {
            dbset = this.defines;
            int row_index = this.current_row;
        } else {
            dbset = this.binds_out;
            int row_index = this.m_currentRank;
        }
        this.prepare_for_new_get(getColumn, index);
        byte[] result = this.getBytesInternal(getColumn, index);
        if (result == null || result.length == 0) {
            return null;
        }
        int type = dbset.getType(col_index);
        switch (type) {
            case 1: 
            case 8: 
            case 96: {
                String str = ((OracleConnection)this.connection).conversion.CharBytesToString(result, result.length);
                return Time.valueOf(str.trim());
            }
            case 12: {
                return ((OracleConnection)this.connection).conversion.DateBytesToTime(result, result.length);
            }
            case 180: {
                Time l_time = TIMESTAMP.toTime(result);
                return new Time(l_time.getHours(), l_time.getMinutes(), l_time.getSeconds());
            }
            case 181: {
                return TIMESTAMPTZ.toTime(this.connection, result);
            }
            case 231: {
                return TIMESTAMPLTZ.toTime(this.connection, result);
            }
        }
        DBError.throwSqlException((int)4);
        return null;
    }

    Time getTimeValue(boolean getColumn, int index, Calendar cal) throws SQLException {
        DATE value;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OracleStatement.getTimeValue(getColumn=" + getColumn + ", index=" + index + ", Calendar)"));
        }
        return (value = this.getDATEValue(getColumn, index)) == null ? null : value.timeValue(cal);
    }

    Timestamp getTimestampValue(boolean getColumn, int index) throws SQLException {
        DBDataSet dbset;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OracleStatement.getTimestampValue(getColumn=" + getColumn + ", index=" + index + ")"));
        }
        int col_index = index - 1;
        if (getColumn) {
            dbset = this.defines;
            int row_index = this.current_row;
        } else {
            dbset = this.binds_out;
            int row_index = this.m_currentRank;
        }
        this.prepare_for_new_get(getColumn, index);
        byte[] result = this.getBytesInternal(getColumn, index);
        if (result == null || result.length == 0) {
            return null;
        }
        int type = dbset.getType(col_index);
        switch (type) {
            case 1: 
            case 8: 
            case 96: {
                String str = ((OracleConnection)this.connection).conversion.CharBytesToString(result, result.length);
                return Timestamp.valueOf(str);
            }
            case 12: {
                return ((OracleConnection)this.connection).conversion.DateBytesToTimestamp(result, result.length);
            }
            case 180: {
                return TIMESTAMP.toTimestamp(result);
            }
            case 181: {
                return TIMESTAMPTZ.toTimestamp(this.connection, result);
            }
            case 231: {
                return TIMESTAMPLTZ.toTimestamp(this.connection, result);
            }
        }
        DBError.throwSqlException((int)4);
        return null;
    }

    Timestamp getTimestampValue(boolean getColumn, int index, Calendar cal) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OracleStatement.getTimestampValue(getColumn=" + getColumn + ", index=" + index + ", calendar)"));
        }
        Timestamp result = null;
        Timestamp value = this.getTimestampValue(getColumn, index);
        if (cal == null) {
            result = value;
        } else if (value != null) {
            cal.set(1, value.getYear() + 1900);
            cal.set(2, value.getMonth());
            cal.set(5, value.getDate());
            cal.set(11, value.getHours());
            cal.set(12, value.getMinutes());
            cal.set(13, value.getSeconds());
            cal.set(14, 0);
            result = new Timestamp(cal.getTime().getTime());
            result.setNanos(value.getNanos());
        }
        return result;
    }

    protected byte[] getColumnBytes(boolean getColumn, int colNum) throws SQLException {
        byte[] result = null;
        this.prepare_for_new_get(getColumn, colNum);
        result = this.getBytesInternal(getColumn, colNum);
        if (result == null || result.length == 0) {
            result = null;
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)64, (String)OracleLog.bytesToPrintableForm("Column", result));
        }
        return result;
    }

    protected int getColumnDBType(boolean getColumn, int colNum) throws SQLException {
        int col_index = colNum - 1;
        int type = 0;
        type = getColumn ? this.defines.getType(col_index) : this.binds_out.getType(col_index);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OracleStatement.getColumnDBType(getColumn=" + getColumn + ", colNum=" + colNum + ") returned " + type));
        }
        return type;
    }

    INTERVALYM getINTERVALYMValue(boolean getColumn, int colNum) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OracleStatement.getINTERVALYMValue(getColumn=" + getColumn + ", colNum=" + colNum + ")"));
        }
        byte[] bytes = this.getColumnBytes(getColumn, colNum);
        int type = this.getColumnDBType(getColumn, colNum);
        INTERVALYM ym = null;
        if (type == 182) {
            ym = new INTERVALYM(bytes);
        } else {
            DBError.throwSqlException((int)4, (Object)("type number " + type));
        }
        return ym;
    }

    TIMESTAMP getTIMESTAMPValue(boolean getColumn, int colNum) throws SQLException {
        DBDataSet dbset;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OracleStatement.getTIMESTAMPValue(getColumn=" + getColumn + ", colNum=" + colNum + ")"));
        }
        TIMESTAMP ts = null;
        int col_index = colNum - 1;
        if (getColumn) {
            dbset = this.defines;
            int row_index = this.current_row;
        } else {
            dbset = this.binds_out;
            int row_index = this.m_currentRank;
        }
        this.prepare_for_new_get(getColumn, colNum);
        byte[] bytes = this.getBytesInternal(getColumn, colNum);
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        int type = dbset.getType(col_index);
        switch (type) {
            case 180: {
                ts = new TIMESTAMP(bytes);
                break;
            }
            default: {
                DBError.throwSqlException((int)4, (Object)("type number " + type));
            }
        }
        return ts;
    }

    TIMESTAMPTZ getTIMESTAMPTZValue(boolean getColumn, int colNum) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OracleStatement.getTIMESTAMPTZValue(getColumn=" + getColumn + ", colNum=" + colNum + ")"));
        }
        byte[] bytes = this.getColumnBytes(getColumn, colNum);
        int type = this.getColumnDBType(getColumn, colNum);
        TIMESTAMPTZ tstz = null;
        switch (type) {
            case 181: {
                tstz = new TIMESTAMPTZ(bytes);
                break;
            }
            default: {
                DBError.throwSqlException((int)4, (Object)("type number " + type));
            }
        }
        return tstz;
    }

    TIMESTAMPLTZ getTIMESTAMPLTZValue(boolean getColumn, int colNum) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OracleStatement.getTIMESTAMPLTZValue(getColumn=" + getColumn + ", colNum=" + colNum + ")"));
        }
        byte[] bytes = this.getColumnBytes(getColumn, colNum);
        int type = this.getColumnDBType(getColumn, colNum);
        TIMESTAMPLTZ tsltz = null;
        switch (type) {
            case 231: {
                tsltz = new TIMESTAMPLTZ(bytes);
                break;
            }
            default: {
                DBError.throwSqlException((int)4, (Object)("type number " + type));
            }
        }
        return tsltz;
    }

    OracleInputStream getStreamInternal(boolean getColumn, int index) throws SQLException {
        int row_index;
        DBDataSet dbset;
        --index;
        Object result = null;
        if (getColumn) {
            dbset = this.defines;
            row_index = this.current_row;
        } else {
            dbset = this.binds_out;
            row_index = this.m_currentRank;
        }
        return (OracleInputStream)dbset.getStreamItem(index, row_index);
    }

    InputStream getAsciiStreamValue(boolean getColumn, int index) throws SQLException {
        int row_index;
        DBDataSet dbset;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OracleStatement.getAsciiStreamValue(getColumn=" + getColumn + ", index=" + index + ")"));
        }
        int col_index = index - 1;
        if (getColumn) {
            dbset = this.defines;
            row_index = this.current_row;
        } else {
            dbset = this.binds_out;
            row_index = this.m_currentRank;
        }
        this.prepare_for_new_get(getColumn, index);
        if (dbset.isNull(col_index, row_index)) {
            return null;
        }
        int dbtype = dbset.getType(col_index);
        DBConversion dbconv = ((OracleConnection)this.connection).conversion;
        switch (dbtype) {
            case 23: 
            case 24: {
                if (dbset.isStreamType(col_index)) {
                    OracleInputStream istream = (OracleInputStream)dbset.getStreamItem(col_index, row_index);
                    if (istream == null) {
                        return null;
                    }
                    return dbconv.ConvertStream((InputStream)istream, 2);
                }
                byte[] result = dbset.getBytesItem(col_index, row_index);
                return dbconv.ConvertStream((InputStream)new ByteArrayInputStream(result), 2);
            }
            case 1: 
            case 8: {
                if (dbset.isStreamType(col_index)) {
                    OracleInputStream istream = (OracleInputStream)dbset.getStreamItem(col_index, row_index);
                    if (istream == null) {
                        return null;
                    }
                    return dbconv.ConvertStream((InputStream)istream, 0);
                }
                byte[] result = dbset.getBytesItem(col_index, row_index);
                return dbconv.ConvertStream((InputStream)new ByteArrayInputStream(result), 0);
            }
            case 96: {
                int actual_size;
                if (dbset.isStreamType(col_index)) {
                    OracleInputStream istream = (OracleInputStream)dbset.getStreamItem(col_index, row_index);
                    if (istream == null) {
                        return null;
                    }
                    return dbconv.ConvertStream((InputStream)istream, 0);
                }
                byte[] result = dbset.getBytesItem(index - 1, row_index);
                char[] java_chars = new char[result.length];
                int chars_read = dbconv.CHARBytesToJavaChars(result, result.length, java_chars);
                if (getColumn && this.connection.db_access.getNlsRatio() > 1 && chars_read > 0 && this.dbdescription != null && this.dbdescription.length >= index && (actual_size = this.dbdescription[index - 1].max_length) > 0 && chars_read > actual_size) {
                    chars_read = actual_size;
                }
                int count = DBConversion.javaCharsToAsciiBytes((char[])java_chars, (int)chars_read, (byte[])result);
                return new ByteArrayInputStream(result, 0, count);
            }
            case 113: {
                BLOB datum = this.get_blob_value(dbset, col_index, row_index);
                return ((Datum)datum).asciiStreamValue();
            }
            case 112: {
                CLOB datum = this.get_clob_value(dbset, col_index, row_index);
                return ((Datum)datum).asciiStreamValue();
            }
        }
        DBError.throwSqlException((int)4);
        return null;
    }

    InputStream getUnicodeStreamValue(boolean getColumn, int index) throws SQLException {
        int row_index;
        DBDataSet dbset;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OracleStatement.getUnicodeStreamValue(getColumn=" + getColumn + ", index=" + index + ")"));
        }
        int col_index = index - 1;
        if (getColumn) {
            dbset = this.defines;
            row_index = this.current_row;
        } else {
            dbset = this.binds_out;
            row_index = this.m_currentRank;
        }
        this.prepare_for_new_get(getColumn, index);
        if (dbset.isNull(col_index, row_index)) {
            return null;
        }
        int dbtype = dbset.getType(col_index);
        DBConversion dbconv = ((OracleConnection)this.connection).conversion;
        switch (dbtype) {
            case 23: 
            case 24: {
                if (dbset.isStreamType(col_index)) {
                    OracleInputStream istream = (OracleInputStream)dbset.getStreamItem(col_index, row_index);
                    if (istream == null) {
                        return null;
                    }
                    return dbconv.ConvertStream((InputStream)istream, 3);
                }
                byte[] result = dbset.getBytesItem(col_index, row_index);
                return dbconv.ConvertStream((InputStream)new ByteArrayInputStream(result), 3);
            }
            case 1: 
            case 8: {
                if (dbset.isStreamType(col_index)) {
                    OracleInputStream istream = (OracleInputStream)dbset.getStreamItem(col_index, row_index);
                    if (istream == null) {
                        return null;
                    }
                    return dbconv.ConvertStream((InputStream)istream, 1);
                }
                byte[] result = dbset.getBytesItem(col_index, row_index);
                return dbconv.ConvertStream((InputStream)new ByteArrayInputStream(result), 1);
            }
            case 96: {
                int actual_size;
                if (dbset.isStreamType(col_index)) {
                    OracleInputStream istream = this.getStreamInternal(getColumn, index);
                    if (istream == null) {
                        return null;
                    }
                    return dbconv.ConvertStream((InputStream)istream, 1);
                }
                byte[] result = dbset.getBytesItem(col_index, row_index);
                char[] java_chars = new char[result.length];
                int chars_read = dbconv.CHARBytesToJavaChars(result, result.length, java_chars);
                if (getColumn && this.connection.db_access.getNlsRatio() > 1 && chars_read > 0 && this.dbdescription != null && this.dbdescription.length >= index && (actual_size = this.dbdescription[index - 1].max_length) > 0 && chars_read > actual_size) {
                    chars_read = actual_size;
                }
                byte[] buf = new byte[chars_read * 2];
                int count = DBConversion.javaCharsToUcs2Bytes((char[])java_chars, (int)chars_read, (byte[])buf);
                return new ByteArrayInputStream(buf, 0, count);
            }
        }
        DBError.throwSqlException((int)4);
        return null;
    }

    InputStream getBinaryStreamValue(boolean getColumn, int index) throws SQLException {
        int row_index;
        DBDataSet dbset;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OracleStatement.getBinaryStreamValue(getColumn=" + getColumn + ", index=" + index + ")"));
        }
        int col_index = index - 1;
        if (getColumn) {
            dbset = this.defines;
            row_index = this.current_row;
        } else {
            dbset = this.binds_out;
            row_index = this.m_currentRank;
        }
        this.prepare_for_new_get(getColumn, index);
        if (dbset.isNull(col_index, row_index)) {
            return null;
        }
        int dbtype = dbset.getType(col_index);
        switch (dbtype) {
            case 1: 
            case 8: 
            case 23: 
            case 24: {
                if (dbset.isStreamType(col_index)) {
                    OracleInputStream istream = (OracleInputStream)dbset.getStreamItem(col_index, row_index);
                    if (istream == null) {
                        return null;
                    }
                    return istream;
                }
                byte[] result = dbset.getBytesItem(col_index, row_index);
                return new ByteArrayInputStream(result);
            }
            case 96: {
                if (dbset.isStreamType(col_index)) {
                    OracleInputStream istream = (OracleInputStream)dbset.getStreamItem(col_index, row_index);
                    if (istream.isClosed()) {
                        DBError.throwSqlException((int)27);
                    }
                    if (istream == null) {
                        return null;
                    }
                    return istream;
                }
                byte[] result = dbset.getBytesItem(col_index, row_index);
                if (getColumn && this.connection.db_access.getNlsRatio() > 1 && result != null && this.dbdescription != null && this.dbdescription.length >= index) {
                    char[] java_chars = new char[result.length];
                    DBConversion dbconv = ((OracleConnection)this.connection).conversion;
                    int chars_read = dbconv.CHARBytesToJavaChars(result, result.length, java_chars);
                    int actual_size = this.dbdescription[index - 1].max_length;
                    if (actual_size > 0 && chars_read > actual_size) {
                        chars_read = actual_size;
                    }
                    int count = dbconv.javaCharsToCHARBytes(java_chars, chars_read, result);
                    return new ByteArrayInputStream(result, 0, count);
                }
                return new ByteArrayInputStream(result);
            }
            case 113: {
                BLOB datum = this.get_blob_value(dbset, col_index, row_index);
                return ((Datum)datum).binaryStreamValue();
            }
            case 112: {
                CLOB datum = this.get_clob_value(dbset, col_index, row_index);
                return ((Datum)datum).binaryStreamValue();
            }
        }
        DBError.throwSqlException((int)4);
        return null;
    }

    Reader getCharacterStreamValue(boolean getColumn, int index) throws SQLException {
        int row_index;
        DBDataSet dbset;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OracleStatement.getCharacterStreamValue(getColumn=" + getColumn + ", index=" + index + ")"));
        }
        int col_index = index - 1;
        if (getColumn) {
            dbset = this.defines;
            row_index = this.current_row;
        } else {
            dbset = this.binds_out;
            row_index = this.m_currentRank;
        }
        this.prepare_for_new_get(getColumn, index);
        if (dbset.isNull(col_index, row_index)) {
            return null;
        }
        int dbtype = dbset.getType(col_index);
        DBConversion dbconv = ((OracleConnection)this.connection).conversion;
        switch (dbtype) {
            case 23: 
            case 24: {
                if (dbset.isStreamType(col_index)) {
                    OracleInputStream istream = (OracleInputStream)dbset.getStreamItem(col_index, row_index);
                    if (istream == null) {
                        return null;
                    }
                    return dbconv.ConvertCharacterStream((InputStream)istream, 8);
                }
                byte[] result = dbset.getBytesItem(col_index, row_index);
                char[] charBuf = new char[result.length * 2];
                int chars_read = DBConversion.RAWBytesToHexChars((byte[])result, (int)result.length, (char[])charBuf);
                return new CharArrayReader(charBuf, 0, chars_read);
            }
            case 1: 
            case 8: {
                short form = this.getDBTypeForm(col_index);
                if (dbset.isStreamType(col_index)) {
                    OracleInputStream istream = (OracleInputStream)dbset.getStreamItem(col_index, row_index);
                    if (istream == null) {
                        return null;
                    }
                    return dbconv.ConvertCharacterStream((InputStream)istream, 9, form);
                }
                byte[] result = dbset.getBytesItem(col_index, row_index);
                String str = null;
                str = form == 2 ? dbconv.NCharBytesToString(result, result.length) : dbconv.CharBytesToString(result, result.length);
                return new StringReader(str);
            }
            case 96: {
                int actual_size;
                if (dbset.isStreamType(col_index)) {
                    OracleInputStream istream = (OracleInputStream)dbset.getStreamItem(col_index, row_index);
                    if (istream == null) {
                        return null;
                    }
                    return dbconv.ConvertCharacterStream((InputStream)istream, 9);
                }
                byte[] result = dbset.getBytesItem(col_index, row_index);
                String str = dbconv.CharBytesToString(result, result.length);
                if (getColumn && this.connection.db_access.getNlsRatio() > 1 && this.dbdescription != null && this.dbdescription.length >= index && str != null && (actual_size = this.dbdescription[index - 1].max_length) > 0 && str.length() > actual_size) {
                    str = str.substring(0, actual_size);
                }
                return new StringReader(str);
            }
            case 113: {
                BLOB datum = this.get_blob_value(dbset, col_index, row_index);
                return ((Datum)datum).characterStreamValue();
            }
            case 112: {
                CLOB datum = this.get_clob_value(dbset, col_index, row_index);
                return ((Datum)datum).characterStreamValue();
            }
        }
        DBError.throwSqlException((int)4);
        return null;
    }

    Object getObjectValue(boolean getColumn, int index) throws SQLException {
        return this.getObjectValue(getColumn, index, ((OracleConnectionWrapper)this.connection).getTypeMap());
    }

    Object getObjectValue(boolean getColumn, int index, Map map) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OracleStatement.getObjectValue(getColumn=" + getColumn + ", index=" + index + ", map)"));
        }
        this.prepare_for_new_get(getColumn, index);
        int external_type = this.get_value_external_type(getColumn, index);
        if (external_type == 0) {
            int column_type = this.get_value_type(getColumn, index);
            switch (column_type) {
                case 1: 
                case 8: 
                case 96: {
                    return this.getStringValue(getColumn, index);
                }
                case 2: 
                case 6: {
                    if (this.connection.m_j2ee13Compliant && this.dbdescription[index - 1].precision != 0 && this.dbdescription[index - 1].scale == -127) {
                        return this.wasNullValue() ? null : new Double(this.getDoubleValue(getColumn, index));
                    }
                    return this.getBigDecimalValue(getColumn, index, this.get_value_scale(getColumn, index));
                }
                case 23: 
                case 24: {
                    return this.getBytesValue(getColumn, index);
                }
                case 12: {
                    if (this.connection.m_j2ee13Compliant) {
                        return this.getDateValue(getColumn, index);
                    }
                    return this.getTimestampValue(getColumn, index);
                }
                case 180: {
                    if (this.connection.m_j2ee13Compliant) {
                        return this.getTimestampValue(getColumn, index);
                    }
                    return this.getTIMESTAMPValue(getColumn, index);
                }
                case 181: {
                    return this.getTIMESTAMPTZValue(getColumn, index);
                }
                case 231: {
                    return this.getTIMESTAMPLTZValue(getColumn, index);
                }
                case 182: {
                    return this.getINTERVALYMValue(getColumn, index);
                }
                case 104: {
                    return this.getROWIDValue(getColumn, index);
                }
                case 113: {
                    return this.getBLOBValue(getColumn, index);
                }
                case 112: {
                    return this.getCLOBValue(getColumn, index);
                }
                case 114: {
                    return this.getBFILEValue(getColumn, index);
                }
                case 102: {
                    return this.getCursorValue(getColumn, index);
                }
                case 109: {
                    Datum named_obj = this.getNamedTypeValue(getColumn, index);
                    if (named_obj == null) {
                        return null;
                    }
                    if (named_obj instanceof STRUCT) {
                        return ((STRUCT)named_obj).toJdbc(map);
                    }
                    if (named_obj instanceof OPAQUE) {
                        return ((OPAQUE)named_obj).toJdbc(map);
                    }
                    return named_obj.toJdbc();
                }
                case 111: {
                    return this.getREFValue(getColumn, index);
                }
            }
            DBError.throwSqlException((int)4);
            return null;
        }
        if (this.wasNullValue()) {
            return null;
        }
        switch (external_type) {
            case -7: {
                return new Boolean(this.getBooleanValue(getColumn, index));
            }
            case -6: {
                return new Byte(this.getByteValue(getColumn, index));
            }
            case 5: {
                return new Short(this.getShortValue(getColumn, index));
            }
            case 4: {
                return new Integer(this.getIntValue(getColumn, index));
            }
            case -5: {
                return new Long(this.getLongValue(getColumn, index));
            }
            case 6: 
            case 8: {
                return new Double(this.getDoubleValue(getColumn, index));
            }
            case 7: {
                return new Float(this.getFloatValue(getColumn, index));
            }
            case 2: 
            case 3: {
                int scale = this.get_value_scale(getColumn, index);
                return this.getBigDecimalValue(getColumn, index, scale);
            }
            case -1: 
            case 1: 
            case 12: {
                return this.getStringValue(getColumn, index);
            }
            case 91: {
                return this.getDateValue(getColumn, index);
            }
            case 92: {
                return this.getTimeValue(getColumn, index);
            }
            case 93: {
                return this.getTimestampValue(getColumn, index);
            }
            case -100: {
                return this.getTIMESTAMPValue(getColumn, index);
            }
            case -101: {
                return this.getTIMESTAMPTZValue(getColumn, index);
            }
            case -102: {
                return this.getTIMESTAMPLTZValue(getColumn, index);
            }
            case -4: 
            case -3: 
            case -2: {
                return this.getBytesValue(getColumn, index);
            }
            case -8: {
                return this.getROWIDValue(getColumn, index);
            }
            case -10: {
                return this.getCursorValue(getColumn, index);
            }
            case 2004: {
                return this.getBLOBValue(getColumn, index);
            }
            case 2005: {
                return this.getCLOBValue(getColumn, index);
            }
            case -13: {
                return this.getBFILEValue(getColumn, index);
            }
            case 2008: {
                map = null;
            }
            case 2000: 
            case 2002: 
            case 2003: 
            case 2007: {
                Datum named_obj = this.getNamedTypeValue(getColumn, index);
                if (named_obj instanceof STRUCT) {
                    return ((STRUCT)named_obj).toJdbc(map);
                }
                return named_obj.toJdbc();
            }
            case 2006: {
                return this.getREFValue(getColumn, index);
            }
        }
        DBError.throwSqlException((int)4);
        return null;
    }

    Datum getOracleObjectValue(boolean getColumn, int index) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OracleStatement.getOracleObjectValue(getColumn=" + getColumn + ", index=" + index + ")"));
        }
        this.prepare_for_new_get(getColumn, index);
        int column_type = this.get_value_type(getColumn, index);
        switch (column_type) {
            case 1: 
            case 8: 
            case 96: {
                return this.getCHARValue(getColumn, index);
            }
            case 2: 
            case 6: {
                return this.getNUMBERValue(getColumn, index);
            }
            case 23: 
            case 24: {
                return this.getRAWValue(getColumn, index);
            }
            case 12: {
                return this.getDATEValue(getColumn, index);
            }
            case 180: {
                return this.getTIMESTAMPValue(getColumn, index);
            }
            case 181: {
                return this.getTIMESTAMPTZValue(getColumn, index);
            }
            case 231: {
                return this.getTIMESTAMPLTZValue(getColumn, index);
            }
            case 182: {
                return this.getINTERVALYMValue(getColumn, index);
            }
            case 104: {
                return this.getROWIDValue(getColumn, index);
            }
            case 113: {
                return this.getBLOBValue(getColumn, index);
            }
            case 112: {
                return this.getCLOBValue(getColumn, index);
            }
            case 114: {
                return this.getBFILEValue(getColumn, index);
            }
            case 109: {
                return this.getNamedTypeValue(getColumn, index);
            }
            case 111: {
                return this.getREFValue(getColumn, index);
            }
        }
        DBError.throwSqlException((int)4);
        return null;
    }

    CustomDatum getCustomDatumValue(boolean getColumn, int index, CustomDatumFactory factory) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OracleStatement.getCustomDatumValue(getColumn=" + getColumn + ", index=" + index + ", factory)"));
        }
        Datum d2 = this.getOracleObjectValue(getColumn, index);
        return factory.create(d2, 0);
    }

    ORAData getORADataValue(boolean getColumn, int index, ORADataFactory factory) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OracleStatement.getORADataValue(getColumn=" + getColumn + ", index=" + index + ", factory)"));
        }
        Datum d2 = this.getOracleObjectValue(getColumn, index);
        return factory.create(d2, 0);
    }

    int get_column_index(String columnName) throws SQLException {
        if (this.dbdescription == null) {
            this.describe();
        }
        int column_num = this.dbdescription.length;
        int index = 0;
        while (index < column_num) {
            if (this.dbdescription[index].getColumnName().equalsIgnoreCase(columnName)) {
                return index + 1;
            }
            ++index;
        }
        DBError.throwSqlException((int)6);
        return 0;
    }

    int get_value_type(boolean getColumn, int index) {
        if (getColumn) {
            return this.defines.getType(index - 1);
        }
        return this.binds_out.getType(index - 1);
    }

    int get_value_external_type(boolean getColumn, int index) {
        if (getColumn) {
            return this.defines.getExternalType(index - 1);
        }
        return this.binds_out.getExternalType(index - 1);
    }

    int get_value_scale(boolean getColumn, int index) {
        return 0;
    }

    private BLOB get_blob_value(DBDataSet dbset, int colIndex, int rowIndex) throws SQLException {
        byte[] lob_descriptor = dbset.getBytesItem(colIndex, rowIndex);
        if (lob_descriptor == null) {
            return null;
        }
        return new BLOB(this.connection, lob_descriptor);
    }

    private CLOB get_clob_value(DBDataSet dbset, int colIndex, int rowIndex) throws SQLException {
        byte[] lob_descriptor = dbset.getBytesItem(colIndex, rowIndex);
        short form = this.getDBTypeForm(colIndex);
        if (lob_descriptor == null) {
            return null;
        }
        return new CLOB((oracle.jdbc.OracleConnection)this.connection, lob_descriptor, form);
    }

    private BFILE get_bfile_value(DBDataSet dbset, int colIndex, int rowIndex) throws SQLException {
        byte[] file_descriptor = dbset.getBytesItem(colIndex, rowIndex);
        if (file_descriptor == null) {
            return null;
        }
        return new BFILE(this.connection, file_descriptor);
    }

    public boolean is_value_null(boolean getColumn, int index) throws SQLException {
        if (getColumn) {
            return this.defines.isNull(index - 1, this.current_row);
        }
        return this.binds_out.isNull(index - 1, this.m_currentRank);
    }

    int get_internal_type(int external_type) throws SQLException {
        switch (external_type) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return 6;
            }
            case 999: {
                return 999;
            }
            case 1: {
                return 96;
            }
            case 12: {
                return 1;
            }
            case -1: {
                return 8;
            }
            case 91: 
            case 92: {
                return 12;
            }
            case -100: 
            case 93: {
                return 180;
            }
            case -101: {
                return 181;
            }
            case -102: {
                return 231;
            }
            case -103: {
                return 182;
            }
            case -104: {
                return 183;
            }
            case -3: 
            case -2: {
                return 23;
            }
            case -4: {
                return 24;
            }
            case -8: {
                return 104;
            }
            case 2004: {
                return 113;
            }
            case 2005: {
                return 112;
            }
            case -13: {
                return 114;
            }
            case -10: {
                return 102;
            }
            case 2002: 
            case 2003: 
            case 2007: 
            case 2008: {
                return 109;
            }
            case 2006: {
                return 111;
            }
            case -14: {
                return 998;
            }
        }
        DBError.throwSqlException((int)4);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void describe() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleStatement oracleStatement = this;
            synchronized (oracleStatement) {
                if (this.dbdescription == null) {
                    try {
                        this.connection.needLine();
                        this.dbdescription = this.connection.db_access.describe(this.dbstmt);
                    }
                    catch (IOException e2) {
                        DBError.throwSqlException((IOException)e2);
                    }
                }
            }
        }
    }

    void freeLine() throws SQLException {
        if (this.streams != null) {
            try {
                this.streams.close();
            }
            catch (IOException e2) {
                DBError.throwSqlException((IOException)e2);
            }
        }
    }

    private synchronized void initializeColumnsToFetch(DBDataSet _dataSet) {
        this.m_lastFetchedColumn = 0;
        this.m_currentDataSet = _dataSet;
    }

    synchronized void fetchedFirstColumns() {
        int nextStreamColumn = this.getNextStreamColumn(1);
        this.m_lastFetchedColumn = nextStreamColumn > 0 ? nextStreamColumn - 1 : (nextStreamColumn == 0 ? this.m_currentDataSet.getNoOfArgs() : 0);
    }

    private synchronized int[] getNextFetchColumnRange() {
        int[] range;
        ++this.m_lastFetchedColumn;
        if (this.m_currentDataSet == null) {
            return null;
        }
        int numColumns = this.m_currentDataSet.getNoOfArgs();
        if (numColumns == 0) {
            return null;
        }
        if (this.m_lastFetchedColumn >= numColumns) {
            return null;
        }
        if (this.m_currentDataSet.isStreamType(this.m_lastFetchedColumn)) {
            return null;
        }
        int nextStreamColumn = this.getNextStreamColumn(range[0]);
        range = new int[]{this.m_lastFetchedColumn + 1, nextStreamColumn > 0 ? nextStreamColumn - 1 : numColumns};
        this.m_lastFetchedColumn = range[1];
        return range;
    }

    private int getNextStreamColumn(int _startColumn) {
        int numColumns;
        int nextStreamColumn = -1;
        if (this.m_currentDataSet != null && (numColumns = this.m_currentDataSet.getNoOfArgs()) > 0) {
            int i2 = _startColumn - 1;
            if (i2 < 0) {
                i2 = 0;
            }
            boolean done = false;
            while (!done && i2 < numColumns) {
                if (this.m_currentDataSet.isStreamType(i2)) {
                    nextStreamColumn = i2 + 1;
                    done = true;
                }
                ++i2;
            }
            if (!done) {
                nextStreamColumn = 0;
            }
        }
        return nextStreamColumn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void fetchNextColumns() throws SQLException, IOException {
        int[] range = this.getNextFetchColumnRange();
        if (range != null) {
            DBAccess db = this.connection.db_access;
            try {
                this.m_isExecuting = true;
                int n2 = db.fetch(this.dbstmt, this.m_currentDataSet, range[0], range[1]);
                Object var5_4 = null;
                this.m_isExecuting = false;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.m_isExecuting = false;
                throw throwable;
            }
        }
    }

    final void ensureOpen() throws SQLException {
        if (this.closed) {
            DBError.throwSqlException((int)9);
        }
    }

    final int parseSqlKind() throws SQLException {
        String oracle_sql = this.expandSqlEscapes(this.sql_query);
        this.parameterCount = this.connection.m_osql.parameterCount;
        if (this.sql_kind == -1) {
            this.sql_kind = this.getSqlKind(oracle_sql);
        }
        this.array_sql = this.strToDbaccessBytes(oracle_sql);
        this.sql_string_changed = false;
        return this.sql_kind;
    }

    final String expandSqlEscapes(String sqlStr) throws SQLException {
        return this.process_escapes ? ((OracleConnectionWrapper)this.connection).nativeSQL(sqlStr) : sqlStr;
    }

    final byte[] strToDbaccessBytes(String str) throws SQLException {
        return ((OracleConnection)this.connection).conversion.StringToCharBytes(str);
    }

    public synchronized void setFetchDirection(int direction) throws SQLException {
        if (direction == 1000) {
            this.default_fetch_direction = direction;
        } else if (direction == 1001 || direction == 1002) {
            this.default_fetch_direction = 1000;
            this.m_warning = DBError.addSqlWarning((SQLWarning)this.m_warning, (int)87);
        } else {
            DBError.throwSqlException((int)68, (Object)"setFetchDirection");
        }
    }

    public int getFetchDirection() throws SQLException {
        return this.default_fetch_direction;
    }

    public synchronized void setFetchSize(int rows) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)("OracleStatement.setFetchSize(rows=" + rows + ")"));
        }
        this.setPrefetchInternal(rows, false, true);
    }

    public int getFetchSize() throws SQLException {
        return this.getPrefetchInternal(true);
    }

    public int getResultSetConcurrency() throws SQLException {
        return ResultSetUtil.getUpdateConcurrency(this.m_userRsetType);
    }

    public int getResultSetType() throws SQLException {
        return ResultSetUtil.getScrollType(this.m_userRsetType);
    }

    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    public synchronized void setResultSetCache(oracle.jdbc.OracleResultSetCache cache) throws SQLException {
        try {
            if (cache == null) {
                DBError.throwSqlException((int)68);
            }
            if (this.m_cache != null) {
                this.m_cache.close();
            }
            this.m_cache = cache;
        }
        catch (IOException e2) {
            DBError.throwSqlException((IOException)e2);
        }
    }

    public synchronized void setResultSetCache(OracleResultSetCache cache) throws SQLException {
        this.setResultSetCache((oracle.jdbc.OracleResultSetCache)cache);
    }

    public synchronized OracleResultSetCache getResultSetCache() throws SQLException {
        return (OracleResultSetCache)this.m_cache;
    }

    private void initBatch() {
    }

    private int getBatchSize() {
        return this.m_batchItems.size();
    }

    private void addBatchItem(String sql) {
        this.m_batchItems.addElement(sql);
    }

    private String getBatchItem(int index) {
        return (String)this.m_batchItems.elementAt(index);
    }

    private void clearBatchItems() {
        this.m_batchItems.removeAllElements();
    }

    private void checkIfJdbcBatchExists() throws SQLException {
        if (this.getBatchSize() > 0) {
            DBError.throwSqlException((int)81, (Object)"batch must be either executed or cleared");
        }
    }

    public synchronized void addBatch(String sql) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)"OracleStatement.addBatch(sql)");
            OracleLog.print((Object)this, (int)1, (int)16, (int)128, (String)("SQL: \"" + sql + "\""));
        }
        this.addBatchItem(sql);
    }

    public synchronized void clearBatch() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)"OracleStatement.clearBatch()");
        }
        this.clearBatchItems();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int[] executeBatch() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleStatement oracleStatement = this;
            synchronized (oracleStatement) {
                int i2 = 0;
                int n_batches = this.getBatchSize();
                if (OracleLog.TRACE) {
                    OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)("OracleStatement.executeBatch(): batch size is " + n_batches));
                }
                if (n_batches <= 0) {
                    return new int[0];
                }
                int[] ret_array = new int[n_batches];
                String sql_str = null;
                String expanded_sql = null;
                byte[] sql_bytes = null;
                byte stmt_type = 0;
                this.ensureOpen();
                this.prepare_for_new_result(true);
                this.noMoreUpdateCounts = false;
                try {
                    try {
                        this.connection.needLine();
                        i2 = 0;
                        while (i2 < n_batches) {
                            sql_str = this.getBatchItem(i2);
                            expanded_sql = this.expandSqlEscapes(sql_str);
                            sql_bytes = this.strToDbaccessBytes(expanded_sql);
                            stmt_type = this.getSqlKind(expanded_sql);
                            if (OracleLog.TRACE) {
                                OracleLog.print((Object)this, (int)1, (int)16, (int)32, (String)("batch item " + i2 + ": stmt_type=" + stmt_type));
                                OracleLog.print((Object)this, (int)1, (int)16, (int)32, (String)("expanded SQL: " + expanded_sql));
                            }
                            if (stmt_type == 0) {
                                DBError.throwBatchUpdateException((int)80, (Object)("invalid SELECT batch command " + i2), (int)i2, (int[])ret_array);
                            }
                            this.open();
                            ret_array[i2] = this.parseExecuteFetchWithTimeout(this.dbstmt, stmt_type, sql_bytes, null, 1, null, 1);
                            if (ret_array[i2] < 0) {
                                DBError.throwBatchUpdateException((int)81, (Object)("command return value " + ret_array[i2]), (int)i2, (int[])ret_array);
                            }
                            ++i2;
                        }
                    }
                    catch (IOException e2) {
                        DBError.throwBatchUpdateException((int)81, (Object)e2.getMessage(), (int)i2, (int[])ret_array);
                        Object var13_12 = null;
                        this.clearBatchItems();
                        return ret_array;
                    }
                    catch (SQLException e1) {
                        this.isCachable = false;
                        this.need_to_parse = true;
                        if (e1 instanceof BatchUpdateException) {
                            throw e1;
                        }
                        DBError.throwBatchUpdateException((int)81, (Object)e1.getMessage(), (int)i2, (int[])ret_array);
                        Object var13_13 = null;
                        this.clearBatchItems();
                        return ret_array;
                    }
                    Object var13_11 = null;
                    this.clearBatchItems();
                    return ret_array;
                }
                catch (Throwable throwable) {
                    Object var13_14 = null;
                    this.clearBatchItems();
                    throw throwable;
                }
            }
        }
    }

    public DBDataSet getBinds() {
        return null;
    }

    public void notify_close_rset() throws SQLException {
        this.m_scrollRset = null;
        this.end_of_result_set();
    }

    public String getRevisedSql() throws SQLException {
        return ResultSetUtil.removeForUpdate((String)this.m_revisedSql);
    }

    public String getOriginalSql() throws SQLException {
        return this.m_originalSql;
    }

    boolean isRegularResultSet() throws SQLException {
        return this.m_userRsetType == DEFAULT_RSET_TYPE;
    }

    void scrollStmt_cleanup(boolean cleanSql) throws SQLException {
        if (cleanSql) {
            this.m_originalSql = null;
            this.m_revisedSql = null;
        }
        if (this.m_scrollRset != null) {
            this.m_scrollRset.close();
            this.m_scrollRset = null;
        }
    }

    private OracleResultSet doScrollStmtExecuteQuery(String sql) throws SQLException {
        this.scrollStmt_cleanup(true);
        this.parseSqlKind();
        if (this.sql_kind != 0) {
            this.doExecuteWithTimeout();
            return null;
        }
        this.m_originalSql = sql;
        boolean success = true;
        String _errMsg = null;
        if (!this.m_needToAddIdentifier) {
            this.doExecuteWithTimeout();
            this.current_result_set = new OracleResultSetImpl((OracleConnection)this.connection, this);
            this.m_realRsetType = this.m_userRsetType;
        } else {
            block13: {
                try {
                    this.m_revisedSql = ResultSetUtil.addIdentifierToSql((String)sql);
                    this.need_to_parse = true;
                    this.sql_string_changed = true;
                    this.sql_query = this.m_revisedSql;
                    this.sql_kind = (byte)-1;
                    this.prepare_for_new_result(true);
                    if (this.columns_defined_by_user) {
                        this.adjustUserDefines(1);
                    }
                    if (OracleLog.TRACE) {
                        OracleLog.print((Object)this, (int)1, (int)16, (int)32, (String)this.m_revisedSql);
                    }
                    this.doExecuteWithTimeout();
                    this.current_result_set = new OracleResultSetImpl((OracleConnection)this.connection, this);
                }
                catch (SQLException e2) {
                    success = false;
                    _errMsg = e2.getMessage();
                    if (!OracleLog.TRACE) break block13;
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    e2.printStackTrace(pw);
                    OracleLog.print((Object)this, (int)1, (int)16, (int)64, (String)sw.toString());
                }
            }
            if (success) {
                this.m_realRsetType = this.m_userRsetType;
            } else {
                this.m_realRsetType = this.m_userRsetType > 3 ? 3 : 1;
                if (OracleLog.TRACE) {
                    OracleLog.print((Object)this, (int)1, (int)16, (int)32, (String)("Trying type " + this.m_realRsetType + "..."));
                }
                this.need_to_parse = true;
                this.sql_string_changed = true;
                this.sql_query = sql;
                this.sql_kind = (byte)-1;
                this.prepare_for_new_result(true);
                if (this.columns_defined_by_user) {
                    this.adjustUserDefines(-1);
                }
                this.doExecuteWithTimeout();
                this.current_result_set = new OracleResultSetImpl((OracleConnection)this.connection, this);
                success = true;
            }
        }
        if (this.current_result_set != null && success) {
            if (this.m_userRsetType != this.m_realRsetType) {
                this.m_warning = DBError.addSqlWarning((SQLWarning)this.m_warning, (int)91, (Object)_errMsg);
            }
            this.m_scrollRset = ResultSetUtil.createScrollResultSet(this, this.current_result_set, this.m_realRsetType);
            return this.m_scrollRset;
        }
        DBError.check_error((int)1, (Object)"Unable to create result set");
        return null;
    }

    void adjustUserDefines(int shift) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)32, (String)("current length = " + this.defines.getNoOfArgs()));
        }
        if (shift == 1) {
            this.defines.prependRowidColumn();
        } else if (shift == -1) {
            this.columns_defined_by_user = true;
            this.need_to_prepare_define_buffer = true;
            this.defines.removeRowidColumn();
        }
    }

    public void setAutoRefetch(boolean autoRefetch) throws SQLException {
        this.m_autoRefetch = autoRefetch;
    }

    public boolean getAutoRefetch() throws SQLException {
        return this.m_autoRefetch;
    }

    public synchronized int creationState() {
        return this.m_creationState;
    }

    public boolean isColumnSetNull(int index) {
        return this.columnSetNull;
    }

    public boolean isNCHAR(int index) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)32, (String)("isNCHAR (index = " + index + ")  " + (this.getDBDescription()[index].FormOfUse == 2)));
        }
        return this.getDBDescription()[index].FormOfUse == 2;
    }

    public boolean getMoreResults(int current) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return false;
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return -1;
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return -1;
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return -1;
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return false;
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return false;
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return false;
    }

    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    static {
        VALID_ROWS_UNINIT = -999;
        EXECUTE_NONE = (byte)-1;
        EXECUTE_QUERY = 1;
        EXECUTE_UPDATE = (byte)2;
        EXECUTE_NORMAL = (byte)3;
        DEFAULT_RSET_TYPE = 1;
        CLOSED = 0;
        ACTIVE = 1;
        CACHED = 2;
        NON_CACHED = 3;
    }
}

